<?php
/**
 * Plugin Name:       Fancy Filter – Grid Showcase with Category Filters
 * Plugin URI:        https://wordpress.org/plugins/fancy-fiter/
 * Description:       A category based filter that creates amazing portfolio, post, and Product filters
 * Version:           2.0.3
 * Author:            Sharabindu
 * Author URI:        https://sharabindu.com/plugins/fancy-filter/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       fancy-fiter
 * Domain Path:       /languages
 */


// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


/**
 *Include plugin.php
 *Check Qr composer Pro Version is enable.
 * Then Deactive Pro version and activate Lite version
 */

include_once(ABSPATH.'wp-admin/includes/plugin.php');
if( is_plugin_active('fancy-filter-pro/fancy-filter-pro.php') ){
     add_action('update_option_active_plugins', 'fancy_deactivate_pro_version');
}
function fancy_deactivate_pro_version(){
   deactivate_plugins('fancy-filter-pro/fancy-filter-pro.php');
}




/**
 * Currently plugin version.
 * Start at version 2.0.3 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'FANCYFILTER_VERSION', '2.0.3' );

/**
 * plugin define directory.
 * 
 */


define('FANCYFILTER_DIR' ,plugin_dir_url( __DIR__ ));

/**
 * define plugin path.
 * 
 */
define('FANCYFILTER_PATH' ,plugin_dir_path( __FILE__ ));

/**
 * define plugin url.
 * 
 */
define('FANCYFILTER_URL' ,plugin_dir_url( __FILE__ ));
/**
 *  define plugin basename.
 * 
 */
define('FANCYFILTER_BASENAME' ,plugin_basename( __FILE__ ));



/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-fancyfilter-activator.php
 */
function FancyFilter_Lite_Activator() {
	require_once FANCYFILTER_PATH . 'includes/Class/class-fancyfilter-activator.php';
	FancyFilter_Lite_Activator::fancyfilter_activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-fancyfilter-deactivator.php
 */
function fancyfilter_deativator() {
	require_once FANCYFILTER_PATH . 'includes/Class/class-fancyfilter-deactivator.php';
	fancyfilter_Deactivatore::fancyfilter_deactivate();
}

register_activation_hook( __FILE__, 'FancyFilter_Lite_Activator' );
register_deactivation_hook( __FILE__, 'fancyfilter_deativator' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/Class/class-fancyfilter.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    2.0.3
 */
function fancyfilter_run() {

	$plugin = new fancyfilter();
	$plugin->fancyfilter_get_run();

}
fancyfilter_run();


function register_portfolio_post_type() {
    $labels = array(
        'name'               => __( 'Portfolios', 'textdomain' ),
        'singular_name'      => __( 'Portfolio', 'textdomain' ),
        'menu_name'          => __( 'Portfolios', 'textdomain' ),
        'name_admin_bar'     => __( 'Portfolio', 'textdomain' ),
        'add_new'            => __( 'Add New', 'textdomain' ),
        'add_new_item'       => __( 'Add New Portfolio', 'textdomain' ),
        'new_item'           => __( 'New Portfolio', 'textdomain' ),
        'edit_item'          => __( 'Edit Portfolio', 'textdomain' ),
        'view_item'          => __( 'View Portfolio', 'textdomain' ),
        'all_items'          => __( 'All Portfolios', 'textdomain' ),
        'search_items'       => __( 'Search Portfolios', 'textdomain' ),
        'not_found'          => __( 'No portfolios found.', 'textdomain' ),
    );

    $args = array(
        'labels'             => $labels,
        'public'             => false,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => false,
        'rewrite'            => false,
        'capability_type'    => 'post',
        'has_archive'        => false,
        'hierarchical'       => false,
        'menu_position'      => 5,
        'supports'           => array( 'title', 'editor', 'thumbnail' ),
        'show_in_rest'       => true,
        //'menu_icon'          => 'dashicons-portfolio',
    );

    register_post_type( 'portfolio', $args );
}
add_action( 'init', 'register_portfolio_post_type' );
