<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://sharabindu.com
 * @since      2.0.3
 *
 * @package    fancyfilter
 * @subpackage fancyfilter/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    fancyfilter
 * @subpackage fancyfilter/admin
 * @author     Sharabindu <sharabindu.bakshi@gmail.com>
 */
class fancyfilter_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    2.0.3
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    2.0.3
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    2.0.3
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}



	function fancyfilter_blog_type() {

		 $value = get_option( 'fancy_cpt_base' ); 

		$tiembav =  $value ? $value : 'fancyfilter';
		/**
		 * Post Type: Fancy Filter.
		 */

		$labels = [
			"name" => esc_html__( "Fancy Filter", "fancy-fiter" ),
			"singular_name" => esc_html__( "Fancy Filter", "fancy-fiter" ),
			"menu_name" => esc_html__( "Fancy Filter", "fancy-fiter" ),
			"all_items" => esc_html__( "All Portfolios", "fancy-fiter" ),
			"add_new" => esc_html__( "Add New Portfolio", "fancy-fiter" ),
			"add_new_item" => esc_html__( "Add New Portfolio", "fancy-fiter" ),
			"edit_item" => esc_html__( "Edit Item", "fancy-fiter" ),
			"new_item" => esc_html__( "New Item", "fancy-fiter" ),
			"view_item" => esc_html__( "View Item", "fancy-fiter" ),
			"view_items" => esc_html__( "View All Items", "fancy-fiter" ),
			"search_items" => esc_html__( "Search Item", "fancy-fiter" ),
			"not_found" => esc_html__( "Not Found Item", "fancy-fiter" ),
			"not_found_in_trash" => esc_html__( "Not  found in Trash", "fancy-fiter" ),
			"parent" => esc_html__( "Parent", "fancy-fiter" ),
			"featured_image" => esc_html__( "Portfolio Image", "fancy-fiter" ),
			"set_featured_image" => esc_html__( "Set Portfolio Image", "fancy-fiter" ),
			"remove_featured_image" => esc_html__( "Remove Portfolio Image", "fancy-fiter" ),
			"use_featured_image" => esc_html__( "Use Portfolio Image", "fancy-fiter" ),
			"archives" => esc_html__( "Portfolio Archive", "fancy-fiter" ),
			"parent_item_colon" => esc_html__( "Parent", "fancy-fiter" ),
		];

		$args = [
			"label" => esc_html__( "Fancy Filter", "fancy-fiter" ),
			"labels" => $labels,
			"description" => "Fancy Filter is a Portfolio Filter Plugin",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"delete_with_user" => false,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"has_archive" => false,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => true,
			"menu_icon" => "dashicons-grid-view",
			"rewrite" => [ "slug" => "".$tiembav."", "with_front" => true ],
			"query_var" => true,
			"supports" => [ "title", "editor", "thumbnail" ],
		];

		register_post_type( "fancyfilter", $args );




			/**
			 * Taxonomy: fancyfilter Portfolio.
			 */

			$labels = [
				"name" => esc_html__( "Portfolio Category", "fancy-fiter" ),
				"singular_name" => esc_html__( "Portfolio Category", "fancy-fiter" ),
				"menu_name" => esc_html__( "Portfolio Category", "fancy-fiter" ),
				"all_items" => esc_html__( "All Categories", "fancy-fiter" ),
				"edit_item" => esc_html__( "Edit Categories", "fancy-fiter" ),
				"view_item" => esc_html__( "View Categories", "fancy-fiter" ),
				"update_item" => esc_html__( "Update Category", "fancy-fiter" ),
				"add_new_item" => esc_html__( "Add New Category", "fancy-fiter" ),
				"parent_item" => esc_html__( "Parent Category", "fancy-fiter" ),
				"search_items" => esc_html__( "Search Category", "fancy-fiter" ),
				"popular_items" => esc_html__( "Popular Category", "fancy-fiter" ),
				"add_or_remove_items" => esc_html__( "Add or Remove Category", "fancy-fiter" ),
			];

			$args = [
				"label" => esc_html__( "Portfolio Category", "fancy-fiter" ),
				"labels" => $labels,
				"public" => true,
				"publicly_queryable" => true,
				"hierarchical" => true,
				"show_ui" => true,
				"show_in_menu" => true,
				"show_in_nav_menus" => true,
				"query_var" => true,
				"rewrite" => [ 'slug' => 'fl_portfolio', 'with_front' => true, ],
				"show_admin_column" => true,
				"show_in_rest" => true,
				"rest_base" => "fl_portfolio",
				"rest_controller_class" => "WP_REST_Terms_Controller",
				"show_in_quick_edit" => false,
				];
			register_taxonomy( "fl_portfolio", [ "fancyfilter" ], $args );
		}



		 

		 
		function fancyfilter_plugin_row_meta( $links, $file ) {    
		    if ( FANCYFILTER_BASENAME == $file ) {
		        $row_meta = array(

		          'livechat'    => '<a href="' . esc_url( 'https://wordpress.org/support/plugin/fancy-fiter/' ) . '" target="_blank">' . esc_html__( 'Support', 'fancy-fiter' ) . '</a>'

		        );
		 
		        return array_merge( $links, $row_meta );
		    }
		    return (array) $links;
		}



		public function plugin_settings_link($links)
		{

		    return array_merge(array(
		        '<a href="' . admin_url('edit.php?post_type=fancyfilter&page=fancyfilter_settings') . '">' . __('Settings', 'fancy-fiter') . '</a>',
		        '<a class="yhow_yse" href="' . admin_url('edit.php?post_type=fancyfilter&page=how_it_works') . '">' . __('How It Works', 'fancy-fiter') . '</a>',
		    ) , $links);

		}







}
