<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://sharabindu.com
 * @since      2.0.3
 *
 * @package    fancyfilter filter plugin
 * @subpackage fancyfilter filter plugin/includes
 */

class fancyfilter {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    2.0.3
	 * @access   protected
	 * @var      fancyfilter_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    2.0.3
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    2.0.3
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    2.0.3
	 */
	public function __construct() {
		if ( defined( 'FANCYFILTER_VERSION' ) ) {
			$this->version = FANCYFILTER_VERSION;
		} else {
			$this->version = '2.0.3';
		}
		$this->plugin_name = 'fancy-filter-pro';

		$this->fancyfilter_load_dependencies();
		$this->fancyfilter_admin_hooks();


	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - fancyfilter_Loader. Orchestrates the hooks of the plugin.
	 * - fancyfilter_i18n. Defines internationalization functionality.
	 * - fancyfilter_Admin. Defines all hooks for the admin area.
	 * - fancyfilter_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    2.0.3
	 * @access   private
	 */
	private function fancyfilter_load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once FANCYFILTER_PATH. 'includes/Class/class-fancyfilter-loader.php';
		require_once FANCYFILTER_PATH. 'includes/Class/class_fancyfilter_rows.php';
		require_once FANCYFILTER_PATH. 'includes/Class/class-fancyfilter_morefilter.php';
		require_once FANCYFILTER_PATH. 'includes/Class/class-fancyfilter_permalink.php';
		require_once FANCYFILTER_PATH. 'metaData/class-fancy_productMetadata.php';
		require_once FANCYFILTER_PATH. 'metaData/class-fancy_portfolio_Metada.php';
		require_once FANCYFILTER_PATH. 'metaData/class-fancy_BlogMeatada.php';
		require_once FANCYFILTER_PATH. 'metaData/class-fancy-dmeolinkdata.php';
		require_once FANCYFILTER_PATH. 'metaData/class-fancy_previewlink.php';
		require_once FANCYFILTER_PATH. 'includes/Class/class-fancyfilter-admin.php';

		require_once FANCYFILTER_PATH. '/includes/helper/fancyfilter-helper-function.php';

		require_once FANCYFILTER_PATH. 'includes/Class/class_fancyfilter_shortcode.php';

		require_once FANCYFILTER_PATH. 'includes/Class/class-fancyfilter_blog_shortcode.php';

		require_once FANCYFILTER_PATH. 'includes/Class/class_fancyfilter-setting.php';
			
		require_once FANCYFILTER_PATH. 'includes/Class/class-fancifilter-howto-use.php';
		require_once FANCYFILTER_PATH. 'includes/Class/class_fancyfilterproduct_shortcode.php';


		$this->loader = new fancyfilter_product_ShortcodeLite();
		$this->loader = new fancyfilter_Lite_Shortcode();
		$this->loader = new fancyfilterLite_blog_Shortcode();
		$this->loader = new fancyfilter__Settings();
		$this->loader = new fancyfilter_Loader();

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    2.0.3
	 * @access   private
	 */
	private function fancyfilter_admin_hooks() {

		$plugin_admin = new fancyfilter_Admin( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'init', $plugin_admin, 'fancyfilter_blog_type');

		$this->loader->add_filter( 'plugin_row_meta', $plugin_admin, 'fancyfilter_plugin_row_meta', 10, 2 );

		$this->loader->add_filter( 'plugin_action_links_' .FANCYFILTER_BASENAME , $plugin_admin, 'plugin_settings_link');

	}


	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    2.0.3
	 */
	public function fancyfilter_get_run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     2.0.3
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     2.0.3
	 * @return    fancyfilter_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     2.0.3
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
