<?php
/**
 * The file that defines the bulk print admin area
 *
 * public-facing side of the site and the admin area.
 *
 * @link       https://sharabindu.com
 * @since      2.0.3
 *
 * @package    fancy-filter
 * @subpackage fancy-filter/admin
 */

class fancyfilter__Settings
{

    public function __construct()
    {

     define( 'FANCY_FILTER_PLUGIN_ID', 'fancyfilter_settings' ); 
     define( 'FANCY_FILTER_WORKS', 'how_it_works' ); 

        add_action('admin_init', array(
            $this,
            'fancyfilter__light_setting'
        ));

        add_action('admin_enqueue_scripts', array(
            $this,
            'fancyfilter_admin_settings'
        ));
        add_action('admin_menu', array(
            $this,
            'fancyfilter_menu_define'
        ));

    include_once FANCYFILTER_PATH . 'vendor/wordpress-plugin-installer-main/class-connekt-plugin-installer.php';

    }
    function fancyfilter_admin_settings()
    {



    $nonce = wp_create_nonce( 'fancyfilter-nonce' );
    if ( ! wp_verify_nonce( $nonce, 'fancyfilter-nonce' ) ) return;
     $screen = get_current_screen();
    if ( sanitize_title(isset($_GET['page'])) && strpos((sanitize_title(wp_unslash($_GET['page']))), FANCY_FILTER_WORKS) !== false  || sanitize_title(isset($_GET['page'])) && strpos((sanitize_title(wp_unslash($_GET['page']))), FANCY_FILTER_PLUGIN_ID) !== false || 'morefilter' == $screen->post_type) {

        wp_enqueue_style('wp-color-picker');


        wp_enqueue_style('select2', FANCYFILTER_URL . 'assets/css/select2.min.css', array() ,FANCYFILTER_VERSION , false,'all');

        wp_enqueue_style('fancyfilter-admin-settings', FANCYFILTER_URL . 'assets/css/fancyfilter-admin.css', array() ,FANCYFILTER_VERSION , false); 

        wp_enqueue_script('wp-color-picker');
        wp_enqueue_script('select2', FANCYFILTER_URL . 'assets/js/select2.min.js', array(
            'jquery'
        ) , FANCYFILTER_VERSION, false);


        wp_enqueue_script('wp-color-picker-alpha', FANCYFILTER_URL . 'assets/js/wp-color-picker-alpha.js', array('wp-color-picker'
        ) , FANCYFILTER_VERSION, false);
        
        wp_enqueue_script('admin-script', FANCYFILTER_URL . 'assets/js/admin-script.js', array(
            'jquery','select2','wp-color-picker'
        ) , FANCYFILTER_VERSION , false); 
   
    }
    }

    function fancyfilter__light_setting()
    {
        register_setting("fancyfilter_options", "fancyfilter_options", array(
            $this,
            'fancyfilter_options_page_sanitize'
        ));

        add_settings_section("fancyfilter_section_setting", " ", array(
            $this,
            'fancyfilter__settting_func'
        ) , 'fancyfilter_setting');

    }

    function fancyfilter__settting_func()
    {

        return;
    }

    public function fancyfilter_menu_define()
    {

        add_submenu_page('edit.php?post_type=fancyfilter', __('Settings', 'fancy-fiter') , __('Settings', 'fancy-fiter') , 'manage_options', 'fancyfilter_settings', array(
            $this,
            'fancyfilter_settings'
        ));

    }

    function fancyfilter_settings()
    {

    $nonce = wp_create_nonce( 'fancyfilter-nonce' );
    if ( ! wp_verify_nonce( $nonce, 'fancyfilter-nonce' ) ) return;
        settings_errors();
        $options = get_option('fancyfilter_options');
        $fancyfilter_image_url = FANCYFILTER_URL . '/assets/img/gif/'
    ?>
     <div class="qrcodewrap">
        <div class="fancyfilter_admin">

           <ul  class="fancyfilter_hdaer_cnt">
    
              <li>
                <img src=" <?php echo esc_url(FANCYFILTER_URL). '/assets/img/lohof-55x52.png' ?>" alt="fancyfilter logo">
            </li> <li>
                 <h3><?php echo esc_html('Fancy Filter', 'fancy-fiter') . '<sup>'.esc_html(FANCYFILTER_VERSION).'</sup>';?> </h3>
                 <small><?php echo esc_html('Creating beautiful masonry filters', 'fancy-fiter') ?></small> 
             </li>
               </ul>
                  <ul class="fancyfilter_nav_bar">
                    <li><a href="https://wordpress.org/support/plugin/fancy-fiter/" target="_blank"><?php echo esc_html('Support', 'fancy-fiter') ?></a></li>
                     <li><a href="https://fancyfilter.dipashi.com/" target="_blank"><?php echo esc_html('Pro demo', 'fancy-fiter') ?></a></li>

                     <li><a href="https://sharabindu.com/plugins/fancy-filter/" target="_blank"><?php echo esc_html('Get Premimum', 'fancy-fiter') ?></a></li>

                     <li><a href="https://fancyfilter.dipashi.com/docs/introduction/" target="_blank"><?php echo esc_html('Docs', 'fancy-fiter') ?></a></li>
                  </ul>
        </div>
        <div class="fancyfilter_Wrappers">
           <div class="fancyfilter_Wrappers_menu">

<div class="tab-nav">
  <ul>
    <li class="active"><a href="#tab1"><?php echo esc_html("Settings", "fancy-fiter") ?></a></li>
    <li><a href="#tab2"><?php echo esc_html("Pro Features", "fancy-fiter") ?></a></li>
    <li><a href="#tab3"><?php echo esc_html("Our More Plugins", "fancy-fiter") ?></a></li>

  </ul>
</div>

  <div class="tab-content">

    <div  class="tab1-tab active">
        <form action="options.php" method="post" class="fancy_dhgformdtaa">
    <?php 

      settings_fields( 'fancyfilter_options' );
      
      do_settings_sections( 'fancyfilter_setting' );
     ?>
   <div class="fancyfilter-accordion-wrapper">
<?php 

require_once FANCYFILTER_PATH .'/partials/FancyItemWrapper.php';
require_once FANCYFILTER_PATH .'/partials/FancyButtnSetting.php';
require_once FANCYFILTER_PATH .'/partials/FancyLinkPartial.php';
require_once FANCYFILTER_PATH .'/partials/FancyExtra.php';
 ?>
 </div>
 </form>

</div>
    <div  class="tab2-tab">
<?php   require_once FANCYFILTER_PATH. 'includes/helper/features.php'; ?>
    </div>
    <div  class="tab3-tab">
<div class="poytgwbemfn">
<?php 


$plugins = [
  [
    'slug' => 'qr-code-composer',
  ],
  [
    'slug' => 'barcode-generator-for-woocommerce',
  ],
  [
    'slug' => 'mini-cart-for-woocommerce',
  ],
  [
    'slug' => 'elfi-masonry-addon'
  ],
  [
    'slug' => 'yoo-bar'
  ],
  [
    'slug' => 'fancy-fiter'
  ],
  [
    'slug' => 'master-qr-generator'
  ]
]; 

if( class_exists( 'Connekt_Plugin_Installer' ) ) {
  Connekt_Plugin_Installer::init( $plugins );
}
 ?>
        </div>


    </div>



</div>


        </div>
     </div>

            <?php

    }

    function fancyfilter_options_page_sanitize($input)
    {
        $sanitary_values = array();
        if (isset($input['fancyfilter_pro_style']))
        {
            $sanitary_values['fancyfilter_pro_style'] = ($input['fancyfilter_pro_style']);
        }

        if (isset($input['fancyfilter_pro_style_animation']))
        {
            $sanitary_values['fancyfilter_pro_style_animation'] = ($input['fancyfilter_pro_style_animation']);
        }
        if (isset($input['fancyfilter_pro_order_by']))
        {
            $sanitary_values['fancyfilter_pro_order_byfancyfilter_pro_order_by'] = ($input['fancyfilter_pro_order_by']);
        }

        if (isset($input['el_title_color']))
        {
            $sanitary_values['el_title_color'] = ($input['el_title_color']);
        }
        if (isset($input['el_cat_color']))
        {
            $sanitary_values['el_cat_color'] = ($input['el_cat_color']);
        }
        
        if (isset($input['el_btnact_color']))
        {
            $sanitary_values['el_btnact_color'] = ($input['el_btnact_color']);
        }
        if (isset($input['el_btntxt_color']))
        {
            $sanitary_values['el_btntxt_color'] = ($input['el_btntxt_color']);
        }
        if (isset($input['fancyfilter_pro_btn_alighmnt']))
        {
            $sanitary_values['fancyfilter_pro_btn_alighmnt'] = ($input['fancyfilter_pro_btn_alighmnt']);
        }
        if (isset($input['fancyfilter_pro_btn_style']))
        {
            $sanitary_values['fancyfilter_pro_btn_style'] = ($input['fancyfilter_pro_btn_style']);
        }
        if (isset($input['el_link_bgcolor']))
        {
            $sanitary_values['el_link_bgcolor'] = ($input['el_link_bgcolor']);
        }

        if (isset($input['el_link_color']))
        {
            $sanitary_values['el_link_color'] = ($input['el_link_color']);
        }
        if (isset($input['el_zoom_color']))
        {
            $sanitary_values['el_zoom_color'] = ($input['el_zoom_color']);
        }
        if (isset($input['el_zoom_bgcolor']))
        {
            $sanitary_values['el_zoom_bgcolor'] = ($input['el_zoom_bgcolor']);
        }

        if (isset($input['el_all_text']))
        {
            $sanitary_values['el_all_text'] = ($input['el_all_text']);
        }
        if (isset($input['fancyfilter_pro_main_style']))
        {
            $sanitary_values['fancyfilter_pro_main_style'] = ($input['fancyfilter_pro_main_style']);
        }
        if (isset($input['fancyfilter_pro_col_by']))
        {
            $sanitary_values['fancyfilter_pro_col_by'] = ($input['fancyfilter_pro_col_by']);
        }
        if (isset($input['fancyfilter_pro_hide_cat']))
        {
            $sanitary_values['fancyfilter_pro_hide_cat'] = ($input['fancyfilter_pro_hide_cat']);
        }
        if (isset($input['show_fancyfilter_pro_title']))
        {
            $sanitary_values['show_fancyfilter_pro_title'] = ($input['show_fancyfilter_pro_title']);
        }
        if (isset($input['el_ti_font']))
        {
            $sanitary_values['el_ti_font'] = ($input['el_ti_font']);
        }
        if (isset($input['el_ti_font_w']))
        {
            $sanitary_values['el_ti_font_w'] = ($input['el_ti_font_w']);
        }
        if (isset($input['el_btn_f_weight']))
        {
            $sanitary_values['el_btn_f_weight'] = ($input['el_btn_f_weight']);
        }
        if (isset($input['el_btn_f_size']))
        {
            $sanitary_values['el_btn_f_size'] = ($input['el_btn_f_size']);
        }

        if (isset($input['fancyfilter_pro_display_pgination']))
        {
            $sanitary_values['fancyfilter_pro_display_pgination'] = ($input['fancyfilter_pro_display_pgination']);
        }
        if (isset($input['el_pagination_top_space']))
        {
            $sanitary_values['el_pagination_top_space'] = ($input['el_pagination_top_space']);
        }
        if (isset($input['el_pagination_color']))
        {
            $sanitary_values['el_pagination_color'] = ($input['el_pagination_color']);
        }
        if (isset($input['el_pagination_bg_color']))
        {
            $sanitary_values['el_pagination_bg_color'] = ($input['el_pagination_bg_color']);
        }
        if (isset($input['el_pagination_ac_color']))
        {
            $sanitary_values['el_pagination_ac_color'] = ($input['el_pagination_ac_color']);
        }
        if (isset($input['fancyfilter_pro_pg_align']))
        {
            $sanitary_values['fancyfilter_pro_pg_align'] = ($input['fancyfilter_pro_pg_align']);
        }


        if (isset($input['el_item_bg_color']))
        {
            $sanitary_values['el_item_bg_color'] = ($input['el_item_bg_color']);
        }
        if (isset($input['el_btnact_bgcolor']))
        {
            $sanitary_values['el_btnact_bgcolor'] = ($input['el_btnact_bgcolor']);
        }
        if (isset($input['fancyfilter_pro_per_page']))
        {
            $sanitary_values['fancyfilter_pro_per_page'] = ($input['fancyfilter_pro_per_page']);
        }
        if (isset($input['fancyfilter_pro_display_readmore']))
        {
            $sanitary_values['fancyfilter_pro_display_readmore'] = ($input['fancyfilter_pro_display_readmore']);
        }
        if (isset($input['el_readmore_txt']))
        {
            $sanitary_values['el_readmore_txt'] = ($input['el_readmore_txt']);
        }

        if (isset($input['el_readmore_url']))
        {
            $sanitary_values['el_readmore_url'] = ($input['el_readmore_url']);
        }

        if (isset($input['el_readmore_color']))
        {
            $sanitary_values['el_readmore_color'] = ($input['el_readmore_color']);
        }
        if (isset($input['el_readmore_bgcolor']))
        {
            $sanitary_values['el_readmore_bgcolor'] = ($input['el_readmore_bgcolor']);
        }
        if (isset($input['fancyfilter_pro_readmore_align']))
        {
            $sanitary_values['fancyfilter_pro_readmore_align'] = ($input['fancyfilter_pro_readmore_align']);
        }
        
        if (isset($input['yoo_slct_post_types']))
        {
            $sanitary_values['yoo_slct_post_types'] = ($input['yoo_slct_post_types']);
        }

        if (isset($input['slct_post_types']))
        {
            $sanitary_values['slct_post_types'] = ($input['slct_post_types']);
        }

        if (isset($input['slct_portfoli_types']))
        {
            $sanitary_values['slct_portfoli_types'] = ($input['slct_portfoli_types']);
        }

        if (isset($input['fancyfilter_pro_zoom_icon']))
        {
            $sanitary_values['fancyfilter_pro_zoom_icon'] = ($input['fancyfilter_pro_zoom_icon']);
        }
        if (isset($input['fancyfilter_pro_link_icon']))
        {
            $sanitary_values['fancyfilter_pro_link_icon'] = ($input['fancyfilter_pro_link_icon']);
        }
        if (isset($input['fabcy_remove_al_btn']))
        {
            $sanitary_values['fabcy_remove_al_btn'] = ($input['fabcy_remove_al_btn']);
        }

        return $sanitary_values;
    }


}

