<?php
/**
 * The file that defines the bulk print admin area
 *
 * public-facing side of the site and the admin area.
 *
 * @link       https://sharabindu.com
 * @since      1.0.4
 *
 * @package    fancy-filter
 * @subpackage fancy-filter/admin
 */

class fancyfilter_Lite_Shortcode
{

    public function __construct()
    {
        add_action('init', array(
            $this,
            'FancyFilter_link_shortcode'
        ));
        
        add_action('wp_enqueue_scripts', array(
            $this,
            'fancyfilter_pro_shortcode_scripts'
        ));

    }

    function fancyfilter_pro_shortcode_scripts()
    {
        wp_enqueue_style( 'fancy-css', FANCYFILTER_URL . 'assets/css/fancy-filter.css',array(),FANCYFILTER_VERSION,false );


        wp_register_script( 'isotope.pkgd.min', FANCYFILTER_URL . 'assets/js/isotope.pkgd.min.js',array('jquery'),FANCYFILTER_VERSION,true );

        wp_register_script( 'lightbox', FANCYFILTER_URL . 'assets/js/lightbox.min.js',array('jquery'),FANCYFILTER_VERSION,true );

        wp_register_script( 'fancy-fiter', FANCYFILTER_URL . 'assets/js/fancy-filter.js',array('jquery','isotope.pkgd.min','lightbox'),FANCYFILTER_VERSION ,true ,10 );    

    }

    function FancyFilter_link_shortcode()
    {
        add_shortcode('fancyfilter_portfolio', array(
            $this,
            'fancyfilter_portfolio_shortcode_atts'
        ));

    }

    function fancyfilter_portfolio_shortcode_atts($atts)
    {

        ob_start();

        wp_enqueue_script('isotope.pkgd.min');
        wp_enqueue_script('lightbox');
        wp_enqueue_script('fancy-fiter');

         include FANCYFILTER_PATH .'includes/extra/OptionDataPortfolio.php';
         include FANCYFILTER_PATH .'includes/extra/PortfolioCssdata.php';
           
        ?>

        <div class="fancyfilter-filter-wrapper-<?php echo esc_attr($rand_type) ?>" id="fancyfilter_masronry_wrapper">

            <div class="fancyfilter-filter-nav" id="fancyfilter-filter-nav-shrcode">
                <ul style="text-align:<?php echo esc_attr($align); ?>">

        <?php if($fabcy_remove_al_btn !== 'checked'){ 
    if($button == 'btnsyle-1' ||  $button == 'btnsyle-2' ){?>


    <li class="active <?php echo esc_attr($button_class); ?>" data-filter="*" style="margin-left:15px"><?php echo esc_html($el_all_text); ?></li>

        <?php }   } 
            $facncy_portfolios = get_post_meta($post_id, "facncy_portfolios", true);

            if($facncy_portfolios){

                $porttermarry = $facncy_portfolios;
                $Port_btnstyle = $facncy_portfolios;

            }else{

               $porttermarry = $portfolioselect2_style ;
               $Port_btnstyle = $portfolioselect2_style ;
            }
            if(isset($Port_btnstyle)){
            $fancyfilterCat_frontend = $Port_btnstyle;

            if($fancyfilterCat_frontend){
              foreach ($fancyfilterCat_frontend as $fancyfilterCats) { 

                $fancyfilter_term = get_term_by('term_id', $fancyfilterCats, "fl_portfolio");

                if($fancyfilter_term){ ?>


        <?php if($button == 'btnsyle-1' || $button == 'btnsyle-2' ){
            ?>
        <li class=" <?php echo esc_attr($button_class); ?>" data-filter=".<?php echo esc_attr($fancyfilter_term->term_id); ?>" style="margin-left:15px"> <?php echo esc_html($fancyfilter_term->name);?></li>
        <?php } 

          }
        }
      }
    } ?>

        </ul>

         </div>  

         <div class="grid-init" id="grid-filter-init-<?php echo esc_attr($rand_type); ?>">        
            <?php

            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            $x=1;
 

        $args = array(
            'post_type' => 'fancyfilter',
            'posts_per_page' => $fancyfilter_pro_per_page,
            'orderby' => $fancyfilter_pro_order_by,
            'paged' => $paged,
            'tax_query' => array(
                array(
                'taxonomy' => 'fl_portfolio',
                'field' => 'term_id',
                'terms' =>  $porttermarry
                 )
              )

        );
        $layout_class = 'layout_three';
        $fancyfilter_blog_details = new WP_Query($args);

        if ($fancyfilter_blog_details->have_posts())
        {

            while ($fancyfilter_blog_details->have_posts())
            {


                $fancyfilter_blog_details->the_post();

                $terms = get_the_terms(get_the_ID() , 'fl_portfolio');

                if ($terms && !is_wp_error($terms)):

                $draught_links = array();
                $draught_name = array();

                foreach ($terms as $term)
                {
                $draught_links[] = $term->term_id;
                $draught_name[] = $term->name;

                $termLink = get_term_link($term, 'fl_portfolio');
                }
                include FANCYFILTER_PATH .'includes/extra/PortfolioQueryDAta.php';
                
                endif;
                $x++;
            }
        
     
        wp_reset_postdata(); 
        }
        ?>
        </div>
    <?php 
    if ( $fancyfilter_pro_display_pgination == 'checked'){

    fancyfilter_custom_posts_pagination($fancyfilter_blog_details, $paged);

    }
    if ( $fancyfilter_pro_display_readmore == 'checked'){

    echo '<div class="fancyfilter_readmore" >
   <a href="'.esc_url($el_readmore_url).'">'.esc_html($el_readmore_txt).'<i class="eicon-long-arrow-right hidden-log"></i></a>
    </div>';
    }


    ?>
        </div>

    <?php
        return ob_get_clean();
    }

}

