<?php 


   class FancydmeolinkdataLite {

     private $screens = array('post','product','fancyfilter');

    private $fields = array(
  
        array(
          'label' => 'Choose',
          'id' => 'fancymetcsleiten',
          'type' => 'select',
          'options' => array(
             'Video URL',
             'Shortcode',
             'Raw Html',
          ),
         ),
         array(
           'label' => 'Input',
           'id' => 'fncyvidelink',
           'type' => 'textarea',
          ),
         array(
                 'label' => 'Select Icon',
                 'id' => 'select_iconds',
                 'default' =>'video',
                 'type' => 'select',
                 'options' => array(
                    'Map',
                    'Envelop',
                    'File',
                    'video',
                    'custom icon',
                 ),
          ),
            array(
              'label' => 'Write icon class (if custom icon is selected above)',
              'id' => 'writeiconclasss',
              'type' => 'text',
             ),
   
       
      );

      public function __construct() {
        add_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );

      }

      public function add_meta_boxes() {

        foreach ( $this->screens as $s ) {
          add_meta_box(
            'Fancydmeolinkdata',
            '<span class="dashicons-before dashicons-grid-view"> Fancy Video Link/Shortcode/Raw Html <em>(Premium version)</em></span>',
            array( $this, 'meta_box_callback' ),
            $s,
            'normal',
            'default'
          );
        }
      }

      public function meta_box_callback( $post ) {
        wp_nonce_field( 'Fancydmeolinkdata_data', 'Fancydmeolinkdata_nonce' ); 

        $this->field_generator( $post );
      }

      public function field_generator( $post ) {
        $output = '';
        foreach ( $this->fields as $field ) {
          $label = '<label for="' . $field['id'] . '">' . $field['label'] . '</label>';
          $meta_value = get_post_meta( $post->ID, $field['id'], true );
          if ( empty( $meta_value ) ) {
            if ( isset( $field['default'] ) ) {
              $meta_value = $field['default'];
            }
          }
          switch ( $field['type'] ) {
            case 'textarea':
              $input = sprintf(
                '<textarea style="width: 100%%" id="%s" name="%s" rows="5" cols="50">%s</textarea>',
                $field['id'],
                $field['id'],
                $meta_value
              );
              break;
      
            case 'select':
            $input = sprintf(
              '<select id="%s" name="%s">',
              $field['id'],
              $field['id']
            );
            foreach ( $field['options'] as $key => $value ) {
              $field_value = !is_numeric( $key ) ? $key : $value;
              $input .= sprintf(
                '<option %s value="%s">%s</option>',
                $meta_value === $field_value ? 'selected' : '',
                $field_value,
                $value
              );
            }
            $input .= '</select>';
            break;
      
            default:
              $input = sprintf(
              '<input %s id="%s" name="%s" type="%s" value="%s" placeholder="e.g: fa fa-facebook"> If the font awesome package is not active, activate it first<a href="https://wordpress.org/plugins/font-awesome/"> Font Awesome</a><p><em>You can add class to any icon package, but the icons package must be active on your site</em></p>',
              $field['type'] !== 'color' ? 'style="width:auto"' : '',
              $field['id'],
              $field['id'],
              $field['type'],
              $meta_value,
            );
          }
          $output .= $this->format_rows( $label, $input );
        }

 $allowed_html = array(
    'textarea' => array(
        'id'    => array(),
        'class'    => array(),
        'rows'    => array(),
        'cols'    => array(),
        'name'  => array(),
        'value' => array(),
    ),
    'label' => array(
        'id'    => array(),
        'class'    => array(),
        'for'    => array(),
    ),
    'input' => array(
        'type'  => array(),
        'id'    => array(),
        'class'    => array(),
        'name'  => array(),
        'value' => array(),
        'checked'  => array(), 
     ),
    'select' => array(
        'class'    => array(),
        'id'    => array(),
        'name'  => array(),

     ),
        'option'  => array(
        'value' => array(),
        'class'    => array(),
        'id'    => array(),
        'selected'  => array(),        
        ),
        'div'  => array(
        'class'    => array(),
        'id'    => array(),
        'style'    => array(),
        ),
        'strong'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'table'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'tr'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'tbody'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'th'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'td'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'span' => array(
        'id'    => array(),
        'class'    => array(),
        'style'    => array(),
    ),
);


        echo '<table class="form-table"><tbody>' . wp_kses($output ,$allowed_html ) . '</tbody></table>';

      }

      public function format_rows( $label, $input ) {
        return '<div style="margin-top: 10px;"><strong>'.$label.'</strong></div><div>'.$input.'</div>';
      }

    }
     if (class_exists('FancydmeolinkdataLite')) {
       new FancydmeolinkdataLite;
     };
