<?php
/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.1.4
 * @package    Yoo_Bar
 * @subpackage Yoo_Bar/includes
 * @author     Sharabindu <info@sharabindu.com>
 */
class FancyblogMetaDataLite
{

    public function __construct()
    {

        add_action('admin_menu', array(
            $this,
            'fancyfilter_posttype_metas'
        ));
        add_action('save_post', array(
            $this,
            'fancyfilter_posttype_save_metas'
        ) , 10, 2);
    }

    public function fancyfilter_posttype_metas()
    {

        add_meta_box('fancy_blog_type', 'Portfolio', array(
            $this,
            'fancyfilter_posttype_select_metas'
        ) , 'morefilter', 'advanced', 'high');
    }

    public function fancyfilter_posttype_select_metas($post)
    {

 

        $html = ' <ul class="fancydescrip_metainfo">';



        $appended_posts = get_post_meta($post->ID, 'facncy_portfolios', true);
 
        include FANCYFILTER_PATH .'metaData/FancyMetaExtra/PortfolioData.php';

        

    }

    public function fancyfilter_posttype_save_metas($post_id, $post)
    {
    $nonce = wp_create_nonce( 'fancyportfolios-nonce' );
    if ( ! wp_verify_nonce( $nonce, 'fancyportfolios-nonce' ) ) return;
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return $post_id;

        if ($post->post_type == 'morefilter')
        {
            if (isset($_POST['facncy_portfolios'])) update_post_meta($post_id, 'facncy_portfolios', sanitize_mime_type(wp_unslash($_POST['facncy_portfolios'])));
            else delete_post_meta($post_id, 'facncy_portfolios');
            if (isset($_POST['slect_styledata']))
            {update_post_meta($post_id, 'slect_styledata', sanitize_text_field(wp_unslash($_POST['slect_styledata'])));}else{delete_post_meta($post_id, 'slect_styledata');}
            if (isset($_POST['slect_butondata']))
            {update_post_meta($post_id, 'slect_butondata', sanitize_text_field(wp_unslash($_POST['slect_butondata'])));}else{delete_post_meta($post_id, 'slect_butondata');}
            if (isset($_POST['el_fi_gridbg']))
            {update_post_meta($post_id, 'el_fi_gridbg', sanitize_text_field(wp_unslash($_POST['el_fi_gridbg'])));}else{delete_post_meta($post_id, 'el_fi_gridbg');}
            if (isset($_POST['el_fi_gridbg_2']))
            {update_post_meta($post_id, 'el_fi_gridbg_2', sanitize_text_field(wp_unslash($_POST['el_fi_gridbg_2'])));}else{delete_post_meta($post_id, 'el_fi_gridbg_2');}
            if (isset($_POST['fancyMetabtn_align']))
            {update_post_meta($post_id, 'fancyMetabtn_align', sanitize_text_field(wp_unslash($_POST['fancyMetabtn_align'])));}else{delete_post_meta($post_id, 'fancyMetabtn_align');}
            if (isset($_POST['fancy_metabtn_bg']))
            {update_post_meta($post_id, 'fancy_metabtn_bg', sanitize_text_field(wp_unslash($_POST['fancy_metabtn_bg'])));}else{delete_post_meta($post_id, 'fancy_metabtn_bg');}
            if (isset($_POST['fancy_metabtn_ac_bg']))
            {update_post_meta($post_id, 'fancy_metabtn_ac_bg', sanitize_text_field(wp_unslash($_POST['fancy_metabtn_ac_bg'])));}else{delete_post_meta($post_id, 'fancy_metabtn_ac_bg');}
            if (isset($_POST['fancy_metabtn_clor']))
            {update_post_meta($post_id, 'fancy_metabtn_clor', sanitize_text_field(wp_unslash($_POST['fancy_metabtn_clor'])));}else{delete_post_meta($post_id, 'fancy_metabtn_clor');}
        
            if (isset($_POST['slect_prot_erp_rw']))
            {update_post_meta($post_id, 'slect_prot_erp_rw', sanitize_text_field(wp_unslash($_POST['slect_prot_erp_rw'])));}else{delete_post_meta($post_id, 'slect_prot_erp_rw');}        
            if (isset($_POST['slect_styleanimation']))
            {update_post_meta($post_id, 'slect_styleanimation', sanitize_text_field(wp_unslash($_POST['slect_styleanimation'])));}else{delete_post_meta($post_id, 'slect_styleanimation');}
            return $post_id;
        }
    }

}

if (class_exists('FancyblogMetaDataLite'))
{
    new FancyblogMetaDataLite;
};

