<?php 

class FancyPreviewlinkdataLite {

     private $screens = array('fancyfilter');

     private $fields = array(
       array(
         'label' => 'Preview URL',
         'id' => 'fncyprvewlink',
         'type' => 'url',
        ),
       array(
         'label' => 'Download URL',
         'id' => 'fancydwnlink',
         'type' => 'url',
        )  
     );

     public function __construct() {
       add_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );

     }

     public function add_meta_boxes() {
       foreach ( $this->screens as $s ) {
         add_meta_box(
           'FancyPreviewURL',
           __( '<span class="dashicons-before dashicons-grid-view"> Fany Filter Preview & Download URL <em>(Premium version)</em></span>', 'fancy-fiter' ),
           array( $this, 'meta_box_callback' ),
           $s,
           'normal',
           'default'
         );
       }
     }

     public function meta_box_callback( $post ) {
       wp_nonce_field( 'FancyPreviewURL_data', 'FancyPreviewURL_nonce' ); 
       $this->field_generator( $post );
     }

     public function field_generator( $post ) {
       $output = '';
       foreach ( $this->fields as $field ) {
         $label = '<label for="' . $field['id'] . '">' . $field['label'] . '</label>';
         $meta_value = get_post_meta( $post->ID, $field['id'], true );
         if ( empty( $meta_value ) ) {
           if ( isset( $field['default'] ) ) {
             $meta_value = $field['default'];
           }
         }
         switch ( $field['type'] ) {
           default:
             $input = sprintf(
             '<input %s id="%s" name="%s" type="%s" value="%s">',
             $field['type'] !== 'color' ? 'style="width: 100%"' : '',
             $field['id'],
             $field['id'],
             $field['type'],
             $meta_value
           );
         }
         $output .= $this->format_rows( $label, $input );
       }


$allowed_html = array(

    'label' => array(
        'id'    => array(),
        'class'    => array(),
        'for'    => array(),
    ),
    'input' => array(
        'type'  => array(),
        'id'    => array(),
        'class'    => array(),
        'name'  => array(),
        'value' => array(),
        'style' => array(),
     ),

        'div'  => array(
        'class'    => array(),
        'id'    => array(),
        'style'    => array(),
        ),
        'strong'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'table'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'tr'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'tbody'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'th'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'td'  => array(
        'class'    => array(),
        'id'    => array(),
        ),
        'span' => array(
        'id'    => array(),
        'class'    => array(),
        'style'    => array(),
    ),
);


        echo '<table class="form-table"><tbody>' . wp_kses($output ,$allowed_html ) . '</tbody></table>';



     }

     public function format_rows( $label, $input ) {
       return '<div style="margin-top: 10px;"><strong>'.$label.'</strong></div><div>'.$input.'</div>';

     }
   }

   if (class_exists('FancyPreviewlinkdataLite')) {
     new FancyPreviewlinkdataLite;
   };

   