<?php
/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.1.4
 * @package    Yoo_Bar
 * @subpackage Yoo_Bar/includes
 * @author     Sharabindu <info@sharabindu.com>
 */

class FancyAddMetaFilterLite
{

    public function __construct()
    {

        add_action('admin_menu', array(
            $this,
            'fancyfilter_posttype_metas'
        ));
        add_action('save_post', array(
            $this,
            'fancyfilter_posttype_save_metas'
        ) , 10, 2);
    }

    public function fancyfilter_posttype_metas()
    {

        add_meta_box('fancy_filter_type', 'Product', array(
            $this,
            'fancyfilter_posttype_select_metas'
        ) , 'morefilter', 'advanced', 'low');

    }

    public function fancyfilter_posttype_select_metas($post)
    {


        $html = ' <ul class="fancydescrip_metainfo">';


        $appended_meta_product = get_post_meta($post->ID, 'facncy_meta_product', true);

        include FANCYFILTER_PATH .'metaData/FancyMetaExtra/ProductData.php';

       
    }

    public function fancyfilter_posttype_save_metas($post_id, $post)
    {
    $nonce = wp_create_nonce( 'fancyproduct-nonce' );
    if ( ! wp_verify_nonce( $nonce, 'fancyproduct-nonce' ) ) return;
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return $post_id;

        if ($post->post_type == 'morefilter')
        {
            if (isset($_POST['facncy_meta_product'])) update_post_meta($post_id, 'facncy_meta_product', sanitize_mime_type(wp_unslash($_POST['facncy_meta_product'])));
            else delete_post_meta($post_id, 'facncy_meta_product');
            if (isset($_POST['slect_stylepro_data']))
            {update_post_meta($post_id, 'slect_stylepro_data', sanitize_text_field(wp_unslash($_POST['slect_stylepro_data'])));}else{delete_post_meta($post_id, 'slect_stylepro_data');}
            if (isset($_POST['slect_prodct_butondata']))
            {update_post_meta($post_id, 'slect_prodct_butondata', sanitize_text_field(wp_unslash($_POST['slect_prodct_butondata'])));}else{delete_post_meta($post_id, 'slect_prodct_butondata');}
            if (isset($_POST['el_fi_prodct_gridbg']))
            {update_post_meta($post_id, 'el_fi_prodct_gridbg', sanitize_text_field(wp_unslash($_POST['el_fi_prodct_gridbg'])));}else{delete_post_meta($post_id, 'el_fi_prodct_gridbg');}
            if (isset($_POST['el_fi_prodct_gridbg_2']))
            {update_post_meta($post_id, 'el_fi_prodct_gridbg_2', sanitize_text_field(wp_unslash($_POST['el_fi_prodct_gridbg_2'])));}else{delete_post_meta($post_id, 'el_fi_prodct_gridbg_2');}
            if (isset($_POST['fancy_proMetabtn_align']))
            {update_post_meta($post_id, 'fancy_proMetabtn_align', sanitize_text_field(wp_unslash($_POST['fancy_proMetabtn_align'])));}else{delete_post_meta($post_id, 'fancy_proMetabtn_align');}
            if (isset($_POST['fancy_Pro_metabtn_bg']))
            {update_post_meta($post_id, 'fancy_Pro_metabtn_bg', sanitize_text_field(wp_unslash($_POST['fancy_Pro_metabtn_bg'])));}else{delete_post_meta($post_id, 'fancy_Pro_metabtn_bg');}
            if (isset($_POST['fancy_Pro_metabtn_ac_bg']))
            {update_post_meta($post_id, 'fancy_Pro_metabtn_ac_bg', sanitize_text_field(wp_unslash($_POST['fancy_Pro_metabtn_ac_bg'])));}else{delete_post_meta($post_id, 'fancy_Pro_metabtn_ac_bg');}

            if (isset($_POST['fancy_metabtn_Proclor']))
            {update_post_meta($post_id, 'fancy_metabtn_Proclor', sanitize_text_field(wp_unslash($_POST['fancy_metabtn_Proclor'])));}else{delete_post_meta($post_id, 'fancy_metabtn_Proclor');}
            if (isset($_POST['slect_clm_erp_rw']))
            {update_post_meta($post_id, 'slect_clm_erp_rw', sanitize_text_field(wp_unslash($_POST['slect_clm_erp_rw'])));}else{delete_post_meta($post_id, 'slect_clm_erp_rw');}

        
            return $post_id;
        }
    }

}

if (class_exists('FancyAddMetaFilterLite'))
{


    new FancyAddMetaFilterLite;
}

