<?php
/**
 * Font awesome icons array array file.
 *
 * @author  Brainstorm Force
 * @package Astra
 * @todo    If this icon file updates via grunt, it's default version is minified. But to get the icons label available on translate wordpress.org we need to unminify it. Use tool: https://beautifytools.com/php-beautifier.php
 */

/**
 * Returns font awesome icons array
 */
return array(
	'imdb'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM21.3 229.2H21c.1-.1 .2-.3 .3-.4zM97 319.8H64V192h33zm113.2 0h-28.7v-86.4l-11.6 86.4h-20.6l-12.2-84.5v84.5h-29V192h42.8c3.3 19.8 6 39.9 8.7 59.9l7.6-59.9h43zm11.4 0V192h24.6c17.6 0 44.7-1.6 49 20.9 1.7 7.6 1.4 16.3 1.4 24.4 0 88.5 11.1 82.6-75 82.5zm160.9-29.2c0 15.7-2.4 30.9-22.2 30.9-9 0-15.2-3-20.9-9.8l-1.9 8.1h-29.8V192h31.7v41.7c6-6.5 12-9.2 20.9-9.2 21.4 0 22.2 12.8 22.2 30.1zM265 229.9c0-9.7 1.6-16-10.3-16v83.7c12.2 .3 10.3-8.7 10.3-18.4zm85.5 26.1c0-5.4 1.1-12.7-6.2-12.7-6 0-4.9 8.9-4.9 12.7 0 .6-1.1 39.6 1.1 44.7 .8 1.6 2.2 2.4 3.8 2.4 7.8 0 6.2-9 6.2-14.4z',
			),
		),
		'label'             => __( 'IMDB', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'inbox'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M447 56.25C443.5 42 430.7 31.1 416 31.1H96c-14.69 0-27.47 10-31.03 24.25L3.715 304.9C1.247 314.9 0 325.2 0 335.5v96.47c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48v-96.47c0-10.32-1.247-20.6-3.715-30.61L447 56.25zM352 352H160L128 288H72.97L121 96h270l48.03 192H384L352 352z',
			),
		),
		'label'             => __( 'Inbox', 'astra' ),
		'custom_categories' => array(
			'communication',
		),
	),
	'indent'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M0 64C0 46.33 14.33 32 32 32H416C433.7 32 448 46.33 448 64C448 81.67 433.7 96 416 96H32C14.33 96 0 81.67 0 64zM192 192C192 174.3 206.3 160 224 160H416C433.7 160 448 174.3 448 192C448 209.7 433.7 224 416 224H224C206.3 224 192 209.7 192 192zM416 288C433.7 288 448 302.3 448 320C448 337.7 433.7 352 416 352H224C206.3 352 192 337.7 192 320C192 302.3 206.3 288 224 288H416zM0 448C0 430.3 14.33 416 32 416H416C433.7 416 448 430.3 448 448C448 465.7 433.7 480 416 480H32C14.33 480 0 465.7 0 448zM25.82 347.9C15.31 356.1 0 348.6 0 335.3V176.7C0 163.4 15.31 155.9 25.82 164.1L127.8 243.4C135.1 249.8 135.1 262.2 127.8 268.6L25.82 347.9z',
			),
		),
		'label'             => __( 'Indent', 'astra' ),
		'custom_categories' => array(),
	),
	'indian-rupee-sign'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M.0022 64C.0022 46.33 14.33 32 32 32H288C305.7 32 320 46.33 320 64C320 81.67 305.7 96 288 96H231.8C241.4 110.4 248.5 126.6 252.4 144H288C305.7 144 320 158.3 320 176C320 193.7 305.7 208 288 208H252.4C239.2 266.3 190.5 311.2 130.3 318.9L274.6 421.1C288.1 432.2 292.3 452.2 282 466.6C271.8 480.1 251.8 484.3 237.4 474L13.4 314C2.083 305.1-2.716 291.5 1.529 278.2C5.774 264.1 18.09 256 32 256H112C144.8 256 173 236.3 185.3 208H32C14.33 208 .0022 193.7 .0022 176C.0022 158.3 14.33 144 32 144H185.3C173 115.7 144.8 96 112 96H32C14.33 96 .0022 81.67 .0022 64V64z',
			),
		),
		'label'             => __( 'Indian Rupee Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'industry'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M128 32C145.7 32 160 46.33 160 64V215.4L316.6 131C332.6 122.4 352 134 352 152.2V215.4L508.6 131C524.6 122.4 544 134 544 152.2V432C544 458.5 522.5 480 496 480H80C53.49 480 32 458.5 32 432V64C32 46.33 46.33 32 64 32H128z',
			),
		),
		'label'             => __( 'Industry', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
			'travel',
		),
	),
	'infinity'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M494.9 96.01c-38.78 0-75.22 15.09-102.6 42.5L320 210.8L247.8 138.5c-27.41-27.41-63.84-42.5-102.6-42.5C65.11 96.01 0 161.1 0 241.1v29.75c0 80.03 65.11 145.1 145.1 145.1c38.78 0 75.22-15.09 102.6-42.5L320 301.3l72.23 72.25c27.41 27.41 63.84 42.5 102.6 42.5C574.9 416 640 350.9 640 270.9v-29.75C640 161.1 574.9 96.01 494.9 96.01zM202.5 328.3c-15.31 15.31-35.69 23.75-57.38 23.75C100.4 352 64 315.6 64 270.9v-29.75c0-44.72 36.41-81.13 81.14-81.13c21.69 0 42.06 8.438 57.38 23.75l72.23 72.25L202.5 328.3zM576 270.9c0 44.72-36.41 81.13-81.14 81.13c-21.69 0-42.06-8.438-57.38-23.75l-72.23-72.25l72.23-72.25c15.31-15.31 35.69-23.75 57.38-23.75C539.6 160 576 196.4 576 241.1V270.9z',
			),
		),
		'label'             => 'Infinity',
		'custom_categories' => array(
			'education',
			'travel',
		),
	),
	'info'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 192,
				'height' => 512,
				'path'   => 'M160 448h-32V224c0-17.69-14.33-32-32-32L32 192c-17.67 0-32 14.31-32 32s14.33 31.1 32 31.1h32v192H32c-17.67 0-32 14.31-32 32s14.33 32 32 32h128c17.67 0 32-14.31 32-32S177.7 448 160 448zM96 128c26.51 0 48-21.49 48-48S122.5 32.01 96 32.01s-48 21.49-48 48S69.49 128 96 128z',
			),
		),
		'label'             => __( 'Info', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'instagram'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z',
			),
		),
		'label'             => __( 'Instagram', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'instagram-square'                       => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M224 202.7A53.34 53.34 0 1 0 277.4 256 53.38 53.38 0 0 0 224 202.7zm124.7-41a54 54 0 0 0 -30.41-30.41c-21-8.29-71-6.43-94.3-6.43s-73.25-1.93-94.31 6.43a54 54 0 0 0 -30.41 30.41c-8.28 21-6.43 71.05-6.43 94.33S91 329.3 99.32 350.3a54 54 0 0 0 30.41 30.41c21 8.29 71 6.43 94.31 6.43s73.24 1.93 94.3-6.43a54 54 0 0 0 30.41-30.41c8.35-21 6.43-71.05 6.43-94.33S357.1 182.7 348.8 161.7zM224 338a82 82 0 1 1 82-82A81.9 81.9 0 0 1 224 338zm85.38-148.3a19.14 19.14 0 1 1 19.13-19.14A19.1 19.1 0 0 1 309.4 189.7zM400 32H48A48 48 0 0 0 0 80V432a48 48 0 0 0 48 48H400a48 48 0 0 0 48-48V80A48 48 0 0 0 400 32zM382.9 322c-1.29 25.63-7.14 48.34-25.85 67s-41.4 24.63-67 25.85c-26.41 1.49-105.6 1.49-132 0-25.63-1.29-48.26-7.15-67-25.85s-24.63-41.42-25.85-67c-1.49-26.42-1.49-105.6 0-132 1.29-25.63 7.07-48.34 25.85-67s41.47-24.56 67-25.78c26.41-1.49 105.6-1.49 132 0 25.63 1.29 48.33 7.15 67 25.85s24.63 41.42 25.85 67.05C384.4 216.4 384.4 295.6 382.9 322z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'instalod'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M153.4 480H387.1L502.6 275.8 204.2 333.2zM504.7 240.1 387.1 32H155.7L360.2 267.9zM124.4 48.81 7.274 256 123.2 461.2 225.6 165.6z',
			),
		),
		'label'             => __( 'InstaLOD', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'intercom'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M392 32H56C25.1 32 0 57.1 0 88v336c0 30.9 25.1 56 56 56h336c30.9 0 56-25.1 56-56V88c0-30.9-25.1-56-56-56zm-108.3 82.1c0-19.8 29.9-19.8 29.9 0v199.5c0 19.8-29.9 19.8-29.9 0V114.1zm-74.6-7.5c0-19.8 29.9-19.8 29.9 0v216.5c0 19.8-29.9 19.8-29.9 0V106.6zm-74.7 7.5c0-19.8 29.9-19.8 29.9 0v199.5c0 19.8-29.9 19.8-29.9 0V114.1zM59.7 144c0-19.8 29.9-19.8 29.9 0v134.3c0 19.8-29.9 19.8-29.9 0V144zm323.4 227.8c-72.8 63-241.7 65.4-318.1 0-15-12.8 4.4-35.5 19.4-22.7 65.9 55.3 216.1 53.9 279.3 0 14.9-12.9 34.3 9.8 19.4 22.7zm5.2-93.5c0 19.8-29.9 19.8-29.9 0V144c0-19.8 29.9-19.8 29.9 0v134.3z',
			),
		),
		'label'             => __( 'Intercom', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'internet-explorer'                      => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M483 159.7c10.85-24.58 21.42-60.44 21.42-87.87 0-72.72-79.64-98.37-209.7-38.58-107.6-7.181-211.2 73.67-237.1 186.5 30.85-34.86 78.27-82.3 121.1-101.2C125.4 166.9 79.13 228 43.99 291.7 23.25 329.7 0 390.9 0 436.7c0 98.57 92.85 86.5 180.3 42.01 31.42 15.43 66.56 15.57 101.7 15.57 97.12 0 184.2-54.29 216.8-146H377.9c-52.51 88.59-196.8 52.1-196.8-47.44H509.9c6.407-43.58-1.655-95.71-26.85-141.2zM64.56 346.9c17.71 51.15 53.7 95.87 100.3 123.3-88.74 48.94-173.3 29.1-100.3-123.3zm115.1-108.9c2-55.15 50.28-94.87 103.1-94.87 53.42 0 101.1 39.72 103.1 94.87H180.5zm184.5-187.6c21.42-10.29 48.56-22 72.56-22 31.42 0 54.27 21.72 54.27 53.72 0 20-7.427 49.01-14.57 67.87-26.28-42.29-65.99-81.58-112.3-99.59z',
			),
		),
		'label'             => __( 'Internet-explorer', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'invision'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M407.4 32H40.6C18.2 32 0 50.2 0 72.6v366.8C0 461.8 18.2 480 40.6 480h366.8c22.4 0 40.6-18.2 40.6-40.6V72.6c0-22.4-18.2-40.6-40.6-40.6zM176.1 145.6c.4 23.4-22.4 27.3-26.6 27.4-14.9 0-27.1-12-27.1-27 .1-35.2 53.1-35.5 53.7-.4zM332.8 377c-65.6 0-34.1-74-25-106.6 14.1-46.4-45.2-59-59.9 .7l-25.8 103.3H177l8.1-32.5c-31.5 51.8-94.6 44.4-94.6-4.3 .1-14.3 .9-14 23-104.1H81.7l9.7-35.6h76.4c-33.6 133.7-32.6 126.9-32.9 138.2 0 20.9 40.9 13.5 57.4-23.2l19.8-79.4h-32.3l9.7-35.6h68.8l-8.9 40.5c40.5-75.5 127.9-47.8 101.8 38-14.2 51.1-14.6 50.7-14.9 58.8 0 15.5 17.5 22.6 31.8-16.9L386 325c-10.5 36.7-29.4 52-53.2 52z',
			),
		),
		'label'             => __( 'InVision', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'ioxhost'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M616 160h-67.3C511.2 70.7 422.9 8 320 8 183 8 72 119 72 256c0 16.4 1.6 32.5 4.7 48H24c-13.3 0-24 10.8-24 24 0 13.3 10.7 24 24 24h67.3c37.5 89.3 125.8 152 228.7 152 137 0 248-111 248-248 0-16.4-1.6-32.5-4.7-48H616c13.3 0 24-10.8 24-24 0-13.3-10.7-24-24-24zm-96 96c0 110.5-89.5 200-200 200-75.7 0-141.6-42-175.5-104H424c13.3 0 24-10.8 24-24 0-13.3-10.7-24-24-24H125.8c-3.8-15.4-5.8-31.4-5.8-48 0-110.5 89.5-200 200-200 75.7 0 141.6 42 175.5 104H216c-13.3 0-24 10.8-24 24 0 13.3 10.7 24 24 24h298.2c3.8 15.4 5.8 31.4 5.8 48zm-304-24h208c13.3 0 24 10.7 24 24 0 13.2-10.7 24-24 24H216c-13.3 0-24-10.7-24-24 0-13.2 10.7-24 24-24z',
			),
		),
		'label'             => __( 'ioxhost', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'italic'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M384 64.01c0 17.69-14.31 32-32 32h-58.67l-133.3 320H224c17.69 0 32 14.31 32 32s-14.31 32-32 32H32c-17.69 0-32-14.31-32-32s14.31-32 32-32h58.67l133.3-320H160c-17.69 0-32-14.31-32-32s14.31-32 32-32h192C369.7 32.01 384 46.33 384 64.01z',
			),
		),
		'label'             => __( 'Italic', 'astra' ),
		'custom_categories' => array(),
	),
	'itch-io'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M71.92 34.77C50.2 47.67 7.4 96.84 7 109.7v21.34c0 27.06 25.29 50.84 48.25 50.84 27.57 0 50.54-22.85 50.54-50 0 27.12 22.18 50 49.76 50s49-22.85 49-50c0 27.12 23.59 50 51.16 50h.5c27.57 0 51.16-22.85 51.16-50 0 27.12 21.47 50 49 50s49.76-22.85 49.76-50c0 27.12 23 50 50.54 50 23 0 48.25-23.78 48.25-50.84v-21.34c-.4-12.9-43.2-62.07-64.92-75C372.6 32.4 325.8 32 256 32S91.14 33.1 71.92 34.77zm132.3 134.4c-22 38.4-77.9 38.71-99.85 .25-13.17 23.14-43.17 32.07-56 27.66-3.87 40.15-13.67 237.1 17.73 269.1 80 18.67 302.1 18.12 379.8 0 31.65-32.27 21.32-232 17.75-269.1-12.92 4.44-42.88-4.6-56-27.66-22 38.52-77.85 38.1-99.85-.24-7.1 12.49-23.05 28.94-51.76 28.94a57.54 57.54 0 0 1 -51.75-28.94zm-41.58 53.77c16.47 0 31.09 0 49.22 19.78a436.9 436.9 0 0 1 88.18 0C318.2 223 332.9 223 349.3 223c52.33 0 65.22 77.53 83.87 144.4 17.26 62.15-5.52 63.67-33.95 63.73-42.15-1.57-65.49-32.18-65.49-62.79-39.25 6.43-101.9 8.79-155.6 0 0 30.61-23.34 61.22-65.49 62.79-28.42-.06-51.2-1.58-33.94-63.73 18.67-67 31.56-144.4 83.88-144.4zM256 270.8s-44.38 40.77-52.35 55.21l29-1.17v25.32c0 1.55 21.34 .16 23.33 .16 11.65 .54 23.31 1 23.31-.16v-25.28l29 1.17c-8-14.48-52.35-55.24-52.35-55.24z',
			),
		),
		'label'             => __( 'itch.io', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'itunes'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M223.6 80.3C129 80.3 52.5 157 52.5 251.5S129 422.8 223.6 422.8s171.2-76.7 171.2-171.2c0-94.6-76.7-171.3-171.2-171.3zm79.4 240c-3.2 13.6-13.5 21.2-27.3 23.8-12.1 2.2-22.2 2.8-31.9-5-11.8-10-12-26.4-1.4-36.8 8.4-8 20.3-9.6 38-12.8 3-.5 5.6-1.2 7.7-3.7 3.2-3.6 2.2-2 2.2-80.8 0-5.6-2.7-7.1-8.4-6.1-4 .7-91.9 17.1-91.9 17.1-5 1.1-6.7 2.6-6.7 8.3 0 116.1 .5 110.8-1.2 118.5-2.1 9-7.6 15.8-14.9 19.6-8.3 4.6-23.4 6.6-31.4 5.2-21.4-4-28.9-28.7-14.4-42.9 8.4-8 20.3-9.6 38-12.8 3-.5 5.6-1.2 7.7-3.7 5-5.7 .9-127 2.6-133.7 .4-2.6 1.5-4.8 3.5-6.4 2.1-1.7 5.8-2.7 6.7-2.7 101-19 113.3-21.4 115.1-21.4 5.7-.4 9 3 9 8.7-.1 170.6 .4 161.4-1 167.6zM345.2 32H102.8C45.9 32 0 77.9 0 134.8v242.4C0 434.1 45.9 480 102.8 480h242.4c57 0 102.8-45.9 102.8-102.8V134.8C448 77.9 402.1 32 345.2 32zM223.6 444c-106.3 0-192.5-86.2-192.5-192.5S117.3 59 223.6 59s192.5 86.2 192.5 192.5S329.9 444 223.6 444z',
			),
		),
		'label'             => __( 'iTunes', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'itunes-note'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M381.9 388.2c-6.4 27.4-27.2 42.8-55.1 48-24.5 4.5-44.9 5.6-64.5-10.2-23.9-20.1-24.2-53.4-2.7-74.4 17-16.2 40.9-19.5 76.8-25.8 6-1.1 11.2-2.5 15.6-7.4 6.4-7.2 4.4-4.1 4.4-163.2 0-11.2-5.5-14.3-17-12.3-8.2 1.4-185.7 34.6-185.7 34.6-10.2 2.2-13.4 5.2-13.4 16.7 0 234.7 1.1 223.9-2.5 239.5-4.2 18.2-15.4 31.9-30.2 39.5-16.8 9.3-47.2 13.4-63.4 10.4-43.2-8.1-58.4-58-29.1-86.6 17-16.2 40.9-19.5 76.8-25.8 6-1.1 11.2-2.5 15.6-7.4 10.1-11.5 1.8-256.6 5.2-270.2 .8-5.2 3-9.6 7.1-12.9 4.2-3.5 11.8-5.5 13.4-5.5 204-38.2 228.9-43.1 232.4-43.1 11.5-.8 18.1 6 18.1 17.6 .2 344.5 1.1 326-1.8 338.5z',
			),
		),
		'label'             => __( 'Itunes Note', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'j'                                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M320 64.01v259.4c0 86.36-71.78 156.6-160 156.6s-160-70.26-160-156.6V288c0-17.67 14.31-32 32-32s32 14.33 32 32v35.38c0 51.08 43.06 92.63 96 92.63s96-41.55 96-92.63V64.01c0-17.67 14.31-32 32-32S320 46.34 320 64.01z',
			),
		),
		'label'             => __( 'J', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'jar'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M32 32C32 14.33 46.33 0 64 0H256C273.7 0 288 14.33 288 32C288 49.67 273.7 64 256 64H64C46.33 64 32 49.67 32 32zM0 160C0 124.7 28.65 96 64 96H256C291.3 96 320 124.7 320 160V448C320 483.3 291.3 512 256 512H64C28.65 512 0 483.3 0 448V160zM256 224H64V384H256V224z',
			),
		),
		'label'             => __( 'Jar', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'jar-wheat'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M32 32C32 14.33 46.33 0 64 0H256C273.7 0 288 14.33 288 32C288 49.67 273.7 64 256 64H64C46.33 64 32 49.67 32 32zM0 160C0 124.7 28.65 96 64 96H256C291.3 96 320 124.7 320 160V448C320 483.3 291.3 512 256 512H64C28.65 512 0 483.3 0 448V160zM192 320C227.3 320 256 291.3 256 256H208C188.9 256 171.7 264.4 160 277.7C148.3 264.4 131.1 256 112 256H64C64 291.3 92.65 320 128 320H192zM192 224C227.3 224 256 195.3 256 160H208C188.9 160 171.7 168.4 160 181.7C148.3 168.4 131.1 160 112 160H64C64 195.3 92.65 224 128 224H192zM192 416C227.3 416 256 387.3 256 352H208C188.9 352 171.7 360.4 160 373.7C148.3 360.4 131.1 352 112 352H64C64 387.3 92.65 416 128 416H144V448C144 456.8 151.2 464 160 464C168.8 464 176 456.8 176 448V416H192z',
			),
		),
		'label'             => __( 'Jar Wheat', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'java'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M277.7 312.9c9.8-6.7 23.4-12.5 23.4-12.5s-38.7 7-77.2 10.2c-47.1 3.9-97.7 4.7-123.1 1.3-60.1-8 33-30.1 33-30.1s-36.1-2.4-80.6 19c-52.5 25.4 130 37 224.5 12.1zm-85.4-32.1c-19-42.7-83.1-80.2 0-145.8C296 53.2 242.8 0 242.8 0c21.5 84.5-75.6 110.1-110.7 162.6-23.9 35.9 11.7 74.4 60.2 118.2zm114.6-176.2c.1 0-175.2 43.8-91.5 140.2 24.7 28.4-6.5 54-6.5 54s62.7-32.4 33.9-72.9c-26.9-37.8-47.5-56.6 64.1-121.3zm-6.1 270.5a12.19 12.19 0 0 1 -2 2.6c128.3-33.7 81.1-118.9 19.8-97.3a17.33 17.33 0 0 0 -8.2 6.3 70.45 70.45 0 0 1 11-3c31-6.5 75.5 41.5-20.6 91.4zM348 437.4s14.5 11.9-15.9 21.2c-57.9 17.5-240.8 22.8-291.6 .7-18.3-7.9 16-19 26.8-21.3 11.2-2.4 17.7-2 17.7-2-20.3-14.3-131.3 28.1-56.4 40.2C232.8 509.4 401 461.3 348 437.4zM124.4 396c-78.7 22 47.9 67.4 148.1 24.5a185.9 185.9 0 0 1 -28.2-13.8c-44.7 8.5-65.4 9.1-106 4.5-33.5-3.8-13.9-15.2-13.9-15.2zm179.8 97.2c-78.7 14.8-175.8 13.1-233.3 3.6 0-.1 11.8 9.7 72.4 13.6 92.2 5.9 233.8-3.3 237.1-46.9 0 0-6.4 16.5-76.2 29.7zM260.6 353c-59.2 11.4-93.5 11.1-136.8 6.6-33.5-3.5-11.6-19.7-11.6-19.7-86.8 28.8 48.2 61.4 169.5 25.9a60.37 60.37 0 0 1 -21.1-12.8z',
			),
		),
		'label'             => __( 'Java', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'jedi'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M554.9 293.1l-58.88 58.88h40C493.2 446.1 398.2 511.1 287.1 512c-110.3-.0078-205.2-65.88-247.1-160h40L21.13 293.1C17.75 275.1 16 258.6 16 241.2c0-5.75 .75-11.5 1-17.25h47L22.75 182.7C37.38 117.1 75.86 59.37 130.6 20.5c2.75-2 6.021-3.005 9.272-3.005c5.5 0 10.5 2.75 13.5 7.25c3.125 4.375 3.625 10.13 1.625 15.13C148.5 56.12 145.1 73.62 145.1 91.12c0 45.13 21.13 86.63 57.75 113.8C206.9 207.7 209.4 212.4 209.5 217.2c.25 5-1.751 9.752-5.501 13c-32.75 29.38-47.5 74-38.5 117.1c9.751 48.38 48.88 87.13 97.26 96.5l2.5-65.37l-27.13 18.5c-3.125 2-7.251 1.75-10-.75c-2.75-2.625-3.25-6.75-1.375-10l20.13-33.75l-42.13-8.627c-3.625-.875-6.375-4.125-6.375-7.875s2.75-7 6.375-7.875l42.13-8.75L226.8 285.6C224.9 282.5 225.4 278.4 228.1 275.7c2.75-2.5 6.876-2.875 10-.75l30.38 20.63l11.49-287.8C280.3 3.461 283.7 .0156 287.1 0c4.237 .0156 7.759 3.461 8.009 7.828l11.49 287.8l30.38-20.63c3.125-2.125 7.251-1.75 10 .75c2.75 2.625 3.25 6.75 1.375 9.875l-20.13 33.75l42.13 8.75c3.625 .875 6.375 4.125 6.375 7.875s-2.75 7-6.375 7.875l-42.13 8.627l20.13 33.75c1.875 3.25 1.375 7.375-1.375 10c-2.75 2.5-6.876 2.75-10 .75l-27.13-18.5l2.5 65.37c48.38-9.375 87.51-48.13 97.26-96.5c9.001-43.13-5.75-87.75-38.5-117.1c-3.75-3.25-5.751-8.002-5.501-13c.125-4.875 2.626-9.5 6.626-12.38c36.63-27.13 57.75-68.63 57.75-113.8c0-17.5-3.375-35-9.875-51.25c-2-5-1.5-10.75 1.625-15.13c3-4.5 8.001-7.25 13.5-7.25c3.25 0 6.474 .9546 9.224 2.955c54.75 38.88 93.28 96.67 107.9 162.3l-41.25 41.25h47c.2501 5.75 .9965 11.5 .9965 17.25C559.1 258.6 558.3 275.1 554.9 293.1z',
			),
		),
		'label'             => __( 'Jedi', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
			'brands',
			'brands',
			'social',
		),
	),
	'jedi-order'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M398.5 373.6c95.9-122.1 17.2-233.1 17.2-233.1 45.4 85.8-41.4 170.5-41.4 170.5 105-171.5-60.5-271.5-60.5-271.5 96.9 72.7-10.1 190.7-10.1 190.7 85.8 158.4-68.6 230.1-68.6 230.1s-.4-16.9-2.2-85.7c4.3 4.5 34.5 36.2 34.5 36.2l-24.2-47.4 62.6-9.1-62.6-9.1 20.2-55.5-31.4 45.9c-2.2-87.7-7.8-305.1-7.9-306.9v-2.4 1-1 2.4c0 1-5.6 219-7.9 306.9l-31.4-45.9 20.2 55.5-62.6 9.1 62.6 9.1-24.2 47.4 34.5-36.2c-1.8 68.8-2.2 85.7-2.2 85.7s-154.4-71.7-68.6-230.1c0 0-107-118.1-10.1-190.7 0 0-165.5 99.9-60.5 271.5 0 0-86.8-84.8-41.4-170.5 0 0-78.7 111 17.2 233.1 0 0-26.2-16.1-49.4-77.7 0 0 16.9 183.3 222 185.7h4.1c205-2.4 222-185.7 222-185.7-23.6 61.5-49.9 77.7-49.9 77.7z',
			),
		),
		'label'             => __( 'Jedi Order', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
			'brands',
			'brands',
			'social',
		),
	),
	'jenkins'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M487.1 425c-1.4-11.2-19-23.1-28.2-31.9-5.1-5-29-23.1-30.4-29.9-1.4-6.6 9.7-21.5 13.3-28.9 5.1-10.7 8.8-23.7 11.3-32.6 18.8-66.1 20.7-156.9-6.2-211.2-10.2-20.6-38.6-49-56.4-62.5-42-31.7-119.6-35.3-170.1-16.6-14.1 5.2-27.8 9.8-40.1 17.1-33.1 19.4-68.3 32.5-78.1 71.6-24.2 10.8-31.5 41.8-30.3 77.8 .2 7 4.1 15.8 2.7 22.4-.7 3.3-5.2 7.6-6.1 9.8-11.6 27.7-2.3 64 11.1 83.7 8.1 11.9 21.5 22.4 39.2 25.2 .7 10.6 3.3 19.7 8.2 30.4 3.1 6.8 14.7 19 10.4 27.7-2.2 4.4-21 13.8-27.3 17.6C89 407.2 73.7 415 54.2 429c-12.6 9-32.3 10.2-29.2 31.1 2.1 14.1 10.1 31.6 14.7 45.8 .7 2 1.4 4.1 2.1 6h422c4.9-15.3 9.7-30.9 14.6-47.2 3.4-11.4 10.2-27.8 8.7-39.7zM205.9 33.7c1.8-.5 3.4 .7 4.9 2.4-.2 5.2-5.4 5.1-8.9 6.8-5.4 6.7-13.4 9.8-20 17.2-6.8 7.5-14.4 27.7-23.4 30-4.5 1.1-9.7-.8-13.6-.5-10.4 .7-17.7 6-28.3 7.5 13.6-29.9 56.1-54 89.3-63.4zm-104.8 93.6c13.5-14.9 32.1-24.1 54.8-25.9 11.7 29.7-8.4 65-.9 97.6 2.3 9.9 10.2 25.4-2.4 25.7 .3-28.3-34.8-46.3-61.3-29.6-1.8-21.5-4.9-51.7 9.8-67.8zm36.7 200.2c-1-4.1-2.7-12.9-2.3-15.1 1.6-8.7 17.1-12.5 11-24.7-11.3-.1-13.8 10.2-24.1 11.3-26.7 2.6-45.6-35.4-44.4-58.4 1-19.5 17.6-38.2 40.1-35.8 16 1.8 21.4 19.2 24.5 34.7 9.2 .5 22.5-.4 26.9-7.6-.6-17.5-8.8-31.6-8.2-47.7 1-30.3 17.5-57.6 4.8-87.4 13.6-30.9 53.5-55.3 83.1-70 36.6-18.3 94.9-3.7 129.3 15.8 19.7 11.1 34.4 32.7 48.3 50.7-19.5-5.8-36.1 4.2-33.1 20.3 16.3-14.9 44.2-.2 52.5 16.4 7.9 15.8 7.8 39.3 9 62.8 2.9 57-10.4 115.9-39.1 157.1-7.7 11-14.1 23-24.9 30.6-26 18.2-65.4 34.7-99.2 23.4-44.7-15-65-44.8-89.5-78.8 .7 18.7 13.8 34.1 26.8 48.4 11.3 12.5 25 26.6 39.7 32.4-12.3-2.9-31.1-3.8-36.2 7.2-28.6-1.9-55.1-4.8-68.7-24.2-10.6-15.4-21.4-41.4-26.3-61.4zm222 124.1c4.1-3 11.1-2.9 17.4-3.6-5.4-2.7-13-3.7-19.3-2.2-.1-4.2-2-6.8-3.2-10.2 10.6-3.8 35.5-28.5 49.6-20.3 6.7 3.9 9.5 26.2 10.1 37 .4 9-.8 18-4.5 22.8-18.8-.6-35.8-2.8-50.7-7 .9-6.1-1-12.1 .6-16.5zm-17.2-20c-16.8 .8-26-1.2-38.3-10.8 .2-.8 1.4-.5 1.5-1.4 18 8 40.8-3.3 59-4.9-7.9 5.1-14.6 11.6-22.2 17.1zm-12.1 33.2c-1.6-9.4-3.5-12-2.8-20.2 25-16.6 29.7 28.6 2.8 20.2zM226 438.6c-11.6-.7-48.1-14-38.5-23.7 9.4 6.5 27.5 4.9 41.3 7.3 .8 4.4-2.8 10.2-2.8 16.4zM57.7 497.1c-4.3-12.7-9.2-25.1-14.8-36.9 30.8-23.8 65.3-48.9 102.2-63.5 2.8-1.1 23.2 25.4 26.2 27.6 16.5 11.7 37 21 56.2 30.2 1.2 8.8 3.9 20.2 8.7 35.5 .7 2.3 1.4 4.7 2.2 7.2H57.7zm240.6 5.7h-.8c.3-.2 .5-.4 .8-.5v.5zm7.5-5.7c2.1-1.4 4.3-2.8 6.4-4.3 1.1 1.4 2.2 2.8 3.2 4.3h-9.6zm15.1-24.7c-10.8 7.3-20.6 18.3-33.3 25.2-6 3.3-27 11.7-33.4 10.2-3.6-.8-3.9-5.3-5.4-9.5-3.1-9-10.1-23.4-10.8-37-.8-17.2-2.5-46 16-42.4 14.9 2.9 32.3 9.7 43.9 16.1 7.1 3.9 11.1 8.6 21.9 9.5-.1 1.4-.1 2.8-.2 4.3-5.9 3.9-15.3 3.8-21.8 7.1 9.5 .4 17 2.7 23.5 5.9-.1 3.4-.3 7-.4 10.6zm53.4 24.7h-14c-.1-3.2-2.8-5.8-6.1-5.8s-5.9 2.6-6.1 5.8h-17.4c-2.8-4.4-5.7-8.6-8.9-12.5 2.1-2.2 4-4.7 6-6.9 9 3.7 14.8-4.9 21.7-4.2 7.9 .8 14.2 11.7 25.4 11l-.6 12.6zm8.7 0c.2-4 .4-7.8 .6-11.5 15.6-7.3 29 1.3 35.7 11.5H383zm83.4-37c-2.3 11.2-5.8 24-9.9 37.1-.2-.1-.4-.1-.6-.1H428c.6-1.1 1.2-2.2 1.9-3.3-2.6-6.1-9-8.7-10.9-15.5 12.1-22.7 6.5-93.4-24.2-78.5 4.3-6.3 15.6-11.5 20.8-19.3 13 10.4 20.8 20.3 33.2 31.4 6.8 6 20 13.3 21.4 23.1 .8 5.5-2.6 18.9-3.8 25.1zM222.2 130.5c5.4-14.9 27.2-34.7 45-32 7.7 1.2 18 8.2 12.2 17.7-30.2-7-45.2 12.6-54.4 33.1-8.1-2-4.9-13.1-2.8-18.8zm184.1 63.1c8.2-3.6 22.4-.7 29.6-5.3-4.2-11.5-10.3-21.4-9.3-37.7 .5 0 1 0 1.4 .1 6.8 14.2 12.7 29.2 21.4 41.7-5.7 13.5-43.6 25.4-43.1 1.2zm20.4-43zm-117.2 45.7c-6.8-10.9-19-32.5-14.5-45.3 6.5 11.9 8.6 24.4 17.8 33.3 4.1 4 12.2 9 8.2 20.2-.9 2.7-7.8 8.6-11.7 9.7-14.4 4.3-47.9 .9-36.6-17.1 11.9 .7 27.9 7.8 36.8-.8zm27.3 70c3.8 6.6 1.4 18.7 12.1 20.6 20.2 3.4 43.6-12.3 58.1-17.8 9-15.2-.8-20.7-8.9-30.5-16.6-20-38.8-44.8-38-74.7 6.7-4.9 7.3 7.4 8.2 9.7 8.7 20.3 30.4 46.2 46.3 63.5 3.9 4.3 10.3 8.4 11 11.2 2.1 8.2-5.4 18-4.5 23.5-21.7 13.9-45.8 29.1-81.4 25.6-7.4-6.7-10.3-21.4-2.9-31.1zm-201.3-9.2c-6.8-3.9-8.4-21-16.4-21.4-11.4-.7-9.3 22.2-9.3 35.5-7.8-7.1-9.2-29.1-3.5-40.3-6.6-3.2-9.5 3.6-13.1 5.9 4.7-34.1 49.8-15.8 42.3 20.3zm299.6 28.8c-10.1 19.2-24.4 40.4-54 41-.6-6.2-1.1-15.6 0-19.4 22.7-2.2 36.6-13.7 54-21.6zm-141.9 12.4c18.9 9.9 53.6 11 79.3 10.2 1.4 5.6 1.3 12.6 1.4 19.4-33 1.8-72-6.4-80.7-29.6zm92.2 46.7c-1.7 4.3-5.3 9.3-9.8 11.1-12.1 4.9-45.6 8.7-62.4-.3-10.7-5.7-17.5-18.5-23.4-26-2.8-3.6-16.9-12.9-.2-12.9 13.1 32.7 58 29 95.8 28.1z',
			),
		),
		'label'             => __( 'Jenkis', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'jet-fighter'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M160 24C160 10.75 170.7 0 184 0H296C309.3 0 320 10.75 320 24C320 37.25 309.3 48 296 48H280L384 192H500.4C508.1 192 515.7 193.4 522.9 196.1L625 234.4C634 237.8 640 246.4 640 256C640 265.6 634 274.2 625 277.6L522.9 315.9C515.7 318.6 508.1 320 500.4 320H384L280 464H296C309.3 464 320 474.7 320 488C320 501.3 309.3 512 296 512H184C170.7 512 160 501.3 160 488C160 474.7 170.7 464 184 464H192V320H160L105.4 374.6C99.37 380.6 91.23 384 82.75 384H64C46.33 384 32 369.7 32 352V288C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224V160C32 142.3 46.33 128 64 128H82.75C91.23 128 99.37 131.4 105.4 137.4L160 192H192V48H184C170.7 48 160 37.25 160 24V24zM80 240C71.16 240 64 247.2 64 256C64 264.8 71.16 272 80 272H144C152.8 272 160 264.8 160 256C160 247.2 152.8 240 144 240H80z',
			),
		),
		'label'             => __( 'Jet Fighter', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'jet-fighter-up'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M346.8 112.6C350.2 120.6 352 129.2 352 137.9V214.8L496 298.8V280C496 266.7 506.7 256 520 256C533.3 256 544 266.7 544 280V392C544 405.3 533.3 416 520 416C506.7 416 496 405.3 496 392V384H352V416.7L410.5 467.1C414 470.1 416 475.4 416 480V496C416 504.8 408.8 512 400 512H304V448C304 439.2 296.8 432 288 432C279.2 432 272 439.2 272 448V512H176C167.2 512 160 504.8 160 496V480C160 475.4 161.1 470.1 165.5 467.1L224 416.7V384H80V392C80 405.3 69.25 416 56 416C42.75 416 32 405.3 32 392V280C32 266.7 42.75 256 56 256C69.25 256 80 266.7 80 280V298.8L224 214.8V137.9C224 129.2 225.8 120.6 229.2 112.6L273.3 9.697C275.8 3.814 281.6 0 288 0C294.4 0 300.2 3.814 302.7 9.697L346.8 112.6z',
			),
		),
		'label'             => __( 'Jet Fighter Up', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'jira'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M490 241.7C417.1 169 320.6 71.8 248.5 0 83 164.9 6 241.7 6 241.7c-7.9 7.9-7.9 20.7 0 28.7C138.8 402.7 67.8 331.9 248.5 512c379.4-378 15.7-16.7 241.5-241.7 8-7.9 8-20.7 0-28.6zm-241.5 90l-76-75.7 76-75.7 76 75.7-76 75.7z',
			),
		),
		'label'             => __( 'Jira', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'joget'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M378.1 45C337.6 19.9 292.6 8 248.2 8 165 8 83.8 49.9 36.9 125.9c-71.9 116.6-35.6 269.3 81 341.2s269.3 35.6 341.2-80.9c71.9-116.6 35.6-269.4-81-341.2zm51.8 323.2c-40.4 65.5-110.4 101.5-182 101.5-6.8 0-13.6-.4-20.4-1-9-13.6-19.9-33.3-23.7-42.4-5.7-13.7-27.2-45.6 31.2-67.1 51.7-19.1 176.7-16.5 208.8-17.6-4 9-8.6 17.9-13.9 26.6zm-200.8-86.3c-55.5-1.4-81.7-20.8-58.5-48.2s51.1-40.7 68.9-51.2c17.9-10.5 27.3-33.7-23.6-29.7C87.3 161.5 48.6 252.1 37.6 293c-8.8-49.7-.1-102.7 28.5-149.1C128 43.4 259.6 12.2 360.1 74.1c74.8 46.1 111.2 130.9 99.3 212.7-24.9-.5-179.3-3.6-230.3-4.9zm183.8-54.8c-22.7-6-57 11.3-86.7 27.2-29.7 15.8-31.1 8.2-31.1 8.2s40.2-28.1 50.7-34.5 31.9-14 13.4-24.6c-3.2-1.8-6.7-2.7-10.4-2.7-17.8 0-41.5 18.7-67.5 35.6-31.5 20.5-65.3 31.3-65.3 31.3l169.5-1.6 46.5-23.4s3.6-9.5-19.1-15.5z',
			),
		),
		'label'             => __( 'Joget', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'joint'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M444.4 181.1C466.8 196.8 480 222.2 480 249.8V280C480 284.4 483.6 288 488 288h48C540.4 288 544 284.4 544 280V249.8c0-43.25-21-83.5-56.38-108.1C463.9 125 448 99.38 448 70.25V8C448 3.625 444.4 0 440 0h-48C387.6 0 384 3.625 384 8v66.38C384 118.1 408.5 156 444.4 181.1zM195 359C125.1 370.1 59.75 394.8 0 432C83.62 484.2 180.2 512 279 512h88.5l-112.7-131.5C240 363.2 217.4 355.4 195 359zM553.3 87.12C547.6 83.25 544 77.12 544 70.25V8C544 3.625 540.4 0 536 0h-48C483.6 0 480 3.625 480 8v62.25c0 22.13 10.12 43.5 28.62 55.5C550.8 153 576 199.5 576 249.8V280C576 284.4 579.6 288 584 288h48C636.4 288 640 284.4 640 280V249.8C640 184.2 607.6 123.5 553.3 87.12zM360.9 352c-34.38 .125-86.75 .25-88.25 .25l117.9 137.4C402.6 503.9 420.4 512 439.1 512h88.38l-117.9-137.6C397.4 360.1 379.6 352 360.9 352zM616 352H432l117.1 137.6C562.1 503.9 579.9 512 598.6 512H616c13.25 0 24-10.75 24-24v-112C640 362.8 629.3 352 616 352z',
			),
		),
		'label'             => __( 'Joint', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'joomla'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M.6 92.1C.6 58.8 27.4 32 60.4 32c30 0 54.5 21.9 59.2 50.2 32.6-7.6 67.1 .6 96.5 30l-44.3 44.3c-20.5-20.5-42.6-16.3-55.4-3.5-14.3 14.3-14.3 37.9 0 52.2l99.5 99.5-44 44.3c-87.7-87.2-49.7-49.7-99.8-99.7-26.8-26.5-35-64.8-24.8-98.9C20.4 144.6 .6 120.7 .6 92.1zm129.5 116.4l44.3 44.3c10-10 89.7-89.7 99.7-99.8 14.3-14.3 37.6-14.3 51.9 0 12.8 12.8 17 35-3.5 55.4l44 44.3c31.2-31.2 38.5-67.6 28.9-101.2 29.2-4.1 51.9-29.2 51.9-59.5 0-33.2-26.8-60.1-59.8-60.1-30.3 0-55.4 22.5-59.5 51.6-33.8-9.9-71.7-1.5-98.3 25.1-18.3 19.1-71.1 71.5-99.6 99.9zm266.3 152.2c8.2-32.7-.9-68.5-26.3-93.9-11.8-12.2 5 4.7-99.5-99.7l-44.3 44.3 99.7 99.7c14.3 14.3 14.3 37.6 0 51.9-12.8 12.8-35 17-55.4-3.5l-44 44.3c27.6 30.2 68 38.8 102.7 28 5.5 27.4 29.7 48.1 58.9 48.1 33 0 59.8-26.8 59.8-60.1 0-30.2-22.5-55-51.6-59.1zm-84.3-53.1l-44-44.3c-87 86.4-50.4 50.4-99.7 99.8-14.3 14.3-37.6 14.3-51.9 0-13.1-13.4-16.9-35.3 3.2-55.4l-44-44.3c-30.2 30.2-38 65.2-29.5 98.3-26.7 6-46.2 29.9-46.2 58.2C0 453.2 26.8 480 59.8 480c28.6 0 52.5-19.8 58.6-46.7 32.7 8.2 68.5-.6 94.2-26 32.1-32 12.2-12.4 99.5-99.7z',
			),
		),
		'label'             => __( 'Joomla Logo', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'js'                                     => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M0 32v448h448V32H0zm243.8 349.4c0 43.6-25.6 63.5-62.9 63.5-33.7 0-53.2-17.4-63.2-38.5l34.3-20.7c6.6 11.7 12.6 21.6 27.1 21.6 13.8 0 22.6-5.4 22.6-26.5V237.7h42.1v143.7zm99.6 63.5c-39.1 0-64.4-18.6-76.7-43l34.3-19.8c9 14.7 20.8 25.6 41.5 25.6 17.4 0 28.6-8.7 28.6-20.8 0-14.4-11.4-19.5-30.7-28l-10.5-4.5c-30.4-12.9-50.5-29.2-50.5-63.5 0-31.6 24.1-55.6 61.6-55.6 26.8 0 46 9.3 59.8 33.7L368 290c-7.2-12.9-15-18-27.1-18-12.3 0-20.1 7.8-20.1 18 0 12.6 7.8 17.7 25.9 25.6l10.5 4.5c35.8 15.3 55.9 31 55.9 66.2 0 37.8-29.8 58.6-69.7 58.6z',
			),
		),
		'label'             => __( 'JavaScript (JS)', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'js-square'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM243.8 381.4c0 43.6-25.6 63.5-62.9 63.5-33.7 0-53.2-17.4-63.2-38.5l34.3-20.7c6.6 11.7 12.6 21.6 27.1 21.6 13.8 0 22.6-5.4 22.6-26.5V237.7h42.1v143.7zm99.6 63.5c-39.1 0-64.4-18.6-76.7-43l34.3-19.8c9 14.7 20.8 25.6 41.5 25.6 17.4 0 28.6-8.7 28.6-20.8 0-14.4-11.4-19.5-30.7-28l-10.5-4.5c-30.4-12.9-50.5-29.2-50.5-63.5 0-31.6 24.1-55.6 61.6-55.6 26.8 0 46 9.3 59.8 33.7L368 290c-7.2-12.9-15-18-27.1-18-12.3 0-20.1 7.8-20.1 18 0 12.6 7.8 17.7 25.9 25.6l10.5 4.5c35.8 15.3 55.9 31 55.9 66.2 0 37.8-29.8 58.6-69.7 58.6z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'jsfiddle'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M510.6 237.5c-4.727-2.621-5.664-5.748-6.381-10.78-2.352-16.49-3.539-33.62-9.097-49.1-35.9-99.96-153.1-143.4-246.8-91.65-27.37 15.25-48.97 36.37-65.49 63.9-3.184-1.508-5.458-2.71-7.824-3.686-30.1-12.42-59.05-10.12-85.33 9.167-25.53 18.74-36.42 44.55-32.68 76.41 .355 3.025-1.967 7.621-4.514 9.545-39.71 29.99-56.03 78.07-41.9 124.6 13.83 45.57 57.51 79.8 105.6 81.43 30.29 1.031 60.64 .546 90.96 .539 84.04-.021 168.1 .531 252.1-.48 52.66-.634 96.11-36.87 108.2-87.29 11.54-48.07-11.14-97.3-56.83-122.6zm21.11 156.9c-18.23 22.43-42.34 35.25-71.28 35.65-56.87 .781-113.8 .23-170.7 .23 0 .7-163 .159-163.7 .154-43.86-.332-76.74-19.77-95.18-59.99-18.9-41.24-4.004-90.85 34.19-116.1 9.182-6.073 12.51-11.57 10.1-23.14-5.49-26.36 4.453-47.96 26.42-62.98 22.99-15.72 47.42-16.15 72.03-3.083 10.27 5.45 14.61 11.56 22.2-2.527 14.22-26.4 34.56-46.73 60.67-61.29 97.46-54.37 228.4 7.568 230.2 132.7 .122 8.15 2.412 12.43 9.848 15.89 57.56 26.83 74.46 96.12 35.14 144.5zm-87.79-80.5c-5.848 31.16-34.62 55.1-66.67 55.1-16.95-.001-32.06-6.545-44.08-17.7-27.7-25.71-71.14-74.98-95.94-93.39-20.06-14.89-41.99-12.33-60.27 3.782-49.1 44.07 15.86 121.8 67.06 77.19 4.548-3.96 7.84-9.543 12.74-12.84 8.184-5.509 20.77-.884 13.17 10.62-17.36 26.28-49.33 38.2-78.86 29.3-28.9-8.704-48.84-35.97-48.63-70.18 1.225-22.49 12.36-43.06 35.41-55.97 22.58-12.64 46.37-13.15 66.99 2.474C295.7 280.7 320.5 323.1 352.2 343.5c24.56 15.1 54.25 7.363 68.82-17.51 28.83-49.21-34.59-105-78.87-63.46-3.989 3.744-6.917 8.932-11.41 11.72-10.98 6.811-17.33-4.113-12.81-10.35 20.7-28.55 50.46-40.44 83.27-28.21 31.43 11.71 49.11 44.37 42.76 78.19z',
			),
		),
		'label'             => __( 'jsFiddle', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'jug-detergent'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M96 24C96 10.75 106.7 0 120 0H200C213.3 0 224 10.75 224 24V48H232C245.3 48 256 58.75 256 72C256 85.25 245.3 96 232 96H88C74.75 96 64 85.25 64 72C64 58.75 74.75 48 88 48H96V24zM0 256C0 185.3 57.31 128 128 128H256C326.7 128 384 185.3 384 256V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V256zM256 352C256 369.7 270.3 384 288 384C305.7 384 320 369.7 320 352V256C320 238.3 305.7 224 288 224C270.3 224 256 238.3 256 256V352z',
			),
		),
		'label'             => __( 'Jug Detergent', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'k'                                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M314.3 429.8c10.06 14.53 6.438 34.47-8.094 44.53c-5.562 3.844-11.91 5.688-18.19 5.688c-10.16 0-20.12-4.812-26.34-13.78L128.1 273.3L64 338.9v109.1c0 17.67-14.31 32-32 32s-32-14.33-32-32v-384C0 46.34 14.31 32.01 32 32.01S64 46.34 64 64.01v183.3l201.1-205.7c12.31-12.61 32.63-12.86 45.25-.5c12.62 12.34 12.88 32.61 .5 45.25l-137.2 140.3L314.3 429.8z',
			),
		),
		'label'             => __( 'K', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'kaaba'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 239.4V197.4L278.1 115.3C284.9 113.6 291.1 113.6 297 115.3L576 197.4V239.4L537.1 228.6C528.6 226.2 519.7 231.2 517.4 239.7C515 248.2 520 257.1 528.5 259.4L576 272.6V409.5C576 431.1 560.4 451.5 538.4 456.4L298.4 509.7C291.6 511.2 284.4 511.2 277.6 509.7L37.59 456.4C15.63 451.5 0 431.1 0 409.5V272.6L47.48 259.4C55.1 257.1 60.98 248.2 58.62 239.7C56.25 231.2 47.43 226.2 38.92 228.6L0 239.4zM292.3 160.6C289.5 159.8 286.5 159.8 283.7 160.6L240.5 172.6C232 174.9 227 183.8 229.4 192.3C231.7 200.8 240.6 205.8 249.1 203.4L288 192.6L326.9 203.4C335.4 205.8 344.3 200.8 346.6 192.3C348.1 183.8 343.1 174.9 335.5 172.6L292.3 160.6zM191.5 219.4C199.1 217.1 204.1 208.2 202.6 199.7C200.3 191.2 191.4 186.2 182.9 188.6L96.52 212.6C88 214.9 83.02 223.8 85.38 232.3C87.75 240.8 96.57 245.8 105.1 243.4L191.5 219.4zM393.1 188.6C384.6 186.2 375.7 191.2 373.4 199.7C371 208.2 376 217.1 384.5 219.4L470.9 243.4C479.4 245.8 488.3 240.8 490.6 232.3C492.1 223.8 487.1 214.9 479.5 212.6L393.1 188.6zM269.9 84.63L0 164V130.6C0 109.9 13.22 91.59 32.82 85.06L272.8 5.061C282.7 1.777 293.3 1.777 303.2 5.061L543.2 85.06C562.8 91.59 576 109.9 576 130.6V164L306.1 84.63C294.3 81.17 281.7 81.17 269.9 84.63V84.63z',
			),
		),
		'label'             => __( 'Kaaba', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'kaggle'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M304.2 501.5L158.4 320.3 298.2 185c2.6-2.7 1.7-10.5-5.3-10.5h-69.2c-3.5 0-7 1.8-10.5 5.3L80.9 313.5V7.5q0-7.5-7.5-7.5H21.5Q14 0 14 7.5v497q0 7.5 7.5 7.5h51.9q7.5 0 7.5-7.5v-109l30.8-29.3 110.5 140.6c3 3.5 6.5 5.3 10.5 5.3h66.9q5.25 0 6-3z',
			),
		),
		'label'             => __( 'Kaggle', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'key'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M282.3 343.7L248.1 376.1C244.5 381.5 238.4 384 232 384H192V424C192 437.3 181.3 448 168 448H128V488C128 501.3 117.3 512 104 512H24C10.75 512 0 501.3 0 488V408C0 401.6 2.529 395.5 7.029 391L168.3 229.7C162.9 212.8 160 194.7 160 176C160 78.8 238.8 0 336 0C433.2 0 512 78.8 512 176C512 273.2 433.2 352 336 352C317.3 352 299.2 349.1 282.3 343.7zM376 176C398.1 176 416 158.1 416 136C416 113.9 398.1 96 376 96C353.9 96 336 113.9 336 136C336 158.1 353.9 176 376 176z',
			),
		),
		'label'             => __( 'Key', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'keybase'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M286.2 419a18 18 0 1 0 18 18 18 18 0 0 0 -18-18zm111.9-147.6c-9.5-14.62-39.37-52.45-87.26-73.71q-9.1-4.06-18.38-7.27a78.43 78.43 0 0 0 -47.88-104.1c-12.41-4.1-23.33-6-32.41-5.77-.6-2-1.89-11 9.4-35L198.7 32l-5.48 7.56c-8.69 12.06-16.92 23.55-24.34 34.89a51 51 0 0 0 -8.29-1.25c-41.53-2.45-39-2.33-41.06-2.33-50.61 0-50.75 52.12-50.75 45.88l-2.36 36.68c-1.61 27 19.75 50.21 47.63 51.85l8.93 .54a214 214 0 0 0 -46.29 35.54C14 304.7 14 374 14 429.8v33.64l23.32-29.8a148.6 148.6 0 0 0 14.56 37.56c5.78 10.13 14.87 9.45 19.64 7.33 4.21-1.87 10-6.92 3.75-20.11a178.3 178.3 0 0 1 -15.76-53.13l46.82-59.83-24.66 74.11c58.23-42.4 157.4-61.76 236.3-38.59 34.2 10.05 67.45 .69 84.74-23.84 .72-1 1.2-2.16 1.85-3.22a156.1 156.1 0 0 1 2.8 28.43c0 23.3-3.69 52.93-14.88 81.64-2.52 6.46 1.76 14.5 8.6 15.74 7.42 1.57 15.33-3.1 18.37-11.15C429 443 434 414 434 382.3c0-38.58-13-77.46-35.91-110.9zM142.4 128.6l-15.7-.93-1.39 21.79 13.13 .78a93 93 0 0 0 .32 19.57l-22.38-1.34a12.28 12.28 0 0 1 -11.76-12.79L107 119c1-12.17 13.87-11.27 13.26-11.32l29.11 1.73a144.4 144.4 0 0 0 -7 19.17zm148.4 172.2a10.51 10.51 0 0 1 -14.35-1.39l-9.68-11.49-34.42 27a8.09 8.09 0 0 1 -11.13-1.08l-15.78-18.64a7.38 7.38 0 0 1 1.34-10.34l34.57-27.18-14.14-16.74-17.09 13.45a7.75 7.75 0 0 1 -10.59-1s-3.72-4.42-3.8-4.53a7.38 7.38 0 0 1 1.37-10.34L214 225.2s-18.51-22-18.6-22.14a9.56 9.56 0 0 1 1.74-13.42 10.38 10.38 0 0 1 14.3 1.37l81.09 96.32a9.58 9.58 0 0 1 -1.74 13.44zM187.4 419a18 18 0 1 0 18 18 18 18 0 0 0 -18-18z',
			),
		),
		'label'             => __( 'Keybase', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'keyboard'                               => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M512 448H64c-35.35 0-64-28.65-64-64V128c0-35.35 28.65-64 64-64h448c35.35 0 64 28.65 64 64v256C576 419.3 547.3 448 512 448zM128 180v-40C128 133.4 122.6 128 116 128h-40C69.38 128 64 133.4 64 140v40C64 186.6 69.38 192 76 192h40C122.6 192 128 186.6 128 180zM224 180v-40C224 133.4 218.6 128 212 128h-40C165.4 128 160 133.4 160 140v40C160 186.6 165.4 192 172 192h40C218.6 192 224 186.6 224 180zM320 180v-40C320 133.4 314.6 128 308 128h-40C261.4 128 256 133.4 256 140v40C256 186.6 261.4 192 268 192h40C314.6 192 320 186.6 320 180zM416 180v-40C416 133.4 410.6 128 404 128h-40C357.4 128 352 133.4 352 140v40C352 186.6 357.4 192 364 192h40C410.6 192 416 186.6 416 180zM512 180v-40C512 133.4 506.6 128 500 128h-40C453.4 128 448 133.4 448 140v40C448 186.6 453.4 192 460 192h40C506.6 192 512 186.6 512 180zM128 276v-40C128 229.4 122.6 224 116 224h-40C69.38 224 64 229.4 64 236v40C64 282.6 69.38 288 76 288h40C122.6 288 128 282.6 128 276zM224 276v-40C224 229.4 218.6 224 212 224h-40C165.4 224 160 229.4 160 236v40C160 282.6 165.4 288 172 288h40C218.6 288 224 282.6 224 276zM320 276v-40C320 229.4 314.6 224 308 224h-40C261.4 224 256 229.4 256 236v40C256 282.6 261.4 288 268 288h40C314.6 288 320 282.6 320 276zM416 276v-40C416 229.4 410.6 224 404 224h-40C357.4 224 352 229.4 352 236v40C352 282.6 357.4 288 364 288h40C410.6 288 416 282.6 416 276zM512 276v-40C512 229.4 506.6 224 500 224h-40C453.4 224 448 229.4 448 236v40C448 282.6 453.4 288 460 288h40C506.6 288 512 282.6 512 276zM128 372v-40C128 325.4 122.6 320 116 320h-40C69.38 320 64 325.4 64 332v40C64 378.6 69.38 384 76 384h40C122.6 384 128 378.6 128 372zM416 372v-40C416 325.4 410.6 320 404 320h-232C165.4 320 160 325.4 160 332v40C160 378.6 165.4 384 172 384h232C410.6 384 416 378.6 416 372zM512 372v-40C512 325.4 506.6 320 500 320h-40C453.4 320 448 325.4 448 332v40C448 378.6 453.4 384 460 384h40C506.6 384 512 378.6 512 372z',
			),
			'regular' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M512 64H64C28.65 64 0 92.65 0 128v256c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V128C576 92.65 547.3 64 512 64zM528 384c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V128c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V384zM140 152h-24c-6.656 0-12 5.344-12 12v24c0 6.656 5.344 12 12 12h24c6.656 0 12-5.344 12-12v-24C152 157.3 146.7 152 140 152zM196 200h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C184 194.7 189.3 200 196 200zM276 200h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C264 194.7 269.3 200 276 200zM356 200h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C344 194.7 349.3 200 356 200zM460 152h-24c-6.656 0-12 5.344-12 12v24c0 6.656 5.344 12 12 12h24c6.656 0 12-5.344 12-12v-24C472 157.3 466.7 152 460 152zM140 232h-24c-6.656 0-12 5.344-12 12v24c0 6.656 5.344 12 12 12h24c6.656 0 12-5.344 12-12v-24C152 237.3 146.7 232 140 232zM196 280h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C184 274.7 189.3 280 196 280zM276 280h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C264 274.7 269.3 280 276 280zM356 280h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C344 274.7 349.3 280 356 280zM460 232h-24c-6.656 0-12 5.344-12 12v24c0 6.656 5.344 12 12 12h24c6.656 0 12-5.344 12-12v-24C472 237.3 466.7 232 460 232zM400 320h-224C167.1 320 160 327.1 160 336V352c0 8.875 7.125 16 16 16h224c8.875 0 16-7.125 16-16v-16C416 327.1 408.9 320 400 320z',
			),
		),
		'label'             => __( 'Keyboard', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'keycdn'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M63.8 409.3l60.5-59c32.1 42.8 71.1 66 126.6 67.4 30.5 .7 60.3-7 86.4-22.4 5.1 5.3 18.5 19.5 20.9 22-32.2 20.7-69.6 31.1-108.1 30.2-43.3-1.1-84.6-16.7-117.7-44.4 .3-.6-38.2 37.5-38.6 37.9 9.5 29.8-13.1 62.4-46.3 62.4C20.7 503.3 0 481.7 0 454.9c0-34.3 33.1-56.6 63.8-45.6zm354.9-252.4c19.1 31.3 29.6 67.4 28.7 104-1.1 44.8-19 87.5-48.6 121 .3 .3 23.8 25.2 24.1 25.5 9.6-1.3 19.2 2 25.9 9.1 11.3 12 10.9 30.9-1.1 42.4-12 11.3-30.9 10.9-42.4-1.1-6.7-7-9.4-16.8-7.6-26.3-24.9-26.6-44.4-47.2-44.4-47.2 42.7-34.1 63.3-79.6 64.4-124.2 .7-28.9-7.2-57.2-21.1-82.2l22.1-21zM104 53.1c6.7 7 9.4 16.8 7.6 26.3l45.9 48.1c-4.7 3.8-13.3 10.4-22.8 21.3-25.4 28.5-39.6 64.8-40.7 102.9-.7 28.9 6.1 57.2 20 82.4l-22 21.5C72.7 324 63.1 287.9 64.2 250.9c1-44.6 18.3-87.6 47.5-121.1l-25.3-26.4c-9.6 1.3-19.2-2-25.9-9.1-11.3-12-10.9-30.9 1.1-42.4C73.5 40.7 92.2 41 104 53.1zM464.9 8c26 0 47.1 22.4 47.1 48.3S490.9 104 464.9 104c-6.3 .1-14-1.1-15.9-1.8l-62.9 59.7c-32.7-43.6-76.7-65.9-126.9-67.2-30.5-.7-60.3 6.8-86.2 22.4l-21.1-22C184.1 74.3 221.5 64 260 64.9c43.3 1.1 84.6 16.7 117.7 44.6l41.1-38.6c-1.5-4.7-2.2-9.6-2.2-14.5C416.5 29.7 438.9 8 464.9 8zM256.7 113.4c5.5 0 10.9 .4 16.4 1.1 78.1 9.8 133.4 81.1 123.8 159.1-9.8 78.1-81.1 133.4-159.1 123.8-78.1-9.8-133.4-81.1-123.8-159.2 9.3-72.4 70.1-124.6 142.7-124.8zm-59 119.4c.6 22.7 12.2 41.8 32.4 52.2l-11 51.7h73.7l-11-51.7c20.1-10.9 32.1-29 32.4-52.2-.4-32.8-25.8-57.5-58.3-58.3-32.1 .8-57.3 24.8-58.2 58.3zM256 160',
			),
		),
		'label'             => __( 'KeyCDN', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'khanda'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M447.7 65.1c-6.25-3.5-14.29-2.351-19.29 3.024c-5.125 5.375-5.833 13.37-1.958 19.5c16.5 26.25 25.23 56.34 25.23 87.46c-.25 53.25-26.74 102.6-71.24 132.4l-76.62 53.35v-20.12l44.01-36.12c3.875-4.125 4.983-10.13 2.858-15.26L342.8 273c33.88-19.25 56.94-55.25 56.94-97c0-40.75-22.06-76.12-54.56-95.75l5.151-11.39c2.375-5.5 .9825-11.87-3.518-15.1L287.9 .0074l-59.05 52.77C224.4 57.02 222.1 63.37 225.2 68.87l5.203 11.32C197.1 99.81 175.9 135.2 175.9 175.1c0 41.75 23.08 77.75 56.95 97L224.1 290.2C222.9 295.4 223.9 301.2 227.9 305.5l43.1 36.11v19.91L195.2 308.1c-44.25-29.5-70.72-78.9-70.97-132.1c0-31.12 8.73-61.2 25.23-87.45C153.3 82.4 151.8 74.75 146.8 69.5C141.8 64.12 133.2 63.25 126.8 66.75C48.34 109.6 9.713 205.2 45.34 296c7 18 17.88 34.38 30.5 49l55.92 65.38c4.875 5.75 13.09 7.232 19.71 3.732l79.25-42.25l29.26 20.37l-47.09 32.75c-1.625-.375-3.125-1-4.1-1c-13.25 0-23.97 10.75-23.97 24s10.72 23.1 23.97 23.1c12.13 0 21.74-9.126 23.36-20.75l40.6-28.25v29.91c-9.375 5.625-15.97 15.37-15.97 27.12c0 17.62 14.37 31.1 31.1 31.1c17.63 0 31.1-14.37 31.1-31.1c0-11.75-6.656-21.52-16.03-27.14v-30.12l40.87 28.48c1.625 11.63 11.23 20.75 23.35 20.75c13.25 0 23.98-10.74 23.98-23.99s-10.73-24-23.98-24c-1.875 0-3.375 .625-5 1l-47.09-32.75l29.25-20.37l79.26 42.25c6.625 3.5 14.84 2.018 19.71-3.732l52.51-61.27c18.88-22 33.1-47.49 41.25-75.61C559.6 189.9 521.5 106.2 447.7 65.1zM351.8 176c0 22.25-11.45 41.91-28.82 53.41l-5.613-12.43c-8.75-24.5-8.811-51.11-.061-75.61l7.748-17.12C341.2 135.9 351.8 154.6 351.8 176zM223.8 176c0-21.38 10.67-40.16 26.67-51.79l7.848 17.17c8.75 24.63 8.747 51.11-.0032 75.61L252.7 229.4C235.4 217.9 223.8 198.2 223.8 176z',
			),
		),
		'label'             => __( 'Khanda', 'astra' ),
		'custom_categories' => array(),
	),
	'kickstarter'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 480H48c-26.4 0-48-21.6-48-48V80c0-26.4 21.6-48 48-48h352c26.4 0 48 21.6 48 48v352c0 26.4-21.6 48-48 48zM199.6 178.5c0-30.7-17.6-45.1-39.7-45.1-25.8 0-40 19.8-40 44.5v154.8c0 25.8 13.7 45.6 40.5 45.6 21.5 0 39.2-14 39.2-45.6v-41.8l60.6 75.7c12.3 14.9 39 16.8 55.8 0 14.6-15.1 14.8-36.8 4-50.4l-49.1-62.8 40.5-58.7c9.4-13.5 9.5-34.5-5.6-49.1-16.4-15.9-44.6-17.3-61.4 7l-44.8 64.7v-38.8z',
			),
		),
		'label'             => __( 'Kickstarter', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'kickstarter-k'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M147.3 114.4c0-56.2-32.5-82.4-73.4-82.4C26.2 32 0 68.2 0 113.4v283c0 47.3 25.3 83.4 74.9 83.4 39.8 0 72.4-25.6 72.4-83.4v-76.5l112.1 138.3c22.7 27.2 72.1 30.7 103.2 0 27-27.6 27.3-67.4 7.4-92.2l-90.8-114.8 74.9-107.4c17.4-24.7 17.5-63.1-10.4-89.8-30.3-29-82.4-31.6-113.6 12.8L147.3 185v-70.6z',
			),
		),
		'label'             => __( 'Kickstarter K', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'kip-sign'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M182.5 224H352C369.7 224 384 238.3 384 256C384 273.7 369.7 288 352 288H182.5L340.8 423.7C354.2 435.2 355.8 455.4 344.3 468.8C332.8 482.2 312.6 483.8 299.2 472.3L128 325.6V448C128 465.7 113.7 480 96 480C78.33 480 64 465.7 64 448V288H32C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224H64V64C64 46.33 78.33 32 96 32C113.7 32 128 46.33 128 64V186.4L299.2 39.7C312.6 28.2 332.8 29.76 344.3 43.18C355.8 56.59 354.2 76.8 340.8 88.3L182.5 224z',
			),
		),
		'label'             => __( 'Kip Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'kit-medical'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M64 32h32v448H64c-35.35 0-64-28.66-64-64V96C0 60.66 28.65 32 64 32zM128 32h320v448H128V32zM176 282c0 8.835 7.164 16 16 16h53.1V352c0 8.836 7.165 16 16 16h52c8.836 0 16-7.164 16-16V298H384c8.836 0 16-7.165 16-16v-52c0-8.837-7.164-16-16-16h-54V160c0-8.836-7.164-16-16-16h-52c-8.835 0-16 7.164-16 16v54H192c-8.836 0-16 7.163-16 16V282zM512 32h-32v448h32c35.35 0 64-28.66 64-64V96C576 60.66 547.3 32 512 32z',
			),
		),
		'label'             => __( 'Kit Medical', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'kitchen-set'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M80 144C80 108.7 108.7 80 144 80C179.3 80 208 108.7 208 144C208 179.3 179.3 208 144 208C108.7 208 80 179.3 80 144zM284.4 176C269.9 240.1 212.5 288 144 288C64.47 288 0 223.5 0 144C0 64.47 64.47 0 144 0C212.5 0 269.9 47.87 284.4 112H356.2C365 102.2 377.8 96 392 96H496C522.5 96 544 117.5 544 144C544 170.5 522.5 192 496 192H392C377.8 192 365 185.8 356.2 176H284.4zM144 48C90.98 48 48 90.98 48 144C48 197 90.98 240 144 240C197 240 240 197 240 144C240 90.98 197 48 144 48zM424 264V272H520C533.3 272 544 282.7 544 296C544 309.3 533.3 320 520 320H280C266.7 320 256 309.3 256 296C256 282.7 266.7 272 280 272H376V264C376 250.7 386.7 240 400 240C413.3 240 424 250.7 424 264zM288 464V352H512V464C512 490.5 490.5 512 464 512H336C309.5 512 288 490.5 288 464zM176 320C202.5 320 224 341.5 224 368C224 394.5 202.5 416 176 416H160C160 433.7 145.7 448 128 448H64C46.33 448 32 433.7 32 416V336C32 327.2 39.16 320 48 320H176zM192 368C192 359.2 184.8 352 176 352H160V384H176C184.8 384 192 376.8 192 368zM200 464C213.3 464 224 474.7 224 488C224 501.3 213.3 512 200 512H24C10.75 512 0 501.3 0 488C0 474.7 10.75 464 24 464H200z',
			),
		),
		'label'             => __( 'Kitchen Set', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'kiwi-bird'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M256 405.1V456C256 469.3 245.3 480 232 480C218.7 480 208 469.3 208 456V415.3C202.7 415.8 197.4 416 192 416C175.4 416 159.3 413.9 144 409.1V456C144 469.3 133.3 480 120 480C106.7 480 96 469.3 96 456V390.3C38.61 357.1 0 295.1 0 224C0 117.1 85.96 32 192 32C228.3 32 262.3 42.08 291.2 59.6C322.4 78.44 355.9 96 392.3 96H448C518.7 96 576 153.3 576 224V464C576 470.1 571.5 477.2 564.8 479.3C558.2 481.4 550.9 478.9 546.9 473.2L461.6 351.3C457.1 351.8 452.6 352 448 352H392.3C355.9 352 322.4 369.6 291.2 388.4C280.2 395.1 268.4 400.7 256 405.1zM448 248C461.3 248 472 237.3 472 224C472 210.7 461.3 200 448 200C434.7 200 424 210.7 424 224C424 237.3 434.7 248 448 248z',
			),
		),
		'label'             => __( 'Kiwi Bird', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'korvue'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 446,
				'height' => 512,
				'path'   => 'M386.5 34h-327C26.8 34 0 60.8 0 93.5v327.1C0 453.2 26.8 480 59.5 480h327.1c33 0 59.5-26.8 59.5-59.5v-327C446 60.8 419.2 34 386.5 34zM87.1 120.8h96v116l61.8-116h110.9l-81.2 132H87.1v-132zm161.8 272.1l-65.7-113.6v113.6h-96V262.1h191.5l88.6 130.8H248.9z',
			),
		),
		'label'             => __( 'KORVUE', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'l'                                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M320 448c0 17.67-14.31 32-32 32H64c-17.69 0-32-14.33-32-32v-384C32 46.34 46.31 32.01 64 32.01S96 46.34 96 64.01v352h192C305.7 416 320 430.3 320 448z',
			),
		),
		'label'             => __( 'L', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'land-mine-on'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M312 168C312 181.3 301.3 192 288 192C274.7 192 264 181.3 264 168V24C264 10.75 274.7 0 288 0C301.3 0 312 10.75 312 24V168zM160 320C160 302.3 174.3 288 192 288H384C401.7 288 416 302.3 416 320V352H160V320zM82.74 410.5C90.87 394.3 107.5 384 125.7 384H450.3C468.5 384 485.1 394.3 493.3 410.5L520.8 465.7C531.5 486.1 516 512 492.2 512H83.78C59.99 512 44.52 486.1 55.16 465.7L82.74 410.5zM4.269 138.3C11.81 127.4 26.77 124.7 37.66 132.3L141.7 204.3C152.6 211.8 155.3 226.8 147.7 237.7C140.2 248.6 125.2 251.3 114.3 243.7L10.34 171.7C-.5568 164.2-3.275 149.2 4.269 138.3V138.3zM538.3 132.3C549.2 124.7 564.2 127.4 571.7 138.3C579.3 149.2 576.6 164.2 565.7 171.7L461.7 243.7C450.8 251.3 435.8 248.6 428.3 237.7C420.7 226.8 423.4 211.8 434.3 204.3L538.3 132.3z',
			),
		),
		'label'             => __( 'Land Mine On', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'landmark'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M240.1 4.216C249.1-1.405 262-1.405 271.9 4.216L443.6 102.4L447.1 104V104.9L495.9 132.2C508.5 139.4 514.6 154.2 510.9 168.2C507.2 182.2 494.5 192 479.1 192H31.1C17.49 192 4.795 182.2 1.071 168.2C-2.653 154.2 3.524 139.4 16.12 132.2L63.1 104.9V104L68.37 102.4L240.1 4.216zM64 224H128V416H168V224H232V416H280V224H344V416H384V224H448V420.3C448.6 420.6 449.2 420.1 449.8 421.4L497.8 453.4C509.5 461.2 514.7 475.8 510.6 489.3C506.5 502.8 494.1 512 480 512H32C17.9 512 5.46 502.8 1.373 489.3C-2.713 475.8 2.517 461.2 14.25 453.4L62.25 421.4C62.82 420.1 63.41 420.6 64 420.3V224z',
			),
		),
		'label'             => __( 'Landmark', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'landmark-dome'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M264 0C277.3 0 288 10.75 288 24V34.65C368.4 48.14 431.9 111.6 445.3 192H448C465.7 192 480 206.3 480 224C480 241.7 465.7 256 448 256H63.1C46.33 256 31.1 241.7 31.1 224C31.1 206.3 46.33 192 63.1 192H66.65C80.14 111.6 143.6 48.14 223.1 34.65V24C223.1 10.75 234.7 0 247.1 0L264 0zM63.1 288H127.1V416H167.1V288H231.1V416H280V288H344V416H384V288H448V420.3C448.6 420.6 449.2 420.1 449.8 421.4L497.8 453.4C509.5 461.2 514.7 475.8 510.6 489.3C506.5 502.8 494.1 512 480 512H31.1C17.9 512 5.458 502.8 1.372 489.3C-2.715 475.8 2.515 461.2 14.25 453.4L62.25 421.4C62.82 420.1 63.41 420.6 63.1 420.3V288z',
			),
		),
		'label'             => __( 'Landmark Dome', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'landmark-flag'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M352 0C360.8 0 368 7.164 368 16V80C368 88.84 360.8 96 352 96H272V128H464C481.7 128 496 142.3 496 160C496 177.7 481.7 192 464 192H47.1C30.33 192 15.1 177.7 15.1 160C15.1 142.3 30.33 128 47.1 128H239.1V16C239.1 7.164 247.2 0 255.1 0H352zM63.1 224H127.1V416H167.1V224H231.1V416H280V224H344V416H384V224H448V420.3C448.6 420.6 449.2 420.1 449.8 421.4L497.8 453.4C509.5 461.2 514.7 475.8 510.6 489.3C506.5 502.8 494.1 512 480 512H31.1C17.9 512 5.458 502.8 1.372 489.3C-2.715 475.8 2.515 461.2 14.25 453.4L62.25 421.4C62.82 420.1 63.4 420.6 63.1 420.3V224z',
			),
		),
		'label'             => __( 'Landmark Flag', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'language'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M448 164C459 164 468 172.1 468 184V188H528C539 188 548 196.1 548 208C548 219 539 228 528 228H526L524.4 232.5C515.5 256.1 501.9 279.1 484.7 297.9C485.6 298.4 486.5 298.1 487.4 299.5L506.3 310.8C515.8 316.5 518.8 328.8 513.1 338.3C507.5 347.8 495.2 350.8 485.7 345.1L466.8 333.8C462.4 331.1 457.1 328.3 453.7 325.3C443.2 332.8 431.8 339.3 419.8 344.7L416.1 346.3C406 350.8 394.2 346.2 389.7 336.1C385.2 326 389.8 314.2 399.9 309.7L403.5 308.1C409.9 305.2 416.1 301.1 422 298.3L409.9 286.1C402 278.3 402 265.7 409.9 257.9C417.7 250 430.3 250 438.1 257.9L452.7 272.4L453.3 272.1C465.7 259.9 475.8 244.7 483.1 227.1H376C364.1 227.1 356 219 356 207.1C356 196.1 364.1 187.1 376 187.1H428V183.1C428 172.1 436.1 163.1 448 163.1L448 164zM160 233.2L179 276H140.1L160 233.2zM0 128C0 92.65 28.65 64 64 64H576C611.3 64 640 92.65 640 128V384C640 419.3 611.3 448 576 448H64C28.65 448 0 419.3 0 384V128zM320 384H576V128H320V384zM178.3 175.9C175.1 168.7 167.9 164 160 164C152.1 164 144.9 168.7 141.7 175.9L77.72 319.9C73.24 329.1 77.78 341.8 87.88 346.3C97.97 350.8 109.8 346.2 114.3 336.1L123.2 315.1H196.8L205.7 336.1C210.2 346.2 222 350.8 232.1 346.3C242.2 341.8 246.8 329.1 242.3 319.9L178.3 175.9z',
			),
		),
		'label'             => __( 'Language', 'astra' ),
		'custom_categories' => array(
			'communication',
		),
	),
	'laptop'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M128 96h384v256h64v-272c0-26.38-21.62-48-48-48h-416c-26.38 0-48 21.62-48 48V352h64V96zM624 383.1h-608c-8.75 0-16 7.25-16 16v16c0 35.25 28.75 64 64 64h512c35.25 0 64-28.75 64-64v-16C640 391.2 632.8 383.1 624 383.1z',
			),
		),
		'label'             => __( 'Laptop', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'laptop-code'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M128 96h384v256h64V80C576 53.63 554.4 32 528 32h-416C85.63 32 64 53.63 64 80V352h64V96zM624 384h-608C7.25 384 0 391.3 0 400V416c0 35.25 28.75 64 64 64h512c35.25 0 64-28.75 64-64v-16C640 391.3 632.8 384 624 384zM365.9 286.2C369.8 290.1 374.9 292 380 292s10.23-1.938 14.14-5.844l48-48c7.812-7.813 7.812-20.5 0-28.31l-48-48c-7.812-7.813-20.47-7.813-28.28 0c-7.812 7.813-7.812 20.5 0 28.31l33.86 33.84l-33.86 33.84C358 265.7 358 278.4 365.9 286.2zM274.1 161.9c-7.812-7.813-20.47-7.813-28.28 0l-48 48c-7.812 7.813-7.812 20.5 0 28.31l48 48C249.8 290.1 254.9 292 260 292s10.23-1.938 14.14-5.844c7.812-7.813 7.812-20.5 0-28.31L240.3 224l33.86-33.84C281.1 182.4 281.1 169.7 274.1 161.9z',
			),
		),
		'label'             => __( 'Laptop Code', 'astra' ),
		'custom_categories' => array(
			'education',
			'science-and-technology',
		),
	),
	'laptop-file'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M192 96C192 113.7 206.3 128 224 128H320V192H288C243.8 192 208 227.8 208 272V384C187.1 384 169.3 397.4 162.7 416H48C21.49 416 0 394.5 0 368V48C0 21.49 21.49 0 48 0H192V96zM240 272C240 245.5 261.5 224 288 224H544C570.5 224 592 245.5 592 272V416H624C632.8 416 640 423.2 640 432V448C640 483.3 611.3 512 576 512H256C220.7 512 192 483.3 192 448V432C192 423.2 199.2 416 208 416H240V272zM304 288V416H528V288H304zM320 96H224V0L320 96z',
			),
		),
		'label'             => __( 'Laptop File', 'astra' ),
		'custom_categories' => array(
			'business',
			'education',
			'science-and-technology',
		),
	),
	'laptop-medical'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M624 384h-608C7.25 384 0 391.3 0 400V416c0 35.25 28.75 64 64 64h512c35.25 0 64-28.75 64-64v-16C640 391.3 632.8 384 624 384zM128 96h384v256h64V80C576 53.63 554.4 32 528 32h-416C85.63 32 64 53.63 64 80V352h64V96zM304 336h32c8.801 0 16-7.201 16-16V272h48C408.8 272 416 264.8 416 256V224c0-8.801-7.199-16-16-16H352V160c0-8.801-7.199-16-16-16h-32C295.2 144 288 151.2 288 160v48H240C231.2 208 224 215.2 224 224v32c0 8.799 7.199 16 16 16H288V320C288 328.8 295.2 336 304 336z',
			),
		),
		'label'             => __( 'Laptop Medical', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'laravel'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M504.4 115.8a5.72 5.72 0 0 0 -.28-.68 8.52 8.52 0 0 0 -.53-1.25 6 6 0 0 0 -.54-.71 9.36 9.36 0 0 0 -.72-.94c-.23-.22-.52-.4-.77-.6a8.84 8.84 0 0 0 -.9-.68L404.4 55.55a8 8 0 0 0 -8 0L300.1 111h0a8.07 8.07 0 0 0 -.88 .69 7.68 7.68 0 0 0 -.78 .6 8.23 8.23 0 0 0 -.72 .93c-.17 .24-.39 .45-.54 .71a9.7 9.7 0 0 0 -.52 1.25c-.08 .23-.21 .44-.28 .68a8.08 8.08 0 0 0 -.28 2.08V223.2l-80.22 46.19V63.44a7.8 7.8 0 0 0 -.28-2.09c-.06-.24-.2-.45-.28-.68a8.35 8.35 0 0 0 -.52-1.24c-.14-.26-.37-.47-.54-.72a9.36 9.36 0 0 0 -.72-.94 9.46 9.46 0 0 0 -.78-.6 9.8 9.8 0 0 0 -.88-.68h0L115.6 1.07a8 8 0 0 0 -8 0L11.34 56.49h0a6.52 6.52 0 0 0 -.88 .69 7.81 7.81 0 0 0 -.79 .6 8.15 8.15 0 0 0 -.71 .93c-.18 .25-.4 .46-.55 .72a7.88 7.88 0 0 0 -.51 1.24 6.46 6.46 0 0 0 -.29 .67 8.18 8.18 0 0 0 -.28 2.1v329.7a8 8 0 0 0 4 6.95l192.5 110.8a8.83 8.83 0 0 0 1.33 .54c.21 .08 .41 .2 .63 .26a7.92 7.92 0 0 0 4.1 0c.2-.05 .37-.16 .55-.22a8.6 8.6 0 0 0 1.4-.58L404.4 400.1a8 8 0 0 0 4-6.95V287.9l92.24-53.11a8 8 0 0 0 4-7V117.9A8.63 8.63 0 0 0 504.4 115.8zM111.6 17.28h0l80.19 46.15-80.2 46.18L31.41 63.44zm88.25 60V278.6l-46.53 26.79-33.69 19.4V123.5l46.53-26.79zm0 412.8L23.37 388.5V77.32L57.06 96.7l46.52 26.8V338.7a6.94 6.94 0 0 0 .12 .9 8 8 0 0 0 .16 1.18h0a5.92 5.92 0 0 0 .38 .9 6.38 6.38 0 0 0 .42 1v0a8.54 8.54 0 0 0 .6 .78 7.62 7.62 0 0 0 .66 .84l0 0c.23 .22 .52 .38 .77 .58a8.93 8.93 0 0 0 .86 .66l0 0 0 0 92.19 52.18zm8-106.2-80.06-45.32 84.09-48.41 92.26-53.11 80.13 46.13-58.8 33.56zm184.5 4.57L215.9 490.1V397.8L346.6 323.2l45.77-26.15zm0-119.1L358.7 250l-46.53-26.79V131.8l33.69 19.4L392.4 178zm8-105.3-80.2-46.17 80.2-46.16 80.18 46.15zm8 105.3V178L455 151.2l33.68-19.4v91.39h0z',
			),
		),
		'label'             => __( 'Laravel', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'lari-sign'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M144 32C161.7 32 176 46.33 176 64V96.66C181.3 96.22 186.6 96 192 96C197.4 96 202.7 96.22 208 96.66V64C208 46.33 222.3 32 240 32C257.7 32 272 46.33 272 64V113.4C326.9 138.6 367.8 188.9 380.2 249.6C383.7 266.1 372.5 283.8 355.2 287.4C337.8 290.9 320.1 279.7 317.4 262.4C311.4 232.5 294.9 206.4 272 188.1V256C272 273.7 257.7 288 240 288C222.3 288 208 273.7 208 256V160.1C202.8 160.3 197.4 160 192 160C186.6 160 181.2 160.3 176 160.1V256C176 273.7 161.7 288 144 288C126.3 288 112 273.7 112 256V188.1C82.74 211.5 64 247.6 64 288C64 358.7 121.3 416 192 416H352C369.7 416 384 430.3 384 448C384 465.7 369.7 480 352 480H32C14.33 480 0 465.7 0 448C0 430.3 14.33 416 32 416H48.89C18.49 382 0 337.2 0 288C0 210.5 45.9 143.7 112 113.4V64C112 46.33 126.3 32 144 32V32z',
			),
		),
		'label'             => __( 'Lari Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'lastfm'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M225.8 367.1l-18.8-51s-30.5 34-76.2 34c-40.5 0-69.2-35.2-69.2-91.5 0-72.1 36.4-97.9 72.1-97.9 66.5 0 74.8 53.3 100.9 134.9 18.8 56.9 54 102.6 155.4 102.6 72.7 0 122-22.3 122-80.9 0-72.9-62.7-80.6-115-92.1-25.8-5.9-33.4-16.4-33.4-34 0-19.9 15.8-31.7 41.6-31.7 28.2 0 43.4 10.6 45.7 35.8l58.6-7c-4.7-52.8-41.1-74.5-100.9-74.5-52.8 0-104.4 19.9-104.4 83.9 0 39.9 19.4 65.1 68 76.8 44.9 10.6 79.8 13.8 79.8 45.7 0 21.7-21.1 30.5-61 30.5-59.2 0-83.9-31.1-97.9-73.9-32-96.8-43.6-163-161.3-163C45.7 113.8 0 168.3 0 261c0 89.1 45.7 137.2 127.9 137.2 66.2 0 97.9-31.1 97.9-31.1z',
			),
		),
		'label'             => __( 'last.fm', 'astra' ),
		'custom_categories' => array(),
	),
	'lastfm-square'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-92.2 312.9c-63.4 0-85.4-28.6-97.1-64.1-16.3-51-21.5-84.3-63-84.3-22.4 0-45.1 16.1-45.1 61.2 0 35.2 18 57.2 43.3 57.2 28.6 0 47.6-21.3 47.6-21.3l11.7 31.9s-19.8 19.4-61.2 19.4c-51.3 0-79.9-30.1-79.9-85.8 0-57.9 28.6-92 82.5-92 73.5 0 80.8 41.4 100.8 101.9 8.8 26.8 24.2 46.2 61.2 46.2 24.9 0 38.1-5.5 38.1-19.1 0-19.9-21.8-22-49.9-28.6-30.4-7.3-42.5-23.1-42.5-48 0-40 32.3-52.4 65.2-52.4 37.4 0 60.1 13.6 63 46.6l-36.7 4.4c-1.5-15.8-11-22.4-28.6-22.4-16.1 0-26 7.3-26 19.8 0 11 4.8 17.6 20.9 21.3 32.7 7.1 71.8 12 71.8 57.5 .1 36.7-30.7 50.6-76.1 50.6z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'layer-group'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M232.5 5.171C247.4-1.718 264.6-1.718 279.5 5.171L498.1 106.2C506.6 110.1 512 118.6 512 127.1C512 137.3 506.6 145.8 498.1 149.8L279.5 250.8C264.6 257.7 247.4 257.7 232.5 250.8L13.93 149.8C5.438 145.8 0 137.3 0 127.1C0 118.6 5.437 110.1 13.93 106.2L232.5 5.171zM498.1 234.2C506.6 238.1 512 246.6 512 255.1C512 265.3 506.6 273.8 498.1 277.8L279.5 378.8C264.6 385.7 247.4 385.7 232.5 378.8L13.93 277.8C5.438 273.8 0 265.3 0 255.1C0 246.6 5.437 238.1 13.93 234.2L67.13 209.6L219.1 279.8C242.5 290.7 269.5 290.7 292.9 279.8L444.9 209.6L498.1 234.2zM292.9 407.8L444.9 337.6L498.1 362.2C506.6 366.1 512 374.6 512 383.1C512 393.3 506.6 401.8 498.1 405.8L279.5 506.8C264.6 513.7 247.4 513.7 232.5 506.8L13.93 405.8C5.438 401.8 0 393.3 0 383.1C0 374.6 5.437 366.1 13.93 362.2L67.13 337.6L219.1 407.8C242.5 418.7 269.5 418.7 292.9 407.8V407.8z',
			),
		),
		'label'             => __( 'Layer Group', 'astra' ),
		'custom_categories' => array(
			'design',
			'travel',
		),
	),
	'leaf'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 165.4c0 127.9-70.05 235.3-175.3 270.1c-20.04 7.938-41.83 12.46-64.69 12.46c-64.9 0-125.2-36.51-155.7-94.47c-54.13 49.93-68.71 107-68.96 108.1C44.72 472.6 34.87 480 24.02 480c-1.844 0-3.727-.2187-5.602-.6562c-12.89-3.098-20.84-16.08-17.75-28.96c9.598-39.5 90.47-226.4 335.3-226.4C344.8 224 352 216.8 352 208S344.8 192 336 192C228.6 192 151 226.6 96.29 267.6c.1934-10.82 1.242-21.84 3.535-33.05c13.47-65.81 66.04-119 131.4-134.2c28.33-6.562 55.68-6.013 80.93-.0054c56 13.32 118.2-7.412 149.3-61.24c5.664-9.828 20.02-9.516 24.66 .8282C502.7 76.76 512 121.9 512 165.4z',
			),
		),
		'label'             => __( 'Leaf', 'astra' ),
		'custom_categories' => array(
			'business',
			'environment',
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'leanpub'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M386.5 111.5l15.1 248.1-10.98-.275c-36.23-.824-71.64 8.783-102.7 27.1-31.02-19.21-66.42-27.1-102.7-27.1-45.56 0-82.07 10.7-123.5 27.72L93.12 129.6c28.55-11.8 61.48-18.11 92.23-18.11 41.17 0 73.84 13.18 102.7 42.54 27.72-28.27 59.01-41.72 98.54-42.54zM569.1 448c-25.53 0-47.49-5.215-70.54-15.65-34.31-15.65-69.99-24.98-107.9-24.98-38.98 0-74.93 12.9-102.7 40.62-27.72-27.72-63.68-40.62-102.7-40.62-37.88 0-73.56 9.333-107.9 24.98C55.24 442.2 32.73 448 8.303 448H6.93L49.47 98.86C88.73 76.63 136.5 64 181.8 64 218.8 64 256.1 71.68 288 93.1 319 71.68 357.2 64 394.2 64c45.29 0 93.05 12.63 132.3 34.86L569.1 448zm-43.37-44.74l-34.04-280.2c-30.74-13.1-67.25-21.41-101-21.41-38.43 0-74.39 12.08-102.7 38.7-28.27-26.63-64.23-38.7-102.7-38.7-33.76 0-70.27 7.411-101 21.41L50.3 403.3c47.21-19.49 82.89-33.49 135-33.49 37.6 0 70.82 9.606 102.7 29.64 31.84-20.04 65.05-29.64 102.7-29.64 52.15 0 87.83 13.1 135 33.49z',
			),
		),
		'label'             => __( 'Leanpub', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'left-long'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 256C512 273.7 497.7 288 480 288H160.1l0 72c0 9.547-5.66 18.19-14.42 22c-8.754 3.812-18.95 2.077-25.94-4.407l-112.1-104c-10.24-9.5-10.24-25.69 0-35.19l112.1-104c6.992-6.484 17.18-8.218 25.94-4.406C154.4 133.8 160.1 142.5 160.1 151.1L160.1 224H480C497.7 224 512 238.3 512 256z',
			),
		),
		'label'             => __( 'Left Long', 'astra' ),
		'custom_categories' => array(),
	),
	'left-right'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M503.1 273.6l-112 104c-6.984 6.484-17.17 8.219-25.92 4.406s-14.41-12.45-14.41-22v-56l-192 .001V360c0 9.547-5.656 18.19-14.41 22c-8.75 3.812-18.94 2.078-25.92-4.406l-112-104c-9.781-9.094-9.781-26.09 0-35.19l112-104c6.984-6.484 17.17-8.219 25.92-4.406C154 133.8 159.7 142.5 159.7 152v55.1l192-.001v-56c0-9.547 5.656-18.19 14.41-22s18.94-2.078 25.92 4.406l112 104C513.8 247.5 513.8 264.5 503.1 273.6z',
			),
		),
		'label'             => __( 'Left Right', 'astra' ),
		'custom_categories' => array(),
	),
	'lemon'                                  => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M427.9 52.1c-20.13-20.23-47.58-25.27-65.63-14.77c-51.63 30.08-158.6-46.49-281 75.91c-122.4 122.4-45.83 229.4-75.91 281c-10.5 18.05-5.471 45.5 14.77 65.63c20.13 20.24 47.58 25.27 65.63 14.77c51.63-30.08 158.6 46.49 281-75.91c122.4-122.4 45.83-229.4 75.91-281C453.2 99.69 448.1 72.23 427.9 52.1zM211.9 127.5C167.6 138.7 106.7 199.6 95.53 243.9C93.69 251.2 87.19 255.1 79.1 255.1c-1.281 0-2.594-.1562-3.906-.4687C67.53 253.4 62.34 244.7 64.47 236.1c14.16-56.28 83.31-125.4 139.6-139.6c8.656-2.031 17.25 3.062 19.44 11.62C225.7 116.7 220.5 125.3 211.9 127.5z',
			),
			'regular' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M439.9 144.6c15.34-26.38 8.372-62.41-16.96-87.62c-25.21-25.32-61.22-32.26-87.61-16.95c-9.044 5.218-27.15 3.702-48.08 1.968c-50.78-4.327-127.4-10.73-207.6 69.56C-.6501 191.9 5.801 268.5 10.07 319.3c1.749 20.96 3.28 39.07-1.984 48.08c-15.35 26.4-8.357 62.45 16.92 87.57c16.26 16.37 37.05 25.09 56.83 25.09c10.89 0 21.46-2.64 30.83-8.092c9.013-5.249 27.12-3.718 48.08-1.968c50.69 4.233 127.4 10.7 207.6-69.56c80.27-80.28 73.82-156.9 69.56-207.7C436.2 171.8 434.7 153.7 439.9 144.6zM398.4 120.5c-12.87 22.09-10.67 48.41-8.326 76.25c4.155 49.3 8.841 105.2-55.67 169.7c-64.53 64.49-120.5 59.78-169.7 55.68c-27.85-2.328-54.12-4.53-76.26 8.311c-6.139 3.64-19.17 1.031-29.58-9.451c-10.39-10.33-12.95-23.35-9.372-29.49c12.87-22.09 10.67-48.41 8.326-76.25C53.72 265.1 49.04 210.1 113.5 145.5c48.27-48.27 91.71-57.8 131.2-57.8c13.28 0 26.12 1.078 38.52 2.125c27.9 2.359 54.17 4.561 76.26-8.311c6.123-3.577 19.18-1.031 29.49 9.357C399.4 101.2 402 114.4 398.4 120.5zM239.5 124.1c2.156 8.561-3.062 17.25-11.62 19.43C183.6 154.7 122.7 215.6 111.6 259.9C109.7 267.1 103.2 271.1 96.05 271.1c-1.281 0-2.593-.1562-3.905-.4687C83.58 269.3 78.4 260.6 80.52 252.1C94.67 195.8 163.8 126.7 220.1 112.5C228.8 110.4 237.3 115.5 239.5 124.1z',
			),
		),
		'label'             => __( 'Lemon', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'less'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M612.7 219c0-20.5 3.2-32.6 3.2-54.6 0-34.2-12.6-45.2-40.5-45.2h-20.5v24.2h6.3c14.2 0 17.3 4.7 17.3 22.1 0 16.3-1.6 32.6-1.6 51.5 0 24.2 7.9 33.6 23.6 37.3v1.6c-15.8 3.7-23.6 13.1-23.6 37.3 0 18.9 1.6 34.2 1.6 51.5 0 17.9-3.7 22.6-17.3 22.6v.5h-6.3V393h20.5c27.8 0 40.5-11 40.5-45.2 0-22.6-3.2-34.2-3.2-54.6 0-11 6.8-22.6 27.3-23.6v-27.3c-20.5-.7-27.3-12.3-27.3-23.3zm-105.6 32c-15.8-6.3-30.5-10-30.5-20.5 0-7.9 6.3-12.6 17.9-12.6s22.1 4.7 33.6 13.1l21-27.8c-13.1-10-31-20.5-55.2-20.5-35.7 0-59.9 20.5-59.9 49.4 0 25.7 22.6 38.9 41.5 46.2 16.3 6.3 32.1 11.6 32.1 22.1 0 7.9-6.3 13.1-20.5 13.1-13.1 0-26.3-5.3-40.5-16.3l-21 30.5c15.8 13.1 39.9 22.1 59.9 22.1 42 0 64.6-22.1 64.6-51s-22.5-41-43-47.8zm-358.9 59.4c-3.7 0-8.4-3.2-8.4-13.1V119.1H65.2c-28.4 0-41 11-41 45.2 0 22.6 3.2 35.2 3.2 54.6 0 11-6.8 22.6-27.3 23.6v27.3c20.5 .5 27.3 12.1 27.3 23.1 0 19.4-3.2 31-3.2 53.6 0 34.2 12.6 45.2 40.5 45.2h20.5v-24.2h-6.3c-13.1 0-17.3-5.3-17.3-22.6s1.6-32.1 1.6-51.5c0-24.2-7.9-33.6-23.6-37.3v-1.6c15.8-3.7 23.6-13.1 23.6-37.3 0-18.9-1.6-34.2-1.6-51.5s3.7-22.1 17.3-22.1H93v150.8c0 32.1 11 53.1 43.1 53.1 10 0 17.9-1.6 23.6-3.7l-5.3-34.2c-3.1 .8-4.6 .8-6.2 .8zM379.9 251c-16.3-6.3-31-10-31-20.5 0-7.9 6.3-12.6 17.9-12.6 11.6 0 22.1 4.7 33.6 13.1l21-27.8c-13.1-10-31-20.5-55.2-20.5-35.7 0-59.9 20.5-59.9 49.4 0 25.7 22.6 38.9 41.5 46.2 16.3 6.3 32.1 11.6 32.1 22.1 0 7.9-6.3 13.1-20.5 13.1-13.1 0-26.3-5.3-40.5-16.3l-20.5 30.5c15.8 13.1 39.9 22.1 59.9 22.1 42 0 64.6-22.1 64.6-51 .1-28.9-22.5-41-43-47.8zm-155-68.8c-38.4 0-75.1 32.1-74.1 82.5 0 52 34.2 82.5 79.3 82.5 18.9 0 39.9-6.8 56.2-17.9l-15.8-27.8c-11.6 6.8-22.6 10-34.2 10-21 0-37.3-10-41.5-34.2H290c.5-3.7 1.6-11 1.6-19.4 .6-42.6-22.6-75.7-66.7-75.7zm-30 66.2c3.2-21 15.8-31 30.5-31 18.9 0 26.3 13.1 26.3 31h-56.8z',
			),
		),
		'label'             => __( 'Less', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'less-than'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M351.1 448c-4.797 0-9.688-1.094-14.28-3.375l-320-160C6.844 279.2 0 268.1 0 256c0-12.13 6.844-23.18 17.69-28.62l320-160c15.88-7.875 35.05-1.5 42.94 14.31c7.906 15.81 1.5 35.03-14.31 42.94L103.5 256l262.8 131.4c15.81 7.906 22.22 27.12 14.31 42.94C375 441.5 363.7 448 351.1 448z',
			),
		),
		'label'             => __( 'Less Than', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'less-than-equal'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M52.11 221.7l320 128C376 351.3 380 352 383.1 352c12.7 0 24.72-7.594 29.73-20.12c6.562-16.41-1.422-35.03-17.83-41.59L150.2 192l245.7-98.28c16.41-6.562 24.39-25.19 17.83-41.59S388.6 27.68 372.1 34.21l-320 128.1C39.97 167.2 32 178.9 32 192S39.97 216.8 52.11 221.7zM416 416H32c-17.67 0-32 14.31-32 31.1S14.33 480 32 480h384c17.67 0 32-14.31 32-32S433.7 416 416 416z',
			),
		),
		'label'             => __( 'Less Than Equal', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'life-ring'                              => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M470.6 425.4C483.1 437.9 483.1 458.1 470.6 470.6C458.1 483.1 437.9 483.1 425.4 470.6L412.1 458.2C369.6 491.9 315.2 512 255.1 512C196.8 512 142.4 491.9 99.02 458.2L86.63 470.6C74.13 483.1 53.87 483.1 41.37 470.6C28.88 458.1 28.88 437.9 41.37 425.4L53.76 412.1C20.07 369.6 0 315.2 0 255.1C0 196.8 20.07 142.4 53.76 99.02L41.37 86.63C28.88 74.13 28.88 53.87 41.37 41.37C53.87 28.88 74.13 28.88 86.63 41.37L99.02 53.76C142.4 20.07 196.8 0 255.1 0C315.2 0 369.6 20.07 412.1 53.76L425.4 41.37C437.9 28.88 458.1 28.88 470.6 41.37C483.1 53.87 483.1 74.13 470.6 86.63L458.2 99.02C491.9 142.4 512 196.8 512 255.1C512 315.2 491.9 369.6 458.2 412.1L470.6 425.4zM309.3 354.5C293.4 363.1 275.3 368 255.1 368C236.7 368 218.6 363.1 202.7 354.5L144.8 412.5C176.1 434.9 214.5 448 255.1 448C297.5 448 335.9 434.9 367.2 412.5L309.3 354.5zM448 255.1C448 214.5 434.9 176.1 412.5 144.8L354.5 202.7C363.1 218.6 368 236.7 368 256C368 275.3 363.1 293.4 354.5 309.3L412.5 367.2C434.9 335.9 448 297.5 448 256V255.1zM255.1 63.1C214.5 63.1 176.1 77.14 144.8 99.5L202.7 157.5C218.6 148.9 236.7 143.1 255.1 143.1C275.3 143.1 293.4 148.9 309.3 157.5L367.2 99.5C335.9 77.14 297.5 63.1 256 63.1H255.1zM157.5 309.3C148.9 293.4 143.1 275.3 143.1 255.1C143.1 236.7 148.9 218.6 157.5 202.7L99.5 144.8C77.14 176.1 63.1 214.5 63.1 255.1C63.1 297.5 77.14 335.9 99.5 367.2L157.5 309.3zM255.1 207.1C229.5 207.1 207.1 229.5 207.1 255.1C207.1 282.5 229.5 303.1 255.1 303.1C282.5 303.1 304 282.5 304 255.1C304 229.5 282.5 207.1 255.1 207.1z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M464.1 431C474.3 440.4 474.3 455.6 464.1 464.1C455.6 474.3 440.4 474.3 431 464.1L419.3 453.2C374.9 489.9 318.1 512 256 512C193.9 512 137.1 489.9 92.74 453.2L80.97 464.1C71.6 474.3 56.4 474.3 47.03 464.1C37.66 455.6 37.66 440.4 47.03 431L58.8 419.3C22.08 374.9 0 318.1 0 256C0 193.9 22.08 137.1 58.8 92.74L47.03 80.97C37.66 71.6 37.66 56.4 47.03 47.03C56.4 37.66 71.6 37.66 80.97 47.03L92.74 58.8C137.1 22.08 193.9 0 256 0C318.1 0 374.9 22.08 419.3 58.8L431 47.03C440.4 37.66 455.6 37.66 464.1 47.03C474.3 56.4 474.3 71.6 464.1 80.97L453.2 92.74C489.9 137.1 512 193.9 512 256C512 318.1 489.9 374.9 453.2 419.3L464.1 431zM304.8 338.7C290.5 347.2 273.8 352 256 352C238.2 352 221.5 347.2 207.2 338.7L126.9 419.1C162.3 447.2 207.2 464 256 464C304.8 464 349.7 447.2 385.1 419.1L304.8 338.7zM464 256C464 207.2 447.2 162.3 419.1 126.9L338.7 207.2C347.2 221.5 352 238.2 352 256C352 273.8 347.2 290.5 338.7 304.8L419.1 385.1C447.2 349.7 464 304.8 464 256V256zM256 48C207.2 48 162.3 64.8 126.9 92.93L207.2 173.3C221.5 164.8 238.2 160 256 160C273.8 160 290.5 164.8 304.8 173.3L385.1 92.93C349.7 64.8 304.8 48 256 48V48zM173.3 304.8C164.8 290.5 160 273.8 160 256C160 238.2 164.8 221.5 173.3 207.2L92.93 126.9C64.8 162.3 48 207.2 48 256C48 304.8 64.8 349.7 92.93 385.1L173.3 304.8zM256 208C229.5 208 208 229.5 208 256C208 282.5 229.5 304 256 304C282.5 304 304 282.5 304 256C304 229.5 282.5 208 256 208z',
			),
		),
		'label'             => __( 'Life Ring', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'lightbulb'                              => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M112.1 454.3c0 6.297 1.816 12.44 5.284 17.69l17.14 25.69c5.25 7.875 17.17 14.28 26.64 14.28h61.67c9.438 0 21.36-6.401 26.61-14.28l17.08-25.68c2.938-4.438 5.348-12.37 5.348-17.7L272 415.1h-160L112.1 454.3zM191.4 .0132C89.44 .3257 16 82.97 16 175.1c0 44.38 16.44 84.84 43.56 115.8c16.53 18.84 42.34 58.23 52.22 91.45c.0313 .25 .0938 .5166 .125 .7823h160.2c.0313-.2656 .0938-.5166 .125-.7823c9.875-33.22 35.69-72.61 52.22-91.45C351.6 260.8 368 220.4 368 175.1C368 78.61 288.9-.2837 191.4 .0132zM192 96.01c-44.13 0-80 35.89-80 79.1C112 184.8 104.8 192 96 192S80 184.8 80 176c0-61.76 50.25-111.1 112-111.1c8.844 0 16 7.159 16 16S200.8 96.01 192 96.01z',
			),
			'regular' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M112.1 454.3c0 6.297 1.816 12.44 5.284 17.69l17.14 25.69c5.25 7.875 17.17 14.28 26.64 14.28h61.67c9.438 0 21.36-6.401 26.61-14.28l17.08-25.68c2.938-4.438 5.348-12.37 5.348-17.7L272 415.1h-160L112.1 454.3zM192 0C90.02 .3203 16 82.97 16 175.1c0 44.38 16.44 84.84 43.56 115.8c16.53 18.84 42.34 58.23 52.22 91.45c.0313 .25 .0938 .5166 .125 .7823h160.2c.0313-.2656 .0938-.5166 .125-.7823c9.875-33.22 35.69-72.61 52.22-91.45C351.6 260.8 368 220.4 368 175.1C368 78.8 289.2 .0039 192 0zM288.4 260.1c-15.66 17.85-35.04 46.3-49.05 75.89h-94.61c-14.01-29.59-33.39-58.04-49.04-75.88C75.24 236.8 64 206.1 64 175.1C64 113.3 112.1 48.25 191.1 48C262.6 48 320 105.4 320 175.1C320 206.1 308.8 236.8 288.4 260.1zM176 80C131.9 80 96 115.9 96 160c0 8.844 7.156 16 16 16S128 168.8 128 160c0-26.47 21.53-48 48-48c8.844 0 16-7.148 16-15.99S184.8 80 176 80z',
			),
		),
		'label'             => __( 'Lightbulb', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'line'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M272.1 204.2v71.1c0 1.8-1.4 3.2-3.2 3.2h-11.4c-1.1 0-2.1-.6-2.6-1.3l-32.6-44v42.2c0 1.8-1.4 3.2-3.2 3.2h-11.4c-1.8 0-3.2-1.4-3.2-3.2v-71.1c0-1.8 1.4-3.2 3.2-3.2H219c1 0 2.1 .5 2.6 1.4l32.6 44v-42.2c0-1.8 1.4-3.2 3.2-3.2h11.4c1.8-.1 3.3 1.4 3.3 3.1zm-82-3.2h-11.4c-1.8 0-3.2 1.4-3.2 3.2v71.1c0 1.8 1.4 3.2 3.2 3.2h11.4c1.8 0 3.2-1.4 3.2-3.2v-71.1c0-1.7-1.4-3.2-3.2-3.2zm-27.5 59.6h-31.1v-56.4c0-1.8-1.4-3.2-3.2-3.2h-11.4c-1.8 0-3.2 1.4-3.2 3.2v71.1c0 .9 .3 1.6 .9 2.2 .6 .5 1.3 .9 2.2 .9h45.7c1.8 0 3.2-1.4 3.2-3.2v-11.4c0-1.7-1.4-3.2-3.1-3.2zM332.1 201h-45.7c-1.7 0-3.2 1.4-3.2 3.2v71.1c0 1.7 1.4 3.2 3.2 3.2h45.7c1.8 0 3.2-1.4 3.2-3.2v-11.4c0-1.8-1.4-3.2-3.2-3.2H301v-12h31.1c1.8 0 3.2-1.4 3.2-3.2V234c0-1.8-1.4-3.2-3.2-3.2H301v-12h31.1c1.8 0 3.2-1.4 3.2-3.2v-11.4c-.1-1.7-1.5-3.2-3.2-3.2zM448 113.7V399c-.1 44.8-36.8 81.1-81.7 81H81c-44.8-.1-81.1-36.9-81-81.7V113c.1-44.8 36.9-81.1 81.7-81H367c44.8 .1 81.1 36.8 81 81.7zm-61.6 122.6c0-73-73.2-132.4-163.1-132.4-89.9 0-163.1 59.4-163.1 132.4 0 65.4 58 120.2 136.4 130.6 19.1 4.1 16.9 11.1 12.6 36.8-.7 4.1-3.3 16.1 14.1 8.8 17.4-7.3 93.9-55.3 128.2-94.7 23.6-26 34.9-52.3 34.9-81.5z',
			),
		),
		'label'             => __( 'Line', 'astra' ),
		'custom_categories' => array(),
	),
	'lines-leaning'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M62.36 458.1C56.77 474.9 38.65 483.9 21.88 478.4C5.116 472.8-3.946 454.6 1.643 437.9L129.6 53.88C135.2 37.12 153.4 28.05 170.1 33.64C186.9 39.23 195.9 57.35 190.4 74.12L62.36 458.1zM261.3 32.44C278.7 35.34 290.5 51.83 287.6 69.26L223.6 453.3C220.7 470.7 204.2 482.5 186.7 479.6C169.3 476.7 157.5 460.2 160.4 442.7L224.4 58.74C227.3 41.31 243.8 29.53 261.3 32.44H261.3zM352 32C369.7 32 384 46.33 384 64V448C384 465.7 369.7 480 352 480C334.3 480 320 465.7 320 448V64C320 46.33 334.3 32 352 32V32z',
			),
		),
		'label'             => __( 'Lines Leaning', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'link'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M172.5 131.1C228.1 75.51 320.5 75.51 376.1 131.1C426.1 181.1 433.5 260.8 392.4 318.3L391.3 319.9C381 334.2 361 337.6 346.7 327.3C332.3 317 328.9 297 339.2 282.7L340.3 281.1C363.2 249 359.6 205.1 331.7 177.2C300.3 145.8 249.2 145.8 217.7 177.2L105.5 289.5C73.99 320.1 73.99 372 105.5 403.5C133.3 431.4 177.3 435 209.3 412.1L210.9 410.1C225.3 400.7 245.3 404 255.5 418.4C265.8 432.8 262.5 452.8 248.1 463.1L246.5 464.2C188.1 505.3 110.2 498.7 60.21 448.8C3.741 392.3 3.741 300.7 60.21 244.3L172.5 131.1zM467.5 380C411 436.5 319.5 436.5 263 380C213 330 206.5 251.2 247.6 193.7L248.7 192.1C258.1 177.8 278.1 174.4 293.3 184.7C307.7 194.1 311.1 214.1 300.8 229.3L299.7 230.9C276.8 262.1 280.4 306.9 308.3 334.8C339.7 366.2 390.8 366.2 422.3 334.8L534.5 222.5C566 191 566 139.1 534.5 108.5C506.7 80.63 462.7 76.99 430.7 99.9L429.1 101C414.7 111.3 394.7 107.1 384.5 93.58C374.2 79.2 377.5 59.21 391.9 48.94L393.5 47.82C451 6.731 529.8 13.25 579.8 63.24C636.3 119.7 636.3 211.3 579.8 267.7L467.5 380z',
			),
		),
		'label'             => __( 'Link', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'link-slash'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M185.7 120.3C242.5 75.82 324.7 79.73 376.1 131.1C420.1 175.1 430.9 239.6 406.7 293.5L438.6 318.4L534.5 222.5C566 191 566 139.1 534.5 108.5C506.7 80.63 462.7 76.1 430.7 99.9L429.1 101C414.7 111.3 394.7 107.1 384.5 93.58C374.2 79.2 377.5 59.21 391.9 48.94L393.5 47.82C451 6.732 529.8 13.25 579.8 63.24C636.3 119.7 636.3 211.3 579.8 267.7L489.3 358.2L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196C13.29-1.236 28.37-3.065 38.81 5.112L185.7 120.3zM238.1 161.1L353.4 251.7C359.3 225.5 351.7 197.2 331.7 177.2C306.6 152.1 269.1 147 238.1 161.1V161.1zM263 380C233.1 350.1 218.7 309.8 220.9 270L406.6 416.4C357.4 431 301.9 418.9 263 380V380zM116.6 187.9L167.2 227.8L105.5 289.5C73.99 320.1 73.99 372 105.5 403.5C133.3 431.4 177.3 435 209.3 412.1L210.9 410.1C225.3 400.7 245.3 404 255.5 418.4C265.8 432.8 262.5 452.8 248.1 463.1L246.5 464.2C188.1 505.3 110.2 498.7 60.21 448.8C3.741 392.3 3.741 300.7 60.21 244.3L116.6 187.9z',
			),
		),
		'label'             => __( 'Link Slash', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'linkedin'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M416 32H31.9C14.3 32 0 46.5 0 64.3v383.4C0 465.5 14.3 480 31.9 480H416c17.6 0 32-14.5 32-32.3V64.3c0-17.8-14.4-32.3-32-32.3zM135.4 416H69V202.2h66.5V416zm-33.2-243c-21.3 0-38.5-17.3-38.5-38.5S80.9 96 102.2 96c21.2 0 38.5 17.3 38.5 38.5 0 21.3-17.2 38.5-38.5 38.5zm282.1 243h-66.4V312c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9V416h-66.4V202.2h63.7v29.2h.9c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9V416z',
			),
		),
		'label'             => __( 'LinkedIn', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'linkedin-in'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M100.3 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.6 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.3 61.9 111.3 142.3V448z',
			),
		),
		'label'             => __( 'LinkedIn In', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'linode'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M366 186.9l-59.5 36.87-.838 36.87-29.33-19.27-39.38 24.3c2.238 55.21 2.483 59.27 2.51 59.5l-97.2 65.36L127.2 285.7l108.1-62.01L195.1 197.8l-75.42 38.55L98.72 93.01 227.8 43.57 136.4 0 10.74 39.38 38.39 174.3l41.9 32.68L48.44 222.1 69.39 323.5 98.72 351.1 77.77 363.7l16.76 78.77L160.7 512c-10.8-74.84-11.66-78.64-11.73-78.77l77.93-55.3c16.76-12.57 15.08-10.89 15.08-10.89l.838 24.3 33.52 28.49-.838-77.09 46.93-33.52 26.82-18.43-2.514 36.03 25.14 17.6 6.7-74.58 58.66-43.58z',
			),
		),
		'label'             => __( 'Linode', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'linux'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M220.8 123.3c1 .5 1.8 1.7 3 1.7 1.1 0 2.8-.4 2.9-1.5 .2-1.4-1.9-2.3-3.2-2.9-1.7-.7-3.9-1-5.5-.1-.4 .2-.8 .7-.6 1.1 .3 1.3 2.3 1.1 3.4 1.7zm-21.9 1.7c1.2 0 2-1.2 3-1.7 1.1-.6 3.1-.4 3.5-1.6 .2-.4-.2-.9-.6-1.1-1.6-.9-3.8-.6-5.5 .1-1.3 .6-3.4 1.5-3.2 2.9 .1 1 1.8 1.5 2.8 1.4zM420 403.8c-3.6-4-5.3-11.6-7.2-19.7-1.8-8.1-3.9-16.8-10.5-22.4-1.3-1.1-2.6-2.1-4-2.9-1.3-.8-2.7-1.5-4.1-2 9.2-27.3 5.6-54.5-3.7-79.1-11.4-30.1-31.3-56.4-46.5-74.4-17.1-21.5-33.7-41.9-33.4-72C311.1 85.4 315.7 .1 234.8 0 132.4-.2 158 103.4 156.9 135.2c-1.7 23.4-6.4 41.8-22.5 64.7-18.9 22.5-45.5 58.8-58.1 96.7-6 17.9-8.8 36.1-6.2 53.3-6.5 5.8-11.4 14.7-16.6 20.2-4.2 4.3-10.3 5.9-17 8.3s-14 6-18.5 14.5c-2.1 3.9-2.8 8.1-2.8 12.4 0 3.9 .6 7.9 1.2 11.8 1.2 8.1 2.5 15.7 .8 20.8-5.2 14.4-5.9 24.4-2.2 31.7 3.8 7.3 11.4 10.5 20.1 12.3 17.3 3.6 40.8 2.7 59.3 12.5 19.8 10.4 39.9 14.1 55.9 10.4 11.6-2.6 21.1-9.6 25.9-20.2 12.5-.1 26.3-5.4 48.3-6.6 14.9-1.2 33.6 5.3 55.1 4.1 .6 2.3 1.4 4.6 2.5 6.7v.1c8.3 16.7 23.8 24.3 40.3 23 16.6-1.3 34.1-11 48.3-27.9 13.6-16.4 36-23.2 50.9-32.2 7.4-4.5 13.4-10.1 13.9-18.3 .4-8.2-4.4-17.3-15.5-29.7zM223.7 87.3c9.8-22.2 34.2-21.8 44-.4 6.5 14.2 3.6 30.9-4.3 40.4-1.6-.8-5.9-2.6-12.6-4.9 1.1-1.2 3.1-2.7 3.9-4.6 4.8-11.8-.2-27-9.1-27.3-7.3-.5-13.9 10.8-11.8 23-4.1-2-9.4-3.5-13-4.4-1-6.9-.3-14.6 2.9-21.8zM183 75.8c10.1 0 20.8 14.2 19.1 33.5-3.5 1-7.1 2.5-10.2 4.6 1.2-8.9-3.3-20.1-9.6-19.6-8.4 .7-9.8 21.2-1.8 28.1 1 .8 1.9-.2-5.9 5.5-15.6-14.6-10.5-52.1 8.4-52.1zm-13.6 60.7c6.2-4.6 13.6-10 14.1-10.5 4.7-4.4 13.5-14.2 27.9-14.2 7.1 0 15.6 2.3 25.9 8.9 6.3 4.1 11.3 4.4 22.6 9.3 8.4 3.5 13.7 9.7 10.5 18.2-2.6 7.1-11 14.4-22.7 18.1-11.1 3.6-19.8 16-38.2 14.9-3.9-.2-7-1-9.6-2.1-8-3.5-12.2-10.4-20-15-8.6-4.8-13.2-10.4-14.7-15.3-1.4-4.9 0-9 4.2-12.3zm3.3 334c-2.7 35.1-43.9 34.4-75.3 18-29.9-15.8-68.6-6.5-76.5-21.9-2.4-4.7-2.4-12.7 2.6-26.4v-.2c2.4-7.6 .6-16-.6-23.9-1.2-7.8-1.8-15 .9-20 3.5-6.7 8.5-9.1 14.8-11.3 10.3-3.7 11.8-3.4 19.6-9.9 5.5-5.7 9.5-12.9 14.3-18 5.1-5.5 10-8.1 17.7-6.9 8.1 1.2 15.1 6.8 21.9 16l19.6 35.6c9.5 19.9 43.1 48.4 41 68.9zm-1.4-25.9c-4.1-6.6-9.6-13.6-14.4-19.6 7.1 0 14.2-2.2 16.7-8.9 2.3-6.2 0-14.9-7.4-24.9-13.5-18.2-38.3-32.5-38.3-32.5-13.5-8.4-21.1-18.7-24.6-29.9s-3-23.3-.3-35.2c5.2-22.9 18.6-45.2 27.2-59.2 2.3-1.7 .8 3.2-8.7 20.8-8.5 16.1-24.4 53.3-2.6 82.4 .6-20.7 5.5-41.8 13.8-61.5 12-27.4 37.3-74.9 39.3-112.7 1.1 .8 4.6 3.2 6.2 4.1 4.6 2.7 8.1 6.7 12.6 10.3 12.4 10 28.5 9.2 42.4 1.2 6.2-3.5 11.2-7.5 15.9-9 9.9-3.1 17.8-8.6 22.3-15 7.7 30.4 25.7 74.3 37.2 95.7 6.1 11.4 18.3 35.5 23.6 64.6 3.3-.1 7 .4 10.9 1.4 13.8-35.7-11.7-74.2-23.3-84.9-4.7-4.6-4.9-6.6-2.6-6.5 12.6 11.2 29.2 33.7 35.2 59 2.8 11.6 3.3 23.7 .4 35.7 16.4 6.8 35.9 17.9 30.7 34.8-2.2-.1-3.2 0-4.2 0 3.2-10.1-3.9-17.6-22.8-26.1-19.6-8.6-36-8.6-38.3 12.5-12.1 4.2-18.3 14.7-21.4 27.3-2.8 11.2-3.6 24.7-4.4 39.9-.5 7.7-3.6 18-6.8 29-32.1 22.9-76.7 32.9-114.3 7.2zm257.4-11.5c-.9 16.8-41.2 19.9-63.2 46.5-13.2 15.7-29.4 24.4-43.6 25.5s-26.5-4.8-33.7-19.3c-4.7-11.1-2.4-23.1 1.1-36.3 3.7-14.2 9.2-28.8 9.9-40.6 .8-15.2 1.7-28.5 4.2-38.7 2.6-10.3 6.6-17.2 13.7-21.1 .3-.2 .7-.3 1-.5 .8 13.2 7.3 26.6 18.8 29.5 12.6 3.3 30.7-7.5 38.4-16.3 9-.3 15.7-.9 22.6 5.1 9.9 8.5 7.1 30.3 17.1 41.6 10.6 11.6 14 19.5 13.7 24.6zM173.3 148.7c2 1.9 4.7 4.5 8 7.1 6.6 5.2 15.8 10.6 27.3 10.6 11.6 0 22.5-5.9 31.8-10.8 4.9-2.6 10.9-7 14.8-10.4s5.9-6.3 3.1-6.6-2.6 2.6-6 5.1c-4.4 3.2-9.7 7.4-13.9 9.8-7.4 4.2-19.5 10.2-29.9 10.2s-18.7-4.8-24.9-9.7c-3.1-2.5-5.7-5-7.7-6.9-1.5-1.4-1.9-4.6-4.3-4.9-1.4-.1-1.8 3.7 1.7 6.5z',
			),
		),
		'label'             => __( 'Linux', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'lira-sign'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M111.1 191.1H224C241.7 191.1 256 206.3 256 223.1C256 241.7 241.7 255.1 224 255.1H111.1V287.1H224C241.7 287.1 256 302.3 256 319.1C256 337.7 241.7 352 224 352H110.8C108.1 374.2 100.8 395.6 89.2 414.9L88.52 416H288C305.7 416 320 430.3 320 448C320 465.7 305.7 480 288 480H32C20.47 480 9.834 473.8 4.154 463.8C-1.527 453.7-1.371 441.4 4.56 431.5L34.32 381.9C39.89 372.6 43.83 362.5 46.01 352H32C14.33 352 0 337.7 0 320C0 302.3 14.33 288 32 288H48V256H32C14.33 256 0 241.7 0 224C0 206.3 14.33 192 32 192H48V160.4C48 89.47 105.5 32 176.4 32C190.2 32 203.9 34.22 216.1 38.59L298.1 65.64C314.9 71.23 323.9 89.35 318.4 106.1C312.8 122.9 294.6 131.9 277.9 126.4L196.7 99.3C190.2 97.12 183.3 96 176.4 96C140.8 96 112 124.8 112 160.4L111.1 191.1z',
			),
		),
		'label'             => __( 'Lira Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'list'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M88 48C101.3 48 112 58.75 112 72V120C112 133.3 101.3 144 88 144H40C26.75 144 16 133.3 16 120V72C16 58.75 26.75 48 40 48H88zM480 64C497.7 64 512 78.33 512 96C512 113.7 497.7 128 480 128H192C174.3 128 160 113.7 160 96C160 78.33 174.3 64 192 64H480zM480 224C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H192C174.3 288 160 273.7 160 256C160 238.3 174.3 224 192 224H480zM480 384C497.7 384 512 398.3 512 416C512 433.7 497.7 448 480 448H192C174.3 448 160 433.7 160 416C160 398.3 174.3 384 192 384H480zM16 232C16 218.7 26.75 208 40 208H88C101.3 208 112 218.7 112 232V280C112 293.3 101.3 304 88 304H40C26.75 304 16 293.3 16 280V232zM88 368C101.3 368 112 378.7 112 392V440C112 453.3 101.3 464 88 464H40C26.75 464 16 453.3 16 440V392C16 378.7 26.75 368 40 368H88z',
			),
		),
		'label'             => __( 'List', 'astra' ),
		'custom_categories' => array(),
	),
	'list-check'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M152.1 38.16C161.9 47.03 162.7 62.2 153.8 72.06L81.84 152.1C77.43 156.9 71.21 159.8 64.63 159.1C58.05 160.2 51.69 157.6 47.03 152.1L7.029 112.1C-2.343 103.6-2.343 88.4 7.029 79.03C16.4 69.66 31.6 69.66 40.97 79.03L63.08 101.1L118.2 39.94C127 30.09 142.2 29.29 152.1 38.16V38.16zM152.1 198.2C161.9 207 162.7 222.2 153.8 232.1L81.84 312.1C77.43 316.9 71.21 319.8 64.63 319.1C58.05 320.2 51.69 317.6 47.03 312.1L7.029 272.1C-2.343 263.6-2.343 248.4 7.029 239C16.4 229.7 31.6 229.7 40.97 239L63.08 261.1L118.2 199.9C127 190.1 142.2 189.3 152.1 198.2V198.2zM224 96C224 78.33 238.3 64 256 64H480C497.7 64 512 78.33 512 96C512 113.7 497.7 128 480 128H256C238.3 128 224 113.7 224 96V96zM224 256C224 238.3 238.3 224 256 224H480C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H256C238.3 288 224 273.7 224 256zM160 416C160 398.3 174.3 384 192 384H480C497.7 384 512 398.3 512 416C512 433.7 497.7 448 480 448H192C174.3 448 160 433.7 160 416zM0 416C0 389.5 21.49 368 48 368C74.51 368 96 389.5 96 416C96 442.5 74.51 464 48 464C21.49 464 0 442.5 0 416z',
			),
		),
		'label'             => __( 'List Check', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'list-ol'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M55.1 56.04C55.1 42.78 66.74 32.04 79.1 32.04H111.1C125.3 32.04 135.1 42.78 135.1 56.04V176H151.1C165.3 176 175.1 186.8 175.1 200C175.1 213.3 165.3 224 151.1 224H71.1C58.74 224 47.1 213.3 47.1 200C47.1 186.8 58.74 176 71.1 176H87.1V80.04H79.1C66.74 80.04 55.1 69.29 55.1 56.04V56.04zM118.7 341.2C112.1 333.8 100.4 334.3 94.65 342.4L83.53 357.9C75.83 368.7 60.84 371.2 50.05 363.5C39.26 355.8 36.77 340.8 44.47 330.1L55.59 314.5C79.33 281.2 127.9 278.8 154.8 309.6C176.1 333.1 175.6 370.5 153.7 394.3L118.8 432H152C165.3 432 176 442.7 176 456C176 469.3 165.3 480 152 480H64C54.47 480 45.84 474.4 42.02 465.6C38.19 456.9 39.9 446.7 46.36 439.7L118.4 361.7C123.7 355.9 123.8 347.1 118.7 341.2L118.7 341.2zM512 64C529.7 64 544 78.33 544 96C544 113.7 529.7 128 512 128H256C238.3 128 224 113.7 224 96C224 78.33 238.3 64 256 64H512zM512 224C529.7 224 544 238.3 544 256C544 273.7 529.7 288 512 288H256C238.3 288 224 273.7 224 256C224 238.3 238.3 224 256 224H512zM512 384C529.7 384 544 398.3 544 416C544 433.7 529.7 448 512 448H256C238.3 448 224 433.7 224 416C224 398.3 238.3 384 256 384H512z',
			),
		),
		'label'             => __( 'List Ol', 'astra' ),
		'custom_categories' => array(),
	),
	'list-ul'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M16 96C16 69.49 37.49 48 64 48C90.51 48 112 69.49 112 96C112 122.5 90.51 144 64 144C37.49 144 16 122.5 16 96zM480 64C497.7 64 512 78.33 512 96C512 113.7 497.7 128 480 128H192C174.3 128 160 113.7 160 96C160 78.33 174.3 64 192 64H480zM480 224C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H192C174.3 288 160 273.7 160 256C160 238.3 174.3 224 192 224H480zM480 384C497.7 384 512 398.3 512 416C512 433.7 497.7 448 480 448H192C174.3 448 160 433.7 160 416C160 398.3 174.3 384 192 384H480zM16 416C16 389.5 37.49 368 64 368C90.51 368 112 389.5 112 416C112 442.5 90.51 464 64 464C37.49 464 16 442.5 16 416zM112 256C112 282.5 90.51 304 64 304C37.49 304 16 282.5 16 256C16 229.5 37.49 208 64 208C90.51 208 112 229.5 112 256z',
			),
		),
		'label'             => __( 'List Ul', 'astra' ),
		'custom_categories' => array(),
	),
	'litecoin-sign'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M128 195.3L247.2 161.2C264.2 156.4 281.9 166.2 286.8 183.2C291.6 200.2 281.8 217.9 264.8 222.8L128 261.9V416H352C369.7 416 384 430.3 384 448C384 465.7 369.7 480 352 480H96C78.33 480 64 465.7 64 448V280.1L40.79 286.8C23.8 291.6 6.087 281.8 1.232 264.8C-3.623 247.8 6.216 230.1 23.21 225.2L64 213.6V64C64 46.33 78.33 32 96 32C113.7 32 128 46.33 128 64V195.3z',
			),
		),
		'label'             => __( 'Litecoin Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'location-arrow'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M285.6 444.1C279.8 458.3 264.8 466.3 249.8 463.4C234.8 460.4 223.1 447.3 223.1 432V256H47.1C32.71 256 19.55 245.2 16.6 230.2C13.65 215.2 21.73 200.2 35.88 194.4L387.9 50.38C399.8 45.5 413.5 48.26 422.6 57.37C431.7 66.49 434.5 80.19 429.6 92.12L285.6 444.1z',
			),
		),
		'label'             => __( 'Location Arrow', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'location-crosshairs'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M176 256C176 211.8 211.8 176 256 176C300.2 176 336 211.8 336 256C336 300.2 300.2 336 256 336C211.8 336 176 300.2 176 256zM256 0C273.7 0 288 14.33 288 32V66.65C368.4 80.14 431.9 143.6 445.3 224H480C497.7 224 512 238.3 512 256C512 273.7 497.7 288 480 288H445.3C431.9 368.4 368.4 431.9 288 445.3V480C288 497.7 273.7 512 256 512C238.3 512 224 497.7 224 480V445.3C143.6 431.9 80.14 368.4 66.65 288H32C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224H66.65C80.14 143.6 143.6 80.14 224 66.65V32C224 14.33 238.3 0 256 0zM128 256C128 326.7 185.3 384 256 384C326.7 384 384 326.7 384 256C384 185.3 326.7 128 256 128C185.3 128 128 185.3 128 256z',
			),
		),
		'label'             => __( 'Location Crosshairs', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'location-dot'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M168.3 499.2C116.1 435 0 279.4 0 192C0 85.96 85.96 0 192 0C298 0 384 85.96 384 192C384 279.4 267 435 215.7 499.2C203.4 514.5 180.6 514.5 168.3 499.2H168.3zM192 256C227.3 256 256 227.3 256 192C256 156.7 227.3 128 192 128C156.7 128 128 156.7 128 192C128 227.3 156.7 256 192 256z',
			),
		),
		'label'             => __( 'Location Dot', 'astra' ),
		'custom_categories' => array(
			'social',
			'travel',
		),
	),
	'location-pin'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M384 192C384 279.4 267 435 215.7 499.2C203.4 514.5 180.6 514.5 168.3 499.2C116.1 435 0 279.4 0 192C0 85.96 85.96 0 192 0C298 0 384 85.96 384 192H384z',
			),
		),
		'label'             => __( 'Location Pin', 'astra' ),
		'custom_categories' => array(
			'design',
			'social',
			'travel',
		),
	),
	'location-pin-lock'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M168.3 499.2C116.1 435 0 279.4 0 192C0 85.96 85.96 0 192 0C287.7 0 366.1 69.96 381.6 161.5C328.5 170.3 288 216.4 288 272V296.6C268.9 307.6 256 328.3 256 352V446.8C240.7 467.4 226.7 485.4 215.7 499.2C203.4 514.5 180.6 514.5 168.3 499.2H168.3zM192 256C227.3 256 256 227.3 256 192C256 156.7 227.3 128 192 128C156.7 128 128 156.7 128 192C128 227.3 156.7 256 192 256zM400 192C444.2 192 480 227.8 480 272V320C497.7 320 512 334.3 512 352V480C512 497.7 497.7 512 480 512H320C302.3 512 288 497.7 288 480V352C288 334.3 302.3 320 320 320V272C320 227.8 355.8 192 400 192zM400 240C382.3 240 368 254.3 368 272V320H432V272C432 254.3 417.7 240 400 240z',
			),
		),
		'label'             => __( 'Location Pin Lock', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'lock'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M80 192V144C80 64.47 144.5 0 224 0C303.5 0 368 64.47 368 144V192H384C419.3 192 448 220.7 448 256V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V256C0 220.7 28.65 192 64 192H80zM144 192H304V144C304 99.82 268.2 64 224 64C179.8 64 144 99.82 144 144V192z',
			),
		),
		'label'             => __( 'Lock', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'lock-open'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M352 192H384C419.3 192 448 220.7 448 256V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V256C0 220.7 28.65 192 64 192H288V144C288 64.47 352.5 0 432 0C511.5 0 576 64.47 576 144V192C576 209.7 561.7 224 544 224C526.3 224 512 209.7 512 192V144C512 99.82 476.2 64 432 64C387.8 64 352 99.82 352 144V192z',
			),
		),
		'label'             => __( 'Lock Open', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'locust'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M328 32C464.1 32 576 143 576 280V320C576 320.1 576 320.2 576 320.3C575.8 364.3 540.1 400 496 400H483.6L508.8 444.1C515.4 455.6 511.4 470.3 499.9 476.8C488.4 483.4 473.7 479.4 467.2 467.9L428.4 400H347.1L299.7 469.7C292.2 480.6 277.2 483.3 266.3 475.7C255.4 468.2 252.7 453.2 260.3 442.3L289.6 400H215.1L163.3 470.2C155.5 480.9 140.4 483.2 129.8 475.3C119.1 467.5 116.8 452.4 124.7 441.8L165.2 386.7L122.2 370.4L42.84 470.9C34.62 481.3 19.53 483 9.13 474.8C-1.274 466.6-3.049 451.5 5.164 441.1L245.2 137.1C250.4 130.5 258.8 127.1 267.2 128.2C275.5 129.3 282.7 134.8 286.1 142.5L307.8 193.3L348.7 137.8C353.8 130.8 362.2 127.2 370.8 128.2C379.3 129.1 386.7 134.6 390.1 142.5L431.8 240H496C506.2 240 516 241.9 525 245.4C508.6 151.4 426.7 80 328 80H312C298.7 80 288 69.26 288 56C288 42.75 298.7 32 312 32L328 32zM332.1 240H379.6L362.5 199.1L332.1 240zM257.8 198.5L225.1 240H273.3L274.8 238.1L257.8 198.5zM496 336C504.8 336 512 328.8 512 320C512 311.2 504.8 304 496 304C487.2 304 480 311.2 480 320C480 328.8 487.2 336 496 336zM88.83 240H126.7L48.9 337.3C38.31 326.8 32 312.3 32 296.8C32 265.4 57.45 240 88.83 240V240z',
			),
		),
		'label'             => __( 'Locust', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'lungs'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M640 419.8c0 61.25-62.5 105.5-125.3 88.63l-59.53-15.88c-42.12-11.38-71.25-47.5-71.25-88.63L384 316.4l85.88 57.25c3.625 2.375 8.625 1.375 11-2.25l8.875-13.37c2.5-3.625 1.5-8.625-2.125-11L320 235.3l-167.6 111.8c-1.75 1.125-3 3-3.375 5c-.375 2.125 0 4.25 1.25 6l8.875 13.37c1.125 1.75 3 3 5 3.375c2.125 .375 4.25 0 6-1.125L256 316.4l.0313 87.5c0 41.13-29.12 77.25-71.25 88.63l-59.53 15.88C62.5 525.3 0 481 0 419.8c0-10 1.25-19.88 3.875-29.63C25.5 308.9 59.91 231 105.9 159.1c22.12-34.63 36.12-63.13 80.12-63.13C224.7 96 256 125.4 256 161.8v60.1l32.88-21.97C293.4 196.9 296 192 296 186.6V16C296 7.125 303.1 0 312 0h16c8.875 0 16 7.125 16 16v170.6c0 5.375 2.625 10.25 7.125 13.25L384 221.8v-60.1c0-36.38 31.34-65.75 69.97-65.75c43.1 0 58 28.5 80.13 63.13c46 71.88 80.41 149.8 102 231C638.8 399.9 640 409.8 640 419.8z',
			),
		),
		'label'             => __( 'Lungs', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'lungs-virus'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M195.5 444.5c-18.71-18.72-18.71-49.16 .0033-67.87l8.576-8.576H192c-26.47 0-48-21.53-48-48c0-26.47 21.53-48 48-48l12.12-.0055L195.5 263.4c-18.71-18.72-18.71-49.16 0-67.88C204.6 186.5 216.7 181.5 229.5 181.5c9.576 0 18.72 2.799 26.52 7.986l.04-27.75c0-36.38-31.42-65.72-70.05-65.72c-44 0-57.97 28.5-80.09 63.13c-46 71.88-80.39 149.8-102 231C1.257 399.9 0 409.8 0 419.8c0 61.25 62.5 105.5 125.3 88.62l59.5-15.9c21.74-5.867 39.91-18.39 52.51-34.73c-2.553 .4141-5.137 .7591-7.774 .7591C216.7 458.5 204.6 453.5 195.5 444.5zM343.1 150.7L344 16C344 7.125 336.9 0 328 0h-16c-8.875 0-16 7.125-16 16L295.1 150.7c7.088-4.133 15.22-6.675 23.1-6.675S336.9 146.5 343.1 150.7zM421.8 421.8c6.25-6.25 6.25-16.37 0-22.62l-8.576-8.576c-20.16-20.16-5.881-54.63 22.63-54.63H448c8.844 0 16-7.156 16-16c0-8.844-7.156-16-16-16h-12.12c-28.51 0-42.79-34.47-22.63-54.63l8.576-8.577c6.25-6.25 6.25-16.37 0-22.62s-16.38-6.25-22.62 0l-8.576 8.577C370.5 246.9 336 232.6 336 204.1v-12.12c0-8.844-7.156-15.1-16-15.1s-16 7.156-16 15.1v12.12c0 28.51-34.47 42.79-54.63 22.63L240.8 218.2c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.37 0 22.62l8.576 8.577c20.16 20.16 5.881 54.63-22.63 54.63H192c-8.844 0-16 7.156-16 16c0 8.844 7.156 16 16 16h12.12c28.51 0 42.79 34.47 22.63 54.63l-8.576 8.576c-6.25 6.25-6.25 16.37 0 22.62c3.125 3.125 7.219 4.688 11.31 4.688s8.188-1.562 11.31-4.688l8.576-8.575C269.5 393.1 304 407.4 304 435.9v12.12c0 8.844 7.156 16 16 16s16-7.156 16-16v-12.12c0-28.51 34.47-42.79 54.63-22.63l8.576 8.575c3.125 3.125 7.219 4.688 11.31 4.688S418.7 424.9 421.8 421.8zM288 303.1c-8.836 0-16-7.162-16-15.1S279.2 271.1 288 271.1S304 279.2 304 287.1S296.8 303.1 288 303.1zM352 367.1c-8.836 0-16-7.166-16-16s7.164-15.1 16-15.1s16 7.166 16 16S360.8 367.1 352 367.1zM636.1 390.1c-21.62-81.25-56.02-159.1-102-231c-22.12-34.63-36.09-63.13-80.09-63.13c-38.62 0-70.01 29.35-70.01 65.73v27.74c7.795-5.188 16.94-7.986 26.52-7.986c12.82 0 24.88 4.999 33.95 14.07c18.71 18.72 18.71 49.16 0 67.88l-8.576 8.571L448 272c26.47 0 48 21.54 48 48c0 26.47-21.53 48-48 48h-12.12l8.576 8.576c18.71 18.72 18.71 49.16-.0072 67.87c-9.066 9.066-21.12 14.06-33.94 14.06c-2.637 0-5.211-.3438-7.764-.7578c12.6 16.34 30.77 28.86 52.51 34.73l59.5 15.9C577.5 525.3 640 481 640 419.8C640 409.8 638.7 399.9 636.1 390.1z',
			),
		),
		'label'             => __( 'Lungs Virus', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'lyft'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 81.1h77.8v208.7c0 33.1 15 52.8 27.2 61-12.7 11.1-51.2 20.9-80.2-2.8C7.8 334 0 310.7 0 289V81.1zm485.9 173.5v-22h23.8v-76.8h-26.1c-10.1-46.3-51.2-80.7-100.3-80.7-56.6 0-102.7 46-102.7 102.7V357c16 2.3 35.4-.3 51.7-14 17.1-14 24.8-37.2 24.8-59v-6.7h38.8v-76.8h-38.8v-23.3c0-34.6 52.2-34.6 52.2 0v77.1c0 56.6 46 102.7 102.7 102.7v-76.5c-14.5 0-26.1-11.7-26.1-25.9zm-294.3-99v113c0 15.4-23.8 15.4-23.8 0v-113H91v132.7c0 23.8 8 54 45 63.9 37 9.8 58.2-10.6 58.2-10.6-2.1 13.4-14.5 23.3-34.9 25.3-15.5 1.6-35.2-3.6-45-7.8v70.3c25.1 7.5 51.5 9.8 77.6 4.7 47.1-9.1 76.8-48.4 76.8-100.8V155.1h-77.1v.5z',
			),
		),
		'label'             => __( 'lyft', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'm'                                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 64.01v384c0 17.67-14.31 32-32 32s-32-14.33-32-32V169.7l-133.4 200.1c-11.88 17.81-41.38 17.81-53.25 0L64 169.7v278.3c0 17.67-14.31 32-32 32s-32-14.33-32-32v-384c0-14.09 9.219-26.55 22.72-30.63c13.47-4.156 28.09 1.141 35.91 12.88L224 294.3l165.4-248.1c7.812-11.73 22.47-17.03 35.91-12.88C438.8 37.47 448 49.92 448 64.01z',
			),
		),
		'label'             => __( 'M', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'magento'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M445.7 127.9V384l-63.4 36.5V164.7L223.8 73.1 65.2 164.7l.4 255.9L2.3 384V128.1L224.2 0l221.5 127.9zM255.6 420.5L224 438.9l-31.8-18.2v-256l-63.3 36.6 .1 255.9 94.9 54.9 95.1-54.9v-256l-63.4-36.6v255.9z',
			),
		),
		'label'             => __( 'Magento', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'magnet'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M128 160V256C128 309 170.1 352 224 352C277 352 320 309 320 256V160H448V256C448 379.7 347.7 480 224 480C100.3 480 0 379.7 0 256V160H128zM0 64C0 46.33 14.33 32 32 32H96C113.7 32 128 46.33 128 64V128H0V64zM320 64C320 46.33 334.3 32 352 32H416C433.7 32 448 46.33 448 64V128H320V64z',
			),
		),
		'label'             => __( 'Magnet', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
			'travel',
		),
	),
	'magnifying-glass'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M500.3 443.7l-119.7-119.7c27.22-40.41 40.65-90.9 33.46-144.7C401.8 87.79 326.8 13.32 235.2 1.723C99.01-15.51-15.51 99.01 1.724 235.2c11.6 91.64 86.08 166.7 177.6 178.9c53.8 7.189 104.3-6.236 144.7-33.46l119.7 119.7c15.62 15.62 40.95 15.62 56.57 0C515.9 484.7 515.9 459.3 500.3 443.7zM79.1 208c0-70.58 57.42-128 128-128s128 57.42 128 128c0 70.58-57.42 128-128 128S79.1 278.6 79.1 208z',
			),
		),
		'label'             => __( 'Magnifying Glass', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'magnifying-glass-arrow-right'           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M416 208C416 253.9 401.1 296.3 375.1 330.7L502.6 457.4C515.1 469.9 515.1 490.1 502.6 502.6C490.1 515.1 469.9 515.1 457.4 502.6L330.7 375.1C296.3 401.1 253.9 416 208 416C93.12 416 0 322.9 0 208C0 93.12 93.12 0 208 0C322.9 0 416 93.12 416 208zM240.1 119C231.6 109.7 216.4 109.7 207 119C197.7 128.4 197.7 143.6 207 152.1L238.1 184H120C106.7 184 96 194.7 96 208C96 221.3 106.7 232 120 232H238.1L207 263C197.7 272.4 197.7 287.6 207 296.1C216.4 306.3 231.6 306.3 240.1 296.1L312.1 224.1C322.3 215.6 322.3 200.4 312.1 191L240.1 119z',
			),
		),
		'label'             => __( 'Magnifying Glass Arrow Right', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'magnifying-glass-chart'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M416 208C416 253.9 401.1 296.3 375.1 330.7L502.6 457.4C515.1 469.9 515.1 490.1 502.6 502.6C490.1 515.1 469.9 515.1 457.4 502.6L330.7 375.1C296.3 401.1 253.9 416 208 416C93.12 416 0 322.9 0 208C0 93.12 93.12 0 208 0C322.9 0 416 93.12 416 208zM104 280C104 293.3 114.7 304 128 304C141.3 304 152 293.3 152 280V216C152 202.7 141.3 192 128 192C114.7 192 104 202.7 104 216V280zM184 280C184 293.3 194.7 304 208 304C221.3 304 232 293.3 232 280V120C232 106.7 221.3 96 208 96C194.7 96 184 106.7 184 120V280zM264 280C264 293.3 274.7 304 288 304C301.3 304 312 293.3 312 280V184C312 170.7 301.3 160 288 160C274.7 160 264 170.7 264 184V280z',
			),
		),
		'label'             => __( 'Magnifying Glass Chart', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'magnifying-glass-dollar'                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M500.3 443.7l-119.7-119.7c27.22-40.41 40.65-90.9 33.46-144.7c-12.23-91.55-87.28-166-178.9-177.6c-136.2-17.24-250.7 97.28-233.4 233.4c11.6 91.64 86.07 166.7 177.6 178.9c53.81 7.191 104.3-6.235 144.7-33.46l119.7 119.7c15.62 15.62 40.95 15.62 56.57 .0004C515.9 484.7 515.9 459.3 500.3 443.7zM273.7 253.8C269.8 276.4 252.6 291.3 228 296.1V304c0 11.03-8.953 20-20 20S188 315 188 304V295.2C178.2 293.2 168.4 289.9 159.6 286.8L154.8 285.1C144.4 281.4 138.9 269.9 142.6 259.5C146.2 249.1 157.6 243.7 168.1 247.3l5.062 1.812c8.562 3.094 18.25 6.562 25.91 7.719c16.23 2.5 33.47-.0313 35.17-9.812c1.219-7.094 .4062-10.62-31.8-19.84L196.2 225.4C177.8 219.1 134.5 207.3 142.3 162.2C146.2 139.6 163.5 124.8 188 120V112c0-11.03 8.953-20 20-20S228 100.1 228 112v8.695c6.252 1.273 13.06 3.07 21.47 5.992c10.42 3.625 15.95 15.03 12.33 25.47C258.2 162.6 246.8 168.1 236.3 164.5C228.2 161.7 221.8 159.9 216.8 159.2c-16.11-2.594-33.38 .0313-35.08 9.812c-1 5.812-1.719 10 25.7 18.03l6 1.719C238.9 196 281.5 208.2 273.7 253.8z',
			),
		),
		'label'             => __( 'Magnifying Glass Dollar', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'magnifying-glass-location'              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M236 176c0 15.46-12.54 28-28 28S180 191.5 180 176S192.5 148 208 148S236 160.5 236 176zM500.3 500.3c-15.62 15.62-40.95 15.62-56.57 0l-119.7-119.7c-40.41 27.22-90.9 40.65-144.7 33.46c-91.55-12.23-166-87.28-177.6-178.9c-17.24-136.2 97.29-250.7 233.4-233.4c91.64 11.6 166.7 86.07 178.9 177.6c7.19 53.8-6.236 104.3-33.46 144.7l119.7 119.7C515.9 459.3 515.9 484.7 500.3 500.3zM294.1 182.2C294.1 134.5 255.6 96 207.1 96C160.4 96 121.9 134.5 121.9 182.2c0 38.35 56.29 108.5 77.87 134C201.8 318.5 204.7 320 207.1 320c3.207 0 6.26-1.459 8.303-3.791C237.8 290.7 294.1 220.5 294.1 182.2z',
			),
		),
		'label'             => __( 'Magnifying Glass Location', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'magnifying-glass-minus'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M500.3 443.7l-119.7-119.7c27.22-40.41 40.65-90.9 33.46-144.7c-12.23-91.55-87.28-166-178.9-177.6c-136.2-17.24-250.7 97.28-233.4 233.4c11.6 91.64 86.07 166.7 177.6 178.9c53.81 7.191 104.3-6.235 144.7-33.46l119.7 119.7c15.62 15.62 40.95 15.62 56.57 .0003C515.9 484.7 515.9 459.3 500.3 443.7zM288 232H127.1C114.7 232 104 221.3 104 208s10.74-24 23.1-24h160C301.3 184 312 194.7 312 208S301.3 232 288 232z',
			),
		),
		'label'             => __( 'Magnifying Glass Minus', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'magnifying-glass-plus'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M500.3 443.7l-119.7-119.7c27.22-40.41 40.65-90.9 33.46-144.7c-12.23-91.55-87.28-166-178.9-177.6c-136.2-17.24-250.7 97.28-233.4 233.4c11.6 91.64 86.07 166.7 177.6 178.9c53.81 7.191 104.3-6.235 144.7-33.46l119.7 119.7c15.62 15.62 40.95 15.62 56.57 .0003C515.9 484.7 515.9 459.3 500.3 443.7zM288 232H231.1V288c0 13.26-10.74 24-23.1 24C194.7 312 184 301.3 184 288V232H127.1C114.7 232 104 221.3 104 208s10.74-24 23.1-24H184V128c0-13.26 10.74-24 23.1-24S231.1 114.7 231.1 128v56h56C301.3 184 312 194.7 312 208S301.3 232 288 232z',
			),
		),
		'label'             => __( 'Magnifying Glass Plus', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'mailchimp'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M330.6 243.5a36.15 36.15 0 0 1 9.3 0c1.66-3.83 1.95-10.43 .45-17.61-2.23-10.67-5.25-17.14-11.48-16.13s-6.47 8.74-4.24 19.42c1.26 6 3.49 11.14 6 14.32zM277 252c4.47 2 7.2 3.26 8.28 2.13 1.89-1.94-3.48-9.39-12.12-13.09a31.44 31.44 0 0 0 -30.61 3.68c-3 2.18-5.81 5.22-5.41 7.06 .85 3.74 10-2.71 22.6-3.48 7-.44 12.8 1.75 17.26 3.71zm-9 5.13c-9.07 1.42-15 6.53-13.47 10.1 .9 .34 1.17 .81 5.21-.81a37 37 0 0 1 18.72-1.95c2.92 .34 4.31 .52 4.94-.49 1.46-2.22-5.71-8-15.39-6.85zm54.17 17.1c3.38-6.87-10.9-13.93-14.3-7s10.92 13.88 14.32 6.97zm15.66-20.47c-7.66-.13-7.95 15.8-.26 15.93s7.98-15.81 .28-15.96zm-218.8 78.9c-1.32 .31-6 1.45-8.47-2.35-5.2-8 11.11-20.38 3-35.77-9.1-17.47-27.82-13.54-35.05-5.54-8.71 9.6-8.72 23.54-5 24.08 4.27 .57 4.08-6.47 7.38-11.63a12.83 12.83 0 0 1 17.85-3.72c11.59 7.59 1.37 17.76 2.28 28.62 1.39 16.68 18.42 16.37 21.58 9a2.08 2.08 0 0 0 -.2-2.33c.03 .89 .68-1.3-3.35-.39zm299.7-17.07c-3.35-11.73-2.57-9.22-6.78-20.52 2.45-3.67 15.29-24-3.07-43.25-10.4-10.92-33.9-16.54-41.1-18.54-1.5-11.39 4.65-58.7-21.52-83 20.79-21.55 33.76-45.29 33.73-65.65-.06-39.16-48.15-51-107.4-26.47l-12.55 5.33c-.06-.05-22.71-22.27-23.05-22.57C169.5-18-41.77 216.8 25.78 273.9l14.76 12.51a72.49 72.49 0 0 0 -4.1 33.5c3.36 33.4 36 60.42 67.53 60.38 57.73 133.1 267.9 133.3 322.3 3 1.74-4.47 9.11-24.61 9.11-42.38s-10.09-25.27-16.53-25.27zm-316 48.16c-22.82-.61-47.46-21.15-49.91-45.51-6.17-61.31 74.26-75.27 84-12.33 4.54 29.64-4.67 58.49-34.12 57.81zM84.3 249.6C69.14 252.5 55.78 261.1 47.6 273c-4.88-4.07-14-12-15.59-15-13.01-24.85 14.24-73 33.3-100.2C112.4 90.56 186.2 39.68 220.4 48.91c5.55 1.57 23.94 22.89 23.94 22.89s-34.15 18.94-65.8 45.35c-42.66 32.85-74.89 80.59-94.2 132.4zM323.2 350.7s-35.74 5.3-69.51-7.07c6.21-20.16 27 6.1 96.4-13.81 15.29-4.38 35.37-13 51-25.35a102.8 102.8 0 0 1 7.12 24.28c3.66-.66 14.25-.52 11.44 18.1-3.29 19.87-11.73 36-25.93 50.84A106.9 106.9 0 0 1 362.5 421a132.4 132.4 0 0 1 -20.34 8.58c-53.51 17.48-108.3-1.74-126-43a66.33 66.33 0 0 1 -3.55-9.74c-7.53-27.2-1.14-59.83 18.84-80.37 1.23-1.31 2.48-2.85 2.48-4.79a8.45 8.45 0 0 0 -1.92-4.54c-7-10.13-31.19-27.4-26.33-60.83 3.5-24 24.49-40.91 44.07-39.91l5 .29c8.48 .5 15.89 1.59 22.88 1.88 11.69 .5 22.2-1.19 34.64-11.56 4.2-3.5 7.57-6.54 13.26-7.51a17.45 17.45 0 0 1 13.6 2.24c10 6.64 11.4 22.73 11.92 34.49 .29 6.72 1.1 23 1.38 27.63 .63 10.67 3.43 12.17 9.11 14 3.19 1.05 6.15 1.83 10.51 3.06 13.21 3.71 21 7.48 26 12.31a16.38 16.38 0 0 1 4.74 9.29c1.56 11.37-8.82 25.4-36.31 38.16-46.71 21.68-93.68 14.45-100.5 13.68-20.15-2.71-31.63 23.32-19.55 41.15 22.64 33.41 122.4 20 151.4-21.35 .69-1 .12-1.59-.73-1-41.77 28.58-97.06 38.21-128.5 26-4.77-1.85-14.73-6.44-15.94-16.67 43.6 13.49 71 .74 71 .74s2.03-2.79-.56-2.53zm-68.47-5.7zm-83.4-187.5c16.74-19.35 37.36-36.18 55.83-45.63a.73 .73 0 0 1 1 1c-1.46 2.66-4.29 8.34-5.19 12.65a.75 .75 0 0 0 1.16 .79c11.49-7.83 31.48-16.22 49-17.3a.77 .77 0 0 1 .52 1.38 41.86 41.86 0 0 0 -7.71 7.74 .75 .75 0 0 0 .59 1.19c12.31 .09 29.66 4.4 41 10.74 .76 .43 .22 1.91-.64 1.72-69.55-15.94-123.1 18.53-134.5 26.83a.76 .76 0 0 1 -1-1.12z',
			),
		),
		'label'             => __( 'Mailchimp', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'manat-sign'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M224 64V98.65C314.8 113.9 384 192.9 384 288V448C384 465.7 369.7 480 352 480C334.3 480 320 465.7 320 448V288C320 228.4 279.2 178.2 224 164V448C224 465.7 209.7 480 192 480C174.3 480 160 465.7 160 448V164C104.8 178.2 64 228.4 64 288V448C64 465.7 49.67 480 32 480C14.33 480 0 465.7 0 448V288C0 192.9 69.19 113.9 160 98.65V64C160 46.33 174.3 32 192 32C209.7 32 224 46.33 224 64z',
			),
		),
		'label'             => __( 'Manat Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'mandalorian'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M232.3 511.9c-1-3.26-1.69-15.83-1.39-24.58 .55-15.89 1-24.72 1.4-28.76 .64-6.2 2.87-20.72 3.28-21.38 .6-1 .4-27.87-.24-33.13-.31-2.58-.63-11.9-.69-20.73-.13-16.47-.53-20.12-2.73-24.76-1.1-2.32-1.23-3.84-1-11.43a92.38 92.38 0 0 0 -.34-12.71c-2-13-3.46-27.7-3.25-33.9s.43-7.15 2.06-9.67c3.05-4.71 6.51-14 8.62-23.27 2.26-9.86 3.88-17.18 4.59-20.74a109.5 109.5 0 0 1 4.42-15.05c2.27-6.25 2.49-15.39 .37-15.39-.3 0-1.38 1.22-2.41 2.71s-4.76 4.8-8.29 7.36c-8.37 6.08-11.7 9.39-12.66 12.58s-1 7.23-.16 7.76c.34 .21 1.29 2.4 2.11 4.88a28.83 28.83 0 0 1 .72 15.36c-.39 1.77-1 5.47-1.46 8.23s-1 6.46-1.25 8.22a9.85 9.85 0 0 1 -1.55 4.26c-1 1-1.14 .91-2.05-.53a14.87 14.87 0 0 1 -1.44-4.75c-.25-1.74-1.63-7.11-3.08-11.93-3.28-10.9-3.52-16.15-1-21a14.24 14.24 0 0 0 1.67-4.61c0-2.39-2.2-5.32-7.41-9.89-7-6.18-8.63-7.92-10.23-11.3-1.71-3.6-3.06-4.06-4.54-1.54-1.78 3-2.6 9.11-3 22l-.34 12.19 2 2.25c3.21 3.7 12.07 16.45 13.78 19.83 3.41 6.74 4.34 11.69 4.41 23.56s.95 22.75 2 24.71c.36 .66 .51 1.35 .34 1.52s.41 2.09 1.29 4.27a38.14 38.14 0 0 1 2.06 9 91 91 0 0 0 1.71 10.37c2.23 9.56 2.77 14.08 2.39 20.14-.2 3.27-.53 11.07-.73 17.32-1.31 41.76-1.85 58-2 61.21-.12 2-.39 11.51-.6 21.07-.36 16.3-1.3 27.37-2.42 28.65-.64 .73-8.07-4.91-12.52-9.49-3.75-3.87-4-4.79-2.83-9.95 .7-3 2.26-18.29 3.33-32.62 .36-4.78 .81-10.5 1-12.71 .83-9.37 1.66-20.35 2.61-34.78 .56-8.46 1.33-16.44 1.72-17.73s.89-9.89 1.13-19.11l.43-16.77-2.26-4.3c-1.72-3.28-4.87-6.94-13.22-15.34-6-6.07-11.84-12.3-12.91-13.85l-1.95-2.81 .75-10.9c1.09-15.71 1.1-48.57 0-59.06l-.89-8.7-3.28-4.52c-5.86-8.08-5.8-7.75-6.22-33.27-.1-6.07-.38-11.5-.63-12.06-.83-1.87-3.05-2.66-8.54-3.05-8.86-.62-11-1.9-23.85-14.55-6.15-6-12.34-12-13.75-13.19-2.81-2.42-2.79-2-.56-9.63l1.35-4.65-1.69-3a32.22 32.22 0 0 0 -2.59-4.07c-1.33-1.51-5.5-10.89-6-13.49a4.24 4.24 0 0 1 .87-3.9c2.23-2.86 3.4-5.68 4.45-10.73 2.33-11.19 7.74-26.09 10.6-29.22 3.18-3.47 7.7-1 9.41 5 1.34 4.79 1.37 9.79 .1 18.55a101.2 101.2 0 0 0 -1 11.11c0 4 .19 4.69 2.25 7.39 3.33 4.37 7.73 7.41 15.2 10.52a18.67 18.67 0 0 1 4.72 2.85c11.17 10.72 18.62 16.18 22.95 16.85 5.18 .8 8 4.54 10 13.39 1.31 5.65 4 11.14 5.46 11.14a9.38 9.38 0 0 0 3.33-1.39c2-1.22 2.25-1.73 2.25-4.18a132.9 132.9 0 0 0 -2-17.84c-.37-1.66-.78-4.06-.93-5.35s-.61-3.85-1-5.69c-2.55-11.16-3.65-15.46-4.1-16-1.55-2-4.08-10.2-4.93-15.92-1.64-11.11-4-14.23-12.91-17.39A43.15 43.15 0 0 1 165.2 78c-1.15-1-4-3.22-6.35-5.06s-4.41-3.53-4.6-3.76a22.7 22.7 0 0 0 -2.69-2c-6.24-4.22-8.84-7-11.26-12l-2.44-5-.22-13-.22-13 6.91-6.55c3.95-3.75 8.48-7.35 10.59-8.43 3.31-1.69 4.45-1.89 11.37-2 8.53-.19 10.12 0 11.66 1.56s1.36 6.4-.29 8.5a6.66 6.66 0 0 0 -1.34 2.32c0 .58-2.61 4.91-5.42 9a30.39 30.39 0 0 0 -2.37 6.82c20.44 13.39 21.55 3.77 14.07 29L194 66.92c3.11-8.66 6.47-17.26 8.61-26.22 .29-7.63-12-4.19-15.4-8.68-2.33-5.93 3.13-14.18 6.06-19.2 1.6-2.34 6.62-4.7 8.82-4.15 .88 .22 4.16-.35 7.37-1.28a45.3 45.3 0 0 1 7.55-1.68 29.57 29.57 0 0 0 6-1.29c3.65-1.11 4.5-1.17 6.35-.4a29.54 29.54 0 0 0 5.82 1.36 18.18 18.18 0 0 1 6 1.91 22.67 22.67 0 0 0 5 2.17c2.51 .68 3 .57 7.05-1.67l4.35-2.4L268.3 5c10.44-.4 10.81-.47 15.26-2.68L288.2 0l2.46 1.43c1.76 1 3.14 2.73 4.85 6 2.36 4.51 2.38 4.58 1.37 7.37-.88 2.44-.89 3.3-.1 6.39a35.76 35.76 0 0 0 2.1 5.91 13.55 13.55 0 0 1 1.31 4c.31 4.33 0 5.3-2.41 6.92-2.17 1.47-7 7.91-7 9.34a14.77 14.77 0 0 1 -1.07 3c-5 11.51-6.76 13.56-14.26 17-9.2 4.2-12.3 5.19-16.21 5.19-3.1 0-4 .25-4.54 1.26a18.33 18.33 0 0 1 -4.09 3.71 13.62 13.62 0 0 0 -4.38 4.78 5.89 5.89 0 0 1 -2.49 2.91 6.88 6.88 0 0 0 -2.45 1.71 67.62 67.62 0 0 1 -7 5.38c-3.33 2.34-6.87 5-7.87 6A7.27 7.27 0 0 1 224 100a5.76 5.76 0 0 0 -2.13 1.65c-1.31 1.39-1.49 2.11-1.14 4.6a36.45 36.45 0 0 0 1.42 5.88c1.32 3.8 1.31 7.86 0 10.57s-.89 6.65 1.35 9.59c2 2.63 2.16 4.56 .71 8.84a33.45 33.45 0 0 0 -1.06 8.91c0 4.88 .22 6.28 1.46 8.38s1.82 2.48 3.24 2.32c2-.23 2.3-1.05 4.71-12.12 2.18-10 3.71-11.92 13.76-17.08 2.94-1.51 7.46-4 10-5.44s6.79-3.69 9.37-4.91a40.09 40.09 0 0 0 15.22-11.67c7.11-8.79 10-16.22 12.85-33.3a18.37 18.37 0 0 1 2.86-7.73 20.39 20.39 0 0 0 2.89-7.31c1-5.3 2.85-9.08 5.58-11.51 4.7-4.18 6-1.09 4.59 10.87-.46 3.86-1.1 10.33-1.44 14.38l-.61 7.36 4.45 4.09 4.45 4.09 .11 8.42c.06 4.63 .47 9.53 .92 10.89l.82 2.47-6.43 6.28c-8.54 8.33-12.88 13.93-16.76 21.61-1.77 3.49-3.74 7.11-4.38 8-2.18 3.11-6.46 13-8.76 20.26l-2.29 7.22-7 6.49c-3.83 3.57-8 7.25-9.17 8.17-3.05 2.32-4.26 5.15-4.26 10a14.62 14.62 0 0 0 1.59 7.26 42 42 0 0 1 2.09 4.83 9.28 9.28 0 0 0 1.57 2.89c1.4 1.59 1.92 16.12 .83 23.22-.68 4.48-3.63 12-4.7 12-1.79 0-4.06 9.27-5.07 20.74-.18 2-.62 5.94-1 8.7s-1 10-1.35 16.05c-.77 12.22-.19 18.77 2 23.15 3.41 6.69 .52 12.69-11 22.84l-4 3.49 .07 5.19a40.81 40.81 0 0 0 1.14 8.87c4.61 16 4.73 16.92 4.38 37.13-.46 26.4-.26 40.27 .63 44.15a61.31 61.31 0 0 1 1.08 7c.17 2 .66 5.33 1.08 7.36 .47 2.26 .78 11 .79 22.74v19.06l-1.81 2.63c-2.71 3.91-15.11 13.54-15.49 12.29zm29.53-45.11c-.18-.3-.33-6.87-.33-14.59 0-14.06-.89-27.54-2.26-34.45-.4-2-.81-9.7-.9-17.06-.15-11.93-1.4-24.37-2.64-26.38-.66-1.07-3-17.66-3-21.3 0-4.23 1-6 5.28-9.13s4.86-3.14 5.48-.72c.28 1.1 1.45 5.62 2.6 10 3.93 15.12 4.14 16.27 4.05 21.74-.1 5.78-.13 6.13-1.74 17.73-1 7.07-1.17 12.39-1 28.43 .17 19.4-.64 35.73-2 41.27-.71 2.78-2.8 5.48-3.43 4.43zm-71-37.58a101 101 0 0 1 -1.73-10.79 100.5 100.5 0 0 0 -1.73-10.79 37.53 37.53 0 0 1 -1-6.49c-.31-3.19-.91-7.46-1.33-9.48-1-4.79-3.35-19.35-3.42-21.07 0-.74-.34-4.05-.7-7.36-.67-6.21-.84-27.67-.22-28.29 1-1 6.63 2.76 11.33 7.43l5.28 5.25-.45 6.47c-.25 3.56-.6 10.23-.78 14.83s-.49 9.87-.67 11.71-.61 9.36-.94 16.72c-.79 17.41-1.94 31.29-2.65 32a.62 .62 0 0 1 -1-.14zm-87.18-266.6c21.07 12.79 17.84 14.15 28.49 17.66 13 4.29 18.87 7.13 23.15 16.87C111.6 233.3 86.25 255 78.55 268c-31 52-6 101.6 62.75 87.21-14.18 29.23-78 28.63-98.68-4.9-24.68-39.95-22.09-118.3 61-187.7zm210.8 179c56.66 6.88 82.32-37.74 46.54-89.23 0 0-26.87-29.34-64.28-68 3-15.45 9.49-32.12 30.57-53.82 89.2 63.51 92 141.6 92.46 149.4 4.3 70.64-78.7 91.18-105.3 61.71z',
			),
		),
		'label'             => __( 'Mandalorian', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'map'                                    => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M384 476.1L192 421.2V35.93L384 90.79V476.1zM416 88.37L543.1 37.53C558.9 31.23 576 42.84 576 59.82V394.6C576 404.4 570 413.2 560.9 416.9L416 474.8V88.37zM15.09 95.13L160 37.17V423.6L32.91 474.5C17.15 480.8 0 469.2 0 452.2V117.4C0 107.6 5.975 98.78 15.09 95.13V95.13z',
			),
			'regular' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M565.6 36.24C572.1 40.72 576 48.11 576 56V392C576 401.1 569.8 410.9 560.5 414.4L392.5 478.4C387.4 480.4 381.7 480.5 376.4 478.8L192.5 417.5L32.54 478.4C25.17 481.2 16.88 480.2 10.38 475.8C3.882 471.3 0 463.9 0 456V120C0 110 6.15 101.1 15.46 97.57L183.5 33.57C188.6 31.6 194.3 31.48 199.6 33.23L383.5 94.52L543.5 33.57C550.8 30.76 559.1 31.76 565.6 36.24H565.6zM48 421.2L168 375.5V90.83L48 136.5V421.2zM360 137.3L216 89.3V374.7L360 422.7V137.3zM408 421.2L528 375.5V90.83L408 136.5V421.2z',
			),
		),
		'label'             => __( 'Map', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'map-location'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M273.2 311.1C241.1 271.9 167.1 174.6 167.1 120C167.1 53.73 221.7 0 287.1 0C354.3 0 408 53.73 408 120C408 174.6 334.9 271.9 302.8 311.1C295.1 321.6 280.9 321.6 273.2 311.1V311.1zM416 503V200.4C419.5 193.5 422.7 186.7 425.6 179.8C426.1 178.6 426.6 177.4 427.1 176.1L543.1 129.7C558.9 123.4 576 135 576 152V422.8C576 432.6 570 441.4 560.9 445.1L416 503zM15.09 187.3L137.6 138.3C140 152.5 144.9 166.6 150.4 179.8C153.3 186.7 156.5 193.5 160 200.4V451.8L32.91 502.7C17.15 508.1 0 497.4 0 480.4V209.6C0 199.8 5.975 190.1 15.09 187.3H15.09zM384 504.3L191.1 449.4V255C212.5 286.3 234.3 314.6 248.2 331.1C268.7 357.6 307.3 357.6 327.8 331.1C341.7 314.6 363.5 286.3 384 255L384 504.3z',
			),
		),
		'label'             => __( 'Map Location', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'map-location-dot'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M408 120C408 174.6 334.9 271.9 302.8 311.1C295.1 321.6 280.9 321.6 273.2 311.1C241.1 271.9 168 174.6 168 120C168 53.73 221.7 0 288 0C354.3 0 408 53.73 408 120zM288 152C310.1 152 328 134.1 328 112C328 89.91 310.1 72 288 72C265.9 72 248 89.91 248 112C248 134.1 265.9 152 288 152zM425.6 179.8C426.1 178.6 426.6 177.4 427.1 176.1L543.1 129.7C558.9 123.4 576 135 576 152V422.8C576 432.6 570 441.4 560.9 445.1L416 503V200.4C419.5 193.5 422.7 186.7 425.6 179.8zM150.4 179.8C153.3 186.7 156.5 193.5 160 200.4V451.8L32.91 502.7C17.15 508.1 0 497.4 0 480.4V209.6C0 199.8 5.975 190.1 15.09 187.3L137.6 138.3C140 152.5 144.9 166.6 150.4 179.8H150.4zM327.8 331.1C341.7 314.6 363.5 286.3 384 255V504.3L192 449.4V255C212.5 286.3 234.3 314.6 248.2 331.1C268.7 357.6 307.3 357.6 327.8 331.1L327.8 331.1z',
			),
		),
		'label'             => __( 'Map Location Dot', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'map-pin'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M320 144C320 223.5 255.5 288 176 288C96.47 288 32 223.5 32 144C32 64.47 96.47 0 176 0C255.5 0 320 64.47 320 144zM192 64C192 55.16 184.8 48 176 48C122.1 48 80 90.98 80 144C80 152.8 87.16 160 96 160C104.8 160 112 152.8 112 144C112 108.7 140.7 80 176 80C184.8 80 192 72.84 192 64zM144 480V317.1C154.4 319 165.1 319.1 176 319.1C186.9 319.1 197.6 319 208 317.1V480C208 497.7 193.7 512 176 512C158.3 512 144 497.7 144 480z',
			),
		),
		'label'             => __( 'Map Pin', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'markdown'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M593.8 59.1H46.2C20.7 59.1 0 79.8 0 105.2v301.5c0 25.5 20.7 46.2 46.2 46.2h547.7c25.5 0 46.2-20.7 46.1-46.1V105.2c0-25.4-20.7-46.1-46.2-46.1zM338.5 360.6H277v-120l-61.5 76.9-61.5-76.9v120H92.3V151.4h61.5l61.5 76.9 61.5-76.9h61.5v209.2zm135.3 3.1L381.5 256H443V151.4h61.5V256H566z',
			),
		),
		'label'             => __( 'Markdown', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'marker'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480.1 160.1L316.3 325.7L186.3 195.7L302.1 80L288.1 66.91C279.6 57.54 264.4 57.54 255 66.91L168.1 152.1C159.6 162.3 144.4 162.3 135 152.1C125.7 143.6 125.7 128.4 135 119L221.1 32.97C249.2 4.853 294.8 4.853 322.9 32.97L336 46.06L351 31.03C386.9-4.849 445.1-4.849 480.1 31.03C516.9 66.91 516.9 125.1 480.1 160.1V160.1zM229.5 412.5C181.5 460.5 120.3 493.2 53.7 506.5L28.71 511.5C20.84 513.1 12.7 510.6 7.03 504.1C1.356 499.3-1.107 491.2 .4662 483.3L5.465 458.3C18.78 391.7 51.52 330.5 99.54 282.5L163.7 218.3L293.7 348.3L229.5 412.5z',
			),
		),
		'label'             => __( 'Marker', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'mars'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M431.1 31.1l-112.6 0c-21.42 0-32.15 25.85-17 40.97l29.61 29.56l-56.65 56.55c-30.03-20.66-65.04-31-100-31c-47.99-.002-95.96 19.44-131.1 58.39c-60.86 67.51-58.65 175 4.748 240.1C83.66 462.2 129.6 480 175.5 480c45.12 0 90.34-17.18 124.8-51.55c61.11-60.99 67.77-155.6 20.42-224.1l56.65-56.55l29.61 29.56C411.9 182.2 417.9 184.4 423.8 184.4C436.1 184.4 448 174.8 448 160.4V47.1C448 39.16 440.8 31.1 431.1 31.1zM243.5 371.9c-18.75 18.71-43.38 28.07-68 28.07c-24.63 0-49.25-9.355-68.01-28.07c-37.5-37.43-37.5-98.33 0-135.8c18.75-18.71 43.38-28.07 68.01-28.07c24.63 0 49.25 9.357 68 28.07C281 273.5 281 334.5 243.5 371.9z',
			),
		),
		'label'             => __( 'Mars', 'astra' ),
		'custom_categories' => array(),
	),
	'mars-and-venus'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 .0002l-112.4 .0001c-21.38 0-32.09 25.85-16.97 40.97l29.56 29.56l-27.11 27.11C326.1 76.85 292.7 64 256 64c-88.37 0-160 71.63-160 160c0 77.4 54.97 141.9 128 156.8v19.22H192c-8.836 0-16 7.162-16 16v31.1c0 8.836 7.164 16 16 16l32 .0001v32c0 8.836 7.164 16 16 16h32c8.838 0 16-7.164 16-16v-32l32-.0001c8.838 0 16-7.164 16-16v-31.1c0-8.838-7.162-16-16-16h-32v-19.22c73.03-14.83 128-79.37 128-156.8c0-28.38-8.018-54.65-20.98-77.77l30.45-30.45l29.56 29.56C470.1 160.5 496 149.8 496 128.4V16C496 7.164 488.8 .0002 480 .0002zM256 304c-44.11 0-80-35.89-80-80c0-44.11 35.89-80 80-80c44.11 0 80 35.89 80 80C336 268.1 300.1 304 256 304z',
			),
		),
		'label'             => __( 'Mars And Venus', 'astra' ),
		'custom_categories' => array(),
	),
	'mars-and-venus-burst'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M607.1 0C625.7 0 639.1 14.33 639.1 32V120C639.1 137.7 625.7 152 607.1 152C590.3 152 575.1 137.7 575.1 120V109.3L539.6 145.7C552.6 168.8 559.1 195.6 559.1 224C559.1 301.4 505 365.1 431.1 380.8V400H447.1C465.7 400 479.1 414.3 479.1 432C479.1 449.7 465.7 464 447.1 464H431.1V480C431.1 497.7 417.7 512 399.1 512C382.3 512 367.1 497.7 367.1 480V464H351.1C334.3 464 319.1 449.7 319.1 432C319.1 414.3 334.3 400 351.1 400H367.1V380.8C294.1 365.1 239.1 301.4 239.1 224C239.1 135.6 311.6 64 399.1 64C436.7 64 470.6 76.37 497.6 97.18L530.7 64H511.1C494.3 64 479.1 49.67 479.1 32C479.1 14.33 494.3 0 511.1 0L607.1 0zM399.1 128C346.1 128 303.1 170.1 303.1 224C303.1 277 346.1 320 399.1 320C453 320 495.1 277 495.1 224C495.1 170.1 453 128 399.1 128zM220.3 92.05L280.4 73.81C236.3 108.1 207.1 163.2 207.1 224C207.1 269.2 223.6 310.8 249.8 343.6C244.5 345 238.7 343.7 234.6 339.9L175.1 286.1L117.4 339.9C112.6 344.4 105.5 345.4 99.63 342.6C93.73 339.7 90.15 333.6 90.62 327L96.21 247.6L17.55 235.4C11.08 234.4 5.868 229.6 4.41 223.2C2.951 216.8 5.538 210.1 10.94 206.4L76.5 161.3L37.01 92.18C33.76 86.49 34.31 79.39 38.39 74.27C42.48 69.14 49.28 67.03 55.55 68.93L131.7 92.05L161.1 18.09C163.6 11.1 169.4 7.1 175.1 7.1C182.6 7.1 188.4 11.1 190.9 18.09L220.3 92.05z',
			),
		),
		'label'             => __( 'Mars And Venus Burst', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'mars-double'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320.7 204.3l56.65-56.55l29.61 29.56C422.1 192.5 448 181.7 448 160.4V47.1c0-8.838-7.176-15.1-16.03-15.1H319.4c-21.42 0-32.15 25.85-17 40.97l29.61 29.56L275.4 159.1c-71.21-48.99-170.4-39.96-231.1 27.39c-60.86 67.51-58.65 175 4.748 240.1c68.7 70.57 181.8 71.19 251.3 1.847C361.4 367.5 368 272.9 320.7 204.3zM243.5 371.9c-37.5 37.43-98.51 37.43-136 0s-37.5-98.33 0-135.8c37.5-37.43 98.51-37.43 136 0C281 273.5 281 334.5 243.5 371.9zM623.1 32h-112.6c-21.42 0-32.15 25.85-17 40.97l29.61 29.56L480 146.5v13.91C480 191.3 454.8 216.4 423.8 216.4C421.2 216.4 418.6 216 416 215.6v5.862c6.922 4.049 13.58 8.691 19.51 14.61c37.5 37.43 37.5 98.33 0 135.8c-18.75 18.71-43.38 28.07-68 28.07c-2.277 0-4.523-.4883-6.795-.6484c-9.641 18.69-22.1 36.24-37.64 51.77c-6.059 6.059-12.49 11.53-19.13 16.73C324.4 475.7 345.9 480 367.5 480c45.12 0 90.34-17.18 124.8-51.55c61.11-60.99 67.77-155.6 20.42-224.1l56.65-56.55l29.61 29.56c4.898 4.889 10.92 7.075 16.83 7.075C628.1 184.4 640 174.8 640 160.4V48C640 39.16 632.8 32 623.1 32z',
			),
		),
		'label'             => __( 'Mars Double', 'astra' ),
		'custom_categories' => array(),
	),
	'mars-stroke'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M496 .0002l-112.4 .0001c-21.38 0-32.09 25.85-16.97 40.97l29.56 29.56l-24.33 24.34l-33.94-33.94c-6.248-6.25-16.38-6.248-22.63 0l-22.63 22.63c-6.25 6.25-6.25 16.38 0 22.63l33.94 33.94l-18.96 18.96C239.1 111.8 144.5 118.6 83.55 179.5c-68.73 68.73-68.73 180.2 0 248.9c68.73 68.73 180.2 68.73 248.9 0c60.99-60.99 67.73-155.6 20.47-224.1l18.96-18.96l33.94 33.94c6.248 6.248 16.38 6.25 22.63 0l22.63-22.63c6.248-6.248 6.248-16.38 0-22.63l-33.94-33.94l24.34-24.33l29.56 29.56C486.1 160.5 512 149.8 512 128.4v-112.4C512 7.162 504.8 .0002 496 .0002zM275.9 371.9c-37.43 37.43-98.33 37.43-135.8 0c-37.43-37.43-37.43-98.33 0-135.8c37.43-37.43 98.33-37.43 135.8 0C313.3 273.5 313.3 334.5 275.9 371.9z',
			),
		),
		'label'             => __( 'Mars Stroke', 'astra' ),
		'custom_categories' => array(),
	),
	'mars-stroke-right'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M619.3 244.7l-82.34-77.61c-15.12-15.12-40.97-4.41-40.97 16.97V223.1L463.1 224V176c.002-8.838-7.162-16-15.1-16h-32c-8.84 0-16 7.16-16 16V224h-19.05c-15.07-81.9-86.7-144-172.1-144C110.8 80 32 158.8 32 256c0 97.2 78.8 176 176 176c86.26 0 157.9-62.1 172.1-144h19.05V336c0 8.836 7.162 16 16 16h32c8.836 0 15.1-7.164 15.1-16V287.1L496 288v39.95c0 21.38 25.85 32.09 40.97 16.97l82.34-77.61C625.6 261.1 625.6 250.9 619.3 244.7zM208 352c-52.94 0-96-43.07-96-96c-.002-52.94 43.06-96 96-96c52.93 0 95.1 43.06 95.1 96C304 308.9 260.9 352 208 352z',
			),
		),
		'label'             => __( 'Mars Stroke Right', 'astra' ),
		'custom_categories' => array(),
	),
	'mars-stroke-up'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M224 163V144h24c4.418 0 8-3.578 8-7.1V120c0-4.418-3.582-7.1-8-7.1H224V96h24.63c16.41 0 24.62-19.84 13.02-31.44l-60.97-60.97c-4.795-4.793-12.57-4.793-17.36 0L122.3 64.56c-11.6 11.6-3.383 31.44 13.02 31.44H160v15.1H136c-4.418 0-8 3.582-8 7.1v15.1c0 4.422 3.582 7.1 8 7.1H160v19.05c-84.9 15.62-148.5 92.01-143.7 182.5c4.783 90.69 82.34 165.1 173.2 166.5C287.8 513.4 368 434.1 368 336C368 249.7 305.9 178.1 224 163zM192 431.1c-52.94 0-96-43.06-96-95.1s43.06-95.1 96-95.1c52.93 0 96 43.06 96 95.1S244.9 431.1 192 431.1z',
			),
		),
		'label'             => __( 'Mars Stroke Up', 'astra' ),
		'custom_categories' => array(),
	),
	'martini-glass'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M502 57.63C523.3 36.38 508.3 0 478.3 0H33.72C3.711 0-11.29 36.38 9.962 57.63l214 214V448H175.1c-26.51 0-47.1 21.49-47.1 48c0 8.836 7.164 16 16 16h224c8.836 0 16-7.164 16-16c0-26.51-21.49-48-48-48h-47.1V271.6L502 57.63zM405.1 64l-64.01 64H170.9L106.9 64H405.1z',
			),
		),
		'label'             => __( 'Martini Glass', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'martini-glass-citrus'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M288 464H240v-125.3l168.8-168.7C424.3 154.5 413.3 128 391.4 128H24.63C2.751 128-8.249 154.5 7.251 170l168.7 168.7V464H128c-17.67 0-32 14.33-32 32c0 8.836 7.164 16 15.1 16h191.1c8.836 0 15.1-7.164 15.1-16C320 478.3 305.7 464 288 464zM432 0c-62.63 0-115.4 40.25-135.1 96h52.5c16.62-28.5 47.25-48 82.62-48c52.88 0 95.1 43 95.1 96s-43.12 96-95.1 96c-14 0-27.25-3.25-39.37-8.625l-35.25 35.25c21.88 13.25 47.25 21.38 74.62 21.38c79.5 0 143.1-64.5 143.1-144S511.5 0 432 0z',
			),
		),
		'label'             => __( 'Martini Glass Citrus', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'martini-glass-empty'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M502 57.63C523.3 36.38 508.3 0 478.3 0H33.72C3.711 0-11.29 36.38 9.962 57.63l214 214V448H176c-26.51 0-48 21.49-48 48c0 8.836 7.164 16 16 16h224c8.836 0 16-7.164 16-16c0-26.51-21.49-48-47.1-48h-47.1V271.6L502 57.63zM256 213.1L106.9 64h298.3L256 213.1z',
			),
		),
		'label'             => __( 'Martini Glass Empty', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'mask'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M288 64C39.52 64 0 182.1 0 273.5C0 379.5 78.8 448 176 448c27.33 0 51.21-6.516 66.11-36.79l19.93-40.5C268.3 358.6 278.1 352.4 288 352.1c9.9 .3711 19.7 6.501 25.97 18.63l19.93 40.5C348.8 441.5 372.7 448 400 448c97.2 0 176-68.51 176-174.5C576 182.1 536.5 64 288 64zM160 320c-35.35 0-64-28.65-64-64s28.65-64 64-64c35.35 0 64 28.65 64 64S195.3 320 160 320zM416 320c-35.35 0-64-28.65-64-64s28.65-64 64-64c35.35 0 64 28.65 64 64S451.3 320 416 320z',
			),
		),
		'label'             => __( 'Mask', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'mask-face'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M396.4 87.12L433.5 111.9C449.3 122.4 467.8 128 486.8 128H584C614.9 128 640 153.1 640 184V269C640 324.1 602.5 372.1 549.1 385.5L441.1 412.5C406.2 434.1 364.6 448 320 448C275.4 448 233.8 434.1 198.9 412.5L90.9 385.5C37.48 372.1 0 324.1 0 269V184C0 153.1 25.07 128 56 128H153.2C172.2 128 190.7 122.4 206.5 111.9L243.6 87.12C266.2 72.05 292.8 64 320 64C347.2 64 373.8 72.05 396.4 87.12zM132.3 346.3C109.4 311.2 96 269.1 96 224V176H56C51.58 176 48 179.6 48 184V269C48 302.1 70.49 330.9 102.5 338.9L132.3 346.3zM592 269V184C592 179.6 588.4 176 584 176H544V224C544 269.1 530.6 311.2 507.7 346.3L537.5 338.9C569.5 330.9 592 302.1 592 269H592zM208 224H432C440.8 224 448 216.8 448 208C448 199.2 440.8 192 432 192H208C199.2 192 192 199.2 192 208C192 216.8 199.2 224 208 224zM208 256C199.2 256 192 263.2 192 272C192 280.8 199.2 288 208 288H432C440.8 288 448 280.8 448 272C448 263.2 440.8 256 432 256H208zM240 352H400C408.8 352 416 344.8 416 336C416 327.2 408.8 320 400 320H240C231.2 320 224 327.2 224 336C224 344.8 231.2 352 240 352z',
			),
		),
		'label'             => __( 'Mask Face', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'mask-ventilator'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320 32C372.1 32 419.7 73.8 454.5 128H584C614.9 128 640 153.1 640 184V269C640 324.1 602.5 372.1 549.1 385.5L477.5 403.4C454.6 433.8 421.1 457.2 384 469.8V393.2C403.6 376.8 416 353.1 416 326.4C416 276.9 372.5 191.1 320 191.1C267 191.1 224 276.9 224 326.4C224 353 236.3 376.9 256 393.3V469.9C217.6 457.4 184.9 433.8 162.2 403.3L90.9 385.5C37.48 372.1 0 324.1 0 269V184C0 153.1 25.07 128 56 128H185.1C219.8 73.8 267.4 32 320 32V32zM56 176C51.58 176 48 179.6 48 184V269C48 302.1 70.49 330.9 102.5 338.9L134.3 346.8C130.2 332.2 127.1 316.7 127.1 300.8C127.1 264.7 139.4 219.2 159.1 176H56zM480.7 176C500.4 219.2 512 264.7 512 300.8C512 316.8 509.8 332.2 505.6 346.9L537.5 338.9C569.5 330.9 592 302.1 592 269V184C592 179.6 588.4 176 584 176H480.7zM288 320C288 302.3 302.3 288 320 288C337.7 288 352 302.3 352 320V512H288V320z',
			),
		),
		'label'             => __( 'Mask Ventilator', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'masks-theater'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M206.9 245.1C171 255.6 146.8 286.4 149.3 319.3C160.7 306.5 178.1 295.5 199.3 288.4L206.9 245.1zM95.78 294.9L64.11 115.5C63.74 113.9 64.37 112.9 64.37 112.9c57.75-32.13 123.1-48.99 189-48.99c1.625 0 3.113 .0745 4.738 .0745c13.1-13.5 31.75-22.75 51.62-26c18.87-3 38.12-4.5 57.25-5.25c-9.999-14-24.47-24.27-41.84-27.02c-23.87-3.875-47.9-5.732-71.77-5.732c-76.74 0-152.4 19.45-220.1 57.07C9.021 70.57-3.853 98.5 1.021 126.6L32.77 306c14.25 80.5 136.3 142 204.5 142c3.625 0 6.777-.2979 10.03-.6729c-13.5-17.13-28.1-40.5-39.5-67.63C160.1 366.8 101.7 328 95.78 294.9zM193.4 157.6C192.6 153.4 191.1 149.7 189.3 146.2c-8.249 8.875-20.62 15.75-35.25 18.37c-14.62 2.5-28.75 .376-39.5-5.249c-.5 4-.6249 7.998 .125 12.12c3.75 21.75 24.5 36.24 46.25 32.37C182.6 200.1 197.3 179.3 193.4 157.6zM606.8 121c-88.87-49.38-191.4-67.38-291.9-51.38C287.5 73.1 265.8 95.85 260.8 123.1L229 303.5c-15.37 87.13 95.33 196.3 158.3 207.3c62.1 11.13 204.5-53.68 219.9-140.8l31.75-179.5C643.9 162.3 631 134.4 606.8 121zM333.5 217.8c3.875-21.75 24.62-36.25 46.37-32.37c21.75 3.75 36.25 24.49 32.5 46.12c-.7499 4.125-2.25 7.873-4.125 11.5c-8.249-9-20.62-15.75-35.25-18.37c-14.75-2.625-28.75-.3759-39.5 5.124C332.1 225.9 332.9 221.9 333.5 217.8zM403.1 416.5c-55.62-9.875-93.49-59.23-88.99-112.1c20.62 25.63 56.25 46.24 99.49 53.87c43.25 7.625 83.74 .3781 111.9-16.62C512.2 392.7 459.7 426.3 403.1 416.5zM534.4 265.2c-8.249-8.875-20.75-15.75-35.37-18.37c-14.62-2.5-28.62-.3759-39.5 5.249c-.5-4-.625-7.998 .125-12.12c3.875-21.75 24.62-36.25 46.37-32.37c21.75 3.875 36.25 24.49 32.37 46.24C537.6 257.9 536.1 261.7 534.4 265.2z',
			),
		),
		'label'             => __( 'Masks Theater', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'mastodon'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M433 179.1c0-97.2-63.71-125.7-63.71-125.7-62.52-28.7-228.6-28.4-290.5 0 0 0-63.72 28.5-63.72 125.7 0 115.7-6.6 259.4 105.6 289.1 40.51 10.7 75.32 13 103.3 11.4 50.81-2.8 79.32-18.1 79.32-18.1l-1.7-36.9s-36.31 11.4-77.12 10.1c-40.41-1.4-83-4.4-89.63-54a102.5 102.5 0 0 1 -.9-13.9c85.63 20.9 158.6 9.1 178.8 6.7 56.12-6.7 105-41.3 111.2-72.9 9.8-49.8 9-121.5 9-121.5zm-75.12 125.2h-46.63v-114.2c0-49.7-64-51.6-64 6.9v62.5h-46.33V197c0-58.5-64-56.6-64-6.9v114.2H90.19c0-122.1-5.2-147.9 18.41-175 25.9-28.9 79.82-30.8 103.8 6.1l11.6 19.5 11.6-19.5c24.11-37.1 78.12-34.8 103.8-6.1 23.71 27.3 18.4 53 18.4 175z',
			),
		),
		'label'             => __( 'Mastodon', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'mattress-pillow'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M256 448H64C28.65 448 0 419.3 0 384V128C0 92.65 28.65 64 64 64H256V448zM64 352C64 369.7 78.33 384 96 384H160C177.7 384 192 369.7 192 352V160C192 142.3 177.7 128 160 128H96C78.33 128 64 142.3 64 160V352zM288 64H576C611.3 64 640 92.65 640 128V384C640 419.3 611.3 448 576 448H288V64z',
			),
		),
		'label'             => __( 'Mattress Pillow', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'maxcdn'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M461.1 442.7h-97.4L415.6 200c2.3-10.2 .9-19.5-4.4-25.7-5-6.1-13.7-9.6-24.2-9.6h-49.3l-59.5 278h-97.4l59.5-278h-83.4l-59.5 278H0l59.5-278-44.6-95.4H387c39.4 0 75.3 16.3 98.3 44.9 23.3 28.6 31.8 67.4 23.6 105.9l-47.8 222.6z',
			),
		),
		'label'             => __( 'MaxCDN', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'maximize'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M447.1 319.1v135.1c0 13.26-10.75 23.1-23.1 23.1h-135.1c-12.94 0-24.61-7.781-29.56-19.75c-4.906-11.1-2.203-25.72 6.937-34.87l30.06-30.06L224 323.9l-71.43 71.44l30.06 30.06c9.156 9.156 11.91 22.91 6.937 34.87C184.6 472.2 172.9 479.1 160 479.1H24c-13.25 0-23.1-10.74-23.1-23.1v-135.1c0-12.94 7.781-24.61 19.75-29.56C23.72 288.8 27.88 288 32 288c8.312 0 16.5 3.242 22.63 9.367l30.06 30.06l71.44-71.44L84.69 184.6L54.63 214.6c-9.156 9.156-22.91 11.91-34.87 6.937C7.798 216.6 .0013 204.9 .0013 191.1v-135.1c0-13.26 10.75-23.1 23.1-23.1h135.1c12.94 0 24.61 7.781 29.56 19.75C191.2 55.72 191.1 59.87 191.1 63.1c0 8.312-3.237 16.5-9.362 22.63L152.6 116.7l71.44 71.44l71.43-71.44l-30.06-30.06c-9.156-9.156-11.91-22.91-6.937-34.87c4.937-11.95 16.62-19.75 29.56-19.75h135.1c13.26 0 23.1 10.75 23.1 23.1v135.1c0 12.94-7.781 24.61-19.75 29.56c-11.1 4.906-25.72 2.203-34.87-6.937l-30.06-30.06l-71.43 71.43l71.44 71.44l30.06-30.06c9.156-9.156 22.91-11.91 34.87-6.937C440.2 295.4 447.1 307.1 447.1 319.1z',
			),
		),
		'label'             => __( 'Maximize', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'mdb'                                    => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M17.37 160.4L7 352h43.91l5.59-79.83L84.43 352h44.71l25.54-77.43 4.79 77.43H205l-12.79-191.6H146.7L106 277.7 63.67 160.4zm281 0h-47.9V352h47.9s95 .8 94.2-95.79c-.78-94.21-94.18-95.78-94.18-95.78zm-1.2 146.5V204.8s46 4.27 46.8 50.57-46.78 51.54-46.78 51.54zm238.3-74.24a56.16 56.16 0 0 0 8-38.31c-5.34-35.76-55.08-34.32-55.08-34.32h-51.9v191.6H482s87 4.79 87-63.85c0-43.14-33.52-55.08-33.52-55.08zm-51.9-31.94s13.57-1.59 16 9.59c1.43 6.66-4 12-4 12h-12v-21.57zm-.1 109.5l.1-24.92V267h.08s41.58-4.73 41.19 22.43c-.33 25.65-41.35 20.74-41.35 20.74z',
			),
		),
		'label'             => __( 'Material Design for Bootstrap', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'medal'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M223.7 130.8L149.1 7.77C147.1 2.949 141.9 0 136.3 0H16.03c-12.95 0-20.53 14.58-13.1 25.18l111.3 158.9C143.9 156.4 181.7 137.3 223.7 130.8zM256 160c-97.25 0-176 78.75-176 176S158.8 512 256 512s176-78.75 176-176S353.3 160 256 160zM348.5 317.3l-37.88 37l8.875 52.25c1.625 9.25-8.25 16.5-16.63 12l-46.88-24.62L209.1 418.5c-8.375 4.5-18.25-2.75-16.63-12l8.875-52.25l-37.88-37C156.6 310.6 160.5 299 169.9 297.6l52.38-7.625L245.7 242.5c2-4.25 6.125-6.375 10.25-6.375S264.2 238.3 266.2 242.5l23.5 47.5l52.38 7.625C351.6 299 355.4 310.6 348.5 317.3zM495.1 0H375.7c-5.621 0-10.83 2.949-13.72 7.77l-73.76 122.1c42 6.5 79.88 25.62 109.5 53.38l111.3-158.9C516.5 14.58 508.9 0 495.1 0z',
			),
		),
		'label'             => __( 'Medal', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'medapps'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M118.3 238.4c3.5-12.5 6.9-33.6 13.2-33.6 8.3 1.8 9.6 23.4 18.6 36.6 4.6-23.5 5.3-85.1 14.1-86.7 9-.7 19.7 66.5 22 77.5 9.9 4.1 48.9 6.6 48.9 6.6 1.9 7.3-24 7.6-40 7.8-4.6 14.8-5.4 27.7-11.4 28-4.7 .2-8.2-28.8-17.5-49.6l-9.4 65.5c-4.4 13-15.5-22.5-21.9-39.3-3.3-.1-62.4-1.6-47.6-7.8l31-5zM228 448c21.2 0 21.2-32 0-32H92c-21.2 0-21.2 32 0 32h136zm-24 64c21.2 0 21.2-32 0-32h-88c-21.2 0-21.2 32 0 32h88zm34.2-141.5c3.2-18.9 5.2-36.4 11.9-48.8 7.9-14.7 16.1-28.1 24-41 24.6-40.4 45.9-75.2 45.9-125.5C320 69.6 248.2 0 160 0S0 69.6 0 155.2c0 50.2 21.3 85.1 45.9 125.5 7.9 12.9 16 26.3 24 41 6.7 12.5 8.7 29.8 11.9 48.9 3.5 21 36.1 15.7 32.6-5.1-3.6-21.7-5.6-40.7-15.3-58.6C66.5 246.5 33 211.3 33 155.2 33 87.3 90 32 160 32s127 55.3 127 123.2c0 56.1-33.5 91.3-66.1 151.6-9.7 18-11.7 37.4-15.3 58.6-3.4 20.6 29 26.4 32.6 5.1z',
			),
		),
		'label'             => __( 'MedApps', 'astra' ),
		'custom_categories' => array(),
	),
	'medium'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M180.5 74.26C80.81 74.26 0 155.6 0 256S80.82 437.7 180.5 437.7 361 356.4 361 256 280.2 74.26 180.5 74.26zm288.3 10.65c-49.85 0-90.25 76.62-90.25 171.1s40.41 171.1 90.25 171.1 90.25-76.62 90.25-171.1H559C559 161.5 518.6 84.91 468.8 84.91zm139.5 17.82c-17.53 0-31.74 68.63-31.74 153.3s14.2 153.3 31.74 153.3S640 340.6 640 256C640 171.4 625.8 102.7 608.3 102.7z',
			),
		),
		'label'             => __( 'Medium', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'medrt'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 544,
				'height' => 512,
				'path'   => 'M113.7 256c0 121.8 83.9 222.8 193.5 241.1-18.7 4.5-38.2 6.9-58.2 6.9C111.4 504 0 393 0 256S111.4 8 248.9 8c20.1 0 39.6 2.4 58.2 6.9C197.5 33.2 113.7 134.2 113.7 256m297.4 100.3c-77.7 55.4-179.6 47.5-240.4-14.6 5.5 14.1 12.7 27.7 21.7 40.5 61.6 88.2 182.4 109.3 269.7 47 87.3-62.3 108.1-184.3 46.5-272.6-9-12.9-19.3-24.3-30.5-34.2 37.4 78.8 10.7 178.5-67 233.9m-218.8-244c-1.4 1-2.7 2.1-4 3.1 64.3-17.8 135.9 4 178.9 60.5 35.7 47 42.9 106.6 24.4 158 56.7-56.2 67.6-142.1 22.3-201.8-50-65.5-149.1-74.4-221.6-19.8M296 224c-4.4 0-8-3.6-8-8v-40c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v40c0 4.4-3.6 8-8 8h-40c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h40c4.4 0 8 3.6 8 8v40c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-40c0-4.4 3.6-8 8-8h40c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8h-40z',
			),
		),
		'label'             => __( 'MRT', 'astra' ),
		'custom_categories' => array(),
	),
	'meetup'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M99 414.3c1.1 5.7-2.3 11.1-8 12.3-5.4 1.1-10.9-2.3-12-8-1.1-5.4 2.3-11.1 7.7-12.3 5.4-1.2 11.1 2.3 12.3 8zm143.1 71.4c-6.3 4.6-8 13.4-3.7 20 4.6 6.6 13.4 8.3 20 3.7 6.3-4.6 8-13.4 3.4-20-4.2-6.5-13.1-8.3-19.7-3.7zm-86-462.3c6.3-1.4 10.3-7.7 8.9-14-1.1-6.6-7.4-10.6-13.7-9.1-6.3 1.4-10.3 7.7-9.1 14 1.4 6.6 7.6 10.6 13.9 9.1zM34.4 226.3c-10-6.9-23.7-4.3-30.6 6-6.9 10-4.3 24 5.7 30.9 10 7.1 23.7 4.6 30.6-5.7 6.9-10.4 4.3-24.1-5.7-31.2zm272-170.9c10.6-6.3 13.7-20 7.7-30.3-6.3-10.6-19.7-14-30-7.7s-13.7 20-7.4 30.6c6 10.3 19.4 13.7 29.7 7.4zm-191.1 58c7.7-5.4 9.4-16 4.3-23.7s-15.7-9.4-23.1-4.3c-7.7 5.4-9.4 16-4.3 23.7 5.1 7.8 15.6 9.5 23.1 4.3zm372.3 156c-7.4 1.7-12.3 9.1-10.6 16.9 1.4 7.4 8.9 12.3 16.3 10.6 7.4-1.4 12.3-8.9 10.6-16.6-1.5-7.4-8.9-12.3-16.3-10.9zm39.7-56.8c-1.1-5.7-6.6-9.1-12-8-5.7 1.1-9.1 6.9-8 12.6 1.1 5.4 6.6 9.1 12.3 8 5.4-1.5 9.1-6.9 7.7-12.6zM447 138.9c-8.6 6-10.6 17.7-4.9 26.3 5.7 8.6 17.4 10.6 26 4.9 8.3-6 10.3-17.7 4.6-26.3-5.7-8.7-17.4-10.9-25.7-4.9zm-6.3 139.4c26.3 43.1 15.1 100-26.3 129.1-17.4 12.3-37.1 17.7-56.9 17.1-12 47.1-69.4 64.6-105.1 32.6-1.1 .9-2.6 1.7-3.7 2.9-39.1 27.1-92.3 17.4-119.4-22.3-9.7-14.3-14.6-30.6-15.1-46.9-65.4-10.9-90-94-41.1-139.7-28.3-46.9 .6-107.4 53.4-114.9C151.6 70 234.1 38.6 290.1 82c67.4-22.3 136.3 29.4 130.9 101.1 41.1 12.6 52.8 66.9 19.7 95.2zm-70 74.3c-3.1-20.6-40.9-4.6-43.1-27.1-3.1-32 43.7-101.1 40-128-3.4-24-19.4-29.1-33.4-29.4-13.4-.3-16.9 2-21.4 4.6-2.9 1.7-6.6 4.9-11.7-.3-6.3-6-11.1-11.7-19.4-12.9-12.3-2-17.7 2-26.6 9.7-3.4 2.9-12 12.9-20 9.1-3.4-1.7-15.4-7.7-24-11.4-16.3-7.1-40 4.6-48.6 20-12.9 22.9-38 113.1-41.7 125.1-8.6 26.6 10.9 48.6 36.9 47.1 11.1-.6 18.3-4.6 25.4-17.4 4-7.4 41.7-107.7 44.6-112.6 2-3.4 8.9-8 14.6-5.1 5.7 3.1 6.9 9.4 6 15.1-1.1 9.7-28 70.9-28.9 77.7-3.4 22.9 26.9 26.6 38.6 4 3.7-7.1 45.7-92.6 49.4-98.3 4.3-6.3 7.4-8.3 11.7-8 3.1 0 8.3 .9 7.1 10.9-1.4 9.4-35.1 72.3-38.9 87.7-4.6 20.6 6.6 41.4 24.9 50.6 11.4 5.7 62.5 15.7 58.5-11.1zm5.7 92.3c-10.3 7.4-12.9 22-5.7 32.6 7.1 10.6 21.4 13.1 32 6 10.6-7.4 13.1-22 6-32.6-7.4-10.6-21.7-13.5-32.3-6z',
			),
		),
		'label'             => __( 'Meetup', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'megaport'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M214.5 209.6v66.2l33.5 33.5 33.3-33.3v-66.4l-33.4-33.4zM248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm145.1 414.4L367 441.6l-26-19.2v-65.5l-33.4-33.4-33.4 33.4v65.5L248 441.6l-26.1-19.2v-65.5l-33.4-33.4-33.5 33.4v65.5l-26.1 19.2-26.1-19.2v-87l59.5-59.5V188l59.5-59.5V52.9l26.1-19.2L274 52.9v75.6l59.5 59.5v87.6l59.7 59.7v87.1z',
			),
		),
		'label'             => __( 'Megaport', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'memory'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 448h80v-32c0-8.838 7.164-16 16-16c8.838 0 16 7.162 16 16v32h96v-32c0-8.838 7.164-16 16-16c8.838 0 16 7.162 16 16v32h96v-32c0-8.838 7.164-16 16-16c8.838 0 16 7.162 16 16v32h96v-32c0-8.838 7.164-16 16-16c8.838 0 16 7.162 16 16v32H576v-96H0V448zM576 146.9V112C576 85.49 554.5 64 528 64h-480C21.49 64 0 85.49 0 112v34.94C18.6 153.5 32 171.1 32 192S18.6 230.5 0 237.1V320h576V237.1C557.4 230.5 544 212.9 544 192S557.4 153.5 576 146.9zM192 240C192 248.8 184.8 256 176 256h-32C135.2 256 128 248.8 128 240v-96C128 135.2 135.2 128 144 128h32C184.8 128 192 135.2 192 144V240zM320 240C320 248.8 312.8 256 304 256h-32C263.2 256 256 248.8 256 240v-96C256 135.2 263.2 128 272 128h32C312.8 128 320 135.2 320 144V240zM448 240C448 248.8 440.8 256 432 256h-32C391.2 256 384 248.8 384 240v-96C384 135.2 391.2 128 400 128h32C440.8 128 448 135.2 448 144V240z',
			),
		),
		'label'             => __( 'Memory', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'mendeley'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M624.6 325.2c-12.3-12.4-29.7-19.2-48.4-17.2-43.3-1-49.7-34.9-37.5-98.8 22.8-57.5-14.9-131.5-87.4-130.8-77.4 .7-81.7 82-130.9 82-48.1 0-54-81.3-130.9-82-72.9-.8-110.1 73.3-87.4 130.8 12.2 63.9 5.8 97.8-37.5 98.8-21.2-2.3-37 6.5-53 22.5-19.9 19.7-19.3 94.8 42.6 102.6 47.1 5.9 81.6-42.9 61.2-87.8-47.3-103.7 185.9-106.1 146.5-8.2-.1 .1-.2 .2-.3 .4-26.8 42.8 6.8 97.4 58.8 95.2 52.1 2.1 85.4-52.6 58.8-95.2-.1-.2-.2-.3-.3-.4-39.4-97.9 193.8-95.5 146.5 8.2-4.6 10-6.7 21.3-5.7 33 4.9 53.4 68.7 74.1 104.9 35.2 17.8-14.8 23.1-65.6 0-88.3zm-303.9-19.1h-.6c-43.4 0-62.8-37.5-62.8-62.8 0-34.7 28.2-62.8 62.8-62.8h.6c34.7 0 62.8 28.1 62.8 62.8 0 25-19.2 62.8-62.8 62.8z',
			),
		),
		'label'             => __( 'Mendeley', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'menorah'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M544 144C544 135.1 536.9 128 528 128h-32C487.1 128 480 135.1 480 144V288h64V144zM416 95.1c17.62 0 32-14.38 32-32s-32-63.1-32-63.1s-32 46.37-32 63.1S398.4 95.1 416 95.1zM448 144C448 135.1 440.9 128 432 128h-32C391.1 128 384 135.1 384 144V288h64V144zM608 95.1c17.62 0 32-14.38 32-32s-32-63.1-32-63.1s-32 46.37-32 63.1S590.4 95.1 608 95.1zM320 95.1c17.62 0 32-14.38 32-32s-32-63.1-32-63.1S288 46.37 288 63.1S302.4 95.1 320 95.1zM512 95.1c17.62 0 32-14.38 32-32s-32-63.1-32-63.1s-32 46.37-32 63.1S494.4 95.1 512 95.1zM624 128h-32C583.2 128 576 135.2 576 144V288c0 17.6-14.4 32-32 32h-192V144C352 135.2 344.8 128 336 128h-32C295.2 128 288 135.2 288 144V320H96c-17.6 0-32-14.4-32-32V144C64 135.2 56.84 128 48 128h-32C7.164 128 0 135.2 0 144V288c0 53.02 42.98 96 96 96h192v64H176C149.5 448 128 469.5 128 496C128 504.8 135.2 512 144 512h352c8.836 0 16-7.164 16-16c0-26.51-21.49-48-48-48H352v-64h192c53.02 0 96-42.98 96-96V144C640 135.2 632.8 128 624 128zM160 144C160 135.1 152.9 128 144 128h-32C103.1 128 96 135.1 96 144V288h64V144zM224 95.1c17.62 0 32-14.38 32-32S224 0 224 0S192 46.37 192 63.1S206.4 95.1 224 95.1zM32 95.1c17.62 0 32-14.38 32-32S32 0 32 0S0 46.37 0 63.1S14.38 95.1 32 95.1zM128 95.1c17.62 0 32-14.38 32-32S128 0 128 0S96 46.37 96 63.1S110.4 95.1 128 95.1zM256 144C256 135.1 248.9 128 240 128h-32C199.1 128 192 135.1 192 144V288h64V144z',
			),
		),
		'label'             => __( 'Menorah', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'mercury'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M368 223.1c0-55.32-25.57-104.6-65.49-136.9c20.49-17.32 37.2-39.11 48.1-64.21c4.656-10.72-2.9-22.89-14.45-22.89h-54.31c-5.256 0-9.93 2.828-12.96 7.188C251.8 31.77 223.8 47.1 192 47.1c-31.85 0-59.78-16.23-76.88-40.81C112.1 2.828 107.4 0 102.2 0H47.84c-11.55 0-19.11 12.17-14.45 22.89C44.29 47.1 60.1 69.79 81.49 87.11C41.57 119.4 16 168.7 16 223.1c0 86.26 62.1 157.9 144 172.1V416H128c-8.836 0-16 7.164-16 16v32C112 472.8 119.2 480 128 480h32v16C160 504.8 167.2 512 176 512h32c8.838 0 16-7.164 16-16V480h32c8.838 0 16-7.164 16-16v-32c0-8.836-7.162-16-16-16h-32v-19.05C305.9 381.9 368 310.3 368 223.1zM192 320c-52.93 0-96-43.07-96-96c0-52.94 43.07-95.1 96-95.1c52.94 0 96 43.06 96 95.1C288 276.9 244.9 320 192 320z',
			),
		),
		'label'             => __( 'Mercury', 'astra' ),
		'custom_categories' => array(),
	),
	'message'                                => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M511.1 63.1v287.1c0 35.25-28.75 63.1-64 63.1h-144l-124.9 93.68c-7.875 5.75-19.12 .0497-19.12-9.7v-83.98h-96c-35.25 0-64-28.75-64-63.1V63.1c0-35.25 28.75-63.1 64-63.1h384C483.2 0 511.1 28.75 511.1 63.1z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M447.1 0h-384c-35.25 0-64 28.75-64 63.1v287.1c0 35.25 28.75 63.1 64 63.1h96v83.98c0 9.836 11.02 15.55 19.12 9.7l124.9-93.68h144c35.25 0 64-28.75 64-63.1V63.1C511.1 28.75 483.2 0 447.1 0zM464 352c0 8.75-7.25 16-16 16h-160l-80 60v-60H64c-8.75 0-16-7.25-16-16V64c0-8.75 7.25-16 16-16h384c8.75 0 16 7.25 16 16V352z',
			),
		),
		'label'             => __( 'Message', 'astra' ),
		'custom_categories' => array(
			'communication',
			'social',
		),
	),
	'meteor'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M511.4 20.72c-11.63 38.75-34.38 111.8-61.38 187.8c7 2.125 13.38 4 18.63 5.625c4.625 1.375 8.375 4.751 10.13 9.127c1.875 4.5 1.625 9.501-.625 13.75c-22.13 42.25-82.63 152.8-142.5 214.4c-1 1.125-2.001 2.5-3.001 3.5c-76 76.13-199.4 76.13-275.5 .125c-76.13-76.13-76.13-199.5 0-275.7c1-1 2.375-2 3.5-3C122.1 116.5 232.5 55.97 274.1 33.84c4.25-2.25 9.25-2.5 13.63-.625c4.5 1.875 7.875 5.626 9.25 10.13c1.625 5.125 3.5 11.63 5.625 18.63c75.88-27 148.9-49.75 187.6-61.25c5.75-1.75 11.88-.2503 16.13 4C511.5 8.844 512.1 15.09 511.4 20.72zM319.1 319.1c0-70.63-57.38-128-128-128c-70.75 0-128 57.38-128 128c0 70.76 57.25 128 128 128C262.6 448 319.1 390.8 319.1 319.1zM191.1 287.1c0 17.63-14.37 32-32 32c-17.75 0-32-14.38-32-32s14.25-32 32-32c8.5 0 16.63 3.375 22.63 9.375S191.1 279.5 191.1 287.1zM223.9 367.1c0 8.876-7.224 16-15.97 16c-8.875 0-16-7.127-16-16c0-8.876 7.1-16 15.98-16C216.7 351.1 223.9 359.1 223.9 367.1z',
			),
		),
		'label'             => __( 'Meteor', 'astra' ),
		'custom_categories' => array(
			'environment',
			'science-and-technology',
		),
	),
	'microblog'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M399.4 362.2c29.49-34.69 47.1-78.34 47.1-125.8C446.5 123.5 346.9 32 224 32S1.54 123.5 1.54 236.4 101.1 440.9 224 440.9a239.3 239.3 0 0 0 79.44-13.44 7.18 7.18 0 0 1 8.12 2.56c18.58 25.09 47.61 42.74 79.89 49.92a4.42 4.42 0 0 0 5.22-3.43 4.37 4.37 0 0 0 -.85-3.62 87 87 0 0 1 3.69-110.7zM329.5 212.4l-57.3 43.49L293 324.8a6.5 6.5 0 0 1 -9.94 7.22L224 290.9 164.9 332a6.51 6.51 0 0 1 -9.95-7.22l20.79-68.86-57.3-43.49a6.5 6.5 0 0 1 3.8-11.68l71.88-1.51 23.66-67.92a6.5 6.5 0 0 1 12.28 0l23.66 67.92 71.88 1.51a6.5 6.5 0 0 1 3.88 11.68z',
			),
		),
		'label'             => __( 'Micro.blog', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'microchip'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M160 352h192V160H160V352zM448 176h48C504.8 176 512 168.8 512 160s-7.162-16-16-16H448V128c0-35.35-28.65-64-64-64h-16V16C368 7.164 360.8 0 352 0c-8.836 0-16 7.164-16 16V64h-64V16C272 7.164 264.8 0 256 0C247.2 0 240 7.164 240 16V64h-64V16C176 7.164 168.8 0 160 0C151.2 0 144 7.164 144 16V64H128C92.65 64 64 92.65 64 128v16H16C7.164 144 0 151.2 0 160s7.164 16 16 16H64v64H16C7.164 240 0 247.2 0 256s7.164 16 16 16H64v64H16C7.164 336 0 343.2 0 352s7.164 16 16 16H64V384c0 35.35 28.65 64 64 64h16v48C144 504.8 151.2 512 160 512c8.838 0 16-7.164 16-16V448h64v48c0 8.836 7.164 16 16 16c8.838 0 16-7.164 16-16V448h64v48c0 8.836 7.164 16 16 16c8.838 0 16-7.164 16-16V448H384c35.35 0 64-28.65 64-64v-16h48c8.838 0 16-7.164 16-16s-7.162-16-16-16H448v-64h48C504.8 272 512 264.8 512 256s-7.162-16-16-16H448V176zM384 368c0 8.836-7.162 16-16 16h-224C135.2 384 128 376.8 128 368v-224C128 135.2 135.2 128 144 128h224C376.8 128 384 135.2 384 144V368z',
			),
		),
		'label'             => __( 'Microchip', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'microphone'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M192 352c53.03 0 96-42.97 96-96v-160c0-53.03-42.97-96-96-96s-96 42.97-96 96v160C96 309 138.1 352 192 352zM344 192C330.7 192 320 202.7 320 215.1V256c0 73.33-61.97 132.4-136.3 127.7c-66.08-4.169-119.7-66.59-119.7-132.8L64 215.1C64 202.7 53.25 192 40 192S16 202.7 16 215.1v32.15c0 89.66 63.97 169.6 152 181.7V464H128c-18.19 0-32.84 15.18-31.96 33.57C96.43 505.8 103.8 512 112 512h160c8.222 0 15.57-6.216 15.96-14.43C288.8 479.2 274.2 464 256 464h-40v-33.77C301.7 418.5 368 344.9 368 256V215.1C368 202.7 357.3 192 344 192z',
			),
		),
		'label'             => __( 'Microphone', 'astra' ),
		'custom_categories' => array(
			'communication',
			'lifestyle-and-hobbies',
		),
	),
	'microphone-lines'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M192 352c53.03 0 96-42.97 96-96h-80C199.2 256 192 248.8 192 240S199.2 224 208 224H288V192h-80C199.2 192 192 184.8 192 176S199.2 160 208 160H288V127.1h-80c-8.836 0-16-7.164-16-16s7.164-16 16-16L288 96c0-53.03-42.97-96-96-96s-96 42.97-96 96v160C96 309 138.1 352 192 352zM344 192C330.7 192 320 202.7 320 215.1V256c0 73.33-61.97 132.4-136.3 127.7c-66.08-4.169-119.7-66.59-119.7-132.8L64 215.1C64 202.7 53.25 192 40 192S16 202.7 16 215.1v32.15c0 89.66 63.97 169.6 152 181.7V464H128c-18.19 0-32.84 15.18-31.96 33.57C96.43 505.8 103.8 512 112 512h160c8.222 0 15.57-6.216 15.96-14.43C288.8 479.2 274.2 464 256 464h-40v-33.77C301.7 418.5 368 344.9 368 256V215.1C368 202.7 357.3 192 344 192z',
			),
		),
		'label'             => __( 'Microphone Lines', 'astra' ),
		'custom_categories' => array(
			'communication',
			'lifestyle-and-hobbies',
		),
	),
	'microphone-lines-slash'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M383.1 464l-39.1-.0001v-33.77c20.6-2.824 39.99-9.402 57.69-18.72l-43.26-33.91c-14.66 4.65-30.28 7.179-46.68 6.144C245.7 379.6 191.1 317.1 191.1 250.9v-3.777L143.1 209.5l.0001 38.61c0 89.65 63.97 169.6 151.1 181.7v34.15l-40 .0001c-17.67 0-31.1 14.33-31.1 31.1C223.1 504.8 231.2 512 239.1 512h159.1c8.838 0 15.1-7.164 15.1-15.1C415.1 478.3 401.7 464 383.1 464zM630.8 469.1l-159.3-124.9c15.37-25.94 24.53-55.91 24.53-88.21V216c0-13.25-10.75-24-23.1-24c-13.25 0-24 10.75-24 24l-.0001 39.1c0 21.12-5.557 40.77-14.77 58.24l-25.73-20.16c5.234-11.68 8.493-24.42 8.493-38.08l-57.07 .0006l-34.45-27c2.914-3.055 6.969-4.999 11.52-4.999h79.1V192L335.1 192c-8.836 0-15.1-7.164-15.1-15.1s7.164-16 15.1-16l79.1 .0013V128l-79.1-.0015c-8.836 0-15.1-7.164-15.1-15.1s7.164-15.1 15.1-15.1l80-.0003c0-54-44.56-97.57-98.93-95.95C264.5 1.614 223.1 47.45 223.1 100l.0006 50.23L38.81 5.111C34.41 1.673 29.19 0 24.03 0C16.91 0 9.84 3.158 5.121 9.189C-3.067 19.63-1.249 34.72 9.189 42.89l591.1 463.1c10.5 8.203 25.57 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1z',
			),
		),
		'label'             => __( 'Microphone Lines Slash', 'astra' ),
		'custom_categories' => array(
			'communication',
			'lifestyle-and-hobbies',
		),
	),
	'microphone-slash'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M383.1 464l-39.1-.0001v-33.77c20.6-2.824 39.98-9.402 57.69-18.72l-43.26-33.91c-14.66 4.65-30.28 7.179-46.68 6.144C245.7 379.6 191.1 317.1 191.1 250.9V247.2L143.1 209.5l.0001 38.61c0 89.65 63.97 169.6 151.1 181.7v34.15l-40 .0001c-17.67 0-31.1 14.33-31.1 31.1C223.1 504.8 231.2 512 239.1 512h159.1c8.838 0 15.1-7.164 15.1-15.1C415.1 478.3 401.7 464 383.1 464zM630.8 469.1l-159.3-124.9c15.37-25.94 24.53-55.91 24.53-88.21V216c0-13.25-10.75-24-23.1-24c-13.25 0-24 10.75-24 24l-.0001 39.1c0 21.12-5.559 40.77-14.77 58.24l-25.72-20.16c5.234-11.68 8.493-24.42 8.493-38.08l-.001-155.1c0-52.57-40.52-98.41-93.07-99.97c-54.37-1.617-98.93 41.95-98.93 95.95l0 54.25L38.81 5.111C34.41 1.673 29.19 0 24.03 0C16.91 0 9.839 3.158 5.12 9.189c-8.187 10.44-6.37 25.53 4.068 33.7l591.1 463.1c10.5 8.203 25.57 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1z',
			),
		),
		'label'             => __( 'Microphone Slash', 'astra' ),
		'custom_categories' => array(
			'communication',
			'lifestyle-and-hobbies',
		),
	),
	'microscope'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M160 320h12v16c0 8.875 7.125 16 16 16h40c8.875 0 16-7.125 16-16V320H256c17.62 0 32-14.38 32-32V64c0-17.62-14.38-32-32-32V16C256 7.125 248.9 0 240 0h-64C167.1 0 160 7.125 160 16V32C142.4 32 128 46.38 128 64v224C128 305.6 142.4 320 160 320zM464 448h-1.25C493.2 414 512 369.2 512 320c0-105.9-86.13-192-192-192v64c70.63 0 128 57.38 128 128s-57.38 128-128 128H48C21.5 448 0 469.5 0 496C0 504.9 7.125 512 16 512h480c8.875 0 16-7.125 16-16C512 469.5 490.5 448 464 448zM104 416h208c4.375 0 8-3.625 8-8v-16c0-4.375-3.625-8-8-8h-208C99.63 384 96 387.6 96 392v16C96 412.4 99.63 416 104 416z',
			),
		),
		'label'             => __( 'Microscope', 'astra' ),
		'custom_categories' => array(
			'education',
			'science-and-technology',
		),
	),
	'microsoft'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M0 32h214.6v214.6H0V32zm233.4 0H448v214.6H233.4V32zM0 265.4h214.6V480H0V265.4zm233.4 0H448V480H233.4V265.4z',
			),
		),
		'label'             => __( 'Microsoft', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'mill-sign'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M282.9 96.53C339.7 102 384 149.8 384 208V416C384 433.7 369.7 448 352 448C334.3 448 320 433.7 320 416V208C320 181.5 298.5 160 272 160C267.7 160 263.6 160.6 259.7 161.6L224 261.5V416C224 433.7 209.7 448 192 448C179.6 448 168.9 440.1 163.6 430.7L142.1 490.8C136.2 507.4 117.9 516.1 101.2 510.1C84.59 504.2 75.92 485.9 81.86 469.2L160 250.5V208C160 181.5 138.5 160 112 160C85.49 160 64 181.5 64 208V416C64 433.7 49.67 448 32 448C14.33 448 0 433.7 0 416V128C0 110.3 14.33 96 32 96C42.87 96 52.48 101.4 58.26 109.7C74.21 100.1 92.53 96 112 96C143.3 96 171.7 108.9 192 129.6C196.9 124.6 202.2 120.1 207.1 116.1L241.9 21.24C247.8 4.595 266.1-4.079 282.8 1.865C299.4 7.809 308.1 26.12 302.1 42.76L282.9 96.53z',
			),
		),
		'label'             => __( 'Mill Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'minimize'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M200 287.1H64c-12.94 0-24.62 7.797-29.56 19.75c-4.969 11.97-2.219 25.72 6.937 34.87l30.06 30.06l-62.06 62.07c-12.49 12.5-12.5 32.75-.0012 45.25l22.62 22.62c12.5 12.5 32.76 12.5 45.26 .0012l62.06-62.07l30.06 30.06c6.125 6.125 14.31 9.375 22.62 9.375c4.125 0 8.281-.7969 12.25-2.437c11.97-4.953 19.75-16.62 19.75-29.56V311.1C224 298.7 213.3 287.1 200 287.1zM312 224h135.1c12.94 0 24.62-7.797 29.56-19.75c4.969-11.97 2.219-25.72-6.937-34.87l-30.06-30.06l62.06-62.07c12.5-12.5 12.5-32.76 .0003-45.26l-22.62-22.62c-12.5-12.5-32.76-12.5-45.26-.0003l-62.06 62.07l-30.06-30.06c-9.156-9.141-22.87-11.84-34.87-6.937C295.8 39.39 288 51.06 288 64v135.1C288 213.3 298.7 224 312 224zM204.3 34.44C192.3 29.47 178.5 32.22 169.4 41.38L139.3 71.44L77.25 9.374C64.75-3.123 44.49-3.123 31.1 9.374l-22.63 22.63c-12.49 12.49-12.49 32.75 .0018 45.25l62.07 62.06L41.38 169.4C35.25 175.5 32 183.7 32 192c0 4.125 .7969 8.281 2.438 12.25C39.39 216.2 51.07 224 64 224h135.1c13.25 0 23.1-10.75 23.1-23.1V64C224 51.06 216.2 39.38 204.3 34.44zM440.6 372.7l30.06-30.06c9.141-9.156 11.84-22.88 6.938-34.87C472.6 295.8 460.9 287.1 448 287.1h-135.1c-13.25 0-23.1 10.75-23.1 23.1v135.1c0 12.94 7.797 24.62 19.75 29.56c11.97 4.969 25.72 2.219 34.87-6.937l30.06-30.06l62.06 62.06c12.5 12.5 32.76 12.5 45.26 .0002l22.62-22.62c12.5-12.5 12.5-32.76 .0002-45.26L440.6 372.7z',
			),
		),
		'label'             => __( 'Minimize', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'science-and-technology',
		),
	),
	'minus'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 288h-352c-17.69 0-32-14.32-32-32.01s14.31-31.99 32-31.99h352c17.69 0 32 14.3 32 31.99S417.7 288 400 288z',
			),
		),
		'label'             => __( 'Minus', 'astra' ),
		'custom_categories' => array(
			'design',
			'education',
		),
	),
	'mitten'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M351.1 416H63.99c-17.6 0-31.1 14.4-31.1 31.1l.0026 31.1C31.1 497.6 46.4 512 63.1 512h288c17.6 0 32-14.4 32-31.1l-.0049-31.1C383.1 430.4 369.6 416 351.1 416zM425 206.9c-27.25-22.62-67.5-19-90.13 8.25l-20.88 25L284.4 111.8c-18-77.5-95.38-125.1-172.8-108C34.26 21.63-14.25 98.88 3.754 176.4L64 384h288l81.14-86.1C455.8 269.8 452.1 229.5 425 206.9z',
			),
		),
		'label'             => __( 'Mitten', 'astra' ),
		'custom_categories' => array(
			'education',
			'lifestyle-and-hobbies',
		),
	),
	'mix'                                    => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M0 64v348.9c0 56.2 88 58.1 88 0V174.3c7.9-52.9 88-50.4 88 6.5v175.3c0 57.9 96 58 96 0V240c5.3-54.7 88-52.5 88 4.3v23.8c0 59.9 88 56.6 88 0V64H0z',
			),
		),
		'label'             => __( 'Mix', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'mixcloud'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M424.4 219.7C416.1 134.7 344.1 68 256.9 68c-72.27 0-136.2 46.52-159.2 114.1-54.54 8.029-96.63 54.82-96.63 111.6 0 62.3 50.67 112.1 113.2 112.1h289.6c52.33 0 94.97-42.36 94.97-94.69 0-45.13-32.12-83.06-74.48-92.2zm-20.49 144.5H114.3c-39.04 0-70.88-31.56-70.88-70.6s31.84-70.6 70.88-70.6c18.83 0 36.55 7.475 49.84 20.77 19.96 19.96 50.13-10.23 30.18-30.18-14.68-14.4-32.67-24.36-52.05-29.35 19.93-44.3 64.79-73.93 114.6-73.93 69.5 0 125.1 56.48 125.1 125.7 0 13.57-2.215 26.86-6.369 39.59-8.943 27.52 32.13 38.94 40.15 13.29 2.769-8.306 4.984-16.89 6.369-25.47 19.38 7.476 33.5 26.3 33.5 48.45 0 28.8-23.53 52.33-52.61 52.33zm235.1-52.33c0 44.02-12.74 86.39-37.1 122.7-4.153 6.092-10.8 9.414-17.72 9.414-16.32 0-27.13-18.83-17.44-32.95 19.38-29.35 29.9-63.68 29.9-99.12s-10.52-69.77-29.9-98.85c-15.65-22.83 19.36-47.24 35.16-23.53 24.37 35.99 37.1 78.36 37.1 122.4zm-70.88 0c0 31.57-9.137 62.02-26.86 88.32-4.153 6.091-10.8 9.136-17.72 9.136-17.2 0-27.02-18.98-17.44-32.95 13.01-19.1 19.66-41.26 19.66-64.51 0-22.98-6.645-45.41-19.66-64.51-15.76-22.99 19.01-47.1 35.16-23.53 17.72 26.03 26.86 56.48 26.86 88.05z',
			),
		),
		'label'             => __( 'Mixcloud', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'mixer'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M114.6 76.07a45.71 45.71 0 0 0 -67.51-6.41c-17.58 16.18-19 43.52-4.75 62.77l91.78 123L41.76 379.6c-14.23 19.25-13.11 46.59 4.74 62.77A45.71 45.71 0 0 0 114 435.9L242.9 262.7a12.14 12.14 0 0 0 0-14.23zM470.2 379.6 377.9 255.4l91.78-123c14.22-19.25 12.83-46.59-4.75-62.77a45.71 45.71 0 0 0 -67.51 6.41l-128 172.1a12.14 12.14 0 0 0 0 14.23L398 435.9a45.71 45.71 0 0 0 67.51 6.41C483.4 426.2 484.5 398.8 470.2 379.6z',
			),
		),
		'label'             => __( 'Mixer', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'mizuni'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M248 8C111 8 0 119.1 0 256c0 137 111 248 248 248s248-111 248-248C496 119.1 385 8 248 8zm-80 351.9c-31.4 10.6-58.8 27.3-80 48.2V136c0-22.1 17.9-40 40-40s40 17.9 40 40v223.9zm120-9.9c-12.9-2-26.2-3.1-39.8-3.1-13.8 0-27.2 1.1-40.2 3.1V136c0-22.1 17.9-40 40-40s40 17.9 40 40v214zm120 57.7c-21.2-20.8-48.6-37.4-80-48V136c0-22.1 17.9-40 40-40s40 17.9 40 40v271.7z',
			),
		),
		'label'             => __( 'Mizuni', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'mobile'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M320 0H64C37.5 0 16 21.5 16 48v416C16 490.5 37.5 512 64 512h256c26.5 0 48-21.5 48-48v-416C368 21.5 346.5 0 320 0zM240 447.1C240 456.8 232.8 464 224 464H159.1C151.2 464 144 456.8 144 448S151.2 432 160 432h64C232.8 432 240 439.2 240 447.1z',
			),
		),
		'label'             => __( 'Mobile', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'mobile-button'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M320 0H64C37.49 0 16 21.49 16 48v416C16 490.5 37.49 512 64 512h256c26.51 0 48-21.49 48-48v-416C368 21.49 346.5 0 320 0zM192 464c-17.75 0-32-14.25-32-32s14.25-32 32-32s32 14.25 32 32S209.8 464 192 464z',
			),
		),
		'label'             => __( 'Mobile button', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'mobile-retro'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H256C291.3 0 320 28.65 320 64V448C320 483.3 291.3 512 256 512H64C28.65 512 0 483.3 0 448V64zM64 232C64 245.3 74.75 256 88 256H232C245.3 256 256 245.3 256 232V152C256 138.7 245.3 128 232 128H88C74.75 128 64 138.7 64 152V232zM80 352C93.25 352 104 341.3 104 328C104 314.7 93.25 304 80 304C66.75 304 56 314.7 56 328C56 341.3 66.75 352 80 352zM80 384C66.75 384 56 394.7 56 408C56 421.3 66.75 432 80 432C93.25 432 104 421.3 104 408C104 394.7 93.25 384 80 384zM160 352C173.3 352 184 341.3 184 328C184 314.7 173.3 304 160 304C146.7 304 136 314.7 136 328C136 341.3 146.7 352 160 352zM160 384C146.7 384 136 394.7 136 408C136 421.3 146.7 432 160 432C173.3 432 184 421.3 184 408C184 394.7 173.3 384 160 384zM240 352C253.3 352 264 341.3 264 328C264 314.7 253.3 304 240 304C226.7 304 216 314.7 216 328C216 341.3 226.7 352 240 352zM240 384C226.7 384 216 394.7 216 408C216 421.3 226.7 432 240 432C253.3 432 264 421.3 264 408C264 394.7 253.3 384 240 384zM128 48C119.2 48 112 55.16 112 64C112 72.84 119.2 80 128 80H192C200.8 80 208 72.84 208 64C208 55.16 200.8 48 192 48H128z',
			),
		),
		'label'             => __( 'Mobile Retro', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'mobile-screen'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M320 0H64C37.5 0 16 21.5 16 48v416C16 490.5 37.5 512 64 512h256c26.5 0 48-21.5 48-48v-416C368 21.5 346.5 0 320 0zM240 447.1C240 456.8 232.8 464 224 464H159.1C151.2 464 144 456.8 144 448S151.2 432 160 432h64C232.8 432 240 439.2 240 447.1zM304 384h-224V64h224V384z',
			),
		),
		'label'             => __( 'Mobile screen', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'mobile-screen-button'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M304 0h-224c-35.35 0-64 28.65-64 64v384c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64V64C368 28.65 339.3 0 304 0zM192 480c-17.75 0-32-14.25-32-32s14.25-32 32-32s32 14.25 32 32S209.8 480 192 480zM304 64v320h-224V64H304z',
			),
		),
		'label'             => __( 'Mobile Screen Button', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'modx'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M356 241.8l36.7 23.7V480l-133-83.8L356 241.8zM440 75H226.3l-23 37.8 153.5 96.5L440 75zm-89 142.8L55.2 32v214.5l46 29L351 217.8zM97 294.2L8 437h213.7l125-200.5L97 294.2z',
			),
		),
		'label'             => __( 'MODX', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'monero'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M352 384h108.4C417 455.9 338.1 504 248 504S79 455.9 35.6 384H144V256.2L248 361l104-105v128zM88 336V128l159.4 159.4L408 128v208h74.8c8.5-25.1 13.2-52 13.2-80C496 119 385 8 248 8S0 119 0 256c0 28 4.6 54.9 13.2 80H88z',
			),
		),
		'label'             => __( 'Monero', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'money-bill'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M512 64C547.3 64 576 92.65 576 128V384C576 419.3 547.3 448 512 448H64C28.65 448 0 419.3 0 384V128C0 92.65 28.65 64 64 64H512zM128 384C128 348.7 99.35 320 64 320V384H128zM64 192C99.35 192 128 163.3 128 128H64V192zM512 384V320C476.7 320 448 348.7 448 384H512zM512 128H448C448 163.3 476.7 192 512 192V128zM288 352C341 352 384 309 384 256C384 202.1 341 160 288 160C234.1 160 192 202.1 192 256C192 309 234.1 352 288 352z',
			),
		),
		'label'             => __( 'Money Bill', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'money-bill-1'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M252 208C252 196.1 260.1 188 272 188H288C299 188 308 196.1 308 208V276H312C323 276 332 284.1 332 296C332 307 323 316 312 316H264C252.1 316 244 307 244 296C244 284.1 252.1 276 264 276H268V227.6C258.9 225.7 252 217.7 252 208zM512 64C547.3 64 576 92.65 576 128V384C576 419.3 547.3 448 512 448H64C28.65 448 0 419.3 0 384V128C0 92.65 28.65 64 64 64H512zM128 384C128 348.7 99.35 320 64 320V384H128zM64 192C99.35 192 128 163.3 128 128H64V192zM512 384V320C476.7 320 448 348.7 448 384H512zM512 128H448C448 163.3 476.7 192 512 192V128zM288 144C226.1 144 176 194.1 176 256C176 317.9 226.1 368 288 368C349.9 368 400 317.9 400 256C400 194.1 349.9 144 288 144z',
			),
			'regular' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M400 256C400 317.9 349.9 368 288 368C226.1 368 176 317.9 176 256C176 194.1 226.1 144 288 144C349.9 144 400 194.1 400 256zM272 224V288H264C255.2 288 248 295.2 248 304C248 312.8 255.2 320 264 320H312C320.8 320 328 312.8 328 304C328 295.2 320.8 288 312 288H304V208C304 199.2 296.8 192 288 192H272C263.2 192 256 199.2 256 208C256 216.8 263.2 224 272 224zM0 128C0 92.65 28.65 64 64 64H512C547.3 64 576 92.65 576 128V384C576 419.3 547.3 448 512 448H64C28.65 448 0 419.3 0 384V128zM48 176V336C83.35 336 112 364.7 112 400H464C464 364.7 492.7 336 528 336V176C492.7 176 464 147.3 464 112H112C112 147.3 83.35 176 48 176z',
			),
		),
		'label'             => __( 'Money Bill 1', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'money-bill-1-wave'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M251.1 207.1C251.1 196.1 260.1 187.1 271.1 187.1H287.1C299 187.1 308 196.1 308 207.1V275.1H312C323 275.1 332 284.1 332 295.1C332 307 323 315.1 312 315.1H263.1C252.1 315.1 243.1 307 243.1 295.1C243.1 284.1 252.1 275.1 263.1 275.1H267.1V227.6C258.9 225.7 251.1 217.7 251.1 207.1zM48.66 79.13C128.4 100.9 208.2 80.59 288 60.25C375 38.08 462 15.9 549 48.38C565.9 54.69 576 71.62 576 89.66V399.5C576 423.4 550.4 439.2 527.3 432.9C447.6 411.1 367.8 431.4 288 451.7C200.1 473.9 113.1 496.1 26.97 463.6C10.06 457.3 0 440.4 0 422.3V112.5C0 88.59 25.61 72.83 48.66 79.13L48.66 79.13zM127.1 416C127.1 380.7 99.35 352 63.1 352V416H127.1zM63.1 223.1C99.35 223.1 127.1 195.3 127.1 159.1H63.1V223.1zM512 352V287.1C476.7 287.1 448 316.7 448 352H512zM512 95.1H448C448 131.3 476.7 159.1 512 159.1V95.1zM287.1 143.1C234.1 143.1 191.1 194.1 191.1 255.1C191.1 317.9 234.1 368 287.1 368C341 368 384 317.9 384 255.1C384 194.1 341 143.1 287.1 143.1z',
			),
		),
		'label'             => __( 'Money Bill 1 Wave', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'money-bill-transfer'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M535 7.03C544.4-2.343 559.6-2.343 568.1 7.029L632.1 71.02C637.5 75.52 640 81.63 640 87.99C640 94.36 637.5 100.5 632.1 104.1L568.1 168.1C559.6 178.3 544.4 178.3 535 168.1C525.7 159.6 525.7 144.4 535 135L558.1 111.1L384 111.1C370.7 111.1 360 101.2 360 87.99C360 74.74 370.7 63.99 384 63.99L558.1 63.1L535 40.97C525.7 31.6 525.7 16.4 535 7.03V7.03zM104.1 376.1L81.94 400L255.1 399.1C269.3 399.1 279.1 410.7 279.1 423.1C279.1 437.2 269.3 447.1 255.1 447.1L81.95 448L104.1 471C114.3 480.4 114.3 495.6 104.1 504.1C95.6 514.3 80.4 514.3 71.03 504.1L7.029 440.1C2.528 436.5-.0003 430.4 0 423.1C0 417.6 2.529 411.5 7.03 407L71.03 343C80.4 333.7 95.6 333.7 104.1 343C114.3 352.4 114.3 367.6 104.1 376.1H104.1zM95.1 64H337.9C334.1 71.18 332 79.34 332 87.1C332 116.7 355.3 139.1 384 139.1L481.1 139.1C484.4 157.5 494.9 172.5 509.4 181.9C511.1 184.3 513.1 186.6 515.2 188.8C535.5 209.1 568.5 209.1 588.8 188.8L608 169.5V384C608 419.3 579.3 448 544 448H302.1C305.9 440.8 307.1 432.7 307.1 423.1C307.1 395.3 284.7 371.1 255.1 371.1L158.9 372C155.5 354.5 145.1 339.5 130.6 330.1C128.9 327.7 126.9 325.4 124.8 323.2C104.5 302.9 71.54 302.9 51.23 323.2L31.1 342.5V128C31.1 92.65 60.65 64 95.1 64V64zM95.1 192C131.3 192 159.1 163.3 159.1 128H95.1V192zM544 384V320C508.7 320 480 348.7 480 384H544zM319.1 352C373 352 416 309 416 256C416 202.1 373 160 319.1 160C266.1 160 223.1 202.1 223.1 256C223.1 309 266.1 352 319.1 352z',
			),
		),
		'label'             => __( 'Money Bill Transfer', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'money-bill-trend-up'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M470.7 9.441C473.7 12.49 476 16 477.6 19.75C479.1 23.5 479.1 27.6 480 31.9V32V128C480 145.7 465.7 160 448 160C430.3 160 416 145.7 416 128V109.3L310.6 214.6C298.8 226.5 279.9 227.2 267.2 216.3L175.1 138.1L84.82 216.3C71.41 227.8 51.2 226.2 39.7 212.8C28.2 199.4 29.76 179.2 43.17 167.7L155.2 71.7C167.2 61.43 184.8 61.43 196.8 71.7L286.3 148.4L370.7 64H352C334.3 64 320 49.67 320 32C320 14.33 334.3 0 352 0H447.1C456.8 0 464.8 3.554 470.6 9.305L470.7 9.441zM0 304C0 277.5 21.49 256 48 256H464C490.5 256 512 277.5 512 304V464C512 490.5 490.5 512 464 512H48C21.49 512 0 490.5 0 464V304zM48 464H96C96 437.5 74.51 416 48 416V464zM48 304V352C74.51 352 96 330.5 96 304H48zM464 416C437.5 416 416 437.5 416 464H464V416zM416 304C416 330.5 437.5 352 464 352V304H416zM256 320C220.7 320 192 348.7 192 384C192 419.3 220.7 448 256 448C291.3 448 320 419.3 320 384C320 348.7 291.3 320 256 320z',
			),
		),
		'label'             => __( 'Money Bill Trend Up', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'money-bill-wave'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M48.66 79.13C128.4 100.9 208.2 80.59 288 60.25C375 38.08 462 15.9 549 48.38C565.9 54.69 576 71.62 576 89.66V399.5C576 423.4 550.4 439.2 527.3 432.9C447.6 411.1 367.8 431.4 288 451.7C200.1 473.9 113.1 496.1 26.97 463.6C10.06 457.3 0 440.4 0 422.3V112.5C0 88.59 25.61 72.83 48.66 79.13L48.66 79.13zM287.1 352C332.2 352 368 309 368 255.1C368 202.1 332.2 159.1 287.1 159.1C243.8 159.1 207.1 202.1 207.1 255.1C207.1 309 243.8 352 287.1 352zM63.1 416H127.1C127.1 380.7 99.35 352 63.1 352V416zM63.1 143.1V207.1C99.35 207.1 127.1 179.3 127.1 143.1H63.1zM512 303.1C476.7 303.1 448 332.7 448 368H512V303.1zM448 95.1C448 131.3 476.7 159.1 512 159.1V95.1H448z',
			),
		),
		'label'             => __( 'Money Bill Wave', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'money-bill-wheat'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 80C256 88.84 248.8 96 240 96C195.8 96 160 60.18 160 16C160 7.164 167.2 0 176 0C220.2 0 256 35.82 256 80zM104 16C117.3 16 128 26.75 128 40C128 53.25 117.3 64 104 64H56C42.75 64 32 53.25 32 40C32 26.75 42.75 16 56 16H104zM136 88C149.3 88 160 98.75 160 112C160 125.3 149.3 136 136 136H24C10.75 136 0 125.3 0 112C0 98.75 10.75 88 24 88H136zM32 184C32 170.7 42.75 160 56 160H104C117.3 160 128 170.7 128 184C128 197.3 117.3 208 104 208H56C42.75 208 32 197.3 32 184zM272 16C272 7.164 279.2 0 288 0C332.2 0 368 35.82 368 80C368 88.84 360.8 96 352 96C307.8 96 272 60.18 272 16zM480 80C480 88.84 472.8 96 464 96C419.8 96 384 60.18 384 16C384 7.164 391.2 0 400 0C444.2 0 480 35.82 480 80zM400 224C391.2 224 384 216.8 384 208C384 163.8 419.8 128 464 128C472.8 128 480 135.2 480 144C480 188.2 444.2 224 400 224zM352 128C360.8 128 368 135.2 368 144C368 188.2 332.2 224 288 224C279.2 224 272 216.8 272 208C272 163.8 307.8 128 352 128zM176 224C167.2 224 160 216.8 160 208C160 163.8 195.8 128 240 128C248.8 128 256 135.2 256 144C256 188.2 220.2 224 176 224zM0 304C0 277.5 21.49 256 48 256H464C490.5 256 512 277.5 512 304V464C512 490.5 490.5 512 464 512H48C21.49 512 0 490.5 0 464V304zM48 464H96C96 437.5 74.51 416 48 416V464zM48 304V352C74.51 352 96 330.5 96 304H48zM464 416C437.5 416 416 437.5 416 464H464V416zM416 304C416 330.5 437.5 352 464 352V304H416zM256 320C220.7 320 192 348.7 192 384C192 419.3 220.7 448 256 448C291.3 448 320 419.3 320 384C320 348.7 291.3 320 256 320z',
			),
		),
		'label'             => __( 'Money Bill Wheat', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'money-bills'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M96 96C96 60.65 124.7 32 160 32H576C611.3 32 640 60.65 640 96V320C640 355.3 611.3 384 576 384H160C124.7 384 96 355.3 96 320V96zM160 320H224C224 284.7 195.3 256 160 256V320zM160 96V160C195.3 160 224 131.3 224 96H160zM576 256C540.7 256 512 284.7 512 320H576V256zM512 96C512 131.3 540.7 160 576 160V96H512zM368 128C323.8 128 288 163.8 288 208C288 252.2 323.8 288 368 288C412.2 288 448 252.2 448 208C448 163.8 412.2 128 368 128zM48 360C48 399.8 80.24 432 120 432H520C533.3 432 544 442.7 544 456C544 469.3 533.3 480 520 480H120C53.73 480 0 426.3 0 360V120C0 106.7 10.75 96 24 96C37.25 96 48 106.7 48 120V360z',
			),
		),
		'label'             => __( 'Money Bills', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'money-check'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M512 64C547.3 64 576 92.65 576 128V384C576 419.3 547.3 448 512 448H64C28.65 448 0 419.3 0 384V128C0 92.65 28.65 64 64 64H512zM112 224C103.2 224 96 231.2 96 240C96 248.8 103.2 256 112 256H272C280.8 256 288 248.8 288 240C288 231.2 280.8 224 272 224H112zM112 352H464C472.8 352 480 344.8 480 336C480 327.2 472.8 320 464 320H112C103.2 320 96 327.2 96 336C96 344.8 103.2 352 112 352zM376 160C362.7 160 352 170.7 352 184V232C352 245.3 362.7 256 376 256H456C469.3 256 480 245.3 480 232V184C480 170.7 469.3 160 456 160H376z',
			),
		),
		'label'             => __( 'Money Check', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
		),
	),
	'money-check-dollar'                     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M512 64C547.3 64 576 92.65 576 128V384C576 419.3 547.3 448 512 448H64C28.65 448 0 419.3 0 384V128C0 92.65 28.65 64 64 64H512zM272 192C263.2 192 256 199.2 256 208C256 216.8 263.2 224 272 224H496C504.8 224 512 216.8 512 208C512 199.2 504.8 192 496 192H272zM272 320H496C504.8 320 512 312.8 512 304C512 295.2 504.8 288 496 288H272C263.2 288 256 295.2 256 304C256 312.8 263.2 320 272 320zM164.1 160C164.1 148.9 155.1 139.9 143.1 139.9C132.9 139.9 123.9 148.9 123.9 160V166C118.3 167.2 112.1 168.9 108 171.1C93.06 177.9 80.07 190.5 76.91 208.8C75.14 219 76.08 228.9 80.32 237.8C84.47 246.6 91 252.8 97.63 257.3C109.2 265.2 124.5 269.8 136.2 273.3L138.4 273.9C152.4 278.2 161.8 281.3 167.7 285.6C170.2 287.4 171.1 288.8 171.4 289.7C171.8 290.5 172.4 292.3 171.7 296.3C171.1 299.8 169.2 302.8 163.7 305.1C157.6 307.7 147.7 309 134.9 307C128.9 306 118.2 302.4 108.7 299.2C106.5 298.4 104.3 297.7 102.3 297C91.84 293.5 80.51 299.2 77.02 309.7C73.53 320.2 79.2 331.5 89.68 334.1C90.89 335.4 92.39 335.9 94.11 336.5C101.1 339.2 114.4 343.4 123.9 345.6V352C123.9 363.1 132.9 372.1 143.1 372.1C155.1 372.1 164.1 363.1 164.1 352V346.5C169.4 345.5 174.6 343.1 179.4 341.9C195.2 335.2 207.8 322.2 211.1 303.2C212.9 292.8 212.1 282.8 208.1 273.7C204.2 264.7 197.9 258.1 191.2 253.3C179.1 244.4 162.9 239.6 150.8 235.9L149.1 235.7C135.8 231.4 126.2 228.4 120.1 224.2C117.5 222.4 116.7 221.2 116.5 220.7C116.3 220.3 115.7 219.1 116.3 215.7C116.7 213.7 118.2 210.4 124.5 207.6C130.1 204.7 140.9 203.1 153.1 204.1C157.5 205.7 171 208.3 174.9 209.3C185.5 212.2 196.5 205.8 199.3 195.1C202.2 184.5 195.8 173.5 185.1 170.7C180.7 169.5 170.7 167.5 164.1 166.3L164.1 160z',
			),
		),
		'label'             => __( 'Money Check Dollar', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
		),
	),
	'monument'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M180.7 4.686C186.9-1.562 197.1-1.562 203.3 4.686L283.3 84.69C285.8 87.2 287.4 90.48 287.9 94.02L328.1 416H55.88L96.12 94.02C96.57 90.48 98.17 87.2 100.7 84.69L180.7 4.686zM152 272C138.7 272 128 282.7 128 296C128 309.3 138.7 320 152 320H232C245.3 320 256 309.3 256 296C256 282.7 245.3 272 232 272H152zM352 448C369.7 448 384 462.3 384 480C384 497.7 369.7 512 352 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448H352z',
			),
		),
		'label'             => __( 'Monument', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'moon'                                   => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M32 256c0-123.8 100.3-224 223.8-224c11.36 0 29.7 1.668 40.9 3.746c9.616 1.777 11.75 14.63 3.279 19.44C245 86.5 211.2 144.6 211.2 207.8c0 109.7 99.71 193 208.3 172.3c9.561-1.805 16.28 9.324 10.11 16.95C387.9 448.6 324.8 480 255.8 480C132.1 480 32 379.6 32 256z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M421.6 379.9c-.6641 0-1.35 .0625-2.049 .1953c-11.24 2.143-22.37 3.17-33.32 3.17c-94.81 0-174.1-77.14-174.1-175.5c0-63.19 33.79-121.3 88.73-152.6c8.467-4.812 6.339-17.66-3.279-19.44c-11.2-2.078-29.53-3.746-40.9-3.746C132.3 31.1 32 132.2 32 256c0 123.6 100.1 224 223.8 224c69.04 0 132.1-31.45 173.8-82.93C435.3 389.1 429.1 379.9 421.6 379.9zM255.8 432C158.9 432 80 353 80 256c0-76.32 48.77-141.4 116.7-165.8C175.2 125 163.2 165.6 163.2 207.8c0 99.44 65.13 183.9 154.9 212.8C298.5 428.1 277.4 432 255.8 432z',
			),
		),
		'label'             => __( 'Moon', 'astra' ),
		'custom_categories' => array(
			'environment',
			'science-and-technology',
		),
	),
	'mortar-pestle'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M501.5 60.87c17.25-17.12 12.5-46.25-9.25-57.13c-12.12-6-26.5-4.75-37.38 3.375L251.1 159.1h151.4L501.5 60.87zM496 191.1h-480c-8.875 0-16 7.125-16 16v32c0 8.875 7.125 16 16 16L31.1 256c0 81 50.25 150.1 121.1 178.4c-12.75 16.88-21.75 36.75-25 58.63C126.8 502.9 134.2 512 144.2 512h223.5c10 0 17.51-9.125 16.13-19c-3.25-21.88-12.25-41.75-25-58.63C429.8 406.1 479.1 337 479.1 256L496 255.1c8.875 0 16-7.125 16-16v-32C512 199.1 504.9 191.1 496 191.1z',
			),
		),
		'label'             => __( 'Mortar Pestle', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'mosque'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M400 0C405 0 409.8 2.371 412.8 6.4C447.5 52.7 490.9 81.34 546.3 117.9C551.5 121.4 556.9 124.9 562.3 128.5C591.3 147.7 608 180.2 608 214.6C608 243.1 596.7 269 578.2 288H221.8C203.3 269 192 243.1 192 214.6C192 180.2 208.7 147.7 237.7 128.5C243.1 124.9 248.5 121.4 253.7 117.9C309.1 81.34 352.5 52.7 387.2 6.4C390.2 2.371 394.1 0 400 0V0zM288 440C288 426.7 277.3 416 264 416C250.7 416 240 426.7 240 440V512H192C174.3 512 160 497.7 160 480V352C160 334.3 174.3 320 192 320H608C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H560V440C560 426.7 549.3 416 536 416C522.7 416 512 426.7 512 440V512H448V453.1C448 434.1 439.6 416.1 424.1 404.8L400 384L375 404.8C360.4 416.1 352 434.1 352 453.1V512H288V440zM70.4 5.2C76.09 .9334 83.91 .9334 89.6 5.2L105.6 17.2C139.8 42.88 160 83.19 160 126V128H0V126C0 83.19 20.15 42.88 54.4 17.2L70.4 5.2zM0 160H160V296.6C140.9 307.6 128 328.3 128 352V480C128 489.6 130.1 498.6 133.8 506.8C127.3 510.1 119.9 512 112 512H48C21.49 512 0 490.5 0 464V160z',
			),
		),
		'label'             => __( 'Mosque', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'mosquito'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M430.3 503.8L382.3 447.8C378.4 443.4 376.3 437.7 376.3 431.7V376.3L351.1 344.7V407.8C351.1 425.4 337.7 439.8 319.1 439.8C302.3 439.8 287.1 425.4 287.1 407.8V344.7L263.7 376.3V431.7C263.7 437.7 261.6 443.4 257.7 447.8L209.7 503.8C201.1 513.8 186.1 514.8 176.3 505.9C166.5 497 165.6 481.6 174.3 471.6L216.3 422.5V367.8C216.3 362.3 218.1 357 221.5 352.7L287.1 266.3V266L154.6 387.8C97.58 447.6 .0003 405.2 0 320.6C0 272.7 34.02 232.3 79.35 226.4L232.3 202.5L191.5 161.6C183.7 153.8 182.1 141.5 187.6 131.8L211.5 90.06L173.3 39.18C165.3 28.54 167.2 13.26 177.5 5.046C187.9-3.17 202.7-1.207 210.7 9.429L258.7 73.34C264.6 81.21 265.3 91.99 260.4 100.6L237.8 140L287.1 190.3V152.1C287.1 137.2 298.2 124.7 311.1 121.1V63.93C311.1 59.51 315.6 55.93 319.1 55.93C324.4 55.93 327.1 59.51 327.1 63.93V121.1C341.8 124.7 351.1 137.2 351.1 152.1V190.3L402.2 140L379.6 100.6C374.7 91.99 375.4 81.21 381.3 73.34L429.3 9.429C437.3-1.207 452.1-3.169 462.5 5.047C472.8 13.26 474.7 28.55 466.7 39.18L428.5 90.06L452.4 131.8C457.9 141.5 456.3 153.8 448.5 161.6L407.7 202.5L560.6 226.4C605.1 232.3 640 272.7 640 320.6C640 405.2 542.4 447.6 485.4 387.8L351.1 266V266.3L418.5 352.7C421.9 357 423.7 362.3 423.7 367.8V422.5L465.7 471.6C474.4 481.6 473.5 497 463.7 505.9C453.9 514.8 438.9 513.8 430.3 503.8L430.3 503.8z',
			),
		),
		'label'             => __( 'Mosquito', 'astra' ),
		'custom_categories' => array(
			'environment',
			'lifestyle-and-hobbies',
		),
	),
	'mosquito-net'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M168.8 462.3C160.9 458.4 157.7 448.7 161.7 440.8L191.1 380.2V335.1C191.1 331.8 193.7 327.7 196.7 324.7L255.1 265.4V242.2L139.2 343.1C87.82 395.3 0 358.9 0 286.3C0 245.2 30.62 210.6 71.41 205.5L231.3 181.6L181.8 140.3C176.7 136.1 174.7 129.2 176.8 122.9L190.7 81.22L161.7 23.15C157.7 15.25 160.9 5.637 168.8 1.685C176.7-2.267 186.4 .9369 190.3 8.841L222.3 72.84C224.2 76.64 224.5 81.03 223.2 85.06L210.6 122.7L255.1 160.5V137.9C255.1 123.1 266.1 110.6 279.8 106.1V63.67C279.8 59.17 283.5 55.51 287.1 55.51C292.5 55.51 296.2 59.17 296.2 63.67V106.1C309.9 110.6 319.1 123.1 319.1 137.9V160.5L365.4 122.7L352.8 85.06C351.5 81.03 351.8 76.64 353.7 72.84L385.7 8.84C389.6 .9366 399.3-2.267 407.2 1.685C415.1 5.636 418.3 15.25 414.3 23.15L385.3 81.22L399.2 122.9C401.3 129.2 399.3 136.1 394.2 140.3L344.7 181.6L504.6 205.5C527 208.3 546.4 220 559.3 236.9C556.5 239.4 554.1 242.3 552 245.5C543.4 232.5 528.7 223.1 512 223.1C495.3 223.1 480.6 232.5 472 245.5C463.4 232.5 448.7 223.1 432 223.1C410.3 223.1 392 238.3 386.1 258.1C375.4 261.3 366.3 268.2 360.2 277.2L319.1 242.2V265.4L352.4 297.8C352.1 299.8 352 301.9 352 303.1C352 320.7 360.5 335.4 373.5 343.1C369.5 346.6 365.9 349.9 362.9 353.5L319.1 310.6V360.6C319.1 378.3 305.7 392.6 287.1 392.6C270.3 392.6 255.1 378.3 255.1 360.6V310.6L224 342.6V383.1C224 386.5 223.4 388.9 222.3 391.2L190.3 455.2C186.4 463.1 176.7 466.3 168.8 462.3V462.3zM512 255.1C520.8 255.1 528 263.2 528 271.1V287.1H576V271.1C576 263.2 583.2 255.1 592 255.1C600.8 255.1 608 263.2 608 271.1V287.1H624C632.8 287.1 640 295.2 640 303.1C640 312.8 632.8 319.1 624 319.1H608V367.1H624C632.8 367.1 640 375.2 640 383.1C640 392.8 632.8 399.1 624 399.1H608V447.1H624C632.8 447.1 640 455.2 640 463.1C640 472.8 632.8 479.1 624 479.1H608V495.1C608 504.8 600.8 511.1 592 511.1C583.2 511.1 576 504.8 576 495.1V479.1H528V495.1C528 504.8 520.8 511.1 512 511.1C503.2 511.1 496 504.8 496 495.1V479.1H448V495.1C448 504.8 440.8 511.1 432 511.1C423.2 511.1 416 504.8 416 495.1V479.1H400C391.2 479.1 384 472.8 384 463.1C384 455.2 391.2 447.1 400 447.1H416V399.1H400C391.2 399.1 384 392.8 384 383.1C384 375.2 391.2 367.1 400 367.1H416V319.1H400C391.2 319.1 384 312.8 384 303.1C384 295.2 391.2 287.1 400 287.1H416V271.1C416 263.2 423.2 255.1 432 255.1C440.8 255.1 448 263.2 448 271.1V287.1H496V271.1C496 263.2 503.2 255.1 512 255.1V255.1zM576 367.1V319.1H528V367.1H576zM576 447.1V399.1H528V447.1H576zM448 319.1V367.1H496V319.1H448zM448 399.1V447.1H496V399.1H448z',
			),
		),
		'label'             => __( 'Mosquito Net', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'motorcycle'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M342.5 32C357.2 32 370.7 40.05 377.6 52.98L391.7 78.93L439.1 39.42C444.9 34.62 452.1 32 459.6 32H480C497.7 32 512 46.33 512 64V96C512 113.7 497.7 128 480 128H418.2L473.3 229.1C485.5 226.1 498.5 224 512 224C582.7 224 640 281.3 640 352C640 422.7 582.7 480 512 480C441.3 480 384 422.7 384 352C384 311.1 402.4 276.3 431.1 252.8L415.7 224.2C376.1 253.4 352 299.8 352 352C352 362.1 353.1 373.7 355.2 384H284.8C286.9 373.7 287.1 362.1 287.1 352C287.1 263.6 216.4 192 127.1 192H31.1V160C31.1 142.3 46.33 128 63.1 128H165.5C182.5 128 198.7 134.7 210.7 146.7L255.1 192L354.1 110.3L337.7 80H279.1C266.7 80 255.1 69.25 255.1 56C255.1 42.75 266.7 32 279.1 32L342.5 32zM448 352C448 387.3 476.7 416 512 416C547.3 416 576 387.3 576 352C576 316.7 547.3 288 512 288C509.6 288 507.2 288.1 504.9 288.4L533.1 340.6C539.4 352.2 535.1 366.8 523.4 373.1C511.8 379.4 497.2 375.1 490.9 363.4L462.7 311.2C453.5 322.3 448 336.5 448 352V352zM253.8 376C242.5 435.2 190.5 480 128 480C57.31 480 0 422.7 0 352C0 281.3 57.31 224 128 224C190.5 224 242.5 268.8 253.8 328H187.3C177.9 304.5 154.9 288 128 288C92.65 288 64 316.7 64 352C64 387.3 92.65 416 128 416C154.9 416 177.9 399.5 187.3 376H253.8zM96 352C96 334.3 110.3 320 128 320C145.7 320 160 334.3 160 352C160 369.7 145.7 384 128 384C110.3 384 96 369.7 96 352z',
			),
		),
		'label'             => __( 'Motorcycle', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'mound'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M144.1 179.2C173.8 127.7 228.6 96 288 96C347.4 96 402.2 127.7 431.9 179.2L540.4 368C552.7 389.4 537.3 416 512.7 416H63.31C38.7 416 23.31 389.4 35.57 368L144.1 179.2z',
			),
		),
		'label'             => __( 'Mound', 'astra' ),
		'custom_categories' => array(
			'business',
			'environment',
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'mountain'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M503.2 393.8L280.1 44.25c-10.42-16.33-37.73-16.33-48.15 0L8.807 393.8c-11.11 17.41-11.75 39.42-1.666 57.45C17.07 468.1 35.92 480 56.31 480h399.4c20.39 0 39.24-11.03 49.18-28.77C514.9 433.2 514.3 411.2 503.2 393.8zM256 111.8L327.8 224H256L208 288L177.2 235.3L256 111.8z',
			),
		),
		'label'             => __( 'Mountain', 'astra' ),
		'custom_categories' => array(
			'environment',
			'lifestyle-and-hobbies',
		),
	),
	'mountain-city'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M432 0C458.5 0 480 21.49 480 48V192H520V120C520 106.7 530.7 96 544 96C557.3 96 568 106.7 568 120V192H592C618.5 192 640 213.5 640 240V464C640 490.5 618.5 512 592 512H470.2C470.7 511.2 471.2 510.5 471.6 509.7C483.2 488.6 482.8 462.9 470.3 442.4L396.5 320H400C408.8 320 416 312.8 416 304V272C416 263.2 408.8 256 400 256H368C364.8 256 361.9 256.9 359.4 258.5L288 140.1V48C288 21.49 309.5 0 336 0L432 0zM368 64C359.2 64 352 71.16 352 80V112C352 120.8 359.2 128 368 128H400C408.8 128 416 120.8 416 112V80C416 71.16 408.8 64 400 64H368zM352 208C352 216.8 359.2 224 368 224H400C408.8 224 416 216.8 416 208V176C416 167.2 408.8 160 400 160H368C359.2 160 352 167.2 352 176V208zM512 304C512 312.8 519.2 320 528 320H560C568.8 320 576 312.8 576 304V272C576 263.2 568.8 256 560 256H528C519.2 256 512 263.2 512 272V304zM528 352C519.2 352 512 359.2 512 368V400C512 408.8 519.2 416 528 416H560C568.8 416 576 408.8 576 400V368C576 359.2 568.8 352 560 352H528zM442.9 458.9C449.4 469.7 449.7 483.2 443.6 494.2C437.5 505.2 426 512 413.5 512H34.46C21.1 512 10.5 505.2 4.404 494.2C-1.693 483.2-1.444 469.7 5.056 458.9L194.6 144.7C200.9 134.3 211.1 128 224 128C236 128 247.1 134.3 253.4 144.7L442.9 458.9zM223.1 188.9L150.4 310.8L174.1 352L222.1 288H283.8L223.1 188.9z',
			),
		),
		'label'             => __( 'Mountain City', 'astra' ),
		'custom_categories' => array(
			'business',
			'environment',
			'travel',
		),
	),
	'mountain-sun'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M480 80C480 35.82 515.8 0 560 0C604.2 0 640 35.82 640 80C640 124.2 604.2 160 560 160C515.8 160 480 124.2 480 80zM0 456.1C0 445.6 2.964 435.3 8.551 426.4L225.3 81.01C231.9 70.42 243.5 64 256 64C268.5 64 280.1 70.42 286.8 81.01L412.7 281.7L460.9 202.7C464.1 196.1 472.2 192 480 192C487.8 192 495 196.1 499.1 202.7L631.1 419.1C636.9 428.6 640 439.7 640 450.9C640 484.6 612.6 512 578.9 512H55.91C25.03 512 .0006 486.1 .0006 456.1L0 456.1z',
			),
		),
		'label'             => __( 'Mountain Sun', 'astra' ),
		'custom_categories' => array(
			'environment',
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'mug-hot'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M400 192H32C14.25 192 0 206.3 0 224v192c0 53 43 96 96 96h192c53 0 96-43 96-96h16c61.75 0 112-50.25 112-112S461.8 192 400 192zM400 352H384V256h16C426.5 256 448 277.5 448 304S426.5 352 400 352zM107.9 100.7C120.3 107.1 128 121.4 128 136c0 13.25 10.75 23.89 24 23.89S176 148.1 176 135.7c0-31.34-16.83-60.64-43.91-76.45C119.7 52.03 112 38.63 112 24.28c0-13.25-10.75-24.14-24-24.14S64 11.03 64 24.28C64 55.63 80.83 84.92 107.9 100.7zM219.9 100.7C232.3 107.1 240 121.4 240 136c0 13.25 10.75 23.86 24 23.86S288 148.1 288 135.7c0-31.34-16.83-60.64-43.91-76.45C231.7 52.03 224 38.63 224 24.28c0-13.25-10.75-24.18-24-24.18S176 11.03 176 24.28C176 55.63 192.8 84.92 219.9 100.7z',
			),
		),
		'label'             => __( 'Mug Hot', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'mug-saucer'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M512 32H120c-13.25 0-24 10.75-24 24L96.01 288c0 53 43 96 96 96h192C437 384 480 341 480 288h32c70.63 0 128-57.38 128-128S582.6 32 512 32zM512 224h-32V96h32c35.25 0 64 28.75 64 64S547.3 224 512 224zM560 416h-544C7.164 416 0 423.2 0 432C0 458.5 21.49 480 48 480h480c26.51 0 48-21.49 48-48C576 423.2 568.8 416 560 416z',
			),
		),
		'label'             => __( 'Mug Saucer', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'music'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M511.1 367.1c0 44.18-42.98 80-95.1 80s-95.1-35.82-95.1-79.1c0-44.18 42.98-79.1 95.1-79.1c11.28 0 21.95 1.92 32.01 4.898V148.1L192 224l-.0023 208.1C191.1 476.2 149 512 95.1 512S0 476.2 0 432c0-44.18 42.98-79.1 95.1-79.1c11.28 0 21.95 1.92 32 4.898V126.5c0-12.97 10.06-26.63 22.41-30.52l319.1-94.49C472.1 .6615 477.3 0 480 0c17.66 0 31.97 14.34 32 31.99L511.1 367.1z',
			),
		),
		'label'             => __( 'Music', 'astra' ),
		'custom_categories' => array(
			'communication',
			'education',
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'n'                                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M384 64.01v384c0 13.47-8.438 25.5-21.09 30.09C359.3 479.4 355.7 480 352 480c-9.312 0-18.38-4.078-24.59-11.52L64 152.4v295.6c0 17.67-14.31 32-32 32s-32-14.33-32-32v-384c0-13.47 8.438-25.5 21.09-30.09c12.62-4.516 26.84-.75 35.5 9.609L320 359.6v-295.6c0-17.67 14.31-32 32-32S384 46.34 384 64.01z',
			),
		),
		'label'             => __( 'N', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'naira-sign'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M262.5 256H320V64C320 46.33 334.3 32 352 32C369.7 32 384 46.33 384 64V256H416C433.7 256 448 270.3 448 288C448 305.7 433.7 320 416 320H384V448C384 462.1 374.8 474.5 361.3 478.6C347.8 482.7 333.2 477.5 325.4 465.8L228.2 320H128V448C128 465.7 113.7 480 96 480C78.33 480 64 465.7 64 448V320H32C14.33 320 0 305.7 0 288C0 270.3 14.33 256 32 256H64V64C64 49.9 73.23 37.46 86.73 33.37C100.2 29.29 114.8 34.52 122.6 46.25L262.5 256zM305.1 320L320 342.3V320H305.1zM185.5 256L128 169.7V256H185.5z',
			),
		),
		'label'             => __( 'Naira Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'napster'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M298.3 373.6c-14.2 13.6-31.3 24.1-50.4 30.5-19-6.4-36.2-16.9-50.3-30.5h100.7zm44-199.6c20-16.9 43.6-29.2 69.6-36.2V299c0 219.4-328 217.6-328 .3V137.7c25.9 6.9 49.6 19.6 69.5 36.4 56.8-40 132.5-39.9 188.9-.1zm-208.8-58.5c64.4-60 164.3-60.1 228.9-.2-7.1 3.5-13.9 7.3-20.6 11.5-58.7-30.5-129.2-30.4-187.9 .1-6.3-4-13.9-8.2-20.4-11.4zM43.8 93.2v69.3c-58.4 36.5-58.4 121.1 .1 158.3 26.4 245.1 381.7 240.3 407.6 1.5l.3-1.7c58.7-36.3 58.9-121.7 .2-158.2V93.2c-17.3 .5-34 3-50.1 7.4-82-91.5-225.5-91.5-307.5 .1-16.3-4.4-33.1-7-50.6-7.5zM259.2 352s36-.3 61.3-1.5c10.2-.5 21.1-4 25.5-6.5 26.3-15.1 25.4-39.2 26.2-47.4-79.5-.6-99.9-3.9-113 55.4zm-135.5-55.3c.8 8.2-.1 32.3 26.2 47.4 4.4 2.5 15.2 6 25.5 6.5 25.3 1.1 61.3 1.5 61.3 1.5-13.2-59.4-33.7-56.1-113-55.4zm169.1 123.4c-3.2-5.3-6.9-7.3-6.9-7.3-24.8 7.3-52.2 6.9-75.9 0 0 0-2.9 1.5-6.4 6.6-2.8 4.1-3.7 9.6-3.7 9.6 29.1 17.6 67.1 17.6 96.2 0-.1-.1-.3-4-3.3-8.9z',
			),
		),
		'label'             => __( 'Napster', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'brands',
			'brands',
			'social',
		),
	),
	'neos'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M415.4 512h-95.11L212.1 357.5v91.1L125.7 512H28V29.82L68.47 0h108.1l123.7 176.1V63.45L386.7 0h97.69v461.5zM38.77 35.27V496l72-52.88V194l215.5 307.6h84.79l52.35-38.17h-78.27L69 13zm82.54 466.6l80-58.78v-101l-79.76-114.4v220.9L49 501.9h72.34zM80.63 10.77l310.6 442.6h82.37V10.77h-79.75v317.6L170.9 10.77zM311 191.6l72 102.8V15.93l-72 53v122.7z',
			),
		),
		'label'             => __( 'Neos', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'network-wired'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M400 0C426.5 0 448 21.49 448 48V144C448 170.5 426.5 192 400 192H352V224H608C625.7 224 640 238.3 640 256C640 273.7 625.7 288 608 288H512V320H560C586.5 320 608 341.5 608 368V464C608 490.5 586.5 512 560 512H400C373.5 512 352 490.5 352 464V368C352 341.5 373.5 320 400 320H448V288H192V320H240C266.5 320 288 341.5 288 368V464C288 490.5 266.5 512 240 512H80C53.49 512 32 490.5 32 464V368C32 341.5 53.49 320 80 320H128V288H32C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224H288V192H240C213.5 192 192 170.5 192 144V48C192 21.49 213.5 0 240 0H400zM256 64V128H384V64H256zM224 448V384H96V448H224zM416 384V448H544V384H416z',
			),
		),
		'label'             => __( 'Network Wired', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'neuter'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M368 176c0-97.2-78.8-176-176-176c-97.2 0-176 78.8-176 176c0 86.26 62.1 157.9 144 172.1V496C160 504.8 167.2 512 176 512h32c8.838 0 16-7.164 16-16v-147C305.9 333.9 368 262.3 368 176zM192 272c-52.93 0-96-43.07-96-96c0-52.94 43.07-95.1 96-95.1c52.94 0 96 43.06 96 95.1C288 228.9 244.9 272 192 272z',
			),
		),
		'label'             => __( 'Neuter', 'astra' ),
		'custom_categories' => array(),
	),
	'newspaper'                              => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 32H128C110.3 32 96 46.33 96 64v336C96 408.8 88.84 416 80 416S64 408.8 64 400V96H32C14.33 96 0 110.3 0 128v288c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V64C512 46.33 497.7 32 480 32zM272 416h-96C167.2 416 160 408.8 160 400C160 391.2 167.2 384 176 384h96c8.836 0 16 7.162 16 16C288 408.8 280.8 416 272 416zM272 320h-96C167.2 320 160 312.8 160 304C160 295.2 167.2 288 176 288h96C280.8 288 288 295.2 288 304C288 312.8 280.8 320 272 320zM432 416h-96c-8.836 0-16-7.164-16-16c0-8.838 7.164-16 16-16h96c8.836 0 16 7.162 16 16C448 408.8 440.8 416 432 416zM432 320h-96C327.2 320 320 312.8 320 304C320 295.2 327.2 288 336 288h96C440.8 288 448 295.2 448 304C448 312.8 440.8 320 432 320zM448 208C448 216.8 440.8 224 432 224h-256C167.2 224 160 216.8 160 208v-96C160 103.2 167.2 96 176 96h256C440.8 96 448 103.2 448 112V208z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M456 32h-304C121.1 32 96 57.13 96 88v320c0 13.22-10.77 24-24 24S48 421.2 48 408V112c0-13.25-10.75-24-24-24S0 98.75 0 112v296C0 447.7 32.3 480 72 480h352c48.53 0 88-39.47 88-88v-304C512 57.13 486.9 32 456 32zM464 392c0 22.06-17.94 40-40 40H139.9C142.5 424.5 144 416.4 144 408v-320c0-4.406 3.594-8 8-8h304c4.406 0 8 3.594 8 8V392zM264 272h-64C186.8 272 176 282.8 176 296S186.8 320 200 320h64C277.3 320 288 309.3 288 296S277.3 272 264 272zM408 272h-64C330.8 272 320 282.8 320 296S330.8 320 344 320h64c13.25 0 24-10.75 24-24S421.3 272 408 272zM264 352h-64c-13.25 0-24 10.75-24 24s10.75 24 24 24h64c13.25 0 24-10.75 24-24S277.3 352 264 352zM408 352h-64C330.8 352 320 362.8 320 376s10.75 24 24 24h64c13.25 0 24-10.75 24-24S421.3 352 408 352zM400 112h-192c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32v-64C432 126.3 417.7 112 400 112z',
			),
		),
		'label'             => __( 'Newspaper', 'astra' ),
		'custom_categories' => array(
			'communication',
			'travel',
		),
	),
	'nfc-directional'                        => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M211.8 488.6C213.4 491.1 213.9 494.2 213.2 497.1C212.6 500 210.8 502.6 208.3 504.2C205.7 505.8 202.7 506.3 199.7 505.7C138.3 491.8 84.1 455.8 47.53 404.5C10.97 353.2-5.395 290.3 1.57 227.7C8.536 165 38.34 107.2 85.29 65.21C132.2 23.2 193-.0131 256 0C257.5 0 258.1 .2931 260.3 .8627C261.7 1.432 262.1 2.267 264 3.319C265.1 4.371 265.9 5.619 266.5 6.993C267 8.367 267.3 9.839 267.3 11.32V112.3L291.8 86.39C292.8 85.31 294 84.44 295.4 83.84C296.7 83.23 298.2 82.9 299.7 82.86C301.2 82.81 302.6 83.06 304 83.59C305.4 84.12 306.7 84.92 307.8 85.94C308.8 86.96 309.7 88.18 310.3 89.54C310.9 90.89 311.3 92.35 311.3 93.84C311.3 95.32 311.1 96.8 310.6 98.18C310 99.57 309.2 100.8 308.2 101.9L264.2 148.5C263.1 149.6 261.9 150.5 260.5 151.1C259 151.7 257.5 152 255.1 152C254.5 152 252.9 151.7 251.5 151.1C250.1 150.5 248.8 149.6 247.8 148.5L203.7 101.9C201.7 99.74 200.6 96.83 200.7 93.84C200.7 90.84 202 87.1 204.2 85.94C206.4 83.88 209.3 82.77 212.3 82.86C215.3 82.94 218.1 84.21 220.2 86.39L244.7 112.4V22.89C188.3 25.64 134.9 48.73 94.23 87.87C53.58 127 28.49 179.6 23.61 235.8C18.73 292 34.38 348.1 67.68 393.7C100.1 439.2 149.7 471.2 204.7 483.6C207.6 484.3 210.2 486.1 211.8 488.6L211.8 488.6zM171.4 126.1C170.6 127.4 169.5 128.5 168.3 129.3C147.8 143.2 131.1 161.9 119.5 183.8C107.9 205.7 101.8 230.1 101.8 254.9C101.8 279.7 107.9 304.1 119.5 325.1C131.1 347.9 147.8 366.6 168.3 380.5C170.8 382.2 172.5 384.8 173 387.8C173.6 390.7 172.1 393.8 171.3 396.2C169.6 398.7 166.1 400.4 164 400.1C161.1 401.5 158 400.9 155.6 399.2C132 383.2 112.8 361.7 99.46 336.5C86.15 311.4 79.19 283.4 79.19 254.9C79.19 226.5 86.15 198.4 99.46 173.3C112.8 148.1 132 126.6 155.6 110.6C156.8 109.8 158.2 109.2 159.6 108.8C161.1 108.5 162.6 108.5 164.1 108.8C165.5 109 166.9 109.6 168.2 110.4C169.5 111.2 170.5 112.3 171.4 113.5C172.2 114.7 172.8 116.1 173.1 117.6C173.4 119.1 173.4 120.6 173.1 122C172.8 123.5 172.3 124.9 171.4 126.1H171.4zM340.9 383.5C341.7 382.3 342.8 381.2 343.1 380.4V380.3C364.4 366.3 381.1 347.6 392.7 325.7C404.2 303.9 410.2 279.5 410.2 254.8C410.2 230.1 404.2 205.7 392.7 183.8C381.1 161.1 364.4 143.3 343.1 129.3C342.8 128.5 341.7 127.4 340.9 126.2C340.1 124.9 339.5 123.5 339.3 122.1C338.1 120.6 339 119.1 339.3 117.7C339.6 116.2 340.2 114.8 341 113.6C341.9 112.4 342.1 111.3 344.2 110.5C345.4 109.7 346.8 109.2 348.3 108.9C349.8 108.6 351.2 108.6 352.7 108.9C354.2 109.2 355.5 109.8 356.8 110.7C380.2 126.7 399.5 148.2 412.7 173.3C426 198.4 432.1 226.4 432.1 254.8C432.1 283.3 426 311.3 412.7 336.4C399.5 361.5 380.2 383 356.8 399C355.5 399.9 354.2 400.5 352.7 400.8C351.2 401.1 349.8 401.1 348.3 400.8C346.8 400.5 345.4 399.1 344.2 399.2C342.1 398.4 341.9 397.3 341 396.1C340.2 394.9 339.6 393.5 339.3 392C339 390.6 338.1 389.1 339.3 387.6C339.5 386.2 340.1 384.8 340.9 383.5V383.5zM312.3 6.307C368.5 19.04 418.7 50.28 455 95.01C485.4 132.6 504.6 178 510.3 226C515.9 274 507.9 322.7 487.1 366.3C466.2 409.9 433.5 446.8 392.6 472.6C351.7 498.3 304.4 512 256 512C254.5 512 253.1 511.7 251.7 511.1C250.3 510.6 249.1 509.7 248 508.7C246.1 507.6 246.1 506.4 245.6 505C245 503.6 244.7 502.2 244.7 500.7V401.5L220.2 427.5C218.1 429.7 215.3 430.1 212.3 431.1C209.3 431.2 206.4 430 204.2 427.1C202 425.9 200.7 423.1 200.7 420.1C200.6 417.1 201.7 414.2 203.7 412L247.8 365.4C249.1 363.2 252.9 362 255.1 362C259.1 362 262 363.2 264.2 365.4L308.2 412C310.3 414.2 311.4 417.1 311.3 420.1C311.2 423.1 309.9 425.9 307.8 427.1C305.6 430 302.7 431.2 299.7 431.1C296.7 430.1 293.8 429.7 291.8 427.5L267.3 401.6V489.1C323.7 486.3 377.1 463.3 417.8 424.1C458.5 384.1 483.6 332.4 488.5 276.2C493.3 219.1 477.7 163.9 444.4 118.3C411.1 72.75 362.4 40.79 307.4 28.36C305.9 28.03 304.6 27.42 303.3 26.57C302.1 25.71 301.1 24.63 300.3 23.37C299.5 22.12 298.1 20.72 298.7 19.26C298.5 17.8 298.5 16.3 298.8 14.85C299.2 13.41 299.8 12.04 300.6 10.82C301.5 9.61 302.6 8.577 303.8 7.784C305.1 6.99 306.5 6.451 307.9 6.198C309.4 5.945 310.9 5.982 312.3 6.307L312.3 6.307zM353.1 256.1C353.1 287.5 335.6 317.2 303.8 339.6C301.7 341.1 299 341.9 296.4 341.6C293.7 341.4 291.2 340.3 289.4 338.4L219.3 268.6C217.1 266.5 215.1 263.6 215.9 260.6C215.9 257.6 217.1 254.7 219.2 252.6C221.4 250.5 224.2 249.3 227.2 249.3C230.2 249.3 233.1 250.5 235.2 252.6L298.3 315.4C319.1 298.3 330.5 277.5 330.5 256.1C330.5 232.2 316.4 209.1 290.8 191C288.3 189.3 286.7 186.7 286.2 183.7C285.7 180.8 286.3 177.7 288.1 175.3C289.8 172.8 292.4 171.2 295.4 170.7C298.3 170.2 301.4 170.8 303.8 172.6C335.6 195 353.1 224.7 353.1 256.1V256.1zM216.7 341.5C213.7 342 210.7 341.3 208.2 339.6C176.5 317.2 158.1 287.5 158.1 256.1C158.1 224.7 176.5 195 208.2 172.6C210.4 171 213.1 170.3 215.7 170.5C218.4 170.8 220.8 171.9 222.7 173.8L292.8 243.6C294.9 245.7 296.1 248.6 296.1 251.6C296.1 254.6 294.1 257.4 292.8 259.6C290.7 261.7 287.8 262.9 284.9 262.9C281.9 262.9 278.1 261.7 276.9 259.6L213.8 196.7C192.9 214 181.6 234.7 181.6 256.1C181.6 279.1 195.7 303.1 221.3 321.1C223.7 322.9 225.4 325.5 225.9 328.5C226.4 331.4 225.7 334.4 224 336.9C222.3 339.3 219.6 341 216.7 341.5L216.7 341.5z',
			),
		),
		'label'             => __( 'NFC Directional', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'brands',
			'brands',
			'social',
		),
	),
	'nfc-symbol'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M392.9 32.43C400.6 31.1 408.6 32.89 414.1 37.41C498.2 96.14 544 173.7 544 255.1C544 338.2 498.2 415.9 414.1 474.6C409.3 478.6 402.4 480.5 395.5 479.9C388.5 479.3 382 476.3 377.1 471.4L193.7 288.7C188.1 283.2 185 275.7 184.1 267.8C184.1 260 188.1 252.5 193.6 246.9C199.2 241.4 206.7 238.2 214.5 238.2C222.4 238.2 229.9 241.3 235.4 246.8L400.5 411.2C455.1 366.5 484.8 312 484.8 255.1C484.8 193.5 447.9 132.9 380.9 85.76C374.5 81.24 370.1 74.35 368.8 66.62C367.4 58.89 369.2 50.94 373.8 44.53C378.3 38.12 385.2 33.77 392.9 32.43V32.43zM186.9 479.6C179.2 480.9 171.3 479.1 164.8 474.6C81.67 415.9 35.84 338.2 35.84 255.1C35.84 173.7 81.67 96.14 164.8 37.41C170.5 33.4 177.4 31.53 184.4 32.12C191.3 32.71 197.8 35.72 202.7 40.63L386.1 223.3C391.7 228.8 394.8 236.3 394.8 244.2C394.9 251.1 391.8 259.5 386.2 265.1C380.7 270.6 373.2 273.8 365.3 273.8C357.5 273.8 349.1 270.7 344.4 265.2L179.3 100.7C124.7 145.9 95.03 199.9 95.03 255.1C95.03 318.5 131.9 379.1 198.1 426.2C205.4 430.8 209.7 437.6 211.1 445.4C212.4 453.1 210.6 461.1 206.1 467.5C201.6 473.9 194.7 478.2 186.9 479.6V479.6z',
			),
		),
		'label'             => __( 'Nfc Symbol', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'brands',
			'brands',
			'social',
		),
	),
	'nimblr'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M246.6 299.3c15.57 0 27.15 11.46 27.15 27s-11.62 27-27.15 27c-15.7 0-27.15-11.57-27.15-27s11.55-27 27.15-27zM113 326.3c0-15.61 11.68-27 27.15-27s27.15 11.46 27.15 27-11.47 27-27.15 27c-15.44 0-27.15-11.31-27.15-27M191.8 159C157 159 89.45 178.8 59.25 227L14 0v335.5C14 433.1 93.61 512 191.8 512s177.8-78.95 177.8-176.5S290.1 159 191.8 159zm0 308.1c-73.27 0-132.5-58.9-132.5-131.6s59.24-131.6 132.5-131.6 132.5 58.86 132.5 131.5S265 467.1 191.8 467.1z',
			),
		),
		'label'             => __( 'Nimblr', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'node'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M316.3 452c-2.1 0-4.2-.6-6.1-1.6L291 439c-2.9-1.6-1.5-2.2-.5-2.5 3.8-1.3 4.6-1.6 8.7-4 .4-.2 1-.1 1.4 .1l14.8 8.8c.5 .3 1.3 .3 1.8 0L375 408c.5-.3 .9-.9 .9-1.6v-66.7c0-.7-.3-1.3-.9-1.6l-57.8-33.3c-.5-.3-1.2-.3-1.8 0l-57.8 33.3c-.6 .3-.9 1-.9 1.6v66.7c0 .6 .4 1.2 .9 1.5l15.8 9.1c8.6 4.3 13.9-.8 13.9-5.8v-65.9c0-.9 .7-1.7 1.7-1.7h7.3c.9 0 1.7 .7 1.7 1.7v65.9c0 11.5-6.2 18-17.1 18-3.3 0-6 0-13.3-3.6l-15.2-8.7c-3.7-2.2-6.1-6.2-6.1-10.5v-66.7c0-4.3 2.3-8.4 6.1-10.5l57.8-33.4c3.7-2.1 8.5-2.1 12.1 0l57.8 33.4c3.7 2.2 6.1 6.2 6.1 10.5v66.7c0 4.3-2.3 8.4-6.1 10.5l-57.8 33.4c-1.7 1.1-3.8 1.7-6 1.7zm46.7-65.8c0-12.5-8.4-15.8-26.2-18.2-18-2.4-19.8-3.6-19.8-7.8 0-3.5 1.5-8.1 14.8-8.1 11.9 0 16.3 2.6 18.1 10.6 .2 .8 .8 1.3 1.6 1.3h7.5c.5 0 .9-.2 1.2-.5 .3-.4 .5-.8 .4-1.3-1.2-13.8-10.3-20.2-28.8-20.2-16.5 0-26.3 7-26.3 18.6 0 12.7 9.8 16.1 25.6 17.7 18.9 1.9 20.4 4.6 20.4 8.3 0 6.5-5.2 9.2-17.4 9.2-15.3 0-18.7-3.8-19.8-11.4-.1-.8-.8-1.4-1.7-1.4h-7.5c-.9 0-1.7 .7-1.7 1.7 0 9.7 5.3 21.3 30.6 21.3 18.5 0 29-7.2 29-19.8zm54.5-50.1c0 6.1-5 11.1-11.1 11.1s-11.1-5-11.1-11.1c0-6.3 5.2-11.1 11.1-11.1 6-.1 11.1 4.8 11.1 11.1zm-1.8 0c0-5.2-4.2-9.3-9.4-9.3-5.1 0-9.3 4.1-9.3 9.3 0 5.2 4.2 9.4 9.3 9.4 5.2-.1 9.4-4.3 9.4-9.4zm-4.5 6.2h-2.6c-.1-.6-.5-3.8-.5-3.9-.2-.7-.4-1.1-1.3-1.1h-2.2v5h-2.4v-12.5h4.3c1.5 0 4.4 0 4.4 3.3 0 2.3-1.5 2.8-2.4 3.1 1.7 .1 1.8 1.2 2.1 2.8 .1 1 .3 2.7 .6 3.3zm-2.8-8.8c0-1.7-1.2-1.7-1.8-1.7h-2v3.5h1.9c1.6 0 1.9-1.1 1.9-1.8zM137.3 191c0-2.7-1.4-5.1-3.7-6.4l-61.3-35.3c-1-.6-2.2-.9-3.4-1h-.6c-1.2 0-2.3 .4-3.4 1L3.7 184.6C1.4 185.9 0 188.4 0 191l.1 95c0 1.3 .7 2.5 1.8 3.2 1.1 .7 2.5 .7 3.7 0L42 268.3c2.3-1.4 3.7-3.8 3.7-6.4v-44.4c0-2.6 1.4-5.1 3.7-6.4l15.5-8.9c1.2-.7 2.4-1 3.7-1 1.3 0 2.6 .3 3.7 1l15.5 8.9c2.3 1.3 3.7 3.8 3.7 6.4v44.4c0 2.6 1.4 5.1 3.7 6.4l36.4 20.9c1.1 .7 2.6 .7 3.7 0 1.1-.6 1.8-1.9 1.8-3.2l.2-95zM472.5 87.3v176.4c0 2.6-1.4 5.1-3.7 6.4l-61.3 35.4c-2.3 1.3-5.1 1.3-7.4 0l-61.3-35.4c-2.3-1.3-3.7-3.8-3.7-6.4v-70.8c0-2.6 1.4-5.1 3.7-6.4l61.3-35.4c2.3-1.3 5.1-1.3 7.4 0l15.3 8.8c1.7 1 3.9-.3 3.9-2.2v-94c0-2.8 3-4.6 5.5-3.2l36.5 20.4c2.3 1.2 3.8 3.7 3.8 6.4zm-46 128.9c0-.7-.4-1.3-.9-1.6l-21-12.2c-.6-.3-1.3-.3-1.9 0l-21 12.2c-.6 .3-.9 .9-.9 1.6v24.3c0 .7 .4 1.3 .9 1.6l21 12.1c.6 .3 1.3 .3 1.8 0l21-12.1c.6-.3 .9-.9 .9-1.6v-24.3zm209.8-.7c2.3-1.3 3.7-3.8 3.7-6.4V192c0-2.6-1.4-5.1-3.7-6.4l-60.9-35.4c-2.3-1.3-5.1-1.3-7.4 0l-61.3 35.4c-2.3 1.3-3.7 3.8-3.7 6.4v70.8c0 2.7 1.4 5.1 3.7 6.4l60.9 34.7c2.2 1.3 5 1.3 7.3 0l36.8-20.5c2.5-1.4 2.5-5 0-6.4L550 241.6c-1.2-.7-1.9-1.9-1.9-3.2v-22.2c0-1.3 .7-2.5 1.9-3.2l19.2-11.1c1.1-.7 2.6-.7 3.7 0l19.2 11.1c1.1 .7 1.9 1.9 1.9 3.2v17.4c0 2.8 3.1 4.6 5.6 3.2l36.7-21.3zM559 219c-.4 .3-.7 .7-.7 1.2v13.6c0 .5 .3 1 .7 1.2l11.8 6.8c.4 .3 1 .3 1.4 0L584 235c.4-.3 .7-.7 .7-1.2v-13.6c0-.5-.3-1-.7-1.2l-11.8-6.8c-.4-.3-1-.3-1.4 0L559 219zm-254.2 43.5v-70.4c0-2.6-1.6-5.1-3.9-6.4l-61.1-35.2c-2.1-1.2-5-1.4-7.4 0l-61.1 35.2c-2.3 1.3-3.9 3.7-3.9 6.4v70.4c0 2.8 1.9 5.2 4 6.4l61.2 35.2c2.4 1.4 5.2 1.3 7.4 0l61-35.2c1.8-1 3.1-2.7 3.6-4.7 .1-.5 .2-1.1 .2-1.7zm-74.3-124.9l-.8 .5h1.1l-.3-.5zm76.2 130.2l-.4-.7v.9l.4-.2z',
			),
		),
		'label'             => __( 'Node.js', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'node-js'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M224 508c-6.7 0-13.5-1.8-19.4-5.2l-61.7-36.5c-9.2-5.2-4.7-7-1.7-8 12.3-4.3 14.8-5.2 27.9-12.7 1.4-.8 3.2-.5 4.6 .4l47.4 28.1c1.7 1 4.1 1 5.7 0l184.7-106.6c1.7-1 2.8-3 2.8-5V149.3c0-2.1-1.1-4-2.9-5.1L226.8 37.7c-1.7-1-4-1-5.7 0L36.6 144.3c-1.8 1-2.9 3-2.9 5.1v213.1c0 2 1.1 4 2.9 4.9l50.6 29.2c27.5 13.7 44.3-2.4 44.3-18.7V167.5c0-3 2.4-5.3 5.4-5.3h23.4c2.9 0 5.4 2.3 5.4 5.3V378c0 36.6-20 57.6-54.7 57.6-10.7 0-19.1 0-42.5-11.6l-48.4-27.9C8.1 389.2 .7 376.3 .7 362.4V149.3c0-13.8 7.4-26.8 19.4-33.7L204.6 9c11.7-6.6 27.2-6.6 38.8 0l184.7 106.7c12 6.9 19.4 19.8 19.4 33.7v213.1c0 13.8-7.4 26.7-19.4 33.7L243.4 502.8c-5.9 3.4-12.6 5.2-19.4 5.2zm149.1-210.1c0-39.9-27-50.5-83.7-58-57.4-7.6-63.2-11.5-63.2-24.9 0-11.1 4.9-25.9 47.4-25.9 37.9 0 51.9 8.2 57.7 33.8 .5 2.4 2.7 4.2 5.2 4.2h24c1.5 0 2.9-.6 3.9-1.7s1.5-2.6 1.4-4.1c-3.7-44.1-33-64.6-92.2-64.6-52.7 0-84.1 22.2-84.1 59.5 0 40.4 31.3 51.6 81.8 56.6 60.5 5.9 65.2 14.8 65.2 26.7 0 20.6-16.6 29.4-55.5 29.4-48.9 0-59.6-12.3-63.2-36.6-.4-2.6-2.6-4.5-5.3-4.5h-23.9c-3 0-5.3 2.4-5.3 5.3 0 31.1 16.9 68.2 97.8 68.2 58.4-.1 92-23.2 92-63.4z',
			),
		),
		'label'             => __( 'Node.js JS', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'not-equal'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M432 336c0 17.69-14.31 32.01-32 32.01H187.8l-65.15 97.74C116.5 474.1 106.3 480 95.97 480c-6.094 0-12.25-1.75-17.72-5.375c-14.72-9.812-18.69-29.66-8.875-44.38l41.49-62.23H48c-17.69 0-32-14.32-32-32.01s14.31-31.99 32-31.99h105.5l63.1-96H48c-17.69 0-32-14.32-32-32.01s14.31-31.99 32-31.99h212.2l65.18-97.77c9.781-14.69 29.62-18.66 44.37-8.875c14.72 9.812 18.69 29.66 8.875 44.38l-41.51 62.27H400c17.69 0 32 14.31 32 31.99s-14.31 32.01-32 32.01h-105.6l-63.1 96H400C417.7 304 432 318.3 432 336z',
			),
		),
		'label'             => __( 'Not Equal', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'note-sticky'                            => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 32h-352C21.49 32 0 53.49 0 80v352C0 458.5 21.49 480 48 480h245.5c16.97 0 33.25-6.744 45.26-18.75l90.51-90.51C441.3 358.7 448 342.5 448 325.5V80C448 53.49 426.5 32 400 32zM64 96h320l-.001 224H320c-17.67 0-32 14.33-32 32v64H64V96z',
			),
			'regular' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M384 32H64.01C28.66 32 .0085 60.65 .0065 96L0 415.1C-.002 451.3 28.65 480 64 480h232.1c25.46 0 49.88-10.12 67.89-28.12l55.88-55.89C437.9 377.1 448 353.6 448 328.1V96C448 60.8 419.2 32 384 32zM52.69 427.3C50.94 425.6 48 421.8 48 416l.0195-319.1C48.02 87.18 55.2 80 64.02 80H384c8.674 0 16 7.328 16 16v192h-88C281.1 288 256 313.1 256 344v88H64C58.23 432 54.44 429.1 52.69 427.3zM330.1 417.9C322.9 425.1 313.8 429.6 304 431.2V344c0-4.406 3.594-8 8-8h87.23c-1.617 9.812-6.115 18.88-13.29 26.05L330.1 417.9z',
			),
		),
		'label'             => __( 'Note Sticky', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
		),
	),
	'notes-medical'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 144V384l-96 96H144C117.5 480 96 458.5 96 432v-288C96 117.5 117.5 96 144 96h288C458.5 96 480 117.5 480 144zM384 264C384 259.6 380.4 256 376 256H320V200C320 195.6 316.4 192 312 192h-48C259.6 192 256 195.6 256 200V256H200C195.6 256 192 259.6 192 264v48C192 316.4 195.6 320 200 320H256v56c0 4.375 3.625 8 8 8h48c4.375 0 8-3.625 8-8V320h56C380.4 320 384 316.4 384 312V264zM0 360v-240C0 53.83 53.83 0 120 0h240C373.3 0 384 10.75 384 24S373.3 48 360 48h-240C80.3 48 48 80.3 48 120v240C48 373.3 37.25 384 24 384S0 373.3 0 360z',
			),
		),
		'label'             => __( 'Notes Medical', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'npm'                                    => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M288 288h-32v-64h32v64zm288-128v192H288v32H160v-32H0V160h576zm-416 32H32v128h64v-96h32v96h32V192zm160 0H192v160h64v-32h64V192zm224 0H352v128h64v-96h32v96h32v-96h32v96h32V192z',
			),
		),
		'label'             => __( 'npm', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'ns8'                                    => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M104.3 269.2h26.07V242.1H104.3zm52.47-26.18-.055-26.18v-.941a39.33 39.33 0 0 0 -78.64 .941v.166h26.4v-.166a12.98 12.98 0 0 1 25.96 0v26.18zm52.36 25.85a91.1 91.1 0 0 1 -91.1 91.1h-.609a91.1 91.1 0 0 1 -91.1-91.1H0v.166A117.3 117.3 0 0 0 117.4 386.3h.775A117.3 117.3 0 0 0 235.5 268.8V242.8H209.1zm-157.2 0a65.36 65.36 0 0 0 130.7 0H156.3a39.02 39.02 0 0 1 -78.04 0V242.9H51.97v-26.62A65.42 65.42 0 0 1 182.8 217.5v25.29h26.34V217.5a91.76 91.76 0 0 0 -183.5 0v25.4H51.91zm418.4-71.17c13.67 0 24.57 6.642 30.05 18.26l.719 1.549 23.25-11.51-.609-1.439c-8.025-19.26-28.5-31.27-53.41-31.27-23.13 0-43.61 11.4-50.97 28.45-.123 26.88-.158 23.9 0 24.85 4.7 11.01 14.56 19.37 28.67 24.24a102 102 0 0 0 19.81 3.984c5.479 .72 10.63 1.384 15.83 3.1 6.364 2.1 10.46 5.257 12.84 9.851v9.851c-3.708 7.527-13.78 12.34-25.79 12.34-14.33 0-25.96-6.918-31.93-19.04l-.72-1.494L415 280.9l.553 1.439c7.915 19.43 29.61 32.04 55.29 32.04 23.63 0 44.61-11.4 52.3-28.45l.166-25.9-.166-.664c-4.87-11.01-15.22-19.65-28.94-24.24-7.693-2.712-14.34-3.6-20.7-4.427a83.78 83.78 0 0 1 -14.83-2.878c-6.31-1.937-10.4-5.092-12.62-9.63v-8.412C449.5 202.4 458.1 197.7 470.3 197.7zM287.6 311.3h26.07v-68.4H287.6zm352.3-53.3c-2.933-6.254-8.3-12.01-15.44-16.71A37.99 37.99 0 0 0 637.4 226l.166-25.35-.166-.664C630 184 610.7 173.3 589.3 173.3S548.5 184 541.1 199.1l-.166 25.35 .166 .664a39.64 39.64 0 0 0 13.01 15.33c-7.2 4.7-12.51 10.46-15.44 16.71l-.166 28.89 .166 .72c7.582 15.99 27.89 26.73 50.58 26.73s43.06-10.74 50.58-26.73l.166-28.89zm-73.22-50.81c3.6-6.31 12.56-10.52 22.58-10.52s19.04 4.206 22.64 10.52v13.73c-3.542 6.2-12.56 10.35-22.64 10.35s-19.09-4.15-22.58-10.35zm47.32 72.17c-3.764 6.641-13.34 10.9-24.68 10.9-11.13 0-20.98-4.372-24.68-10.9V263.3c3.708-6.309 13.5-10.52 24.68-10.52 11.35 0 20.92 4.15 24.68 10.52zM376.4 265.1l-59.83-89.71h-29v40.62h26.51v.387l62.54 94.08H402.3V176.2H376.4z',
			),
		),
		'label'             => __( 'NS8', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'nutritionix'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 400,
				'height' => 512,
				'path'   => 'M88 8.1S221.4-.1 209 112.5c0 0 19.1-74.9 103-40.6 0 0-17.7 74-88 56 0 0 14.6-54.6 66.1-56.6 0 0-39.9-10.3-82.1 48.8 0 0-19.8-94.5-93.6-99.7 0 0 75.2 19.4 77.6 107.5 0 .1-106.4 7-104-119.8zm312 315.6c0 48.5-9.7 95.3-32 132.3-42.2 30.9-105 48-168 48-62.9 0-125.8-17.1-168-48C9.7 419 0 372.2 0 323.7 0 275.3 17.7 229 40 192c42.2-30.9 97.1-48.6 160-48.6 63 0 117.8 17.6 160 48.6 22.3 37 40 83.3 40 131.7zM120 428c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zm0-66.2c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zm0-66.2c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zM192 428c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zm0-66.2c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zm0-66.2c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zM264 428c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zm0-66.2c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zm0-66.2c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zM336 428c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zm0-66.2c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zm0-66.2c0-15.5-12.5-28-28-28s-28 12.5-28 28 12.5 28 28 28 28-12.5 28-28zm24-39.6c-4.8-22.3-7.4-36.9-16-56-38.8-19.9-90.5-32-144-32S94.8 180.1 56 200c-8.8 19.5-11.2 33.9-16 56 42.2-7.9 98.7-14.8 160-14.8s117.8 6.9 160 14.8z',
			),
		),
		'label'             => __( 'Nutritionix', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'o'                                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M224 32.01c-123.5 0-224 100.5-224 224s100.5 224 224 224s224-100.5 224-224S347.5 32.01 224 32.01zM224 416c-88.22 0-160-71.78-160-160s71.78-159.1 160-159.1s160 71.78 160 159.1S312.2 416 224 416z',
			),
		),
		'label'             => __( 'O', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'object-group'                           => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M128 160C128 142.3 142.3 128 160 128H288C305.7 128 320 142.3 320 160V256C320 273.7 305.7 288 288 288H160C142.3 288 128 273.7 128 256V160zM288 320C323.3 320 352 291.3 352 256V224H416C433.7 224 448 238.3 448 256V352C448 369.7 433.7 384 416 384H288C270.3 384 256 369.7 256 352V320H288zM32 119.4C12.87 108.4 0 87.69 0 64C0 28.65 28.65 0 64 0C87.69 0 108.4 12.87 119.4 32H456.6C467.6 12.87 488.3 0 512 0C547.3 0 576 28.65 576 64C576 87.69 563.1 108.4 544 119.4V392.6C563.1 403.6 576 424.3 576 448C576 483.3 547.3 512 512 512C488.3 512 467.6 499.1 456.6 480H119.4C108.4 499.1 87.69 512 64 512C28.65 512 0 483.3 0 448C0 424.3 12.87 403.6 32 392.6V119.4zM119.4 96C113.8 105.7 105.7 113.8 96 119.4V392.6C105.7 398.2 113.8 406.3 119.4 416H456.6C462.2 406.3 470.3 398.2 480 392.6V119.4C470.3 113.8 462.2 105.7 456.6 96H119.4z',
			),
			'regular' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M128 160C128 142.3 142.3 128 160 128H288C305.7 128 320 142.3 320 160V256C320 273.7 305.7 288 288 288H160C142.3 288 128 273.7 128 256V160zM288 320C323.3 320 352 291.3 352 256V224H416C433.7 224 448 238.3 448 256V352C448 369.7 433.7 384 416 384H288C270.3 384 256 369.7 256 352V320H288zM48 115.8C38.18 106.1 32 94.22 32 80C32 53.49 53.49 32 80 32C94.22 32 106.1 38.18 115.8 48H460.2C469 38.18 481.8 32 496 32C522.5 32 544 53.49 544 80C544 94.22 537.8 106.1 528 115.8V396.2C537.8 405 544 417.8 544 432C544 458.5 522.5 480 496 480C481.8 480 469 473.8 460.2 464H115.8C106.1 473.8 94.22 480 80 480C53.49 480 32 458.5 32 432C32 417.8 38.18 405 48 396.2V115.8zM96 125.3V386.7C109.6 391.6 120.4 402.4 125.3 416H450.7C455.6 402.4 466.4 391.6 480 386.7V125.3C466.4 120.4 455.6 109.6 450.7 96H125.3C120.4 109.6 109.6 120.4 96 125.3z',
			),
		),
		'label'             => __( 'Object Group', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'object-ungroup'                         => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M32 119.4C12.87 108.4 0 87.69 0 64C0 28.65 28.65 0 64 0C87.69 0 108.4 12.87 119.4 32H328.6C339.6 12.87 360.3 0 384 0C419.3 0 448 28.65 448 64C448 87.69 435.1 108.4 416 119.4V232.6C435.1 243.6 448 264.3 448 288C448 323.3 419.3 352 384 352C360.3 352 339.6 339.1 328.6 320H119.4C108.4 339.1 87.69 352 64 352C28.65 352 0 323.3 0 288C0 264.3 12.87 243.6 32 232.6V119.4zM96 119.4V232.6C105.7 238.2 113.8 246.3 119.4 256H328.6C334.2 246.3 342.3 238.2 352 232.6V119.4C342.3 113.8 334.2 105.7 328.6 96H119.4C113.8 105.7 105.7 113.8 96 119.4V119.4zM311.4 480C300.4 499.1 279.7 512 256 512C220.7 512 192 483.3 192 448C192 424.3 204.9 403.6 224 392.6V352H288V392.6C297.7 398.2 305.8 406.3 311.4 416H520.6C526.2 406.3 534.3 398.2 544 392.6V279.4C534.3 273.8 526.2 265.7 520.6 255.1H474.5C469.1 240.6 459.9 227.1 448 216.4V191.1H520.6C531.6 172.9 552.3 159.1 576 159.1C611.3 159.1 640 188.7 640 223.1C640 247.7 627.1 268.4 608 279.4V392.6C627.1 403.6 640 424.3 640 448C640 483.3 611.3 512 576 512C552.3 512 531.6 499.1 520.6 480H311.4z',
			),
			'regular' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M64 0C90.86 0 113.9 16.55 123.3 40H324.7C334.1 16.55 357.1 0 384 0C419.3 0 448 28.65 448 64C448 90.86 431.5 113.9 408 123.3V228.7C431.5 238.1 448 261.1 448 288C448 323.3 419.3 352 384 352C357.1 352 334.1 335.5 324.7 312H123.3C113.9 335.5 90.86 352 64 352C28.65 352 0 323.3 0 288C0 261.1 16.55 238.1 40 228.7V123.3C16.55 113.9 0 90.86 0 64C0 28.65 28.65 0 64 0V0zM64 80C72.84 80 80 72.84 80 64C80 56.1 74.28 49.54 66.75 48.24C65.86 48.08 64.94 48 64 48C55.16 48 48 55.16 48 64C48 64.07 48 64.14 48 64.21C48.01 65.07 48.09 65.92 48.24 66.75C49.54 74.28 56.1 80 64 80zM384 48C383.1 48 382.1 48.08 381.2 48.24C373.7 49.54 368 56.1 368 64C368 72.84 375.2 80 384 80C391.9 80 398.5 74.28 399.8 66.75C399.9 65.86 400 64.94 400 64C400 55.16 392.8 48 384 48V48zM324.7 88H123.3C116.9 104 104 116.9 88 123.3V228.7C104 235.1 116.9 247.1 123.3 264H324.7C331.1 247.1 343.1 235.1 360 228.7V123.3C343.1 116.9 331.1 104 324.7 88zM400 288C400 287.1 399.9 286.1 399.8 285.2C398.5 277.7 391.9 272 384 272C375.2 272 368 279.2 368 288C368 295.9 373.7 302.5 381.2 303.8C382.1 303.9 383.1 304 384 304C392.8 304 400 296.8 400 288zM64 272C56.1 272 49.54 277.7 48.24 285.2C48.08 286.1 48 287.1 48 288C48 296.8 55.16 304 64 304L64.22 303.1C65.08 303.1 65.93 303.9 66.75 303.8C74.28 302.5 80 295.9 80 288C80 279.2 72.84 272 64 272zM471.3 248C465.8 235.9 457.8 225.2 448 216.4V200H516.7C526.1 176.5 549.1 160 576 160C611.3 160 640 188.7 640 224C640 250.9 623.5 273.9 600 283.3V388.7C623.5 398.1 640 421.1 640 448C640 483.3 611.3 512 576 512C549.1 512 526.1 495.5 516.7 472H315.3C305.9 495.5 282.9 512 256 512C220.7 512 192 483.3 192 448C192 421.1 208.5 398.1 232 388.7V352H280V388.7C296 395.1 308.9 407.1 315.3 424H516.7C523.1 407.1 535.1 395.1 552 388.7V283.3C535.1 276.9 523.1 264 516.7 248H471.3zM592 224C592 215.2 584.8 208 576 208C575.1 208 574.1 208.1 573.2 208.2C565.7 209.5 560 216.1 560 224C560 232.8 567.2 240 576 240C583.9 240 590.5 234.3 591.8 226.8C591.9 225.9 592 224.9 592 224zM240 448C240 456.8 247.2 464 256 464C256.9 464 257.9 463.9 258.8 463.8C266.3 462.5 272 455.9 272 448C272 439.2 264.8 432 256 432C248.1 432 241.5 437.7 240.2 445.2C240.1 446.1 240 447.1 240 448zM573.2 463.8C574.1 463.9 575.1 464 576 464C584.8 464 592 456.8 592 448C592 447.1 591.9 446.2 591.8 445.3L591.8 445.2C590.5 437.7 583.9 432 576 432C567.2 432 560 439.2 560 448C560 455.9 565.7 462.5 573.2 463.8V463.8z',
			),
		),
		'label'             => __( 'Object Ungroup', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'octopus-deploy'                         => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M455.6 349.2c-45.89-39.09-36.67-77.88-16.09-128.1C475.2 134 415.1 34.14 329.9 8.3 237-19.6 134.3 24.34 99.68 117.1a180.9 180.9 0 0 0 -10.99 73.54c1.733 29.54 14.72 52.97 24.09 80.3 17.2 50.16-28.1 92.74-66.66 117.6-46.81 30.2-36.32 39.86-8.428 41.86 23.38 1.68 44.48-4.548 65.26-15.05 9.2-4.647 40.69-18.93 45.13-28.59C135.9 413.4 111.1 459.5 126.6 488.9c19.1 36.23 67.11-31.77 76.71-45.81 8.591-12.57 42.96-81.28 63.63-46.93 18.86 31.36 8.6 76.39 35.74 104.6 32.85 34.2 51.15-18.31 51.41-44.22 .163-16.41-6.1-95.85 29.9-59.94C405.4 418 436.9 467.8 472.6 463.6c38.74-4.516-22.12-67.97-28.26-78.69 5.393 4.279 53.67 34.13 53.82 9.52C498.2 375.7 468 359.8 455.6 349.2z',
			),
		),
		'label'             => __( 'Octopus Deploy', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'odnoklassniki'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M275.1 334c-27.4 17.4-65.1 24.3-90 26.9l20.9 20.6 76.3 76.3c27.9 28.6-17.5 73.3-45.7 45.7-19.1-19.4-47.1-47.4-76.3-76.6L84 503.4c-28.2 27.5-73.6-17.6-45.4-45.7 19.4-19.4 47.1-47.4 76.3-76.3l20.6-20.6c-24.6-2.6-62.9-9.1-90.6-26.9-32.6-21-46.9-33.3-34.3-59 7.4-14.6 27.7-26.9 54.6-5.7 0 0 36.3 28.9 94.9 28.9s94.9-28.9 94.9-28.9c26.9-21.1 47.1-8.9 54.6 5.7 12.4 25.7-1.9 38-34.5 59.1zM30.3 129.7C30.3 58 88.6 0 160 0s129.7 58 129.7 129.7c0 71.4-58.3 129.4-129.7 129.4s-129.7-58-129.7-129.4zm66 0c0 35.1 28.6 63.7 63.7 63.7s63.7-28.6 63.7-63.7c0-35.4-28.6-64-63.7-64s-63.7 28.6-63.7 64z',
			),
		),
		'label'             => __( 'Odnoklassniki', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'odnoklassniki-square'                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M184.2 177.1c0-22.1 17.9-40 39.8-40s39.8 17.9 39.8 40c0 22-17.9 39.8-39.8 39.8s-39.8-17.9-39.8-39.8zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-305.1 97.1c0 44.6 36.4 80.9 81.1 80.9s81.1-36.2 81.1-80.9c0-44.8-36.4-81.1-81.1-81.1s-81.1 36.2-81.1 81.1zm174.5 90.7c-4.6-9.1-17.3-16.8-34.1-3.6 0 0-22.7 18-59.3 18s-59.3-18-59.3-18c-16.8-13.2-29.5-5.5-34.1 3.6-7.9 16.1 1.1 23.7 21.4 37 17.3 11.1 41.2 15.2 56.6 16.8l-12.9 12.9c-18.2 18-35.5 35.5-47.7 47.7-17.6 17.6 10.7 45.8 28.4 28.6l47.7-47.9c18.2 18.2 35.7 35.7 47.7 47.9 17.6 17.2 46-10.7 28.6-28.6l-47.7-47.7-13-12.9c15.5-1.6 39.1-5.9 56.2-16.8 20.4-13.3 29.3-21 21.5-37z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'oil-can'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M288 128V160H368.9C378.8 160 388.6 162.3 397.5 166.8L448 192L615 156.2C633.1 152.3 645.7 173.8 633.5 187.7L451.1 394.3C438.1 408.1 421.5 416 403.1 416H144C117.5 416 96 394.5 96 368V346.7L28.51 316.7C11.17 308.1 0 291.8 0 272.8V208C0 181.5 21.49 160 48 160H224V128H192C174.3 128 160 113.7 160 96C160 78.33 174.3 64 192 64H320C337.7 64 352 78.33 352 96C352 113.7 337.7 128 320 128L288 128zM96 208H48V272.8L96 294.1V208z',
			),
		),
		'label'             => __( 'Oil Can', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'oil-well'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M569.8 215.8C581.2 258.5 555.9 302.4 513.2 313.8L497.7 317.9C480.7 322.5 463.1 312.4 458.5 295.3L433.3 201.3L95.1 288.8V448H137.3L190.4 296.3L264.1 276.1L238.7 352H305.3L277.9 273.6L340 257.5L406.7 448H544C561.7 448 576 462.3 576 480C576 497.7 561.7 512 544 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448H48V184C48 170.7 58.75 160 72 160C85.25 160 96 170.7 96 184V222.6L228.2 188.4L241.8 149.4C246.3 136.6 258.4 128 272 128C285.6 128 297.7 136.6 302.2 149.4L308.5 167.5L416.8 139.5L392.3 48.04C387.7 30.97 397.8 13.42 414.9 8.848L430.4 4.707C473-6.729 516.9 18.6 528.3 61.28L569.8 215.8zM205.1 448H338.9L327.7 416H216.3L205.1 448z',
			),
		),
		'label'             => __( 'Oil Well', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
		),
	),
	'old-republic'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M235.8 10.23c7.5-.31 15-.28 22.5-.09 3.61 .14 7.2 .4 10.79 .73 4.92 .27 9.79 1.03 14.67 1.62 2.93 .43 5.83 .98 8.75 1.46 7.9 1.33 15.67 3.28 23.39 5.4 12.24 3.47 24.19 7.92 35.76 13.21 26.56 12.24 50.94 29.21 71.63 49.88 20.03 20.09 36.72 43.55 48.89 69.19 1.13 2.59 2.44 5.1 3.47 7.74 2.81 6.43 5.39 12.97 7.58 19.63 4.14 12.33 7.34 24.99 9.42 37.83 .57 3.14 1.04 6.3 1.4 9.47 .55 3.83 .94 7.69 1.18 11.56 .83 8.34 .84 16.73 .77 25.1-.07 4.97-.26 9.94-.75 14.89-.24 3.38-.51 6.76-.98 10.12-.39 2.72-.63 5.46-1.11 8.17-.9 5.15-1.7 10.31-2.87 15.41-4.1 18.5-10.3 36.55-18.51 53.63-15.77 32.83-38.83 62.17-67.12 85.12a246.5 246.5 0 0 1 -56.91 34.86c-6.21 2.68-12.46 5.25-18.87 7.41-3.51 1.16-7.01 2.38-10.57 3.39-6.62 1.88-13.29 3.64-20.04 5-4.66 .91-9.34 1.73-14.03 2.48-5.25 .66-10.5 1.44-15.79 1.74-6.69 .66-13.41 .84-20.12 .81-6.82 .03-13.65-.12-20.45-.79-3.29-.23-6.57-.5-9.83-.95-2.72-.39-5.46-.63-8.17-1.11-4.12-.72-8.25-1.37-12.35-2.22-4.25-.94-8.49-1.89-12.69-3.02-8.63-2.17-17.08-5.01-25.41-8.13-10.49-4.12-20.79-8.75-30.64-14.25-2.14-1.15-4.28-2.29-6.35-3.57-11.22-6.58-21.86-14.1-31.92-22.34-34.68-28.41-61.41-66.43-76.35-108.7-3.09-8.74-5.71-17.65-7.8-26.68-1.48-6.16-2.52-12.42-3.58-18.66-.4-2.35-.61-4.73-.95-7.09-.6-3.96-.75-7.96-1.17-11.94-.8-9.47-.71-18.99-.51-28.49 .14-3.51 .34-7.01 .7-10.51 .31-3.17 .46-6.37 .92-9.52 .41-2.81 .65-5.65 1.16-8.44 .7-3.94 1.3-7.9 2.12-11.82 3.43-16.52 8.47-32.73 15.26-48.18 1.15-2.92 2.59-5.72 3.86-8.59 8.05-16.71 17.9-32.56 29.49-47.06 20-25.38 45.1-46.68 73.27-62.47 7.5-4.15 15.16-8.05 23.07-11.37 15.82-6.88 32.41-11.95 49.31-15.38 3.51-.67 7.04-1.24 10.56-1.85 2.62-.47 5.28-.7 7.91-1.08 3.53-.53 7.1-.68 10.65-1.04 2.46-.24 4.91-.36 7.36-.51m8.64 24.41c-9.23 .1-18.43 .99-27.57 2.23-7.3 1.08-14.53 2.6-21.71 4.3-13.91 3.5-27.48 8.34-40.46 14.42-10.46 4.99-20.59 10.7-30.18 17.22-4.18 2.92-8.4 5.8-12.34 9.03-5.08 3.97-9.98 8.17-14.68 12.59-2.51 2.24-4.81 4.7-7.22 7.06-28.22 28.79-48.44 65.39-57.5 104.7-2.04 8.44-3.54 17.02-4.44 25.65-1.1 8.89-1.44 17.85-1.41 26.8 .11 7.14 .38 14.28 1.22 21.37 .62 7.12 1.87 14.16 3.2 21.18 1.07 4.65 2.03 9.32 3.33 13.91 6.29 23.38 16.5 45.7 30.07 65.75 8.64 12.98 18.78 24.93 29.98 35.77 16.28 15.82 35.05 29.04 55.34 39.22 7.28 3.52 14.66 6.87 22.27 9.63 5.04 1.76 10.06 3.57 15.22 4.98 11.26 3.23 22.77 5.6 34.39 7.06 2.91 .29 5.81 .61 8.72 .9 13.82 1.08 27.74 1 41.54-.43 4.45-.6 8.92-.99 13.35-1.78 3.63-.67 7.28-1.25 10.87-2.1 4.13-.98 8.28-1.91 12.36-3.07 26.5-7.34 51.58-19.71 73.58-36.2 15.78-11.82 29.96-25.76 42.12-41.28 3.26-4.02 6.17-8.31 9.13-12.55 3.39-5.06 6.58-10.25 9.6-15.54 2.4-4.44 4.74-8.91 6.95-13.45 5.69-12.05 10.28-24.62 13.75-37.49 2.59-10.01 4.75-20.16 5.9-30.45 1.77-13.47 1.94-27.1 1.29-40.65-.29-3.89-.67-7.77-1-11.66-2.23-19.08-6.79-37.91-13.82-55.8-5.95-15.13-13.53-29.63-22.61-43.13-12.69-18.8-28.24-35.68-45.97-49.83-25.05-20-54.47-34.55-85.65-42.08-7.78-1.93-15.69-3.34-23.63-4.45-3.91-.59-7.85-.82-11.77-1.24-7.39-.57-14.81-.72-22.22-.58zM139.3 83.53c13.3-8.89 28.08-15.38 43.3-20.18-3.17 1.77-6.44 3.38-9.53 5.29-11.21 6.68-21.52 14.9-30.38 24.49-6.8 7.43-12.76 15.73-17.01 24.89-3.29 6.86-5.64 14.19-6.86 21.71-.93 4.85-1.3 9.81-1.17 14.75 .13 13.66 4.44 27.08 11.29 38.82 5.92 10.22 13.63 19.33 22.36 27.26 4.85 4.36 10.24 8.09 14.95 12.6 2.26 2.19 4.49 4.42 6.43 6.91 2.62 3.31 4.89 6.99 5.99 11.1 .9 3.02 .66 6.2 .69 9.31 .02 4.1-.04 8.2 .03 12.3 .14 3.54-.02 7.09 .11 10.63 .08 2.38 .02 4.76 .05 7.14 .16 5.77 .06 11.53 .15 17.3 .11 2.91 .02 5.82 .13 8.74 .03 1.63 .13 3.28-.03 4.91-.91 .12-1.82 .18-2.73 .16-10.99 0-21.88-2.63-31.95-6.93-6-2.7-11.81-5.89-17.09-9.83-5.75-4.19-11.09-8.96-15.79-14.31-6.53-7.24-11.98-15.39-16.62-23.95-1.07-2.03-2.24-4.02-3.18-6.12-1.16-2.64-2.62-5.14-3.67-7.82-4.05-9.68-6.57-19.94-8.08-30.31-.49-4.44-1.09-8.88-1.2-13.35-.7-15.73 .84-31.55 4.67-46.82 2.12-8.15 4.77-16.18 8.31-23.83 6.32-14.2 15.34-27.18 26.3-38.19 6.28-6.2 13.13-11.84 20.53-16.67zm175.4-20.12c2.74 .74 5.41 1.74 8.09 2.68 6.36 2.33 12.68 4.84 18.71 7.96 13.11 6.44 25.31 14.81 35.82 24.97 10.2 9.95 18.74 21.6 25.14 34.34 1.28 2.75 2.64 5.46 3.81 8.26 6.31 15.1 10 31.26 11.23 47.57 .41 4.54 .44 9.09 .45 13.64 .07 11.64-1.49 23.25-4.3 34.53-1.97 7.27-4.35 14.49-7.86 21.18-3.18 6.64-6.68 13.16-10.84 19.24-6.94 10.47-15.6 19.87-25.82 27.22-10.48 7.64-22.64 13.02-35.4 15.38-3.51 .69-7.08 1.08-10.66 1.21-1.85 .06-3.72 .16-5.56-.1-.28-2.15 0-4.31-.01-6.46-.03-3.73 .14-7.45 .1-11.17 .19-7.02 .02-14.05 .21-21.07 .03-2.38-.03-4.76 .03-7.14 .17-5.07-.04-10.14 .14-15.21 .1-2.99-.24-6.04 .51-8.96 .66-2.5 1.78-4.86 3.09-7.08 4.46-7.31 11.06-12.96 17.68-18.26 5.38-4.18 10.47-8.77 15.02-13.84 7.68-8.37 14.17-17.88 18.78-28.27 2.5-5.93 4.52-12.1 5.55-18.46 .86-4.37 1.06-8.83 1.01-13.27-.02-7.85-1.4-15.65-3.64-23.17-1.75-5.73-4.27-11.18-7.09-16.45-3.87-6.93-8.65-13.31-13.96-19.2-9.94-10.85-21.75-19.94-34.6-27.1-1.85-1.02-3.84-1.82-5.63-2.97zm-100.8 58.45c.98-1.18 1.99-2.33 3.12-3.38-.61 .93-1.27 1.81-1.95 2.68-3.1 3.88-5.54 8.31-7.03 13.06-.87 3.27-1.68 6.6-1.73 10-.07 2.52-.08 5.07 .32 7.57 1.13 7.63 4.33 14.85 8.77 21.12 2 2.7 4.25 5.27 6.92 7.33 1.62 1.27 3.53 2.09 5.34 3.05 3.11 1.68 6.32 3.23 9.07 5.48 2.67 2.09 4.55 5.33 4.4 8.79-.01 73.67 0 147.3-.01 221 0 1.35-.08 2.7 .04 4.04 .13 1.48 .82 2.83 1.47 4.15 .86 1.66 1.78 3.34 3.18 4.62 .85 .77 1.97 1.4 3.15 1.24 1.5-.2 2.66-1.35 3.45-2.57 .96-1.51 1.68-3.16 2.28-4.85 .76-2.13 .44-4.42 .54-6.63 .14-4.03-.02-8.06 .14-12.09 .03-5.89 .03-11.77 .06-17.66 .14-3.62 .03-7.24 .11-10.86 .15-4.03-.02-8.06 .14-12.09 .03-5.99 .03-11.98 .07-17.97 .14-3.62 .02-7.24 .11-10.86 .14-3.93-.02-7.86 .14-11.78 .03-5.99 .03-11.98 .06-17.97 .16-3.94-.01-7.88 .19-11.82 .29 1.44 .13 2.92 .22 4.38 .19 3.61 .42 7.23 .76 10.84 .32 3.44 .44 6.89 .86 10.32 .37 3.1 .51 6.22 .95 9.31 .57 4.09 .87 8.21 1.54 12.29 1.46 9.04 2.83 18.11 5.09 26.99 1.13 4.82 2.4 9.61 4 14.3 2.54 7.9 5.72 15.67 10.31 22.62 1.73 2.64 3.87 4.98 6.1 7.21 .27 .25 .55 .51 .88 .71 .6 .25 1.31-.07 1.7-.57 .71-.88 1.17-1.94 1.7-2.93 4.05-7.8 8.18-15.56 12.34-23.31 .7-1.31 1.44-2.62 2.56-3.61 1.75-1.57 3.84-2.69 5.98-3.63 2.88-1.22 5.9-2.19 9.03-2.42 6.58-.62 13.11 .75 19.56 1.85 3.69 .58 7.4 1.17 11.13 1.41 3.74 .1 7.48 .05 11.21-.28 8.55-.92 16.99-2.96 24.94-6.25 5.3-2.24 10.46-4.83 15.31-7.93 11.46-7.21 21.46-16.57 30.04-27.01 1.17-1.42 2.25-2.9 3.46-4.28-1.2 3.24-2.67 6.37-4.16 9.48-1.25 2.9-2.84 5.61-4.27 8.42-5.16 9.63-11.02 18.91-17.75 27.52-4.03 5.21-8.53 10.05-13.33 14.57-6.64 6.05-14.07 11.37-22.43 14.76-8.21 3.37-17.31 4.63-26.09 3.29-3.56-.58-7.01-1.69-10.41-2.88-2.79-.97-5.39-2.38-8.03-3.69-3.43-1.71-6.64-3.81-9.71-6.08 2.71 3.06 5.69 5.86 8.7 8.61 4.27 3.76 8.74 7.31 13.63 10.23 3.98 2.45 8.29 4.4 12.84 5.51 1.46 .37 2.96 .46 4.45 .6-1.25 1.1-2.63 2.04-3.99 2.98-9.61 6.54-20.01 11.86-30.69 16.43-20.86 8.7-43.17 13.97-65.74 15.34-4.66 .24-9.32 .36-13.98 .36-4.98-.11-9.97-.13-14.92-.65-11.2-.76-22.29-2.73-33.17-5.43-10.35-2.71-20.55-6.12-30.3-10.55-8.71-3.86-17.12-8.42-24.99-13.79-1.83-1.31-3.74-2.53-5.37-4.08 6.6-1.19 13.03-3.39 18.99-6.48 5.74-2.86 10.99-6.66 15.63-11.07 2.24-2.19 4.29-4.59 6.19-7.09-3.43 2.13-6.93 4.15-10.62 5.78-4.41 2.16-9.07 3.77-13.81 5.02-5.73 1.52-11.74 1.73-17.61 1.14-8.13-.95-15.86-4.27-22.51-8.98-4.32-2.94-8.22-6.43-11.96-10.06-9.93-10.16-18.2-21.81-25.66-33.86-3.94-6.27-7.53-12.75-11.12-19.22-1.05-2.04-2.15-4.05-3.18-6.1 2.85 2.92 5.57 5.97 8.43 8.88 8.99 8.97 18.56 17.44 29.16 24.48 7.55 4.9 15.67 9.23 24.56 11.03 3.11 .73 6.32 .47 9.47 .81 2.77 .28 5.56 .2 8.34 .3 5.05 .06 10.11 .04 15.16-.16 3.65-.16 7.27-.66 10.89-1.09 2.07-.25 4.11-.71 6.14-1.2 3.88-.95 8.11-.96 11.83 .61 4.76 1.85 8.44 5.64 11.38 9.71 2.16 3.02 4.06 6.22 5.66 9.58 1.16 2.43 2.46 4.79 3.55 7.26 1 2.24 2.15 4.42 3.42 6.52 .67 1.02 1.4 2.15 2.62 2.55 1.06-.75 1.71-1.91 2.28-3.03 2.1-4.16 3.42-8.65 4.89-13.05 2.02-6.59 3.78-13.27 5.19-20.02 2.21-9.25 3.25-18.72 4.54-28.13 .56-3.98 .83-7.99 1.31-11.97 .87-10.64 1.9-21.27 2.24-31.94 .08-1.86 .24-3.71 .25-5.57 .01-4.35 .25-8.69 .22-13.03-.01-2.38-.01-4.76 0-7.13 .05-5.07-.2-10.14-.22-15.21-.2-6.61-.71-13.2-1.29-19.78-.73-5.88-1.55-11.78-3.12-17.51-2.05-7.75-5.59-15.03-9.8-21.82-3.16-5.07-6.79-9.88-11.09-14.03-3.88-3.86-8.58-7.08-13.94-8.45-1.5-.41-3.06-.45-4.59-.64 .07-2.99 .7-5.93 1.26-8.85 1.59-7.71 3.8-15.3 6.76-22.6 1.52-4.03 3.41-7.9 5.39-11.72 3.45-6.56 7.62-12.79 12.46-18.46zm31.27 1.7c.35-.06 .71-.12 1.07-.19 .19 1.79 .09 3.58 .1 5.37v38.13c-.01 1.74 .13 3.49-.15 5.22-.36-.03-.71-.05-1.06-.05-.95-3.75-1.72-7.55-2.62-11.31-.38-1.53-.58-3.09-1.07-4.59-1.7-.24-3.43-.17-5.15-.2-5.06-.01-10.13 0-15.19-.01-1.66-.01-3.32 .09-4.98-.03-.03-.39-.26-.91 .16-1.18 1.28-.65 2.72-.88 4.06-1.35 3.43-1.14 6.88-2.16 10.31-3.31 1.39-.48 2.9-.72 4.16-1.54 .04-.56 .02-1.13-.05-1.68-1.23-.55-2.53-.87-3.81-1.28-3.13-1.03-6.29-1.96-9.41-3.02-1.79-.62-3.67-1-5.41-1.79-.03-.37-.07-.73-.11-1.09 5.09-.19 10.2 .06 15.3-.12 3.36-.13 6.73 .08 10.09-.07 .12-.39 .26-.77 .37-1.16 1.08-4.94 2.33-9.83 3.39-14.75zm5.97-.2c.36 .05 .72 .12 1.08 .2 .98 3.85 1.73 7.76 2.71 11.61 .36 1.42 .56 2.88 1.03 4.27 2.53 .18 5.07-.01 7.61 .05 5.16 .12 10.33 .12 15.49 .07 .76-.01 1.52 .03 2.28 .08-.04 .36-.07 .72-.1 1.08-1.82 .83-3.78 1.25-5.67 1.89-3.73 1.23-7.48 2.39-11.22 3.57-.57 .17-1.12 .42-1.67 .64-.15 .55-.18 1.12-.12 1.69 .87 .48 1.82 .81 2.77 1.09 4.88 1.52 9.73 3.14 14.63 4.6 .38 .13 .78 .27 1.13 .49 .4 .27 .23 .79 .15 1.18-1.66 .13-3.31 .03-4.97 .04-5.17 .01-10.33-.01-15.5 .01-1.61 .03-3.22-.02-4.82 .21-.52 1.67-.72 3.42-1.17 5.11-.94 3.57-1.52 7.24-2.54 10.78-.36 .01-.71 .02-1.06 .06-.29-1.73-.15-3.48-.15-5.22v-38.13c.02-1.78-.08-3.58 .11-5.37zM65.05 168.3c1.12-2.15 2.08-4.4 3.37-6.46-1.82 7.56-2.91 15.27-3.62 23-.8 7.71-.85 15.49-.54 23.23 1.05 19.94 5.54 39.83 14.23 57.88 2.99 5.99 6.35 11.83 10.5 17.11 6.12 7.47 12.53 14.76 19.84 21.09 4.8 4.1 9.99 7.78 15.54 10.8 3.27 1.65 6.51 3.39 9.94 4.68 5.01 2.03 10.19 3.61 15.42 4.94 3.83 .96 7.78 1.41 11.52 2.71 5 1.57 9.47 4.61 13.03 8.43 4.93 5.23 8.09 11.87 10.2 18.67 .99 2.9 1.59 5.91 2.17 8.92 .15 .75 .22 1.52 .16 2.29-6.5 2.78-13.26 5.06-20.26 6.18-4.11 .78-8.29 .99-12.46 1.08-10.25 .24-20.47-1.76-30.12-5.12-3.74-1.42-7.49-2.85-11.03-4.72-8.06-3.84-15.64-8.7-22.46-14.46-2.92-2.55-5.83-5.13-8.4-8.03-9.16-9.83-16.3-21.41-21.79-33.65-2.39-5.55-4.61-11.18-6.37-16.96-1.17-3.94-2.36-7.89-3.26-11.91-.75-2.94-1.22-5.95-1.87-8.92-.46-2.14-.69-4.32-1.03-6.48-.85-5.43-1.28-10.93-1.33-16.43 .11-6.18 .25-12.37 1.07-18.5 .4-2.86 .67-5.74 1.15-8.6 .98-5.7 2.14-11.37 3.71-16.93 3.09-11.65 7.48-22.95 12.69-33.84zm363.7-6.44c1.1 1.66 1.91 3.48 2.78 5.26 2.1 4.45 4.24 8.9 6.02 13.49 7.61 18.76 12.3 38.79 13.04 59.05 .02 1.76 .07 3.52 .11 5.29 .13 9.57-1.27 19.09-3.18 28.45-.73 3.59-1.54 7.17-2.58 10.69-4.04 14.72-10 29-18.41 41.78-8.21 12.57-19.01 23.55-31.84 31.41-5.73 3.59-11.79 6.64-18.05 9.19-5.78 2.19-11.71 4.03-17.8 5.11-6.4 1.05-12.91 1.52-19.4 1.23-7.92-.48-15.78-2.07-23.21-4.85-1.94-.8-3.94-1.46-5.84-2.33-.21-1.51 .25-2.99 .53-4.46 1.16-5.74 3.03-11.36 5.7-16.58 2.37-4.51 5.52-8.65 9.46-11.9 2.43-2.05 5.24-3.61 8.16-4.83 3.58-1.5 7.47-1.97 11.24-2.83 7.23-1.71 14.37-3.93 21.15-7 10.35-4.65 19.71-11.38 27.65-19.46 1.59-1.61 3.23-3.18 4.74-4.87 3.37-3.76 6.71-7.57 9.85-11.53 7.48-10.07 12.82-21.59 16.71-33.48 1.58-5.3 3.21-10.6 4.21-16.05 .63-2.87 1.04-5.78 1.52-8.68 .87-6.09 1.59-12.22 1.68-18.38 .12-6.65 .14-13.32-.53-19.94-.73-7.99-1.87-15.96-3.71-23.78z',
			),
		),
		'label'             => __( 'Old Republic', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'om'                                     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M360.6 61C362.5 62.88 365.2 64 368 64s5.375-1.125 7.375-3l21.5-21.62C398.9 37.38 400 34.75 400 32s-1.125-5.375-3.125-7.375L375.4 3c-4.125-4-10.75-4-14.75 0L339 24.62C337 26.62 336 29.25 336 32s1 5.375 3 7.375L360.6 61zM412.1 191.1c-26.75 0-51.75 10.38-70.63 29.25l-24.25 24.25c-6.75 6.75-15.75 10.5-25.37 10.5H245c10.5-22.12 14.12-48.12 7.75-75.25C242.6 138.2 206.4 104.6 163.2 97.62c-36.25-6-71 5-96 28.75c-7.375 7-7 18.87 1.125 24.87L94.5 170.9c5.75 4.375 13.62 4.375 19.12-.125C122.1 163.8 132.8 159.1 144 159.1c26.38 0 48 21.5 48 48S170.4 255.9 143.1 255.9L112 255.1c-11.88 0-19.75 12.63-14.38 23.25L113.8 311.5C116.2 316.5 121.4 319.5 126.9 320H160c35.25 0 64 28.75 64 64s-28.75 64-64 64c-96.12 0-122.4-53.1-145.2-92C10.25 348.4 0 352.4 0 361.2C-.125 416 41.12 512 160 512c70.5 0 127.1-57.44 127.1-128.1c0-23.38-6.874-45.06-17.87-63.94h21.75c26.62 0 51.75-10.38 70.63-29.25l24.25-24.25c6.75-6.75 15.75-10.5 25.37-10.5C431.9 255.1 448 272.1 448 291.9V392c0 13.25-18.75 24-32 24c-39.38 0-66.75-24.25-81.88-42.88C329.4 367.2 320 370.6 320 378.1V416c0 0 0 64 96 64c48.5 0 96-39.5 96-88V291.9C512 236.8 467.3 191.1 412.1 191.1zM454.3 67.25c-85.5 65.13-169 2.751-172.5 .125c-6-4.625-14.5-4.375-20.13 .5C255.9 72.75 254.3 81 257.9 87.63C259.5 90.63 298.2 160 376.8 160c79.88 0 98.75-31.38 101.8-37.63C479.5 120.2 480 117.9 480 115.5V80C480 66.75 464.9 59.25 454.3 67.25z',
			),
		),
		'label'             => __( 'Om', 'astra' ),
		'custom_categories' => array(),
	),
	'opencart'                               => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M423.3 440.7c0 25.3-20.3 45.6-45.6 45.6s-45.8-20.3-45.8-45.6 20.6-45.8 45.8-45.8c25.4 0 45.6 20.5 45.6 45.8zm-253.9-45.8c-25.3 0-45.6 20.6-45.6 45.8s20.3 45.6 45.6 45.6 45.8-20.3 45.8-45.6-20.5-45.8-45.8-45.8zm291.7-270C158.9 124.9 81.9 112.1 0 25.7c34.4 51.7 53.3 148.9 373.1 144.2 333.3-5 130 86.1 70.8 188.9 186.7-166.7 319.4-233.9 17.2-233.9z',
			),
		),
		'label'             => __( 'OpenCart', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'openid'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M271.5 432l-68 32C88.5 453.7 0 392.5 0 318.2c0-71.5 82.5-131 191.7-144.3v43c-71.5 12.5-124 53-124 101.3 0 51 58.5 93.3 135.7 103v-340l68-33.2v384zM448 291l-131.3-28.5 36.8-20.7c-19.5-11.5-43.5-20-70-24.8v-43c46.2 5.5 87.7 19.5 120.3 39.3l35-19.8L448 291z',
			),
		),
		'label'             => __( 'OpenID', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'opera'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M313.9 32.7c-170.2 0-252.6 223.8-147.5 355.1 36.5 45.4 88.6 75.6 147.5 75.6 36.3 0 70.3-11.1 99.4-30.4-43.8 39.2-101.9 63-165.3 63-3.9 0-8 0-11.9-.3C104.6 489.6 0 381.1 0 248 0 111 111 0 248 0h.8c63.1 .3 120.7 24.1 164.4 63.1-29-19.4-63.1-30.4-99.3-30.4zm101.8 397.7c-40.9 24.7-90.7 23.6-132-5.8 56.2-20.5 97.7-91.6 97.7-176.6 0-84.7-41.2-155.8-97.4-176.6 41.8-29.2 91.2-30.3 132.9-5 105.9 98.7 105.5 265.7-1.2 364z',
			),
		),
		'label'             => __( 'Opera', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'optin-monster'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M572.6 421.4c5.6-9.5 4.7-15.2-5.4-11.6-3-4.9-7-9.5-11.1-13.8 2.9-9.7-.7-14.2-10.8-9.2-4.6-3.2-10.3-6.5-15.9-9.2 0-15.1-11.6-11.6-17.6-5.7-10.4-1.5-18.7-.3-26.8 5.7 .3-6.5 .3-13 .3-19.7 12.6 0 40.2-11 45.9-36.2 1.4-6.8 1.6-13.8-.3-21.9-3-13.5-14.3-21.3-25.1-25.7-.8-5.9-7.6-14.3-14.9-15.9s-12.4 4.9-14.1 10.3c-8.5 0-19.2 2.8-21.1 8.4-5.4-.5-11.1-1.4-16.8-1.9 2.7-1.9 5.4-3.5 8.4-4.6 5.4-9.2 14.6-11.4 25.7-11.6V256c19.5-.5 43-5.9 53.8-18.1 12.7-13.8 14.6-37.3 12.4-55.1-2.4-17.3-9.7-37.6-24.6-48.1-8.4-5.9-21.6-.8-22.7 9.5-2.2 19.6 1.2 30-38.6 25.1-10.3-23.8-24.6-44.6-42.7-60C341 49.6 242.9 55.5 166.4 71.7c19.7 4.6 41.1 8.6 59.7 16.5-26.2 2.4-52.7 11.3-76.2 23.2-32.8 17-44 29.9-56.7 42.4 14.9-2.2 28.9-5.1 43.8-3.8-9.7 5.4-18.4 12.2-26.5 20-25.8 .9-23.8-5.3-26.2-25.9-1.1-10.5-14.3-15.4-22.7-9.7-28.1 19.9-33.5 79.9-12.2 103.5 10.8 12.2 35.1 17.3 54.9 17.8-.3 1.1-.3 1.9-.3 2.7 10.8 .5 19.5 2.7 24.6 11.6 3 1.1 5.7 2.7 8.1 4.6-5.4 .5-11.1 1.4-16.5 1.9-3.3-6.6-13.7-8.1-21.1-8.1-1.6-5.7-6.5-12.2-14.1-10.3-6.8 1.9-14.1 10-14.9 15.9-22.5 9.5-30.1 26.8-25.1 47.6 5.3 24.8 33 36.2 45.9 36.2v19.7c-6.6-5-14.3-7.5-26.8-5.7-5.5-5.5-17.3-10.1-17.3 5.7-5.9 2.7-11.4 5.9-15.9 9.2-9.8-4.9-13.6-1.7-11.1 9.2-4.1 4.3-7.8 8.6-11.1 13.8-10.2-3.7-11 2.2-5.4 11.6-1.1 3.5-1.6 7-1.9 10.8-.5 31.6 44.6 64 73.5 65.1 17.3 .5 34.6-8.4 43-23.5 113.2 4.9 226.7 4.1 340.2 0 8.1 15.1 25.4 24.3 42.7 23.5 29.2-1.1 74.3-33.5 73.5-65.1 .2-3.7-.7-7.2-1.7-10.7zm-73.8-254c1.1-3 2.4-8.4 2.4-14.6 0-5.9 6.8-8.1 14.1-.8 11.1 11.6 14.9 40.5 13.8 51.1-4.1-13.6-13-29-30.3-35.7zm-4.6 6.7c19.5 6.2 28.6 27.6 29.7 48.9-1.1 2.7-3 5.4-4.9 7.6-5.7 5.9-15.4 10-26.2 12.2 4.3-21.3 .3-47.3-12.7-63 4.9-.8 10.9-2.4 14.1-5.7zm-24.1 6.8c13.8 11.9 20 39.2 14.1 63.5-4.1 .5-8.1 .8-11.6 .8-1.9-21.9-6.8-44-14.3-64.6 3.7 .3 8.1 .3 11.8 .3zM47.5 203c-1.1-10.5 2.4-39.5 13.8-51.1 7-7.3 14.1-5.1 14.1 .8 0 6.2 1.4 11.6 2.4 14.6-17.3 6.8-26.2 22.2-30.3 35.7zm9.7 27.6c-1.9-2.2-3.5-4.9-4.9-7.6 1.4-21.3 10.3-42.7 29.7-48.9 3.2 3.2 9.2 4.9 14.1 5.7-13 15.7-17 41.6-12.7 63-10.8-2.2-20.5-6-26.2-12.2zm47.9 14.6c-4.1 0-8.1-.3-12.7-.8-4.6-18.6-1.9-38.9 5.4-53v.3l12.2-5.1c4.9-1.9 9.7-3.8 14.9-4.9-10.7 19.7-17.4 41.3-19.8 63.5zm184-162.7c41.9 0 76.2 34 76.2 75.9 0 42.2-34.3 76.2-76.2 76.2s-76.2-34-76.2-76.2c0-41.8 34.3-75.9 76.2-75.9zm115.6 174.3c-.3 17.8-7 48.9-23 57-13.2 6.6-6.5-7.5-16.5-58.1 13.3 .3 26.6 .3 39.5 1.1zm-54-1.6c.8 4.9 3.8 40.3-1.6 41.9-11.6 3.5-40 4.3-51.1-1.1-4.1-3-4.6-35.9-4.3-41.1v.3c18.9-.3 38.1-.3 57 0zM278.3 309c-13 3.5-41.6 4.1-54.6-1.6-6.5-2.7-3.8-42.4-1.9-51.6 19.2-.5 38.4-.5 57.8-.8v.3c1.1 8.3 3.3 51.2-1.3 53.7zm-106.5-51.1c12.2-.8 24.6-1.4 36.8-1.6-2.4 15.4-3 43.5-4.9 52.2-1.1 6.8-4.3 6.8-9.7 4.3-21.9-9.8-27.6-35.2-22.2-54.9zm-35.4 31.3c7.8-1.1 15.7-1.9 23.5-2.7 1.6 6.2 3.8 11.9 7 17.6 10 17 44 35.7 45.1 7 6.2 14.9 40.8 12.2 54.9 10.8 15.7-1.4 23.8-1.4 26.8-14.3 12.4 4.3 30.8 4.1 44 3 11.3-.8 20.8-.5 24.6-8.9 1.1 5.1 1.9 11.6 4.6 16.8 10.8 21.3 37.3 1.4 46.8-31.6 8.6 .8 17.6 1.9 26.5 2.7-.4 1.3-3.8 7.3 7.3 11.6-47.6 47-95.7 87.8-163.2 107-63.2-20.8-112.1-59.5-155.9-106.5 9.6-3.4 10.4-8.8 8-12.5zm-21.6 172.5c-3.8 17.8-21.9 29.7-39.7 28.9-19.2-.8-46.5-17-59.2-36.5-2.7-31.1 43.8-61.3 66.2-54.6 14.9 4.3 27.8 30.8 33.5 54 0 3-.3 5.7-.8 8.2zm-8.7-66c-.5-13.5-.5-27-.3-40.5h.3c2.7-1.6 5.7-3.8 7.8-6.5 6.5-1.6 13-5.1 15.1-9.2 3.3-7.1-7-7.5-5.4-12.4 2.7-1.1 5.7-2.2 7.8-3.5 29.2 29.2 58.6 56.5 97.3 77-36.8 11.3-72.4 27.6-105.9 47-1.2-18.6-7.7-35.9-16.7-51.9zm337.6 64.6c-103 3.5-206.2 4.1-309.4 0 0 .3 0 .3-.3 .3v-.3h.3c35.1-21.6 72.2-39.2 112.4-50.8 11.6 5.1 23 9.5 34.9 13.2 2.2 .8 2.2 .8 4.3 0 14.3-4.1 28.4-9.2 42.2-15.4 41.5 11.7 78.8 31.7 115.6 53zm10.5-12.4c-35.9-19.5-73-35.9-111.9-47.6 38.1-20 71.9-47.3 103.5-76.7 2.2 1.4 4.6 2.4 7.6 3.2 0 .8 .3 1.9 .5 2.4-4.6 2.7-7.8 6.2-5.9 10.3 2.2 3.8 8.6 7.6 15.1 8.9 2.4 2.7 5.1 5.1 8.1 6.8 0 13.8-.3 27.6-.8 41.3l.3-.3c-9.3 15.9-15.5 37-16.5 51.7zm105.9 6.2c-12.7 19.5-40 35.7-59.2 36.5-19.3 .9-40.5-13.2-40.5-37 5.7-23.2 18.9-49.7 33.5-54 22.7-6.9 69.2 23.4 66.2 54.5zM372.9 75.2c-3.8-72.1-100.8-79.7-126-23.5 44.6-24.3 90.3-15.7 126 23.5zM74.8 407.1c-15.7 1.6-49.5 25.4-49.5 43.2 0 11.6 15.7 19.5 32.2 14.9 12.2-3.2 31.1-17.6 35.9-27.3 6-11.6-3.7-32.7-18.6-30.8zm215.9-176.2c28.6 0 51.9-21.6 51.9-48.4 0-36.1-40.5-58.1-72.2-44.3 9.5 3 16.5 11.6 16.5 21.6 0 23.3-33.3 32-46.5 11.3-7.3 34.1 19.4 59.8 50.3 59.8zM68 474.1c.5 6.5 12.2 12.7 21.6 9.5 6.8-2.7 14.6-10.5 17.3-16.2 3-7-1.1-20-9.7-18.4-8.9 1.6-29.7 16.7-29.2 25.1zm433.2-67c-14.9-1.9-24.6 19.2-18.9 30.8 4.9 9.7 24.1 24.1 36.2 27.3 16.5 4.6 32.2-3.2 32.2-14.9 0-17.8-33.8-41.6-49.5-43.2zM478.8 449c-8.4-1.6-12.4 11.3-9.5 18.4 2.4 5.7 10.3 13.5 17.3 16.2 9.2 3.2 21.1-3 21.3-9.5 .9-8.4-20.2-23.5-29.1-25.1z',
			),
		),
		'label'             => __( 'Optin Monster', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'orcid'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M294.8 188.2h-45.92V342h47.47c67.62 0 83.12-51.34 83.12-76.91 0-41.64-26.54-76.9-84.67-76.9zM256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm-80.79 360.8h-29.84v-207.5h29.84zm-14.92-231.1a19.57 19.57 0 1 1 19.57-19.57 19.64 19.64 0 0 1 -19.57 19.57zM300 369h-81V161.3h80.6c76.73 0 110.4 54.83 110.4 103.8C410 318.4 368.4 369 300 369z',
			),
		),
		'label'             => __( 'ORCID', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'osi'                                    => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M8 266.4C10.3 130.6 105.4 34 221.8 18.34c138.8-18.6 255.6 75.8 278 201.1 21.3 118.8-44 230-151.6 274-9.3 3.8-14.4 1.7-18-7.7q-26.7-69.45-53.4-139c-3.1-8.1-1-13.2 7-16.8 24.2-11 39.3-29.4 43.3-55.8a71.47 71.47 0 0 0 -64.5-82.2c-39-3.4-71.8 23.7-77.5 59.7-5.2 33 11.1 63.7 41.9 77.7 9.6 4.4 11.5 8.6 7.8 18.4q-26.85 69.9-53.7 139.9c-2.6 6.9-8.3 9.3-15.5 6.5-52.6-20.3-101.4-61-130.8-119-24.9-49.2-25.2-87.7-26.8-108.7zm20.9-1.9c.4 6.6 .6 14.3 1.3 22.1 6.3 71.9 49.6 143.5 131 183.1 3.2 1.5 4.4 .8 5.6-2.3q22.35-58.65 45-117.3c1.3-3.3 .6-4.8-2.4-6.7-31.6-19.9-47.3-48.5-45.6-86 1-21.6 9.3-40.5 23.8-56.3 30-32.7 77-39.8 115.5-17.6a91.64 91.64 0 0 1 45.2 90.4c-3.6 30.6-19.3 53.9-45.7 69.8-2.7 1.6-3.5 2.9-2.3 6q22.8 58.8 45.2 117.7c1.2 3.1 2.4 3.8 5.6 2.3 35.5-16.6 65.2-40.3 88.1-72 34.8-48.2 49.1-101.9 42.3-161-13.7-117.5-119.4-214.8-255.5-198-106.1 13-195.3 102.5-197.1 225.8z',
			),
		),
		'label'             => __( 'Open Source Initiative', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'otter'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M224 160c8.836 0 16-7.164 16-16C240 135.2 232.8 128 224 128S208 135.2 208 144C208 152.8 215.2 160 224 160zM96 128C87.16 128 80 135.2 80 144C80 152.8 87.16 160 96 160s16-7.164 16-16C112 135.2 104.8 128 96 128zM474.4 64.12C466.8 63.07 460 69.07 460 76.73c0 5.959 4.188 10.1 9.991 12.36C514.2 99.46 544 160 544 192v112c0 8.844-7.156 16-16 16S512 312.8 512 304V212c0-14.87-15.65-24.54-28.94-17.89c-28.96 14.48-47.83 42.99-50.51 74.88C403.7 285.6 384 316.3 384 352v32H224c17.67 0 32-14.33 32-32c0-17.67-14.33-32-32-32H132.4c-14.46 0-27.37-9.598-31.08-23.57C97.86 283.5 96 269.1 96 256V254.4C101.1 255.3 106.3 256 111.7 256c10.78 0 21.45-2.189 31.36-6.436L160 242.3l16.98 7.271C186.9 253.8 197.6 256 208.3 256c7.176 0 14.11-.9277 20.83-2.426C241.7 292 277.4 320 320 320l36.56-.0366C363.1 294.7 377.1 272.7 396.2 256H320c0-25.73 17.56-31.61 32.31-32C369.8 223.8 384 209.6 384 192c0-17.67-14.31-32-32-32c-15.09 0-32.99 4.086-49.28 13.06C303.3 168.9 304 164.7 304 160.3v-16c0-1.684-.4238-3.248-.4961-4.912C313.2 133.9 320 123.9 320 112C320 103.2 312.8 96 304 96H292.7C274.6 58.26 236.3 32 191.7 32H128.3C83.68 32 45.44 58.26 27.33 96H16C7.164 96 0 103.2 0 112c0 11.93 6.816 21.93 16.5 27.43C16.42 141.1 16 142.7 16 144.3v16c0 19.56 5.926 37.71 16 52.86V256c0 123.7 100.3 224 224 224h160c123.9-1.166 224-101.1 224-226.2C639.9 156.9 567.8 76.96 474.4 64.12zM64 160.3v-16C64 108.9 92.86 80 128.3 80h63.32C227.1 80 256 108.9 256 144.3v16C256 186.6 234.6 208 208.3 208c-4.309 0-8.502-.8608-12.46-2.558L162.1 191.4c2.586-.3066 5.207-.543 7.598-1.631l8.314-3.777C186.9 182.3 192 174.9 192 166.7V160c0-6.723-5.996-12.17-13.39-12.17H141.4C133.1 147.8 128 153.3 128 160v6.701c0 8.15 5.068 15.6 13.09 19.25l8.314 3.777c2.391 1.088 5.012 1.324 7.598 1.631l-32.88 14.08C120.2 207.1 115.1 208 111.7 208C85.38 208 64 186.6 64 160.3z',
			),
		),
		'label'             => __( 'Otter', 'astra' ),
		'custom_categories' => array(
			'environment',
			'travel',
		),
	),
	'outdent'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M32 64C32 46.33 46.33 32 64 32H448C465.7 32 480 46.33 480 64C480 81.67 465.7 96 448 96H64C46.33 96 32 81.67 32 64V64zM224 192C224 174.3 238.3 160 256 160H448C465.7 160 480 174.3 480 192C480 209.7 465.7 224 448 224H256C238.3 224 224 209.7 224 192zM448 288C465.7 288 480 302.3 480 320C480 337.7 465.7 352 448 352H256C238.3 352 224 337.7 224 320C224 302.3 238.3 288 256 288H448zM32 448C32 430.3 46.33 416 64 416H448C465.7 416 480 430.3 480 448C480 465.7 465.7 480 448 480H64C46.33 480 32 465.7 32 448V448zM32.24 268.6C24 262.2 24 249.8 32.24 243.4L134.2 164.1C144.7 155.9 160 163.4 160 176.7V335.3C160 348.6 144.7 356.1 134.2 347.9L32.24 268.6z',
			),
		),
		'label'             => __( 'Outdent', 'astra' ),
		'custom_categories' => array(),
	),
	'p'                                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M160 32.01H32c-17.69 0-32 14.33-32 32v384c0 17.67 14.31 32 32 32s32-14.33 32-32v-96h96c88.22 0 160-71.78 160-159.1S248.2 32.01 160 32.01zM160 288H64V96.01h96c52.94 0 96 43.06 96 96S212.9 288 160 288z',
			),
		),
		'label'             => __( 'P', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'padlet'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M297.9 0L298 .001C305.6 .1078 312.4 4.72 315.5 11.78L447.5 320.3L447.8 320.2L448 320.6L445.2 330.6L402.3 488.6C398.6 504.8 382.6 514.9 366.5 511.2L298.1 495.6L229.6 511.2C213.5 514.9 197.5 504.8 193.8 488.6L150.9 330.6L148.2 320.6L148.3 320.2L280.4 11.78C283.4 4.797 290.3 .1837 297.9 .0006L297.9 0zM160.1 322.1L291.1 361.2L298 483.7L305.9 362.2L436.5 322.9L436.7 322.8L305.7 347.9L297.1 27.72L291.9 347.9L160.1 322.1zM426 222.6L520.4 181.6H594.2L437.2 429.2L468.8 320.2L426 222.6zM597.5 181.4L638.9 257.6C642.9 265.1 635 273.5 627.3 269.8L579.7 247.1L597.5 181.4zM127.3 318.5L158.7 430L1.61 154.5C-4.292 144.1 7.128 132.5 17.55 138.3L169.4 222.5L127.3 318.5z',
			),
		),
		'label'             => __( 'Padlet', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'page4'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M248 504C111 504 0 393 0 256S111 8 248 8c20.9 0 41.3 2.6 60.7 7.5L42.3 392H248v112zm0-143.6V146.8L98.6 360.4H248zm96 31.6v92.7c45.7-19.2 84.5-51.7 111.4-92.7H344zm57.4-138.2l-21.2 8.4 21.2 8.3v-16.7zm-20.3 54.5c-6.7 0-8 6.3-8 12.9v7.7h16.2v-10c0-5.9-2.3-10.6-8.2-10.6zM496 256c0 37.3-8.2 72.7-23 104.4H344V27.3C433.3 64.8 496 153.1 496 256zM360.4 143.6h68.2V96h-13.9v32.6h-13.9V99h-13.9v29.6h-12.7V96h-13.9v47.6zm68.1 185.3H402v-11c0-15.4-5.6-25.2-20.9-25.2-15.4 0-20.7 10.6-20.7 25.9v25.3h68.2v-15zm0-103l-68.2 29.7V268l68.2 29.5v-16.6l-14.4-5.7v-26.5l14.4-5.9v-16.9zm-4.8-68.5h-35.6V184H402v-12.2h11c8.6 15.8 1.3 35.3-18.6 35.3-22.5 0-28.3-25.3-15.5-37.7l-11.6-10.6c-16.2 17.5-12.2 63.9 27.1 63.9 34 0 44.7-35.9 29.3-65.3z',
			),
		),
		'label'             => __( 'page4 Corporation', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'pagelines'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M384 312.7c-55.1 136.7-187.1 54-187.1 54-40.5 81.8-107.4 134.4-184.6 134.7-16.1 0-16.6-24.4 0-24.4 64.4-.3 120.5-42.7 157.2-110.1-41.1 15.9-118.6 27.9-161.6-82.2 109-44.9 159.1 11.2 178.3 45.5 9.9-24.4 17-50.9 21.6-79.7 0 0-139.7 21.9-149.5-98.1 119.1-47.9 152.6 76.7 152.6 76.7 1.6-16.7 3.3-52.6 3.3-53.4 0 0-106.3-73.7-38.1-165.2 124.6 43 61.4 162.4 61.4 162.4 .5 1.6 .5 23.8 0 33.4 0 0 45.2-89 136.4-57.5-4.2 134-141.9 106.4-141.9 106.4-4.4 27.4-11.2 53.4-20 77.5 0 0 83-91.8 172-20z',
			),
		),
		'label'             => __( 'Pagelines', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'pager'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M448 64H64C28.63 64 0 92.63 0 128v256c0 35.38 28.62 64 64 64h384c35.38 0 64-28.62 64-64V128C512 92.63 483.4 64 448 64zM160 368H80C71.13 368 64 360.9 64 352v-16C64 327.1 71.13 320 80 320H160V368zM288 352c0 8.875-7.125 16-16 16H192V320h80c8.875 0 16 7.125 16 16V352zM448 224c0 17.62-14.38 32-32 32H96C78.38 256 64 241.6 64 224V160c0-17.62 14.38-32 32-32h320c17.62 0 32 14.38 32 32V224z',
			),
		),
		'label'             => __( 'Pager', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'paint-roller'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 64C0 28.65 28.65 0 64 0H352C387.3 0 416 28.65 416 64V128C416 163.3 387.3 192 352 192H64C28.65 192 0 163.3 0 128V64zM160 352C160 334.3 174.3 320 192 320V304C192 259.8 227.8 224 272 224H416C433.7 224 448 209.7 448 192V69.46C485.3 82.64 512 118.2 512 160V192C512 245 469 288 416 288H272C263.2 288 256 295.2 256 304V320C273.7 320 288 334.3 288 352V480C288 497.7 273.7 512 256 512H192C174.3 512 160 497.7 160 480V352z',
			),
		),
		'label'             => __( 'Paint Roller', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'paintbrush'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M224 263.3C224.2 233.3 238.4 205.2 262.4 187.2L499.1 9.605C517.7-4.353 543.6-2.965 560.7 12.9C577.7 28.76 580.8 54.54 568.2 74.07L406.5 324.1C391.3 347.7 366.6 363.2 339.3 367.1L224 263.3zM320 400C320 461.9 269.9 512 208 512H64C46.33 512 32 497.7 32 480C32 462.3 46.33 448 64 448H68.81C86.44 448 98.4 429.1 96.59 411.6C96.2 407.8 96 403.9 96 400C96 339.6 143.9 290.3 203.7 288.1L319.8 392.5C319.9 394.1 320 397.5 320 400V400z',
			),
		),
		'label'             => __( 'Paintbrush', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'palette'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 255.1C512 256.9 511.1 257.8 511.1 258.7C511.6 295.2 478.4 319.1 441.9 319.1H344C317.5 319.1 296 341.5 296 368C296 371.4 296.4 374.7 297 377.9C299.2 388.1 303.5 397.1 307.9 407.8C313.9 421.6 320 435.3 320 449.8C320 481.7 298.4 510.5 266.6 511.8C263.1 511.9 259.5 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256V255.1zM96 255.1C78.33 255.1 64 270.3 64 287.1C64 305.7 78.33 319.1 96 319.1C113.7 319.1 128 305.7 128 287.1C128 270.3 113.7 255.1 96 255.1zM128 191.1C145.7 191.1 160 177.7 160 159.1C160 142.3 145.7 127.1 128 127.1C110.3 127.1 96 142.3 96 159.1C96 177.7 110.3 191.1 128 191.1zM256 63.1C238.3 63.1 224 78.33 224 95.1C224 113.7 238.3 127.1 256 127.1C273.7 127.1 288 113.7 288 95.1C288 78.33 273.7 63.1 256 63.1zM384 191.1C401.7 191.1 416 177.7 416 159.1C416 142.3 401.7 127.1 384 127.1C366.3 127.1 352 142.3 352 159.1C352 177.7 366.3 191.1 384 191.1z',
			),
		),
		'label'             => __( 'Palette', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'palfed'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M384.9 193.9c0-47.4-55.2-44.2-95.4-29.8-1.3 39.4-2.5 80.7-3 119.8 .7 2.8 2.6 6.2 15.1 6.2 36.8 0 83.4-42.8 83.3-96.2zm-194.5 72.2c.2 0 6.5-2.7 11.2-2.7 26.6 0 20.7 44.1-14.4 44.1-21.5 0-37.1-18.1-37.1-43 0-42 42.9-95.6 100.7-126.5 1-12.4 3-22 10.5-28.2 11.2-9 26.6-3.5 29.5 11.1 72.2-22.2 135.2 1 135.2 72 0 77.9-79.3 152.6-140.1 138.2-.1 39.4 .9 74.4 2.7 100v.2c.2 3.4 .6 12.5-5.3 19.1-9.6 10.6-33.4 10-36.4-22.3-4.1-44.4 .2-206.1 1.4-242.5-21.5 15-58.5 50.3-58.5 75.9 .2 2.5 .4 4 .6 4.6zM8 181.1s-.1 37.4 38.4 37.4h30l22.4 217.2s0 44.3 44.7 44.3h288.9s44.7-.4 44.7-44.3l22.4-217.2h30s38.4 1.2 38.4-37.4c0 0 .1-37.4-38.4-37.4h-30.1c-7.3-25.6-30.2-74.3-119.4-74.3h-28V50.3s-2.7-18.4-21.1-18.4h-85.8s-21.1 0-21.1 18.4v19.1h-28.1s-105 4.2-120.5 74.3h-29S8 142.5 8 181.1z',
			),
		),
		'label'             => __( 'Palfed', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'pallet'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M624 384c8.75 0 16-7.25 16-16v-32c0-8.75-7.25-16-16-16h-608C7.25 320 0 327.3 0 336v32C0 376.8 7.25 384 16 384H64v64H16C7.25 448 0 455.3 0 464v32C0 504.8 7.25 512 16 512h608c8.75 0 16-7.25 16-16v-32c0-8.75-7.25-16-16-16H576v-64H624zM288 448H128v-64h160V448zM512 448h-160v-64h160V448z',
			),
		),
		'label'             => __( 'Pallet', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'panorama'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M578.2 66.06C409.8 116.6 230.2 116.6 61.8 66.06C31 56.82 0 79.88 0 112v319.9c0 32.15 30.1 55.21 61.79 45.97c168.4-50.53 347.1-50.53 516.4-.002C608.1 487.2 640 464.1 640 431.1V112C640 79.88 609 56.82 578.2 66.06zM128 224C110.3 224 96 209.7 96 192s14.33-32 32-32c17.68 0 32 14.33 32 32S145.7 224 128 224zM474.3 388.6C423.4 380.3 371.8 376 320 376c-50.45 0-100.7 4.043-150.3 11.93c-14.14 2.246-24.11-13.19-15.78-24.84l49.18-68.56C206.1 290.4 210.9 288 216 288s9.916 2.441 12.93 6.574l32.46 44.51l93.3-139.1C357.7 194.7 362.7 192 368 192s10.35 2.672 13.31 7.125l109.1 165.1C498.1 375.9 488.1 390.8 474.3 388.6z',
			),
		),
		'label'             => __( 'Panorama', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
		),
	),
	'paper-plane'                            => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M511.6 36.86l-64 415.1c-1.5 9.734-7.375 18.22-15.97 23.05c-4.844 2.719-10.27 4.097-15.68 4.097c-4.188 0-8.319-.8154-12.29-2.472l-122.6-51.1l-50.86 76.29C226.3 508.5 219.8 512 212.8 512C201.3 512 192 502.7 192 491.2v-96.18c0-7.115 2.372-14.03 6.742-19.64L416 96l-293.7 264.3L19.69 317.5C8.438 312.8 .8125 302.2 .0625 289.1s5.469-23.72 16.06-29.77l448-255.1c10.69-6.109 23.88-5.547 34 1.406S513.5 24.72 511.6 36.86z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M501.6 4.186c-7.594-5.156-17.41-5.594-25.44-1.063L12.12 267.1C4.184 271.7-.5037 280.3 .0431 289.4c.5469 9.125 6.234 17.16 14.66 20.69l153.3 64.38v113.5c0 8.781 4.797 16.84 12.5 21.06C184.1 511 188 512 191.1 512c4.516 0 9.038-1.281 12.99-3.812l111.2-71.46l98.56 41.4c2.984 1.25 6.141 1.875 9.297 1.875c4.078 0 8.141-1.031 11.78-3.094c6.453-3.625 10.88-10.06 11.95-17.38l64-432C513.1 18.44 509.1 9.373 501.6 4.186zM369.3 119.2l-187.1 208.9L78.23 284.7L369.3 119.2zM215.1 444v-49.36l46.45 19.51L215.1 444zM404.8 421.9l-176.6-74.19l224.6-249.5L404.8 421.9z',
			),
		),
		'label'             => __( 'Paper Plane', 'astra' ),
		'custom_categories' => array(
			'communication',
			'travel',
		),
	),
	'paperclip'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M364.2 83.8C339.8 59.39 300.2 59.39 275.8 83.8L91.8 267.8C49.71 309.9 49.71 378.1 91.8 420.2C133.9 462.3 202.1 462.3 244.2 420.2L396.2 268.2C407.1 257.3 424.9 257.3 435.8 268.2C446.7 279.1 446.7 296.9 435.8 307.8L283.8 459.8C219.8 523.8 116.2 523.8 52.2 459.8C-11.75 395.8-11.75 292.2 52.2 228.2L236.2 44.2C282.5-2.08 357.5-2.08 403.8 44.2C450.1 90.48 450.1 165.5 403.8 211.8L227.8 387.8C199.2 416.4 152.8 416.4 124.2 387.8C95.59 359.2 95.59 312.8 124.2 284.2L268.2 140.2C279.1 129.3 296.9 129.3 307.8 140.2C318.7 151.1 318.7 168.9 307.8 179.8L163.8 323.8C157.1 330.5 157.1 341.5 163.8 348.2C170.5 354.9 181.5 354.9 188.2 348.2L364.2 172.2C388.6 147.8 388.6 108.2 364.2 83.8V83.8z',
			),
		),
		'label'             => __( 'Paperclip', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
		),
	),
	'parachute-box'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M272 192V320H304C311 320 317.7 321.5 323.7 324.2L443.8 192H415.5C415.8 186.7 416 181.4 416 176C416 112.1 393.8 54.84 358.9 16.69C450 49.27 493.4 122.6 507.8 173.6C510.5 183.1 502.1 192 493.1 192H487.1L346.8 346.3C350.1 352.8 352 360.2 352 368V464C352 490.5 330.5 512 304 512H207.1C181.5 512 159.1 490.5 159.1 464V368C159.1 360.2 161.9 352.8 165.2 346.3L24.92 192H18.89C9 192 1.483 183.1 4.181 173.6C18.64 122.6 61.97 49.27 153.1 16.69C118.2 54.84 96 112.1 96 176C96 181.4 96.16 186.7 96.47 192H68.17L188.3 324.2C194.3 321.5 200.1 320 207.1 320H239.1V192H128.5C128.2 186.7 127.1 181.4 127.1 176C127.1 125 143.9 80.01 168.2 48.43C192.5 16.89 223.8 0 255.1 0C288.2 0 319.5 16.89 343.8 48.43C368.1 80.01 384 125 384 176C384 181.4 383.8 186.7 383.5 192H272z',
			),
		),
		'label'             => __( 'Parachute Box', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'paragraph'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 63.1C448 81.67 433.7 96 416 96H384v352c0 17.67-14.33 32-31.1 32S320 465.7 320 448V96h-32v352c0 17.67-14.33 32-31.1 32S224 465.7 224 448v-96H198.9c-83.57 0-158.2-61.11-166.1-144.3C23.66 112.3 98.44 32 191.1 32h224C433.7 32 448 46.33 448 63.1z',
			),
		),
		'label'             => __( 'Paragraph', 'astra' ),
		'custom_categories' => array(
			'communication',
		),
	),
	'passport'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M129.6 208c5.25 31.25 25.62 57.13 53.25 70.38C175.3 259.4 170.3 235 168.8 208H129.6zM129.6 176h39.13c1.5-27 6.5-51.38 14.12-70.38C155.3 118.9 134.9 144.8 129.6 176zM224 286.8C231.8 279.3 244.8 252.3 247.4 208H200.5C203.3 252.3 216.3 279.3 224 286.8zM265.1 105.6C272.8 124.6 277.8 149 279.3 176h39.13C313.1 144.8 292.8 118.9 265.1 105.6zM384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.2 0 64-28.8 64-64V64C448 28.8 419.2 0 384 0zM336 416h-224C103.3 416 96 408.8 96 400S103.3 384 112 384h224c8.75 0 16 7.25 16 16S344.8 416 336 416zM224 320c-70.75 0-128-57.25-128-128s57.25-128 128-128s128 57.25 128 128S294.8 320 224 320zM265.1 278.4c27.62-13.25 48-39.13 53.25-70.38h-39.13C277.8 235 272.8 259.4 265.1 278.4zM200.6 176h46.88C244.7 131.8 231.8 104.8 224 97.25C216.3 104.8 203.2 131.8 200.6 176z',
			),
		),
		'label'             => __( 'Passport', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
			'travel',
		),
	),
	'paste'                                  => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M320 96V80C320 53.49 298.5 32 272 32H215.4C204.3 12.89 183.6 0 160 0S115.7 12.89 104.6 32H48C21.49 32 0 53.49 0 80v320C0 426.5 21.49 448 48 448l144 .0013L192 176C192 131.8 227.8 96 272 96H320zM160 88C146.8 88 136 77.25 136 64S146.8 40 160 40S184 50.75 184 64S173.3 88 160 88zM416 128v96h96L416 128zM384 224L384 128h-112C245.5 128 224 149.5 224 176v288c0 26.51 21.49 48 48 48h192c26.51 0 48-21.49 48-48V256h-95.99C398.4 256 384 241.6 384 224z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M502.6 198.6l-61.25-61.25C435.4 131.4 427.3 128 418.8 128H256C220.7 128 191.1 156.7 192 192l.0065 255.1C192 483.3 220.7 512 256 512h192c35.2 0 64-28.8 64-64l.0098-226.7C512 212.8 508.6 204.6 502.6 198.6zM464 448c0 8.836-7.164 16-16 16h-192c-8.838 0-16-7.164-16-16L240 192.1c0-8.836 7.164-16 16-16h128L384 224c0 17.67 14.33 32 32 32h48.01V448zM317.7 96C310.6 68.45 285.8 48 256 48H215.2C211.3 20.93 188.1 0 160 0C131.9 0 108.7 20.93 104.8 48H64c-35.35 0-64 28.65-64 64V384c0 35.34 28.65 64 64 64h96v-48H64c-8.836 0-16-7.164-16-16V112C48 103.2 55.18 96 64 96h16v16c0 17.67 14.33 32 32 32h61.35C190 115.4 220.6 96 256 96H317.7zM160 72c-8.822 0-16-7.176-16-16s7.178-16 16-16s16 7.176 16 16S168.8 72 160 72z',
			),
		),
		'label'             => __( 'Paste', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'patreon'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 194.8c0 101.3-82.4 183.8-183.8 183.8-101.7 0-184.4-82.4-184.4-183.8 0-101.6 82.7-184.3 184.4-184.3C429.6 10.5 512 93.2 512 194.8zM0 501.5h90v-491H0v491z',
			),
		),
		'label'             => __( 'Patreon', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'pause'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M272 63.1l-32 0c-26.51 0-48 21.49-48 47.1v288c0 26.51 21.49 48 48 48L272 448c26.51 0 48-21.49 48-48v-288C320 85.49 298.5 63.1 272 63.1zM80 63.1l-32 0c-26.51 0-48 21.49-48 48v288C0 426.5 21.49 448 48 448l32 0c26.51 0 48-21.49 48-48v-288C128 85.49 106.5 63.1 80 63.1z',
			),
		),
		'label'             => __( 'Pause', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'paw'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 224c-79.37 0-191.1 122.7-191.1 200.2C64.02 459.1 90.76 480 135.8 480C184.6 480 216.9 454.9 256 454.9C295.5 454.9 327.9 480 376.2 480c44.1 0 71.74-20.88 71.74-55.75C447.1 346.8 335.4 224 256 224zM108.8 211.4c-10.37-34.62-42.5-57.12-71.62-50.12S-7.104 202 3.27 236.6C13.64 271.3 45.77 293.8 74.89 286.8S119.1 246 108.8 211.4zM193.5 190.6c30.87-8.125 46.37-49.1 34.5-93.37s-46.5-71.1-77.49-63.87c-30.87 8.125-46.37 49.1-34.5 93.37C127.9 170.1 162.5 198.8 193.5 190.6zM474.9 161.3c-29.12-6.1-61.25 15.5-71.62 50.12c-10.37 34.63 4.75 68.37 33.87 75.37c29.12 6.1 61.12-15.5 71.62-50.12C519.1 202 503.1 168.3 474.9 161.3zM318.5 190.6c30.1 8.125 65.62-20.5 77.49-63.87c11.87-43.37-3.625-85.25-34.5-93.37c-30.1-8.125-65.62 20.5-77.49 63.87C272.1 140.6 287.6 182.5 318.5 190.6z',
			),
		),
		'label'             => __( 'Paw', 'astra' ),
		'custom_categories' => array(
			'environment',
			'travel',
		),
	),
	'paypal'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M111.4 295.9c-3.5 19.2-17.4 108.7-21.5 134-.3 1.8-1 2.5-3 2.5H12.3c-7.6 0-13.1-6.6-12.1-13.9L58.8 46.6c1.5-9.6 10.1-16.9 20-16.9 152.3 0 165.1-3.7 204 11.4 60.1 23.3 65.6 79.5 44 140.3-21.5 62.6-72.5 89.5-140.1 90.3-43.4 .7-69.5-7-75.3 24.2zM357.1 152c-1.8-1.3-2.5-1.8-3 1.3-2 11.4-5.1 22.5-8.8 33.6-39.9 113.8-150.5 103.9-204.5 103.9-6.1 0-10.1 3.3-10.9 9.4-22.6 140.4-27.1 169.7-27.1 169.7-1 7.1 3.5 12.9 10.6 12.9h63.5c8.6 0 15.7-6.3 17.4-14.9 .7-5.4-1.1 6.1 14.4-91.3 4.6-22 14.3-19.7 29.3-19.7 71 0 126.4-28.8 142.9-112.3 6.5-34.8 4.6-71.4-23.8-92.6z',
			),
		),
		'label'             => __( 'Paypal', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'brands',
			'brands',
			'social',
		),
	),
	'peace'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM224 445.1c-36.36-6.141-69.2-22.48-95.59-46.04L224 322.6V445.1zM288 322.6l95.59 76.47C357.2 422.6 324.4 438.1 288 445.1V322.6zM64 256c0-94.95 69.34-173.8 160-189.1v173.7l-135.7 108.6C72.86 321.6 64 289.8 64 256zM423.7 349.2L288 240.6V66.89C378.7 82.2 448 161.1 448 256C448 289.8 439.1 321.6 423.7 349.2z',
			),
		),
		'label'             => __( 'Peace', 'astra' ),
		'custom_categories' => array(),
	),
	'pen'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M362.7 19.32C387.7-5.678 428.3-5.678 453.3 19.32L492.7 58.75C517.7 83.74 517.7 124.3 492.7 149.3L444.3 197.7L314.3 67.72L362.7 19.32zM421.7 220.3L188.5 453.4C178.1 463.8 165.2 471.5 151.1 475.6L30.77 511C22.35 513.5 13.24 511.2 7.03 504.1C.8198 498.8-1.502 489.7 .976 481.2L36.37 360.9C40.53 346.8 48.16 333.9 58.57 323.5L291.7 90.34L421.7 220.3z',
			),
		),
		'label'             => __( 'Pen', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'design',
		),
	),
	'pen-clip'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M492.7 58.75C517.7 83.74 517.7 124.3 492.7 149.3L440.6 201.4L310.6 71.43L362.7 19.32C387.7-5.678 428.3-5.678 453.3 19.32L492.7 58.75zM240.1 114.9C231.6 105.5 216.4 105.5 207 114.9L104.1 216.1C95.6 226.3 80.4 226.3 71.03 216.1C61.66 207.6 61.66 192.4 71.03 183L173.1 80.97C201.2 52.85 246.8 52.85 274.9 80.97L417.9 224L229.5 412.5C181.5 460.5 120.3 493.2 53.7 506.5L28.71 511.5C20.84 513.1 12.7 510.6 7.03 504.1C1.356 499.3-1.107 491.2 .4662 483.3L5.465 458.3C18.78 391.7 51.52 330.5 99.54 282.5L254.1 128L240.1 114.9z',
			),
		),
		'label'             => __( 'Pen Clip', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'design',
		),
	),
	'pen-fancy'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M373.5 27.11C388.5 9.885 410.2 0 433 0C476.6 0 512 35.36 512 78.98C512 101.8 502.1 123.5 484.9 138.5L277.7 319L192.1 234.3L373.5 27.11zM255.1 341.7L235.9 425.1C231.9 442.2 218.9 455.8 202 460.5L24.35 510.3L119.7 414.9C122.4 415.6 125.1 416 128 416C145.7 416 160 401.7 160 384C160 366.3 145.7 352 128 352C110.3 352 96 366.3 96 384C96 386.9 96.38 389.6 97.08 392.3L1.724 487.6L51.47 309.1C56.21 293.1 69.8 280.1 86.9 276.1L170.3 256.9L255.1 341.7z',
			),
		),
		'label'             => __( 'Pen Fancy', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'pen-nib'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M368.4 18.34C390.3-3.526 425.7-3.526 447.6 18.34L493.7 64.4C515.5 86.27 515.5 121.7 493.7 143.6L437.9 199.3L312.7 74.06L368.4 18.34zM417.4 224L371.4 377.3C365.4 397.2 350.2 413 330.5 419.6L66.17 508.2C54.83 512 42.32 509.2 33.74 500.9L187.3 347.3C193.6 350.3 200.6 352 207.1 352C234.5 352 255.1 330.5 255.1 304C255.1 277.5 234.5 256 207.1 256C181.5 256 159.1 277.5 159.1 304C159.1 311.4 161.7 318.4 164.7 324.7L11.11 478.3C2.809 469.7-.04 457.2 3.765 445.8L92.39 181.5C98.1 161.8 114.8 146.6 134.7 140.6L287.1 94.6L417.4 224z',
			),
		),
		'label'             => __( 'Pen Nib', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'pen-ruler'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M492.7 42.75C517.7 67.74 517.7 108.3 492.7 133.3L436.3 189.7L322.3 75.72L378.7 19.32C403.7-5.678 444.3-5.678 469.3 19.32L492.7 42.75zM44.89 353.2L299.7 98.34L413.7 212.3L158.8 467.1C152.1 473.8 143.8 478.7 134.6 481.4L30.59 511.1C22.21 513.5 13.19 511.1 7.03 504.1C.8669 498.8-1.47 489.8 .9242 481.4L30.65 377.4C33.26 368.2 38.16 359.9 44.89 353.2zM249.4 103.4L103.4 249.4L16 161.9C-2.745 143.2-2.745 112.8 16 94.06L94.06 16C112.8-2.745 143.2-2.745 161.9 16L181.7 35.76C181.4 36.05 181 36.36 180.7 36.69L116.7 100.7C110.4 106.9 110.4 117.1 116.7 123.3C122.9 129.6 133.1 129.6 139.3 123.3L203.3 59.31C203.6 58.99 203.1 58.65 204.2 58.3L249.4 103.4zM453.7 307.8C453.4 308 453 308.4 452.7 308.7L388.7 372.7C382.4 378.9 382.4 389.1 388.7 395.3C394.9 401.6 405.1 401.6 411.3 395.3L475.3 331.3C475.6 330.1 475.1 330.6 476.2 330.3L496 350.1C514.7 368.8 514.7 399.2 496 417.9L417.9 496C399.2 514.7 368.8 514.7 350.1 496L262.6 408.6L408.6 262.6L453.7 307.8z',
			),
		),
		'label'             => __( 'Pen Ruler', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'pen-to-square'                          => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M490.3 40.4C512.2 62.27 512.2 97.73 490.3 119.6L460.3 149.7L362.3 51.72L392.4 21.66C414.3-.2135 449.7-.2135 471.6 21.66L490.3 40.4zM172.4 241.7L339.7 74.34L437.7 172.3L270.3 339.6C264.2 345.8 256.7 350.4 248.4 353.2L159.6 382.8C150.1 385.6 141.5 383.4 135 376.1C128.6 370.5 126.4 361 129.2 352.4L158.8 263.6C161.6 255.3 166.2 247.8 172.4 241.7V241.7zM192 63.1C209.7 63.1 224 78.33 224 95.1C224 113.7 209.7 127.1 192 127.1H96C78.33 127.1 64 142.3 64 159.1V416C64 433.7 78.33 448 96 448H352C369.7 448 384 433.7 384 416V319.1C384 302.3 398.3 287.1 416 287.1C433.7 287.1 448 302.3 448 319.1V416C448 469 405 512 352 512H96C42.98 512 0 469 0 416V159.1C0 106.1 42.98 63.1 96 63.1H192z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M373.1 24.97C401.2-3.147 446.8-3.147 474.9 24.97L487 37.09C515.1 65.21 515.1 110.8 487 138.9L289.8 336.2C281.1 344.8 270.4 351.1 258.6 354.5L158.6 383.1C150.2 385.5 141.2 383.1 135 376.1C128.9 370.8 126.5 361.8 128.9 353.4L157.5 253.4C160.9 241.6 167.2 230.9 175.8 222.2L373.1 24.97zM440.1 58.91C431.6 49.54 416.4 49.54 407 58.91L377.9 88L424 134.1L453.1 104.1C462.5 95.6 462.5 80.4 453.1 71.03L440.1 58.91zM203.7 266.6L186.9 325.1L245.4 308.3C249.4 307.2 252.9 305.1 255.8 302.2L390.1 168L344 121.9L209.8 256.2C206.9 259.1 204.8 262.6 203.7 266.6zM200 64C213.3 64 224 74.75 224 88C224 101.3 213.3 112 200 112H88C65.91 112 48 129.9 48 152V424C48 446.1 65.91 464 88 464H360C382.1 464 400 446.1 400 424V312C400 298.7 410.7 288 424 288C437.3 288 448 298.7 448 312V424C448 472.6 408.6 512 360 512H88C39.4 512 0 472.6 0 424V152C0 103.4 39.4 64 88 64H200z',
			),
		),
		'label'             => __( 'Pen To Square', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'design',
		),
	),
	'pencil'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M421.7 220.3L188.5 453.4L154.6 419.5L158.1 416H112C103.2 416 96 408.8 96 400V353.9L92.51 357.4C87.78 362.2 84.31 368 82.42 374.4L59.44 452.6L137.6 429.6C143.1 427.7 149.8 424.2 154.6 419.5L188.5 453.4C178.1 463.8 165.2 471.5 151.1 475.6L30.77 511C22.35 513.5 13.24 511.2 7.03 504.1C.8198 498.8-1.502 489.7 .976 481.2L36.37 360.9C40.53 346.8 48.16 333.9 58.57 323.5L291.7 90.34L421.7 220.3zM492.7 58.75C517.7 83.74 517.7 124.3 492.7 149.3L444.3 197.7L314.3 67.72L362.7 19.32C387.7-5.678 428.3-5.678 453.3 19.32L492.7 58.75z',
			),
		),
		'label'             => __( 'Pencil', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'design',
		),
	),
	'people-arrows-left-right'               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M96 304.1c0-12.16 4.971-23.83 13.64-32.01l72.13-68.08c1.65-1.555 3.773-2.311 5.611-3.578C177.1 176.8 155 160 128 160H64C28.65 160 0 188.7 0 224v96c0 17.67 14.33 32 31.1 32L32 480c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32v-96.39l-50.36-47.53C100.1 327.9 96 316.2 96 304.1zM480 128c35.38 0 64-28.62 64-64s-28.62-64-64-64s-64 28.62-64 64S444.6 128 480 128zM96 128c35.38 0 64-28.62 64-64S131.4 0 96 0S32 28.62 32 64S60.63 128 96 128zM444.4 295.3L372.3 227.3c-3.49-3.293-8.607-4.193-13.01-2.299C354.9 226.9 352 231.2 352 236V272H224V236c0-4.795-2.857-9.133-7.262-11.03C212.3 223.1 207.2 223.1 203.7 227.3L131.6 295.3c-4.805 4.535-4.805 12.94 0 17.47l72.12 68.07c3.49 3.291 8.607 4.191 13.01 2.297C221.1 381.3 224 376.9 224 372.1V336h128v36.14c0 4.795 2.857 9.135 7.262 11.04c4.406 1.893 9.523 .9922 13.01-2.299l72.12-68.07C449.2 308.3 449.2 299.9 444.4 295.3zM512 160h-64c-26.1 0-49.98 16.77-59.38 40.42c1.842 1.271 3.969 2.027 5.623 3.588l72.12 68.06C475 280.2 480 291.9 480 304.1c.002 12.16-4.969 23.83-13.64 32.01L416 383.6V480c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32v-128c17.67 0 32-14.33 32-32V224C576 188.7 547.3 160 512 160z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'people-carry-box'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M128 95.1c26.5 0 47.1-21.5 47.1-47.1S154.5 0 128 0S80.01 21.5 80.01 47.1S101.5 95.1 128 95.1zM511.1 95.1c26.5 0 47.1-21.5 47.1-47.1S538.5 0 511.1 0c-26.5 0-48 21.5-48 47.1S485.5 95.1 511.1 95.1zM603.5 258.3l-18.5-80.13c-4.625-20-18.62-36.88-37.5-44.88c-18.5-8-38.1-6.75-56.12 3.25c-22.62 13.38-39.62 34.5-48.12 59.38l-11.25 33.88l-15.1 10.25L415.1 144c0-8.75-7.25-16-16-16H240c-8.75 0-16 7.25-16 16L224 239.1l-16.12-10.25l-11.25-33.88c-8.375-25-25.38-46-48.12-59.38c-17.25-10-37.63-11.25-56.12-3.25c-18.88 8-32.88 24.88-37.5 44.88l-18.37 80.13c-4.625 20 .7506 41.25 14.37 56.75l67.25 75.88l10.12 92.63C130 499.8 143.8 512 160 512c1.25 0 2.25-.125 3.5-.25c17.62-1.875 30.25-17.62 28.25-35.25l-10-92.75c-1.5-13-7-25.12-15.62-35l-43.37-49l17.62-70.38l6.876 20.38c4 12.5 11.87 23.5 24.5 32.63l51 32.5c4.623 2.875 12.12 4.625 17.25 5h159.1c5.125-.375 12.62-2.125 17.25-5l51-32.5c12.62-9.125 20.5-20 24.5-32.63l6.875-20.38l17.63 70.38l-43.37 49c-8.625 9.875-14.12 22-15.62 35l-10 92.75c-2 17.62 10.75 33.38 28.25 35.25C477.7 511.9 478.7 512 479.1 512c16.12 0 29.1-12.12 31.75-28.5l10.12-92.63L589.1 315C602.7 299.5 608.1 278.3 603.5 258.3zM46.26 358.1l-44 110c-6.5 16.38 1.5 35 17.88 41.63c16.75 6.5 35.12-1.75 41.62-17.88l27.62-69.13l-2-18.25L46.26 358.1zM637.7 468.1l-43.1-110l-41.13 46.38l-2 18.25l27.62 69.13C583.2 504.4 595.2 512 607.1 512c3.998 0 7.998-.75 11.87-2.25C636.2 503.1 644.2 484.5 637.7 468.1z',
			),
		),
		'label'             => __( 'People Carry Box', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'people-group'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M184 88C184 118.9 158.9 144 128 144C97.07 144 72 118.9 72 88C72 57.07 97.07 32 128 32C158.9 32 184 57.07 184 88zM208.4 196.3C178.7 222.7 160 261.2 160 304C160 338.3 171.1 369.8 192 394.5V416C192 433.7 177.7 448 160 448H96C78.33 448 64 433.7 64 416V389.2C26.16 371.2 0 332.7 0 288C0 226.1 50.14 176 112 176H144C167.1 176 190.2 183.5 208.4 196.3V196.3zM64 245.7C54.04 256.9 48 271.8 48 288C48 304.2 54.04 319.1 64 330.3V245.7zM448 416V394.5C468 369.8 480 338.3 480 304C480 261.2 461.3 222.7 431.6 196.3C449.8 183.5 472 176 496 176H528C589.9 176 640 226.1 640 288C640 332.7 613.8 371.2 576 389.2V416C576 433.7 561.7 448 544 448H480C462.3 448 448 433.7 448 416zM576 330.3C585.1 319.1 592 304.2 592 288C592 271.8 585.1 256.9 576 245.7V330.3zM568 88C568 118.9 542.9 144 512 144C481.1 144 456 118.9 456 88C456 57.07 481.1 32 512 32C542.9 32 568 57.07 568 88zM256 96C256 60.65 284.7 32 320 32C355.3 32 384 60.65 384 96C384 131.3 355.3 160 320 160C284.7 160 256 131.3 256 96zM448 304C448 348.7 421.8 387.2 384 405.2V448C384 465.7 369.7 480 352 480H288C270.3 480 256 465.7 256 448V405.2C218.2 387.2 192 348.7 192 304C192 242.1 242.1 192 304 192H336C397.9 192 448 242.1 448 304zM256 346.3V261.7C246 272.9 240 287.8 240 304C240 320.2 246 335.1 256 346.3zM384 261.7V346.3C393.1 335 400 320.2 400 304C400 287.8 393.1 272.9 384 261.7z',
			),
		),
		'label'             => __( 'People Group', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'people-line'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M360 72C360 94.09 342.1 112 320 112C297.9 112 280 94.09 280 72C280 49.91 297.9 32 320 32C342.1 32 360 49.91 360 72zM104 168C104 145.9 121.9 128 144 128C166.1 128 184 145.9 184 168C184 190.1 166.1 208 144 208C121.9 208 104 190.1 104 168zM608 416C625.7 416 640 430.3 640 448C640 465.7 625.7 480 608 480H32C14.33 480 0 465.7 0 448C0 430.3 14.33 416 32 416H608zM456 168C456 145.9 473.9 128 496 128C518.1 128 536 145.9 536 168C536 190.1 518.1 208 496 208C473.9 208 456 190.1 456 168zM200 352C200 369.7 185.7 384 168 384H120C102.3 384 88 369.7 88 352V313.5L61.13 363.4C54.85 375 40.29 379.4 28.62 373.1C16.95 366.8 12.58 352.3 18.87 340.6L56.75 270.3C72.09 241.8 101.9 224 134.2 224H153.8C170.1 224 185.7 228.5 199.2 236.6L232.7 174.3C248.1 145.8 277.9 128 310.2 128H329.8C362.1 128 391.9 145.8 407.3 174.3L440.8 236.6C454.3 228.5 469.9 224 486.2 224H505.8C538.1 224 567.9 241.8 583.3 270.3L621.1 340.6C627.4 352.3 623 366.8 611.4 373.1C599.7 379.4 585.2 375 578.9 363.4L552 313.5V352C552 369.7 537.7 384 520 384H472C454.3 384 440 369.7 440 352V313.5L413.1 363.4C406.8 375 392.3 379.4 380.6 373.1C368.1 366.8 364.6 352.3 370.9 340.6L407.2 273.1C405.5 271.5 404 269.6 402.9 267.4L376 217.5V272C376 289.7 361.7 304 344 304H295.1C278.3 304 263.1 289.7 263.1 272V217.5L237.1 267.4C235.1 269.6 234.5 271.5 232.8 273.1L269.1 340.6C275.4 352.3 271 366.8 259.4 373.1C247.7 379.4 233.2 375 226.9 363.4L199.1 313.5L200 352z',
			),
		),
		'label'             => __( 'People Line', 'astra' ),
		'custom_categories' => array(),
	),
	'people-pulling'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M32 48C32 21.49 53.49 0 80 0C106.5 0 128 21.49 128 48C128 74.51 106.5 96 80 96C53.49 96 32 74.51 32 48V48zM118.3 128C130.1 128 143.5 130.5 155.2 135.4L289.3 191.2C302.6 171.1 320.1 156.6 342.7 146.9L353.7 142C374.5 132.8 396.1 128 419.7 128C464.3 128 504.5 154.8 521.6 195.9L536.1 232.7L558.3 243.4C574.1 251.3 580.5 270.5 572.6 286.3C564.7 302.1 545.5 308.5 529.7 300.6L503 287.3C492.7 282.1 484.6 273.4 480.2 262.8L470.6 239.8L451.3 305.3L500.8 359.4C506.2 365.3 510.1 372.4 512 380.2L535 472.2C539.3 489.4 528.9 506.8 511.8 511C494.6 515.3 477.2 504.9 472.1 487.8L450.9 399.6L380.3 322.5C365.5 306.4 359.1 283.9 365.6 262.8L382.5 199.3C381.6 199.7 380.6 200.1 379.7 200.5L368.7 205.4C353.4 212.2 341.4 224.6 335.2 240.1L333.7 243.9C328.6 256.7 316.1 264.4 303 263.1C299.2 263.9 295.4 263.1 291.7 261.5L173.3 212.2L231.2 473.1C235.1 490.3 224.2 507.4 206.9 511.2C189.7 515.1 172.6 504.2 168.8 486.9L138.8 352H123.1L143.6 474.7C146.5 492.2 134.7 508.7 117.3 511.6C99.83 514.5 83.34 502.7 80.44 485.3L56.35 340.8C50.48 347.6 41.75 352 32 352C14.33 352 0 337.7 0 319.1V191.1C0 156.7 28.65 127.1 64 127.1L118.3 128zM416 48C416 21.49 437.5 0 464 0C490.5 0 512 21.49 512 48C512 74.51 490.5 96 464 96C437.5 96 416 74.51 416 48V48zM356.7 344.2L397.4 388.6L382.9 424.8C380.5 430.9 376.9 436.4 372.3 440.9L310.6 502.6C298.1 515.1 277.9 515.1 265.4 502.6C252.9 490.1 252.9 469.9 265.4 457.4L324.7 398L349.7 335.6C351.8 338.6 354.2 341.4 356.7 344.2H356.7z',
			),
		),
		'label'             => __( 'People Pulling', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'people-robbery'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M496.1 24.24C501.2 7.093 518.6-3.331 535.8 .9552C552.9 5.242 563.3 22.62 559 39.76L550.3 74.63C539.3 118.6 510.1 154.2 472 174.3V480C472 497.7 457.7 512 440 512C422.3 512 408 497.7 408 480V352H392V480C392 497.7 377.7 512 360 512C342.3 512 328 497.7 328 480V174.3C289.9 154.2 260.7 118.6 249.7 74.63L240.1 39.76C236.7 22.62 247.1 5.242 264.2 .9552C281.4-3.331 298.8 7.093 303 24.24L311.8 59.1C321.9 99.59 358.3 127.1 400 127.1C441.7 127.1 478.1 99.59 488.2 59.1L496.1 24.24zM352 47.1C352 21.49 373.5-.0006 400-.0006C426.5-.0006 448 21.49 448 47.1C448 74.51 426.5 95.1 400 95.1C373.5 95.1 352 74.51 352 47.1V47.1zM32.01 48C32.01 21.49 53.5 0 80.01 0C106.5 0 128 21.49 128 48C128 74.51 106.5 96 80.01 96C53.5 96 32.01 74.51 32.01 48V48zM104.7 128C132.1 128 157.6 142 172.2 165.1L209.6 224H240C257.7 224 272 238.3 272 256C272 273.7 257.7 288 240 288H192C181 288 170.9 282.4 164.1 273.1L152 252.7V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480V352H72V480C72 497.7 57.68 512 40 512C22.33 512 8.005 497.7 8.005 480V288.6L8 287.1V191.1C8 156.7 36.65 127.1 72 127.1L104.7 128z',
			),
		),
		'label'             => __( 'People Robbery', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'people-roof'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M623.5 164C638.1 172.6 644.6 192.1 635.1 207.5C627.4 222.1 607.9 228.6 592.5 219.1L319.1 68.61L47.54 219.1C32.09 228.6 12.61 222.1 4.025 207.5C-4.558 192.1 1.008 172.6 16.46 164L304.5 4.027C314.1-1.342 325.9-1.342 335.5 4.027L623.5 164zM279.1 200C279.1 177.9 297.9 160 319.1 160C342.1 160 359.1 177.9 359.1 200C359.1 222.1 342.1 240 319.1 240C297.9 240 279.1 222.1 279.1 200zM103.1 296C103.1 273.9 121.9 256 143.1 256C166.1 256 183.1 273.9 183.1 296C183.1 318.1 166.1 336 143.1 336C121.9 336 103.1 318.1 103.1 296V296zM535.1 296C535.1 318.1 518.1 336 495.1 336C473.9 336 455.1 318.1 455.1 296C455.1 273.9 473.9 256 495.1 256C518.1 256 535.1 273.9 535.1 296zM226.9 491.4L199.1 441.5V480C199.1 497.7 185.7 512 167.1 512H119.1C102.3 512 87.1 497.7 87.1 480V441.5L61.13 491.4C54.84 503 40.29 507.4 28.62 501.1C16.95 494.8 12.58 480.3 18.87 468.6L56.74 398.3C72.09 369.8 101.9 352 134.2 352H153.8C170.1 352 185.7 356.5 199.2 364.6L232.7 302.3C248.1 273.8 277.9 255.1 310.2 255.1H329.8C362.1 255.1 391.9 273.8 407.3 302.3L440.8 364.6C454.3 356.5 469.9 352 486.2 352H505.8C538.1 352 567.9 369.8 583.3 398.3L621.1 468.6C627.4 480.3 623 494.8 611.4 501.1C599.7 507.4 585.2 503 578.9 491.4L551.1 441.5V480C551.1 497.7 537.7 512 519.1 512H471.1C454.3 512 439.1 497.7 439.1 480V441.5L413.1 491.4C406.8 503 392.3 507.4 380.6 501.1C368.1 494.8 364.6 480.3 370.9 468.6L407.2 401.1C405.5 399.5 404 397.6 402.9 395.4L375.1 345.5V400C375.1 417.7 361.7 432 343.1 432H295.1C278.3 432 263.1 417.7 263.1 400V345.5L237.1 395.4C235.1 397.6 234.5 399.5 232.8 401.1L269.1 468.6C275.4 480.3 271 494.8 259.4 501.1C247.7 507.4 233.2 503 226.9 491.4H226.9z',
			),
		),
		'label'             => __( 'People Roof', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'pepper-hot'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M465 134.2c21.46-38.38 19.87-87.17-5.65-123.1c-7.541-10.83-22.31-13.53-33.2-5.938c-10.77 7.578-13.44 22.55-5.896 33.41c14.41 20.76 15.13 47.69 4.098 69.77C407.1 100.1 388 95.1 368 95.1c-36.23 0-68.93 13.83-94.24 35.92L352 165.5V256h90.56l33.53 78.23C498.2 308.9 512 276.2 512 239.1C512 198 493.7 160.6 465 134.2zM320 288V186.6l-52.95-22.69C216.2 241.3 188.5 400 56 400C25.13 400 0 425.1 0 456S25.13 512 56 512c180.3 0 320.1-88.27 389.3-168.5L421.5 288H320z',
			),
		),
		'label'             => __( 'Pepper Hot', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'perbyte'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M305.3 284.6H246.6V383.3h58.71q24.42 0 38.19-13.77t13.77-36.11q0-21.83-14.03-35.33T305.3 284.6zM149.4 128.7H90.72v98.72h58.71q24.42 0 38.19-13.77t13.77-36.11q0-21.83-14.03-35.34T149.4 128.7zM366.6 32H81.35A81.44 81.44 0 0 0 0 113.4V398.6A81.44 81.44 0 0 0 81.35 480H366.6A81.44 81.44 0 0 0 448 398.6V113.4A81.44 81.44 0 0 0 366.6 32zm63.63 366.6a63.71 63.71 0 0 1 -63.63 63.63H81.35a63.71 63.71 0 0 1 -63.63-63.63V113.4A63.71 63.71 0 0 1 81.35 49.72H366.6a63.71 63.71 0 0 1 63.63 63.63zM305.3 128.7H246.6v98.72h58.71q24.42 0 38.19-13.77t13.77-36.11q0-21.83-14.03-35.34T305.3 128.7z',
			),
		),
		'label'             => __( 'PerByte', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'percent'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M374.6 73.39c-12.5-12.5-32.75-12.5-45.25 0l-320 320c-12.5 12.5-12.5 32.75 0 45.25C15.63 444.9 23.81 448 32 448s16.38-3.125 22.62-9.375l320-320C387.1 106.1 387.1 85.89 374.6 73.39zM64 192c35.3 0 64-28.72 64-64S99.3 64.01 64 64.01S0 92.73 0 128S28.7 192 64 192zM320 320c-35.3 0-64 28.72-64 64s28.7 64 64 64s64-28.72 64-64S355.3 320 320 320z',
			),
		),
		'label'             => __( 'Percent', 'astra' ),
		'custom_categories' => array(
			'business',
			'education',
		),
	),
	'periscope'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M370 63.6C331.4 22.6 280.5 0 226.6 0 111.9 0 18.5 96.2 18.5 214.4c0 75.1 57.8 159.8 82.7 192.7C137.8 455.5 192.6 512 226.6 512c41.6 0 112.9-94.2 120.9-105 24.6-33.1 82-118.3 82-192.6 0-56.5-21.1-110.1-59.5-150.8zM226.6 493.9c-42.5 0-190-167.3-190-279.4 0-107.4 83.9-196.3 190-196.3 100.8 0 184.7 89 184.7 196.3 .1 112.1-147.4 279.4-184.7 279.4zM338 206.8c0 59.1-51.1 109.7-110.8 109.7-100.6 0-150.7-108.2-92.9-181.8v.4c0 24.5 20.1 44.4 44.8 44.4 24.7 0 44.8-19.9 44.8-44.4 0-18.2-11.1-33.8-26.9-40.7 76.6-19.2 141 39.3 141 112.4z',
			),
		),
		'label'             => __( 'Periscope', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'person'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M208 48C208 74.51 186.5 96 160 96C133.5 96 112 74.51 112 48C112 21.49 133.5 0 160 0C186.5 0 208 21.49 208 48zM152 352V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480V256.9L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L62.85 174.6C80.2 145.7 111.4 128 145.1 128H174.9C208.6 128 239.8 145.7 257.2 174.6L315.4 271.5C324.5 286.7 319.6 306.3 304.5 315.4C289.3 324.5 269.7 319.6 260.6 304.5L232 256.9V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V352L152 352z',
			),
		),
		'label'             => __( 'Person', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'person-arrow-down-to-line'              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M144 48C144 21.49 165.5 0 192 0C218.5 0 240 21.49 240 48C240 74.51 218.5 96 192 96C165.5 96 144 74.51 144 48zM120 256.9L91.43 304.5C82.33 319.6 62.67 324.5 47.52 315.4C32.37 306.3 27.47 286.7 36.57 271.5L94.85 174.6C112.2 145.7 143.4 128 177.1 128H206.9C240.6 128 271.8 145.7 289.2 174.6L347.4 271.5C356.5 286.7 351.6 306.3 336.5 315.4C321.3 324.5 301.7 319.6 292.6 304.5L264 256.9V448H608C625.7 448 640 462.3 640 480C640 497.7 625.7 512 608 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448H120L120 256.9zM200 448V352H184V448H200zM393.4 326.6C380.9 314.1 380.9 293.9 393.4 281.4C405.9 268.9 426.1 268.9 438.6 281.4L464 306.7V64C464 46.33 478.3 32 496 32C513.7 32 528 46.33 528 64V306.7L553.4 281.4C565.9 268.9 586.1 268.9 598.6 281.4C611.1 293.9 611.1 314.1 598.6 326.6L518.6 406.6C506.1 419.1 485.9 419.1 473.4 406.6L393.4 326.6z',
			),
		),
		'label'             => __( 'Person Arrow Down To Line', 'astra' ),
		'custom_categories' => array(),
	),
	'person-arrow-up-from-line'              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M144 48C144 21.49 165.5 0 192 0C218.5 0 240 21.49 240 48C240 74.51 218.5 96 192 96C165.5 96 144 74.51 144 48zM120 256.9L91.43 304.5C82.33 319.6 62.67 324.5 47.52 315.4C32.37 306.3 27.47 286.7 36.57 271.5L94.85 174.6C112.2 145.7 143.4 128 177.1 128H206.9C240.6 128 271.8 145.7 289.2 174.6L347.4 271.5C356.5 286.7 351.6 306.3 336.5 315.4C321.3 324.5 301.7 319.6 292.6 304.5L264 256.9V448H608C625.7 448 640 462.3 640 480C640 497.7 625.7 512 608 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448H120L120 256.9zM200 448V352H184V448H200zM598.6 121.4C611.1 133.9 611.1 154.1 598.6 166.6C586.1 179.1 565.9 179.1 553.4 166.6L528 141.3V384C528 401.7 513.7 416 496 416C478.3 416 464 401.7 464 384V141.3L438.6 166.6C426.1 179.1 405.9 179.1 393.4 166.6C380.9 154.1 380.9 133.9 393.4 121.4L473.4 41.37C485.9 28.88 506.1 28.88 518.6 41.37L598.6 121.4z',
			),
		),
		'label'             => __( 'Person Arrow Up From Line', 'astra' ),
		'custom_categories' => array(),
	),
	'person-biking'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M352 48C352 21.49 373.5 0 400 0C426.5 0 448 21.49 448 48C448 74.51 426.5 96 400 96C373.5 96 352 74.51 352 48zM480 159.1C497.7 159.1 512 174.3 512 191.1C512 209.7 497.7 223.1 480 223.1H416C408.7 223.1 401.7 221.5 396 216.1L355.3 184.4L295 232.9L337.8 261.4C346.7 267.3 352 277.3 352 288V416C352 433.7 337.7 448 320 448C302.3 448 288 433.7 288 416V305.1L227.5 266.8C194.7 245.1 192.5 198.9 223.2 175.2L306.3 110.9C323.8 97.45 348.1 97.58 365.4 111.2L427.2 159.1H480zM256 384C256 454.7 198.7 512 128 512C57.31 512 0 454.7 0 384C0 313.3 57.31 256 128 256C198.7 256 256 313.3 256 384zM128 312C88.24 312 56 344.2 56 384C56 423.8 88.24 456 128 456C167.8 456 200 423.8 200 384C200 344.2 167.8 312 128 312zM640 384C640 454.7 582.7 512 512 512C441.3 512 384 454.7 384 384C384 313.3 441.3 256 512 256C582.7 256 640 313.3 640 384zM512 312C472.2 312 440 344.2 440 384C440 423.8 472.2 456 512 456C551.8 456 584 423.8 584 384C584 344.2 551.8 312 512 312z',
			),
		),
		'label'             => __( 'Person Biking', 'astra' ),
		'custom_categories' => array(
			'education',
			'lifestyle-and-hobbies',
		),
	),
	'person-booth'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M192 496C192 504.8 199.3 512 208 512h32C248.8 512 256 504.8 256 496V320H192V496zM544 0h-32v496c0 8.75 7.25 16 16 16h32c8.75 0 16-7.25 16-16V32C576 14.25 561.8 0 544 0zM64 128c26.5 0 48-21.5 48-48S90.5 32 64 32S16 53.5 16 80S37.5 128 64 128zM224 224H173.1L127.9 178.8C115.8 166.6 99.75 160 82.75 160H64C46.88 160 30.75 166.8 18.75 178.8c-12 12.12-18.72 28.22-18.72 45.35L0 480c0 17.75 14.25 32 31.88 32s32-14.25 32-32L64 379.3c.875 .5 1.625 1.375 2.5 1.75L95.63 424V480c0 17.75 14.25 32 32 32c17.62 0 32-14.25 32-32v-56.5c0-9.875-2.375-19.75-6.75-28.62l-41.13-61.25V253l20.88 20.88C141.8 283 153.8 288 166.5 288H224c17.75 0 32-14.25 32-32S241.8 224 224 224zM192 32v160h64V0H224C206.3 0 192 14.25 192 32zM288 32l31.5 223.1l-30.88 154.6C284.3 431.3 301.6 448 320 448c15.25 0 27.99-9.125 32.24-30.38C353.3 434.5 366.9 448 384 448c17.75 0 32-14.25 32-32c0 17.75 14.25 32 32 32s32-14.25 32-32V0h-192V32z',
			),
		),
		'label'             => __( 'Person Booth', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'person-breastfeeding'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M144 80C144 35.82 179.8 0 224 0C268.2 0 304 35.82 304 80C304 124.2 268.2 160 224 160C179.8 160 144 124.2 144 80zM436.8 382.8L373.5 461.1C356.9 482.7 326.7 486 306 469.5C288.4 455.4 283.3 431.3 292.5 411.7L291.7 411.6C252.8 406.1 217.4 386.5 192 356.8V320C192 302.3 177.7 288 160 288C142.3 288 128 302.3 128 320V368C128 368.8 128 369.6 128.1 370.4L229.5 421.1C253.2 432.9 262.8 461.8 250.9 485.5C239.1 509.2 210.2 518.8 186.5 506.9L27.21 427.3C26.11 426.7 25.02 426.2 23.95 425.5C19.04 422.7 14.79 419.1 11.3 414.1C6.732 409.5 3.492 403.3 1.683 396.6C-1.576 384.6-.1811 371.4 6.459 359.9C7.098 358.8 7.776 357.8 8.489 356.7L75.56 256.1C102.3 216.1 147.2 192 195.4 192H270.6C317.1 192 360.7 214.5 387.8 252.3L438.5 323.2C440.7 326.2 442.5 329.4 443.9 332.7C446.9 339.3 448.2 346.4 447.1 353.5C447.7 364.1 443.8 374.5 436.8 382.8V382.8zM276 288C251.7 288 232 307.7 232 332C232 356.3 251.7 376 276 376C300.3 376 320 356.3 320 332C320 307.7 300.3 288 276 288z',
			),
		),
		'label'             => __( 'Person Breastfeeding', 'astra' ),
		'custom_categories' => array(
			'education',
			'science-and-technology',
		),
	),
	'person-burst'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M431.1 48C431.1 21.49 453.5 0 479.1 0C506.5 0 527.1 21.49 527.1 48C527.1 74.51 506.5 96 479.1 96C453.5 96 431.1 74.51 431.1 48zM439.1 512C422.3 512 407.1 497.7 407.1 480V256.9L379.4 304.5C370.3 319.6 350.7 324.5 335.5 315.4C320.4 306.3 315.5 286.7 324.6 271.5L382.8 174.6C400.2 145.7 431.4 128 465.1 128H494.9C528.6 128 559.8 145.7 577.2 174.6L635.4 271.5C644.5 286.7 639.6 306.3 624.5 315.4C609.3 324.5 589.7 319.6 580.6 304.5L551.1 256.9V480C551.1 497.7 537.7 512 519.1 512C502.3 512 487.1 497.7 487.1 480V352H471.1V480C471.1 497.7 457.7 512 439.1 512L439.1 512zM220.3 92.05L296.4 68.93C302.7 67.03 309.5 69.14 313.6 74.27C317.7 79.39 318.2 86.49 314.1 92.18L275.5 161.3L330.7 199.3L306.3 239.8L255.8 247.6L261.4 327C261.8 333.6 258.3 339.7 252.4 342.6C246.5 345.4 239.4 344.4 234.6 339.9L175.1 286.1L117.4 339.9C112.6 344.4 105.5 345.4 99.63 342.6C93.73 339.7 90.15 333.6 90.62 327L96.21 247.6L17.55 235.4C11.08 234.4 5.868 229.6 4.41 223.2C2.951 216.8 5.538 210.1 10.94 206.4L76.5 161.3L37.01 92.18C33.76 86.49 34.31 79.39 38.39 74.27C42.48 69.14 49.28 67.03 55.55 68.93L131.7 92.05L161.1 18.09C163.6 11.1 169.4 7.1 175.1 7.1C182.6 7.1 188.4 11.1 190.9 18.09L220.3 92.05z',
			),
		),
		'label'             => __( 'Person Burst', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'person-cane'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M240 48C240 74.51 218.5 96 192 96C165.5 96 144 74.51 144 48C144 21.49 165.5 0 192 0C218.5 0 240 21.49 240 48zM232 480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V352H152V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480V256.9L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L62.85 174.6C80.2 145.7 111.4 128 145.1 128H181C209.6 128 236.7 140.7 254.9 162.7L328.6 251.6C339.9 265.2 338 285.3 324.4 296.6C310.8 307.9 290.7 306 279.4 292.4L232 235.3L232 480zM320 384C320 397.3 309.3 408 296 408C282.7 408 272 397.3 272 384V376C272 345.1 297.1 320 328 320C358.9 320 384 345.1 384 376V488C384 501.3 373.3 512 360 512C346.7 512 336 501.3 336 488V376C336 371.6 332.4 368 328 368C323.6 368 320 371.6 320 376V384z',
			),
		),
		'label'             => __( 'Person Cane', 'astra' ),
		'custom_categories' => array(
			'design',
			'science-and-technology',
		),
	),
	'person-chalkboard'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M144 48C144 21.49 165.5 0 192 0C218.5 0 240 21.49 240 48C240 74.51 218.5 96 192 96C165.5 96 144 74.51 144 48zM152 512C134.3 512 120 497.7 120 480V256.9L91.43 304.5C82.33 319.6 62.67 324.5 47.52 315.4C32.37 306.3 27.47 286.7 36.58 271.5L94.85 174.6C112.2 145.7 143.4 128 177.1 128H320V48C320 21.49 341.5 .0003 368 .0003H592C618.5 .0003 640 21.49 640 48V272C640 298.5 618.5 320 592 320H368C341.5 320 320 298.5 320 272V224H384V256H576V64H384V128H400C417.7 128 432 142.3 432 160C432 177.7 417.7 192 400 192H264V480C264 497.7 249.7 512 232 512C214.3 512 200 497.7 200 480V352H184V480C184 497.7 169.7 512 152 512L152 512z',
			),
		),
		'label'             => __( 'Person Chalkboard', 'astra' ),
		'custom_categories' => array(
			'business',
			'education',
		),
	),
	'person-circle-check'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M208 48C208 74.51 186.5 96 160 96C133.5 96 112 74.51 112 48C112 21.49 133.5 0 160 0C186.5 0 208 21.49 208 48zM152 352V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480V256.9L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L62.85 174.6C80.2 145.7 111.4 128 145.1 128H174.9C208.6 128 239.8 145.7 257.2 174.6L302.1 249.3C285.1 266.9 273.4 287.7 265.5 310.8C263.6 308.9 261.1 306.8 260.6 304.5L232 256.9V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V352L152 352zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM476.7 324.7L416 385.4L387.3 356.7C381.1 350.4 370.9 350.4 364.7 356.7C358.4 362.9 358.4 373.1 364.7 379.3L404.7 419.3C410.9 425.6 421.1 425.6 427.3 419.3L499.3 347.3C505.6 341.1 505.6 330.9 499.3 324.7C493.1 318.4 482.9 318.4 476.7 324.7H476.7z',
			),
		),
		'label'             => __( 'Person Circle Check', 'astra' ),
		'custom_categories' => array(),
	),
	'person-circle-exclamation'              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M208 48C208 74.51 186.5 96 160 96C133.5 96 112 74.51 112 48C112 21.49 133.5 0 160 0C186.5 0 208 21.49 208 48zM152 352V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480V256.9L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L62.85 174.6C80.2 145.7 111.4 128 145.1 128H174.9C208.6 128 239.8 145.7 257.2 174.6L302.1 249.3C285.1 266.9 273.4 287.7 265.5 310.8C263.6 308.9 261.1 306.8 260.6 304.5L232 256.9V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V352L152 352zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 464C445.3 464 456 453.3 456 440C456 426.7 445.3 416 432 416C418.7 416 408 426.7 408 440C408 453.3 418.7 464 432 464zM415.1 288V368C415.1 376.8 423.2 384 431.1 384C440.8 384 447.1 376.8 447.1 368V288C447.1 279.2 440.8 272 431.1 272C423.2 272 415.1 279.2 415.1 288z',
			),
		),
		'label'             => __( 'Person Circle Exclamation', 'astra' ),
		'custom_categories' => array(),
	),
	'person-circle-minus'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M208 48C208 74.51 186.5 96 160 96C133.5 96 112 74.51 112 48C112 21.49 133.5 0 160 0C186.5 0 208 21.49 208 48zM152 352V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480V256.9L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L62.85 174.6C80.2 145.7 111.4 128 145.1 128H174.9C208.6 128 239.8 145.7 257.2 174.6L302.1 249.3C285.1 266.9 273.4 287.7 265.5 310.8C263.6 308.9 261.1 306.8 260.6 304.5L232 256.9V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V352L152 352zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM496 351.1H368C359.2 351.1 352 359.2 352 367.1C352 376.8 359.2 383.1 368 383.1H496C504.8 383.1 512 376.8 512 367.1C512 359.2 504.8 351.1 496 351.1z',
			),
		),
		'label'             => __( 'Person Circle Minus', 'astra' ),
		'custom_categories' => array(),
	),
	'person-circle-plus'                     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M208 48C208 74.51 186.5 96 160 96C133.5 96 112 74.51 112 48C112 21.49 133.5 0 160 0C186.5 0 208 21.49 208 48zM152 352V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480V256.9L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L62.85 174.6C80.2 145.7 111.4 128 145.1 128H174.9C208.6 128 239.8 145.7 257.2 174.6L302.1 249.3C285.1 266.9 273.4 287.7 265.5 310.8C263.6 308.9 261.1 306.8 260.6 304.5L232 256.9V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V352L152 352zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM448 303.1C448 295.2 440.8 287.1 432 287.1C423.2 287.1 416 295.2 416 303.1V351.1H368C359.2 351.1 352 359.2 352 367.1C352 376.8 359.2 383.1 368 383.1H416V431.1C416 440.8 423.2 447.1 432 447.1C440.8 447.1 448 440.8 448 431.1V383.1H496C504.8 383.1 512 376.8 512 367.1C512 359.2 504.8 351.1 496 351.1H448V303.1z',
			),
		),
		'label'             => __( 'Person Circle Plus', 'astra' ),
		'custom_categories' => array(),
	),
	'person-circle-question'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M208 48C208 74.51 186.5 96 160 96C133.5 96 112 74.51 112 48C112 21.49 133.5 0 160 0C186.5 0 208 21.49 208 48zM152 352V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480V256.9L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L62.85 174.6C80.2 145.7 111.4 128 145.1 128H174.9C208.6 128 239.8 145.7 257.2 174.6L302.1 249.3C285.1 266.9 273.4 287.7 265.5 310.8C263.6 308.9 261.1 306.8 260.6 304.5L232 256.9V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V352L152 352zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 464C445.3 464 456 453.3 456 440C456 426.7 445.3 416 432 416C418.7 416 408 426.7 408 440C408 453.3 418.7 464 432 464zM368 328C368 336.8 375.2 344 384 344C392.8 344 400 336.8 400 328V321.6C400 316.3 404.3 312 409.6 312H450.1C457.8 312 464 318.2 464 325.9C464 331.1 461.1 335.8 456.6 338.3L424.6 355.1C419.3 357.9 416 363.3 416 369.2V384C416 392.8 423.2 400 432 400C440.8 400 448 392.8 448 384V378.9L471.5 366.6C486.5 358.6 496 342.1 496 325.9C496 300.6 475.4 280 450.1 280H409.6C386.6 280 368 298.6 368 321.6V328z',
			),
		),
		'label'             => __( 'Person Circle Question', 'astra' ),
		'custom_categories' => array(),
	),
	'person-circle-xmark'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M208 48C208 74.51 186.5 96 160 96C133.5 96 112 74.51 112 48C112 21.49 133.5 0 160 0C186.5 0 208 21.49 208 48zM152 352V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480V256.9L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L62.85 174.6C80.2 145.7 111.4 128 145.1 128H174.9C208.6 128 239.8 145.7 257.2 174.6L302.1 249.3C285.1 266.9 273.4 287.7 265.5 310.8C263.6 308.9 261.1 306.8 260.6 304.5L232 256.9V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V352L152 352zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM491.3 331.3C497.6 325.1 497.6 314.9 491.3 308.7C485.1 302.4 474.9 302.4 468.7 308.7L432 345.4L395.3 308.7C389.1 302.4 378.9 302.4 372.7 308.7C366.4 314.9 366.4 325.1 372.7 331.3L409.4 368L372.7 404.7C366.4 410.9 366.4 421.1 372.7 427.3C378.9 433.6 389.1 433.6 395.3 427.3L432 390.6L468.7 427.3C474.9 433.6 485.1 433.6 491.3 427.3C497.6 421.1 497.6 410.9 491.3 404.7L454.6 368L491.3 331.3z',
			),
		),
		'label'             => __( 'Person Circle Xmark', 'astra' ),
		'custom_categories' => array(),
	),
	'person-digging'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M272 95.93c26.5 0 47.99-21.47 47.99-47.97S298.5 0 272 0C245.5 0 224 21.47 224 47.97S245.5 95.93 272 95.93zM209.7 357.3c-25.75-17.25-52.25-33.24-79.5-48.11L58.62 270.2L1.246 471.1c-4.875 16.1 4.1 34.74 22 39.62s34.63-4.998 39.5-21.99l36.63-128.1l60.63 40.37v78.86c0 17.62 14.38 31.99 32 31.99s32-14.37 32-31.99l.0022-95.93C224 373.2 218.6 363.2 209.7 357.3zM311.1 416c-13.88 0-25.95 8.863-30.33 21.86l-24.75 74.07h319.9l-101.9-206.3c-11.38-22.49-43.1-23.63-56.1-2.01l-31.89 54.21l-65.26-35.64l-24-121.2C288.1 161.3 263.2 127.7 227.1 109.7c-1-.4999-2.125-.625-3.125-1.125c-2.25-1.125-4.752-1.1-7.252-2.625C201.5 99.85 185.2 95.98 168.7 95.98H95.1c-9.25 0-18.05 4.061-24.18 10.93l-55.95 63.92c-.75 .9998-1.5 2.124-2.25 3.249c-8.875 13.1-3 32.87 11.63 40.74l336.6 184.3l-9.837 16.87H311.1zM105.9 204.1l-23.5-12.87l28.13-32.12h34.38L105.9 204.1zM199.5 256.1l34.9-41.28l13.5 67.61L199.5 256.1z',
			),
		),
		'label'             => __( 'Person Digging', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'person-dots-from-line'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M463.1 256c8.75 0 15.1-7.25 15.1-16S472.7 224 463.1 224c-8.75 0-15.1 7.25-15.1 16S455.2 256 463.1 256zM287.1 176c48.5 0 87.1-39.5 87.1-88S336.5 0 287.1 0S200 39.5 200 88S239.5 176 287.1 176zM80 256c8.75 0 15.1-7.25 15.1-16S88.75 224 80 224S64 231.3 64 240S71.25 256 80 256zM75.91 375.1c.6289-.459 41.62-29.26 100.1-50.05L176 432h223.1l-.0004-106.8c58.32 20.8 99.51 49.49 100.1 49.91C508.6 381.1 518.3 384 527.9 384c14.98 0 29.73-7 39.11-20.09c15.41-21.59 10.41-51.56-11.16-66.97c-1.955-1.391-21.1-14.83-51.83-30.85C495.5 279.2 480.7 288 463.1 288c-26.25 0-47.1-21.75-47.1-48c0-3.549 .4648-6.992 1.217-10.33C378.6 217.2 334.4 208 288 208c-59.37 0-114.1 15.01-160.1 32.67C127.6 266.6 106 288 80 288C69.02 288 58.94 284 50.8 277.7c-18.11 10.45-29.25 18.22-30.7 19.26c-21.56 15.41-26.56 45.38-11.16 66.97C24.33 385.5 54.3 390.4 75.91 375.1zM335.1 344c13.25 0 23.1 10.75 23.1 24s-10.75 24-23.1 24c-13.25 0-23.1-10.75-23.1-24S322.7 344 335.1 344zM240 248c13.25 0 23.1 10.75 23.1 24S253.3 296 240 296c-13.25 0-23.1-10.75-23.1-24S226.8 248 240 248zM559.1 464H16c-8.75 0-15.1 7.25-15.1 16l-.0016 16c0 8.75 7.25 16 15.1 16h543.1c8.75 0 15.1-7.25 15.1-16L575.1 480C575.1 471.3 568.7 464 559.1 464z',
			),
		),
		'label'             => __( 'Person Dots From Line', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'person-dress'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M112 48C112 21.49 133.5 0 160 0C186.5 0 208 21.49 208 48C208 74.51 186.5 96 160 96C133.5 96 112 74.51 112 48zM88 384H70.2C59.28 384 51.57 373.3 55.02 362.9L93.28 248.1L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L58.18 182.3C78.43 148.6 114.9 128 154.2 128H165.8C205.1 128 241.6 148.6 261.8 182.3L315.4 271.5C324.5 286.7 319.6 306.3 304.5 315.4C289.3 324.5 269.7 319.6 260.6 304.5L226.7 248.1L264.1 362.9C268.4 373.3 260.7 384 249.8 384H232V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V384H152V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480L88 384z',
			),
		),
		'label'             => __( 'Person Dress', 'astra' ),
		'custom_categories' => array(),
	),
	'person-dress-burst'                     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M527.1 48C527.1 74.51 506.5 96 479.1 96C453.5 96 431.1 74.51 431.1 48C431.1 21.49 453.5 0 479.1 0C506.5 0 527.1 21.49 527.1 48zM375 362.9L413.3 248.1L379.4 304.5C370.3 319.6 350.7 324.5 335.5 315.4C320.4 306.3 315.5 286.7 324.6 271.5L378.2 182.3C398.4 148.6 434.9 128 474.2 128H485.8C525.1 128 561.6 148.6 581.8 182.3L635.4 271.5C644.5 286.7 639.6 306.3 624.5 315.4C609.3 324.5 589.7 319.6 580.6 304.5L546.7 248.1L584.1 362.9C588.4 373.3 580.7 384 569.8 384H551.1V480C551.1 497.7 537.7 512 519.1 512C502.3 512 487.1 497.7 487.1 480V384H471.1V480C471.1 497.7 457.7 512 439.1 512C422.3 512 407.1 497.7 407.1 480V384H390.2C379.3 384 371.6 373.3 375 362.9L375 362.9zM220.3 92.05L296.4 68.93C302.7 67.03 309.5 69.14 313.6 74.27C317.7 79.39 318.2 86.49 314.1 92.18L275.5 161.3L330.7 199.3L306.3 239.8L255.8 247.6L261.4 327C261.8 333.6 258.3 339.7 252.4 342.6C246.5 345.4 239.4 344.4 234.6 339.9L175.1 286.1L117.4 339.9C112.6 344.4 105.5 345.4 99.63 342.6C93.73 339.7 90.15 333.6 90.62 327L96.21 247.6L17.55 235.4C11.08 234.4 5.868 229.6 4.41 223.2C2.951 216.8 5.538 210.1 10.94 206.4L76.5 161.3L37.01 92.18C33.76 86.49 34.31 79.39 38.39 74.27C42.48 69.14 49.28 67.03 55.55 68.93L131.7 92.05L161.1 18.09C163.6 11.1 169.4 7.1 175.1 7.1C182.6 7.1 188.4 11.1 190.9 18.09L220.3 92.05z',
			),
		),
		'label'             => __( 'Person Dress Burst', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'person-drowning'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M191.1 96.16C191.1 148.8 226.1 195.4 276.3 211.4C316.3 224.2 358.1 225.1 399.1 216.6L504.9 192.8C522.1 188.9 539.3 199.7 543.2 216.9C547.1 234.1 536.3 251.3 519.1 255.2L414.1 279.1C403.6 281.5 392.9 283.3 382.2 284.5L364.5 382.1C350.9 378.9 337.2 372.7 324.8 364.1C302.8 348.6 273.3 348.6 251.2 364.1C234 375.9 213.2 384.5 192 384.5C184.7 384.5 177 383.3 169.2 381.2L190.2 234.5C151.5 200.1 127.1 150.2 127.1 96.16V64C127.1 46.33 142.3 32 159.1 32C177.7 32 191.1 46.33 191.1 64V96.16zM255.1 127.1C255.1 92.65 284.7 63.1 320 63.1C355.3 63.1 384 92.65 384 127.1C384 163.3 355.3 191.1 320 191.1C284.7 191.1 255.1 163.3 255.1 127.1zM384 416C410.9 416 439.4 405.2 461.4 389.9L461.5 389.9C473.4 381.4 489.5 382.1 500.7 391.6C515 403.5 533.2 412.6 551.3 416.8C568.5 420.8 579.2 438.1 575.2 455.3C571.2 472.5 553.1 483.2 536.7 479.2C512.2 473.4 491.9 462.6 478.5 454.2C449.5 469.7 417 480 384 480C352.1 480 323.4 470.1 303.6 461.1C297.7 458.5 292.5 455.8 288 453.4C283.5 455.8 278.3 458.5 272.4 461.1C252.6 470.1 223.9 480 192 480C158.1 480 126.5 469.7 97.5 454.2C84.12 462.6 63.79 473.4 39.27 479.2C22.06 483.2 4.853 472.5 .8422 455.3C-3.169 438.1 7.532 420.8 24.74 416.8C42.84 412.6 60.96 403.5 75.31 391.6C86.46 382.1 102.6 381.4 114.5 389.9L114.6 389.9C136.7 405.2 165.1 416 192 416C219.5 416 247 405.4 269.5 389.9C280.6 382 295.4 382 306.5 389.9C328.1 405.4 356.5 416 384 416H384z',
			),
		),
		'label'             => __( 'Person Drowning', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'person-falling'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M256 0C273.7 0 288 14.33 288 32V41.84C288 96.45 260.1 146.5 215.5 175.4L215.7 175.8L272.5 255.1H360C375.1 255.1 389.3 263.1 398.4 275.2L441.6 332.8C452.2 346.9 449.3 366.1 435.2 377.6C421.1 388.2 401 385.3 390.4 371.2L352 319.1H254.6L346.9 462.6C356.5 477.5 352.2 497.3 337.4 506.9C322.5 516.5 302.7 512.2 293.1 497.4L132.5 249.2C129.6 258.4 127.1 268.1 127.1 278.2V351.1C127.1 369.7 113.7 383.1 95.1 383.1C78.33 383.1 63.1 369.7 63.1 351.1V278.2C63.1 213 103.6 154.5 164.1 130.3C200.3 115.8 223.1 80.79 223.1 41.84V32C223.1 14.33 238.3 .0003 256 .0003L256 0zM32 80C32 53.49 53.49 32 80 32C106.5 32 128 53.49 128 80C128 106.5 106.5 128 80 128C53.49 128 32 106.5 32 80z',
			),
		),
		'label'             => __( 'Person Falling', 'astra' ),
		'custom_categories' => array(),
	),
	'person-falling-burst'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M256 41.84C256 96.45 228.1 146.5 183.5 175.4L183.7 175.8L240.5 255.1H311.1C327.1 255.1 341.3 263.1 350.4 275.2L393.6 332.8C404.2 346.9 401.3 366.1 387.2 377.6C373.1 388.2 353 385.3 342.4 371.2L303.1 319.1H222.6L314.9 462.6C324.5 477.5 320.2 497.3 305.4 506.9C290.5 516.5 270.7 512.2 261.1 497.4L100.5 249.2C97.57 258.4 95.1 268.1 95.1 278.2V351.1C95.1 369.7 81.67 383.1 63.1 383.1C46.33 383.1 31.1 369.7 31.1 351.1V278.2C31.1 213 71.65 154.5 132.1 130.3C168.3 115.8 191.1 80.79 191.1 41.84V32C191.1 14.33 206.3 0 223.1 0C241.7 0 255.1 14.33 255.1 32L256 41.84zM96 79.1C96 106.5 74.51 127.1 48 127.1C21.49 127.1 0 106.5 0 79.1C0 53.49 21.49 31.1 48 31.1C74.51 31.1 96 53.49 96 79.1zM464 286.1L424.7 322.2C423.1 319.3 421.3 316.4 419.2 313.6L382.1 265.3L384.2 247.6L365.8 244.8C351.2 231.5 332.1 223.1 311.1 223.1H292.6C292.5 223.7 292.5 223.4 292.4 223.2C290.1 216.8 293.5 210.1 298.9 206.4L364.5 161.3L325 92.18C321.8 86.49 322.3 79.39 326.4 74.27C330.5 69.14 337.3 67.03 343.6 68.93L419.7 92.05L449.1 18.09C451.6 11.1 457.4 8 464 8C470.6 8 476.4 11.1 478.9 18.09L508.3 92.05L584.4 68.93C590.7 67.03 597.5 69.14 601.6 74.27C605.7 79.39 606.2 86.49 602.1 92.18L563.5 161.3L629.1 206.4C634.5 210.1 637 216.8 635.6 223.2C634.1 229.6 628.9 234.4 622.4 235.4L543.8 247.6L549.4 327C549.8 333.6 546.3 339.7 540.4 342.6C534.5 345.4 527.4 344.4 522.6 339.9L464 286.1z',
			),
		),
		'label'             => __( 'Person Falling Burst', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'person-half-dress'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M112 48C112 21.49 133.5 0 160 0C186.5 0 208 21.49 208 48C208 74.51 186.5 96 160 96C133.5 96 112 74.51 112 48zM168 128H174.9C208.6 128 239.8 145.7 257.2 174.6L315.4 271.5C324.5 286.7 319.6 306.3 304.5 315.4C289.3 324.5 269.7 319.6 260.6 304.5L232 256.9V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480L168 128zM58.18 182.3C78.06 149.2 113.5 128.8 152 128V480.2C151.9 497.8 137.6 512 120 512C102.3 512 88 497.7 88 480V384H70.2C59.28 384 51.57 373.3 55.02 362.9L93.28 248.1L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L58.18 182.3z',
			),
		),
		'label'             => __( 'Person Half Dress', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'person-harassing'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M144 48C144 21.49 165.5 0 192 0C218.5 0 240 21.49 240 48C240 74.51 218.5 96 192 96C165.5 96 144 74.51 144 48V48zM15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L62.85 174.6C80.2 145.7 111.4 128 145.1 128H181C209.6 128 236.7 140.7 254.9 162.7L328.6 251.6C339.9 265.2 338 285.3 324.4 296.6C310.8 307.9 290.7 306 279.4 292.4L232 235.3V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V352H152V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480V256.9L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4H15.52zM480 240C480 266.5 458.5 288 432 288C405.5 288 384 266.5 384 240C384 213.5 405.5 192 432 192C458.5 192 480 213.5 480 240zM464 344C464 313.1 489.1 288 520 288C550.9 288 576 313.1 576 344V446.1C576 482.5 546.5 512 510.1 512C492.6 512 475.8 505.1 463.4 492.7L408.8 438L380.6 494.3C372.7 510.1 353.5 516.5 337.7 508.6C321.9 500.7 315.5 481.5 323.4 465.7L371.4 369.7C375.1 360.5 384.7 354.1 394.9 352.4C405 350.8 415.4 354.1 422.6 361.4L464 402.7V344zM288 48C288 39.16 295.2 32 304 32H360C368.8 32 376 39.16 376 48C376 56.84 368.8 64 360 64H304C295.2 64 288 56.84 288 48zM335.2 121.7C343.1 125.6 346.3 135.3 342.3 143.2C338.4 151.1 328.7 154.3 320.8 150.3L272.8 126.3C264.9 122.4 261.7 112.7 265.7 104.8C269.6 96.94 279.3 93.74 287.2 97.69L335.2 121.7z',
			),
		),
		'label'             => __( 'Person Harassing', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'person-hiking'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M240 96c26.5 0 48-21.5 48-48S266.5 0 240 0C213.5 0 192 21.5 192 48S213.5 96 240 96zM80.01 287.1c7.31 0 13.97-4.762 15.87-11.86L137 117c.3468-1.291 .5125-2.588 .5125-3.866c0-7.011-4.986-13.44-12.39-15.13C118.4 96.38 111.7 95.6 105.1 95.6c-36.65 0-70 23.84-79.32 59.53L.5119 253.3C.1636 254.6-.0025 255.9-.0025 257.2c0 7.003 4.961 13.42 12.36 15.11L76.01 287.5C77.35 287.8 78.69 287.1 80.01 287.1zM368 160h-15.1c-8.875 0-15.1 7.125-15.1 16V192h-34.75l-46.75-46.75C243.4 134.1 228.6 128 212.9 128C185.9 128 162.5 146.3 155.9 172.5L129 280.3C128.4 282.8 128 285.5 128 288.1c0 8.325 3.265 16.44 9.354 22.53l86.62 86.63V480c0 17.62 14.37 32 31.1 32s32-14.38 32-32v-82.75c0-17.12-6.625-33.13-18.75-45.25l-46.87-46.88c.25-.5 .5-.875 .625-1.375l19.1-79.5l22.37 22.38C271.4 252.6 279.5 256 288 256h47.1v240c0 8.875 7.125 16 15.1 16h15.1C376.9 512 384 504.9 384 496v-320C384 167.1 376.9 160 368 160zM81.01 472.3c-.672 2.63-.993 5.267-.993 7.86c0 14.29 9.749 27.29 24.24 30.89C106.9 511.8 109.5 512 112 512c14.37 0 27.37-9.75 30.1-24.25l25.25-101l-52.75-52.75L81.01 472.3z',
			),
		),
		'label'             => __( 'Person Hiking', 'astra' ),
		'custom_categories' => array(
			'environment',
			'lifestyle-and-hobbies',
		),
	),
	'person-military-pointing'               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M366.7 1.443C376 .6658 384 8.027 384 17.39V47.1C384 56.84 376.8 63.1 368 63.1H216.1C203.2 63.1 192 52.81 192 39C192 25.1 201.1 15.17 214.9 14.09L366.7 1.443zM208 111.1C208 106.5 208.6 101.2 209.6 95.1H366.4C367.5 101.2 368 106.5 368 111.1C368 156.2 332.2 191.1 288 191.1C243.8 191.1 208 156.2 208 111.1V111.1zM313.2 223.1C327.6 223.1 341.6 226.3 354.9 230.5L192 393.4V303.1H40.01C17.92 303.1 .0077 286.1 .0077 263.1C.0077 241.9 17.92 223.1 40.01 223.1H313.2zM430.3 290.8L506.4 419.7C517.7 438.7 511.4 463.2 492.4 474.4C473.3 485.7 448.8 479.4 437.6 460.3L384 369.7V416H214.6L385.7 244.9C403.7 256.3 419.1 271.9 430.3 290.8V290.8zM384 448V480C384 497.7 369.7 512 352 512H224C206.3 512 192 497.7 192 480V448H384z',
			),
		),
		'label'             => __( 'Person Military Pointing', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'person-military-rifle'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M128 39C128 25.1 137.1 15.17 150.9 14.09L302.7 1.443C312 .6658 320 8.027 320 17.39V47.1C320 56.84 312.8 63.1 304 63.1H152.1C139.2 63.1 128 52.81 128 39V39zM302.4 95.1C303.5 101.2 304 106.5 304 111.1C304 156.2 268.2 191.1 224 191.1C179.8 191.1 144 156.2 144 111.1C144 106.5 144.6 101.2 145.6 95.1H302.4zM373.6 460.3L320 369.7V480C320 481.3 319.9 482.5 319.8 483.8L145.5 234.9C162.1 227.8 180.2 223.1 198.8 223.1H249.2C265.1 223.1 280.6 226.8 295 231.9L389.9 67.71C382.2 63.3 379.6 53.51 384 45.86C388.4 38.21 398.2 35.58 405.9 40L433.6 56C441.2 60.42 443.8 70.21 439.4 77.86L383.1 173.9L385.6 174.9C400.9 183.7 406.1 203.3 397.3 218.6L360.6 282C362.6 284.9 364.5 287.8 366.3 290.8L442.4 419.7C453.7 438.7 447.4 463.2 428.4 474.4C409.3 485.7 384.8 479.4 373.6 460.3V460.3zM264 319.1C277.3 319.1 288 309.3 288 295.1C288 282.7 277.3 271.1 264 271.1C250.7 271.1 240 282.7 240 295.1C240 309.3 250.7 319.1 264 319.1zM160 512C142.3 512 128 497.7 128 480V369.7L74.44 460.3C63.21 479.4 38.68 485.7 19.66 474.4C.6381 463.2-5.669 438.7 5.569 419.7L81.7 290.8C91.06 274.1 103.4 261.5 117.7 250.8L299.1 510C295.6 511.3 291.9 512 288 512L160 512z',
			),
		),
		'label'             => __( 'Person Military Rifle', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'person-military-to-person'              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M182.2 .0998C191.7-.9534 200 6.466 200 16V30.13C200 38.91 192.9 46.05 184.1 46.13H72.74C63.48 46.04 56 38.52 56 29.24C56 20.64 62.47 13.41 71.02 12.46L182.2 .0998zM192 96C192 131.3 163.3 160 128 160C92.65 160 64 131.3 64 96C64 89.8 64.88 83.8 66.53 78.13H189.5C191.1 83.8 192 89.8 192 96V96zM32 256C32 237.2 40.09 220.3 52.97 208.6L197.2 319.6C195.5 319.9 193.8 320 192 320H64C46.33 320 32 305.7 32 288L32 256zM222.2 298.5L85.05 192.9C88.61 192.3 92.27 191.1 96 191.1H160C195.3 191.1 224 220.7 224 255.1V287.1C224 291.7 223.4 295.2 222.2 298.5V298.5zM320 96C320 60.65 348.7 31.1 384 31.1C419.3 31.1 448 60.65 448 96C448 131.3 419.3 160 384 160C348.7 160 320 131.3 320 96zM416 192C451.3 192 480 220.7 480 256V288C480 305.7 465.7 320 448 320H320C302.3 320 288 305.7 288 288V256C288 220.7 316.7 192 352 192H416zM151.8 506.1C141.8 514.8 126.7 513.8 117.9 503.8C109.2 493.8 110.2 478.7 120.2 469.9L136.1 456L23.1 455.1C10.74 455.1-.0003 445.2 0 431.1C.0003 418.7 10.75 407.1 24 407.1L136.1 408L120.2 394.1C110.2 385.3 109.2 370.2 117.9 360.2C126.7 350.2 141.8 349.2 151.8 357.9L215.8 413.9C221 418.5 224 425.1 224 431.1C224 438.9 221 445.5 215.8 450.1L151.8 506.1zM296.2 413.9L360.2 357.9C370.2 349.2 385.3 350.2 394.1 360.2C402.8 370.2 401.8 385.3 391.8 394.1L375.9 407.1L488 407.1C501.3 407.1 512 418.7 512 431.1C512 445.2 501.3 455.1 488 455.1L375.9 455.1L391.8 469.9C401.8 478.7 402.8 493.8 394.1 503.8C385.3 513.8 370.2 514.8 360.2 506.1L296.2 450.1C290.1 445.5 288 438.9 288 431.1C288 425.1 290.1 418.5 296.2 413.9H296.2z',
			),
		),
		'label'             => __( 'Person Military To Person', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'person-praying'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M255.1 128c35.38 0 63.1-28.62 63.1-64s-28.62-64-63.1-64S191.1 28.62 191.1 64S220.6 128 255.1 128zM225.4 297.8c14 16.75 39 19.12 56.01 5.25l88.01-72c17-14 19.5-39.25 5.625-56.38c-14-17.12-39.25-19.5-56.38-5.625L261.3 216l-39-46.25c-15.38-18.38-39.13-27.88-64.01-25.38c-24.13 2.5-45.25 16.25-56.38 37l-49.38 92C29.13 317 43.88 369.8 86.76 397.1L131.5 432H40C17.88 432 0 449.9 0 472S17.88 512 40 512h208c34.13 0 53.76-42.75 28.25-68.25L166.4 333.9L201.3 269L225.4 297.8z',
			),
		),
		'label'             => __( 'Person Praying', 'astra' ),
		'custom_categories' => array(),
	),
	'person-pregnant'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M112 48C112 21.49 133.5 0 160 0C186.5 0 208 21.49 208 48C208 74.51 186.5 96 160 96C133.5 96 112 74.51 112 48zM88 382.1C74.2 379.4 64 366.9 64 352V296.9L59.43 304.5C50.33 319.6 30.67 324.5 15.52 315.4C.3696 306.3-4.531 286.7 4.573 271.5L62.85 174.6C77.84 149.6 103.2 133 131.5 128.1C135.6 128.3 139.8 128 144 128H160C161.4 128 162.8 128.1 164.1 128.3C199.8 131.2 229.5 157.6 236.2 193.3L242.3 225.7C286.6 234.3 320 273.2 320 320V352C320 369.7 305.7 384 288 384H232V480C232 497.7 217.7 512 200 512C182.3 512 168 497.7 168 480V384H152V480C152 497.7 137.7 512 120 512C102.3 512 88 497.7 88 480L88 382.1z',
			),
		),
		'label'             => __( 'Person Pregnant', 'astra' ),
		'custom_categories' => array(),
	),
	'person-rays'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M304 48C304 74.51 282.5 96 256 96C229.5 96 208 74.51 208 48C208 21.49 229.5 0 256 0C282.5 0 304 21.49 304 48zM248 352V480C248 497.7 233.7 512 216 512C198.3 512 184 497.7 184 480V256.9L155.4 304.5C146.3 319.6 126.7 324.5 111.5 315.4C96.37 306.3 91.47 286.7 100.6 271.5L158.8 174.6C176.2 145.7 207.4 128 241.1 128H270.9C304.6 128 335.8 145.7 353.2 174.6L411.4 271.5C420.5 286.7 415.6 306.3 400.5 315.4C385.3 324.5 365.7 319.6 356.6 304.5L328 256.9V480C328 497.7 313.7 512 296 512C278.3 512 264 497.7 264 480V352L248 352zM7.029 7.029C16.4-2.343 31.6-2.343 40.97 7.029L120.1 87.03C130.3 96.4 130.3 111.6 120.1 120.1C111.6 130.3 96.4 130.3 87.03 120.1L7.029 40.97C-2.343 31.6-2.343 16.4 7.029 7.029V7.029zM471 7.029C480.4-2.343 495.6-2.343 504.1 7.029C514.3 16.4 514.3 31.6 504.1 40.97L424.1 120.1C415.6 130.3 400.4 130.3 391 120.1C381.7 111.6 381.7 96.4 391 87.03L471 7.029zM7.029 471L87.03 391C96.4 381.7 111.6 381.7 120.1 391C130.3 400.4 130.3 415.6 120.1 424.1L40.97 504.1C31.6 514.3 16.4 514.3 7.029 504.1C-2.343 495.6-2.343 480.4 7.029 471V471zM391 424.1C381.7 415.6 381.7 400.4 391 391C400.4 381.7 415.6 381.7 424.1 391L504.1 471C514.3 480.4 514.3 495.6 504.1 504.1C495.6 514.3 480.4 514.3 471 504.1L391 424.1z',
			),
		),
		'label'             => __( 'Person Rays', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'person-rifle'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M265.2 192C290.6 192 315 199.1 336 211.9V512H144V337.7L90.44 428.3C79.21 447.4 54.68 453.7 35.66 442.4C16.64 431.2 10.33 406.7 21.57 387.7L97.7 258.8C122.2 217.4 166.7 192 214.8 192L265.2 192zM320 80C320 124.2 284.2 160 240 160C195.8 160 160 124.2 160 80C160 35.82 195.8 .0003 240 .0003C284.2 .0003 320 35.82 320 80zM464 16V132.3C473.6 137.8 480 148.2 480 160V269.3L496 264V208C496 199.2 503.2 192 512 192H528C536.8 192 544 199.2 544 208V292.5C544 299.4 539.6 305.5 533.1 307.6L480 325.3V352H528C536.8 352 544 359.2 544 368V384C544 392.8 536.8 400 528 400H484L507 492.1C509.6 502.2 501.9 512 491.5 512H432C423.2 512 416 504.8 416 496V400H400C382.3 400 368 385.7 368 368V224C368 206.3 382.3 192 400 192V160C400 148.2 406.4 137.8 416 132.3V32C407.2 32 400 24.84 400 16C400 7.164 407.2 0 416 0H448C456.8 0 464 7.164 464 16V16z',
			),
		),
		'label'             => __( 'Person Rifle', 'astra' ),
		'custom_categories' => array(
			'environment',
			'science-and-technology',
		),
	),
	'person-running'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M400 224h-44l-26.12-53.25c-12.5-25.5-35.38-44.25-61.75-51L197 98.63C189.5 96.84 181.1 95.97 174.5 95.97c-20.88 0-41.33 6.81-58.26 19.78L76.5 146.3C68.31 152.5 64.01 162 64.01 171.6c0 17.11 13.67 32.02 32.02 32.02c6.808 0 13.67-2.158 19.47-6.616l39.63-30.38c5.92-4.488 13.01-6.787 19.53-6.787c2.017 0 3.981 .2196 5.841 .6623l14.62 4.25l-37.5 87.5C154.1 260.3 152.5 268.8 152.5 277.2c0 22.09 11.49 43.52 31.51 55.29l85 50.13l-27.5 87.75c-.9875 3.174-1.458 6.388-1.458 9.55c0 13.65 8.757 26.31 22.46 30.58C265.6 511.5 268.9 512 272 512c13.62 0 26.25-8.75 30.5-22.5l31.75-101c1.211-4.278 1.796-8.625 1.796-12.93c0-16.57-8.661-32.51-23.55-41.44l-61.13-36.12l31.25-78.38l20.25 41.5C310.9 277.4 327.9 288 345.1 288H400c17.62 0 32-14.38 32-32C432 238.3 417.6 224 400 224zM288 96c26.5 0 48-21.5 48-48s-21.5-48-48-48s-48 21.5-48 48S261.5 96 288 96zM129.8 317.5L114.9 352H48c-17.62 0-32 14.38-32 32s14.38 32 32 32h77.5c19.25 0 36.5-11.5 44-29.12l8.875-20.5l-10.75-6.25C150.4 349.9 137.6 334.8 129.8 317.5z',
			),
		),
		'label'             => __( 'Person Running', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'person-shelter'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M495.9 132.2C505.8 137.9 512 148.5 512 160V480C512 497.7 497.7 512 480 512C462.3 512 448 497.7 448 480V178.6L256 68.86L64 178.6V480C64 497.7 49.67 512 32 512C14.33 512 0 497.7 0 480V160C0 148.5 6.153 137.9 16.12 132.2L240.1 4.216C249.1-1.405 262-1.405 271.9 4.216L495.9 132.2zM216 168C216 145.9 233.9 128 256 128C278.1 128 296 145.9 296 168C296 190.1 278.1 208 256 208C233.9 208 216 190.1 216 168zM224 512C210.7 512 200 501.3 200 488V313.5L173.1 363.4C166.8 375 152.3 379.4 140.6 373.1C128.1 366.8 124.6 352.3 130.9 340.6L168.7 270.3C184.1 241.8 213.9 223.1 246.2 223.1H265.8C298.1 223.1 327.9 241.8 343.3 270.3L381.1 340.6C387.4 352.3 383 366.8 371.4 373.1C359.7 379.4 345.2 375 338.9 363.4L312 313.5V488C312 501.3 301.3 512 288 512C274.7 512 264 501.3 264 488V400H248V488C248 501.3 237.3 512 224 512V512z',
			),
		),
		'label'             => __( 'Person Shelter', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'person-skating'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M399.1 0c-26.5 0-48.01 21.5-48.01 48S373.5 96 399.1 96C426.5 96 448 74.5 448 48S426.5 0 399.1 0zM399.1 448c-8.751 0-16 7.25-16 16S376.7 480 367.1 480h-96.01c-8.751 0-16 7.25-16 16s7.251 16 16 16h96.01c26.5 0 48.01-21.5 48.01-48C415.1 455.2 408.7 448 399.1 448zM129.1 451.9c-11.34 0-11.19 9.36-22.65 9.36c-4.074 0-8.163-1.516-11.21-4.625l-67.98-67.89c-3.063-3.125-7.165-4.688-11.27-4.688c-4.102 0-8.204 1.562-11.27 4.688C1.562 391.8-.0001 395.9-.0001 400s1.562 8.203 4.688 11.27l67.88 67.98c9.376 9.375 21.59 14 33.96 14c13.23 0 38.57-8.992 38.57-25.36C145.1 456.7 135.2 451.9 129.1 451.9zM173.8 276.8L80.2 370.5c-6.251 6.25-9.376 14.44-9.376 22.62c0 24.75 22.57 32 31.88 32c8.251 0 16.5-3.125 22.63-9.375l91.89-92l-30.13-30.12C182.1 288.6 177.7 282.9 173.8 276.8zM127.1 160h105.5L213.3 177.3c-21.18 18.04-22.31 41.73-22.31 48.65c0 16.93 6.8 33.22 18.68 45.1l78.26 78.25V432c0 17.75 14.25 32 32 32s32-14.25 32-32v-89.38c0-12.62-5.126-25-14.13-33.88l-61.01-61c.5001-.5 1.25-.625 1.75-1.125l82.26-82.38c7.703-7.702 11.76-17.87 11.76-28.25c0-22.04-17.86-39.97-40.01-39.97L127.1 96C110.2 96 95.96 110.2 95.96 128S110.2 160 127.1 160z',
			),
		),
		'label'             => __( 'Person Skating', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'person-skiing'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M432.1 96.02c26.51 0 47.99-21.5 47.99-48.01S458.6 0 432.1 0s-47.98 21.5-47.98 48.01S405.6 96.02 432.1 96.02zM511.1 469.1c0-13.98-11.33-23.95-23.89-23.95c-18.89 0-19.23 19.11-46.15 19.11c-5.476 0-10.87-1.081-15.87-3.389l-135.8-70.26l49.15-73.82c5.446-8.116 8.09-17.39 8.09-26.63c0-12.4-4.776-24.73-14.09-33.9l-40.38-40.49l-106.1-53.1C185.6 165.8 185.4 169 185.4 172.2c0 16.65 6.337 32.78 18.42 44.86l75.03 75.21l-45.88 68.76L34.97 258.8C31.44 257 27.64 256.1 23.93 256.1C9.675 256.1 0 267.8 0 280.1c0 8.673 4.735 17.04 12.96 21.24l392 202.6c11.88 5.501 24.45 8.119 37.08 8.119C480.1 512 511.1 486.7 511.1 469.1zM119.1 91.65L108.5 114.2C114.2 117 120.2 118.4 126.2 118.4c9.153 0 18.1-3.2 25.06-9.102l47.26 23.51c-.125 0-.125 .125-.2501 .25l114.5 56.76l32.51-13l6.376 19.13c4.001 12.13 12.63 22.01 24 27.76l58.14 28.1c4.609 2.287 9.455 3.355 14.26 3.355c18.8 0 31.98-15.43 31.98-31.93c0-11.74-6.461-23.1-17.74-28.7l-52.03-26.1l-17.12-51.15C386.6 98.69 364.2 73.99 333.1 73.99c-7.658 0-15.82 1.504-24.43 4.934L227.4 111.3L164.9 80.33c.009-.3461 .0134-.692 .0134-1.038c0-14.13-7.468-27.7-20.89-34.53L132.9 66.45L98.17 59.43C97.83 59.36 97.53 59.35 97.19 59.35c-2.666 0-5.276 2.177-5.276 5.273c0 1.473 .648 2.936 1.81 3.961L119.1 91.65z',
			),
		),
		'label'             => __( 'Person Skiing', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'person-skiing-nordic'                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M336 96C362.5 96 384 74.5 384 48S362.5 0 336 0S288 21.5 288 48S309.5 96 336 96zM552 416c-13.25 0-24 10.75-24 24s-10.75 24-24 24h-69.5L460 285.6c11.75-4.75 20.04-16.31 20.04-29.69c0-17.75-14.38-31.95-32.01-31.95l-43.9-.0393l-26.11-53.22c-12.5-25.5-35.5-44.12-61.75-50.87l-71.22-21.15c-7.475-1.819-15.08-2.693-22.59-2.693c-20.86 0-41.25 6.854-58.16 19.72L124.6 146.2C116.3 152.5 111.1 161.1 111.1 171.6c0 14.71 8.712 21.23 9.031 21.6L66.88 464H24C10.75 464 0 474.8 0 488S10.75 512 24 512h480c39.75 0 72-32.25 72-72C576 426.8 565.3 416 552 416zM291.6 463.9H194.7l43.1-90.97l-21.99-12.1c-12.13-7.25-21.99-16.89-29.49-27.77l-62.48 131.7L99.5 464l52.25-261.4c4.125-1 8.112-2.846 11.74-5.596l39.81-30.45c5.821-4.485 12.86-6.771 19.38-6.771c2.021 0 4.015 .212 5.878 .6556l14.73 4.383L205.8 252.2C202.3 260.3 200.7 268.9 200.7 277.3c0 22.06 11.42 43.37 31.41 55.22l84.97 50.15L291.6 463.9zM402.1 464l-43.58-.125l23.6-75.48c1.221-4.314 1.805-8.69 1.805-13.03c0-16.53-8.558-32.43-23.41-41.34l-61.21-36.1l31.32-78.23l20.26 41.36c8 16.25 24.86 26.89 43.11 26.89L427.3 288L402.1 464z',
			),
		),
		'label'             => __( 'Person Skiing Nordic', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'person-snowboarding'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M460.7 249.6c5.877 4.25 12.47 6.393 19.22 6.393c10.76 0 32.05-8.404 32.05-31.97c0-9.74-4.422-19.36-12.8-25.65l-111.5-83.48c-13.75-10.25-29.04-18.42-45.42-23.79l-63.66-21.23l-26.12-52.12c-5.589-11.17-16.9-17.64-28.63-17.64c-17.8 0-31.99 14.47-31.99 32.01c0 4.803 1.086 9.674 3.374 14.25l29.12 58.12c5.75 11.38 15.55 19.85 27.67 23.98l16.45 5.522L227.3 154.6C205.5 165.5 191.9 187.4 191.9 211.8L191.9 264.9L117.8 289.6C104.4 294.1 95.95 306.5 95.95 319.9c0 12.05 6.004 19.05 10.33 23.09l-38.68-14.14C41.23 319.4 49.11 295 23.97 295c-18.67 0-23.97 17.16-23.97 24.09c0 8.553 13.68 41.32 51.13 54.88l364.1 132.8C425.7 510.2 435.7 512 445.7 512c12.5 0 24.97-2.732 36.47-8.232c8.723-3.997 13.85-12.71 13.85-21.77c0-18.67-17.15-23.96-24.06-23.96c-3.375 0-6.73 .7505-9.998 2.248c-5.111 2.486-10.64 3.702-16.21 3.702c-4.511 0-9.049-.7978-13.41-2.364l-90.68-33.12c8.625-4.125 15.53-11.76 17.78-21.89l21.88-101.1c.7086-3.335 1.05-6.668 1.05-10c0-14.91-6.906-29.31-19.17-38.4l-52.01-39l66.01-30.5L460.7 249.6zM316.3 301.3l-19.66 92c-.4205 1.997-.5923 3.976-.5923 5.911c0 4.968 1.264 9.691 3.333 14.01l-169.5-61.49c2.625-.25 5.492-.4448 8.117-1.32l85-28.38c19.63-6.5 32.77-24.73 32.77-45.48l0-20.53L316.3 301.3zM431.9 95.99c26.5 0 48-21.5 48-47.1S458.4 0 431.9 0s-48 21.5-48 47.1S405.4 95.99 431.9 95.99z',
			),
		),
		'label'             => __( 'Person Snowboarding', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'person-swimming'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M192.4 320c63.38 0 54.09-39.67 95.33-40.02c42.54 .3672 31.81 40.02 95.91 40.02c39.27 0 55.72-18.41 62.21-24.83l-140.4-116.1c3.292-1.689 31.66-18.2 75.25-18.2c12.57 0 25.18 1.397 37.53 4.21l38.59 8.844c2.412 .5592 4.824 .8272 7.2 .8272c15.91 0 31.96-12.81 31.96-32.04c0-14.58-10.03-27.77-24.84-31.16l-38.59-8.844c-17.06-3.904-34.46-5.837-51.81-5.837c-120.1 0-177.4 85.87-178.1 88.02L179.1 213.3C158.1 241.3 147.4 273.8 145 307.7C157.5 315.4 174.3 320 192.4 320zM576 397c0-15.14-10.82-28.59-26.25-31.42c-48.52-8.888-45.5-29.48-69.6-29.48c-25.02 0-31.19 31.79-96.18 31.79c-48.59 0-72.72-22.06-73.38-22.62c-6.141-6.157-14.26-9.188-22.42-9.188c-24.75 0-31.59 31.81-96.2 31.81c-48.59 0-72.69-22.03-73.41-22.59c-6.125-6.157-14.3-9.245-22.46-9.245c-8.072 0-16.12 3.026-22.38 8.901c-29.01 26.25-73.75 12.54-73.75 52.08c0 16.08 12.77 32.07 31.71 32.07c9.77 0 39.65-7.34 64.26-21.84C115.5 418.8 147.4 431.1 192 431.1s76.5-13.12 96-24.66c19.53 11.53 51.47 24.59 96 24.59c44.59 0 76.56-13.09 96.06-24.62c24.71 14.57 54.74 21.83 64.24 21.83C563.2 429.1 576 413.3 576 397zM95.1 224c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C31.1 195.3 60.65 224 95.1 224z',
			),
		),
		'label'             => __( 'Person Swimming', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'person-through-window'                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M191.1 128C191.1 154.5 170.5 176 143.1 176C117.5 176 95.1 154.5 95.1 128C95.1 101.5 117.5 80 143.1 80C170.5 80 191.1 101.5 191.1 128zM385 336H310.5L394.6 462.2C404.4 476.1 400.5 496.8 385.8 506.6C371 516.4 351.2 512.5 341.4 497.8L308.2 448H48C21.49 448 0 426.5 0 400V48C0 21.49 21.49 0 48 0H592C618.5 0 640 21.49 640 48V400C640 426.5 618.5 448 592 448H421.9L379.2 384H425L385 336zM63.1 64V384H127.1C127.1 384 127.1 384 127.1 384V310.2C127.1 245 167.6 186.5 228.1 162.3C264.3 147.8 287.1 112.8 287.1 73.84V64H63.1zM352 64V73.84C352 128.5 324.1 178.5 279.5 207.4C279.8 207.9 280.1 208.4 280.4 208.9L321.4 271.1H392.5C406.8 271.1 420.3 278.3 429.4 289.3L508.3 384H576V64H352zM265.5 384L196.7 280.7C193.6 290 191.1 299.1 191.1 310.2V383.1C191.1 383.1 191.1 384 191.1 383.1L265.5 384z',
			),
		),
		'label'             => __( 'Person Through Window', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'person-walking'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M256 48C256 74.51 234.5 96 208 96C181.5 96 160 74.51 160 48C160 21.49 181.5 0 208 0C234.5 0 256 21.49 256 48zM126.5 199.3C125.6 199.7 124.6 200.1 123.7 200.5L112.7 205.4C97.41 212.2 85.42 224.6 79.22 240.1L77.71 243.9C71.15 260.3 52.53 268.3 36.12 261.7C19.71 255.1 11.73 236.5 18.29 220.1L19.8 216.3C32.19 185.4 56.18 160.5 86.66 146.9L97.66 142C118.5 132.8 140.1 128 163.7 128C208.3 128 248.5 154.8 265.6 195.9L280.1 232.7L302.3 243.4C318.1 251.3 324.5 270.5 316.6 286.3C308.7 302.1 289.5 308.5 273.7 300.6L247 287.3C236.7 282.1 228.6 273.4 224.2 262.8L214.6 239.8L195.3 305.3L244.8 359.4C250.2 365.3 254.1 372.4 256 380.2L279 472.2C283.3 489.4 272.9 506.8 255.8 511C238.6 515.3 221.2 504.9 216.1 487.8L194.9 399.6L124.3 322.5C109.5 306.4 103.1 283.9 109.6 262.8L126.5 199.3zM68.73 398L93.69 335.6C95.84 338.6 98.16 341.4 100.7 344.2L141.4 388.6L126.9 424.8C124.5 430.9 120.9 436.4 116.3 440.9L54.63 502.6C42.13 515.1 21.87 515.1 9.372 502.6C-3.124 490.1-3.124 469.9 9.372 457.4L68.73 398z',
			),
		),
		'label'             => __( 'Person Walking', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'person-walking-arrow-loop-left'         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M160 48C160 21.49 181.5 0 208 0C234.5 0 256 21.49 256 48C256 74.51 234.5 96 208 96C181.5 96 160 74.51 160 48V48zM112.7 205.4C97.41 212.2 85.42 224.6 79.22 240.1L77.71 243.9C71.15 260.3 52.53 268.3 36.12 261.7C19.71 255.1 11.73 236.5 18.29 220.1L19.8 216.3C32.19 185.4 56.18 160.5 86.66 146.9L97.66 142C118.5 132.8 140.1 128 163.7 128C208.3 128 248.5 154.8 265.6 195.9L280.1 232.7L302.3 243.4C318.1 251.3 324.5 270.5 316.6 286.3C308.7 302.1 289.5 308.5 273.7 300.6L247 287.3C236.7 282.1 228.6 273.4 224.2 262.8L214.6 239.8L195.3 305.3L244.8 359.4C250.2 365.3 254.1 372.4 256 380.2L279 472.2C283.3 489.4 272.9 506.8 255.8 511C238.6 515.3 221.2 504.9 216.1 487.8L194.9 399.6L124.3 322.5C109.5 306.4 103.1 283.9 109.6 262.8L126.5 199.3C125.6 199.7 124.6 200.1 123.7 200.5L112.7 205.4zM100.7 344.2L141.4 388.6L126.9 424.8C124.5 430.9 120.9 436.4 116.3 440.9L54.63 502.6C42.13 515.1 21.87 515.1 9.372 502.6C-3.124 490.1-3.124 469.9 9.372 457.4L68.73 398L93.69 335.6C95.84 338.6 98.17 341.4 100.7 344.2H100.7zM361.4 374.6C348.9 362.1 348.9 341.9 361.4 329.4L441.4 249.4C453.9 236.9 474.1 236.9 486.6 249.4C499.1 261.9 499.1 282.1 486.6 294.6L461.3 320H480C533 320 576 277 576 224C576 170.1 533 128 480 128H352C334.3 128 319.1 113.7 319.1 96C319.1 78.33 334.3 64 352 64H480C568.4 64 640 135.6 640 224C640 312.4 568.4 384 480 384H461.3L486.6 409.4C499.1 421.9 499.1 442.1 486.6 454.6C474.1 467.1 453.9 467.1 441.4 454.6L361.4 374.6z',
			),
		),
		'label'             => __( 'Person Walking Arrow Loop Left', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'person-walking-arrow-right'             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M160 48C160 21.49 181.5 0 208 0C234.5 0 256 21.49 256 48C256 74.51 234.5 96 208 96C181.5 96 160 74.51 160 48V48zM112.7 205.4C97.41 212.2 85.42 224.6 79.22 240.1L77.71 243.9C71.15 260.3 52.53 268.3 36.12 261.7C19.71 255.1 11.73 236.5 18.29 220.1L19.8 216.3C32.19 185.4 56.18 160.5 86.66 146.9L97.66 142C118.5 132.8 140.1 128 163.7 128C208.3 128 248.5 154.8 265.6 195.9L280.1 232.7L302.3 243.4C318.1 251.3 324.5 270.5 316.6 286.3C308.7 302.1 289.5 308.5 273.7 300.6L247 287.3C236.7 282.1 228.6 273.4 224.2 262.8L214.6 239.8L195.3 305.3L244.8 359.4C250.2 365.3 254.1 372.4 256 380.2L279 472.2C283.3 489.4 272.9 506.8 255.8 511C238.6 515.3 221.2 504.9 216.1 487.8L194.9 399.6L124.3 322.5C109.5 306.4 103.1 283.9 109.6 262.8L126.5 199.3C125.6 199.7 124.6 200.1 123.7 200.5L112.7 205.4zM100.7 344.2L141.4 388.6L126.9 424.8C124.5 430.9 120.9 436.4 116.3 440.9L54.63 502.6C42.13 515.1 21.87 515.1 9.372 502.6C-3.124 490.1-3.124 469.9 9.372 457.4L68.73 398L93.69 335.6C95.84 338.6 98.17 341.4 100.7 344.2H100.7zM630.6 233.4C643.1 245.9 643.1 266.1 630.6 278.6L550.6 358.6C538.1 371.1 517.9 371.1 505.4 358.6C492.9 346.1 492.9 325.9 505.4 313.4L530.7 288H384C366.3 288 352 273.7 352 256C352 238.3 366.3 224 384 224H530.7L505.4 198.6C492.9 186.1 492.9 165.9 505.4 153.4C517.9 140.9 538.1 140.9 550.6 153.4L630.6 233.4z',
			),
		),
		'label'             => __( 'Person Walking Arrow Right', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'person-walking-dashed-line-arrow-right' => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M160 48C160 21.49 181.5 0 208 0C234.5 0 256 21.49 256 48C256 74.51 234.5 96 208 96C181.5 96 160 74.51 160 48V48zM112.7 205.4C97.41 212.2 85.42 224.6 79.22 240.1L77.71 243.9C71.15 260.3 52.53 268.3 36.12 261.7C19.71 255.1 11.73 236.5 18.29 220.1L19.8 216.3C32.19 185.4 56.18 160.5 86.66 146.9L97.66 142C118.5 132.8 140.1 128 163.7 128C208.3 128 248.5 154.8 265.6 195.9L280.1 232.7L302.3 243.4C318.1 251.3 324.5 270.5 316.6 286.3C308.7 302.1 289.5 308.5 273.7 300.6L247 287.3C236.7 282.1 228.6 273.4 224.2 262.8L214.6 239.8L195.3 305.3L244.8 359.4C250.2 365.3 254.1 372.4 256 380.2L279 472.2C283.3 489.4 272.9 506.8 255.8 511C238.6 515.3 221.2 504.9 216.1 487.8L194.9 399.6L124.3 322.5C109.5 306.4 103.1 283.9 109.6 262.8L126.5 199.3C125.6 199.7 124.6 200.1 123.7 200.5L112.7 205.4zM100.7 344.2L141.4 388.6L126.9 424.8C124.5 430.9 120.9 436.4 116.3 440.9L54.63 502.6C42.13 515.1 21.87 515.1 9.372 502.6C-3.124 490.1-3.124 469.9 9.372 457.4L68.73 398L93.69 335.6C95.84 338.6 98.17 341.4 100.7 344.2H100.7zM630.6 233.4C643.1 245.9 643.1 266.1 630.6 278.6L550.6 358.6C538.1 371.1 517.9 371.1 505.4 358.6C492.9 346.1 492.9 325.9 505.4 313.4L530.7 288H384C366.3 288 352 273.7 352 256C352 238.3 366.3 224 384 224H530.7L505.4 198.6C492.9 186.1 492.9 165.9 505.4 153.4C517.9 140.9 538.1 140.9 550.6 153.4L630.6 233.4zM392 0C405.3 0 416 10.75 416 24V72C416 85.25 405.3 96 392 96C378.7 96 368 85.25 368 72V24C368 10.75 378.7 0 392 0zM416 168C416 181.3 405.3 192 392 192C378.7 192 368 181.3 368 168V152C368 138.7 378.7 128 392 128C405.3 128 416 138.7 416 152V168zM392 320C405.3 320 416 330.7 416 344V360C416 373.3 405.3 384 392 384C378.7 384 368 373.3 368 360V344C368 330.7 378.7 320 392 320zM416 488C416 501.3 405.3 512 392 512C378.7 512 368 501.3 368 488V440C368 426.7 378.7 416 392 416C405.3 416 416 426.7 416 440V488z',
			),
		),
		'label'             => __( 'Person Walking Dashed Line Arrow Right', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'person-walking-luggage'                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M352 48C352 21.49 373.5 0 400 0C426.5 0 448 21.49 448 48C448 74.51 426.5 96 400 96C373.5 96 352 74.51 352 48zM304.6 205.4C289.4 212.2 277.4 224.6 271.2 240.1L269.7 243.9C263.1 260.3 244.5 268.3 228.1 261.7C211.7 255.1 203.7 236.5 210.3 220.1L211.8 216.3C224.2 185.4 248.2 160.5 278.7 146.9L289.7 142C310.5 132.8 332.1 128 355.7 128C400.3 128 440.5 154.8 457.6 195.9L472.1 232.7L494.3 243.4C510.1 251.3 516.5 270.5 508.6 286.3C500.7 302.1 481.5 308.5 465.7 300.6L439 287.3C428.7 282.1 420.6 273.4 416.2 262.8L406.6 239.8L387.3 305.3L436.8 359.4C442.2 365.3 446.1 372.4 448 380.2L471 472.2C475.3 489.4 464.9 506.8 447.8 511C430.6 515.3 413.2 504.9 408.1 487.8L386.9 399.6L316.3 322.5C301.5 306.4 295.1 283.9 301.6 262.8L318.5 199.3C317.6 199.7 316.6 200.1 315.7 200.5L304.6 205.4zM292.7 344.2L333.4 388.6L318.9 424.8C316.5 430.9 312.9 436.4 308.3 440.9L246.6 502.6C234.1 515.1 213.9 515.1 201.4 502.6C188.9 490.1 188.9 469.9 201.4 457.4L260.7 398L285.7 335.6C287.8 338.6 290.2 341.4 292.7 344.2H292.7zM223.1 274.1C231.7 278.6 234.3 288.3 229.9 295.1L186.1 371.8C185.4 374.5 184.3 377.2 182.9 379.7L118.9 490.6C110 505.9 90.44 511.1 75.14 502.3L19.71 470.3C4.407 461.4-.8371 441.9 7.999 426.6L71.1 315.7C80.84 300.4 100.4 295.2 115.7 303.1L170.1 335.4L202.1 279.1C206.6 272.3 216.3 269.7 223.1 274.1H223.1z',
			),
		),
		'label'             => __( 'Person Walking Luggage', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'person-walking-with-cane'               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M445.2 486.1l-117.3-172.6c-3.002 4.529-6.646 8.652-11.12 12c-4.414 3.318-9.299 5.689-14.43 7.307l116.4 171.3c3.094 4.547 8.127 7.008 13.22 7.008c3.125 0 6.247-.8984 8.997-2.773C448.3 504.2 450.2 494.3 445.2 486.1zM143.1 95.1c26.51 0 48.01-21.49 48.01-47.1S170.5 0 144 0S96 21.49 96 48S117.5 95.1 143.1 95.1zM96.01 348.1l-31.03 124.2c-4.312 17.16 6.125 34.53 23.28 38.81C90.86 511.7 93.48 512 96.04 512c14.34 0 27.38-9.703 31-24.23l22.04-88.18L96.01 346.5V348.1zM313.6 268.8l-76.78-102.4C218.8 142.3 190.1 128 160 128L135.6 127.1c-36.59 0-69.5 20.33-85.87 53.06L3.387 273.7C-4.518 289.5 1.887 308.7 17.7 316.6c4.594 2.297 9.469 3.375 14.28 3.375c11.75 0 23.03-6.469 28.66-17.69l35.38-70.76v56.45c0 8.484 3.375 16.62 9.375 22.63l86.63 86.63v82.75c0 17.67 14.31 32 32 32c17.69 0 32-14.33 32-32v-82.75c0-17.09-6.656-33.16-18.75-45.25L192 306.8V213.3l70.38 93.88c10.59 14.11 30.62 16.98 44.78 6.406C321.3 303 324.2 282.9 313.6 268.8z',
			),
		),
		'label'             => __( 'Person Walking With Cane', 'astra' ),
		'custom_categories' => array(
			'design',
			'travel',
		),
	),
	'peseta-sign'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M192 32C269.4 32 333.1 86.97 348.8 160H352C369.7 160 384 174.3 384 192C384 209.7 369.7 224 352 224H348.8C333.1 297 269.4 352 192 352H96V448C96 465.7 81.67 480 64 480C46.33 480 32 465.7 32 448V224C14.33 224 0 209.7 0 192C0 174.3 14.33 160 32 160V64C32 46.33 46.33 32 64 32H192zM282.5 160C269.4 122.7 233.8 96 192 96H96V160H282.5zM96 224V288H192C233.8 288 269.4 261.3 282.5 224H96z',
			),
		),
		'label'             => __( 'Peseta Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'peso-sign'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M176 32C244.4 32 303.7 71.01 332.8 128H352C369.7 128 384 142.3 384 160C384 177.7 369.7 192 352 192H351.3C351.8 197.3 352 202.6 352 208C352 213.4 351.8 218.7 351.3 224H352C369.7 224 384 238.3 384 256C384 273.7 369.7 288 352 288H332.8C303.7 344.1 244.4 384 176 384H96V448C96 465.7 81.67 480 64 480C46.33 480 32 465.7 32 448V288C14.33 288 0 273.7 0 256C0 238.3 14.33 224 32 224V192C14.33 192 0 177.7 0 160C0 142.3 14.33 128 32 128V64C32 46.33 46.33 32 64 32H176zM254.4 128C234.2 108.2 206.5 96 176 96H96V128H254.4zM96 192V224H286.9C287.6 218.8 288 213.4 288 208C288 202.6 287.6 197.2 286.9 192H96zM254.4 288H96V320H176C206.5 320 234.2 307.8 254.4 288z',
			),
		),
		'label'             => __( 'Peso Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'phabricator'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M323 262.1l-.1-13s21.7-19.8 21.1-21.2l-9.5-20c-.6-1.4-29.5-.5-29.5-.5l-9.4-9.3s.2-28.5-1.2-29.1l-20.1-9.2c-1.4-.6-20.7 21-20.7 21l-13.1-.2s-20.5-21.4-21.9-20.8l-20 8.3c-1.4 .5 .2 28.9 .2 28.9l-9.1 9.1s-29.2-.9-29.7 .4l-8.1 19.8c-.6 1.4 21 21 21 21l.1 12.9s-21.7 19.8-21.1 21.2l9.5 20c.6 1.4 29.5 .5 29.5 .5l9.4 9.3s-.2 31.8 1.2 32.3l20.1 8.3c1.4 .6 20.7-23.5 20.7-23.5l13.1 .2s20.5 23.8 21.8 23.3l20-7.5c1.4-.6-.2-32.1-.2-32.1l9.1-9.1s29.2 .9 29.7-.5l8.1-19.8c.7-1.1-20.9-20.7-20.9-20.7zm-44.9-8.7c.7 17.1-12.8 31.6-30.1 32.4-17.3 .8-32.1-12.5-32.8-29.6-.7-17.1 12.8-31.6 30.1-32.3 17.3-.8 32.1 12.5 32.8 29.5zm201.2-37.9l-97-97-.1 .1c-75.1-73.3-195.4-72.8-269.8 1.6-50.9 51-27.8 27.9-95.7 95.3-22.3 22.3-22.3 58.7 0 81 69.9 69.4 46.4 46 97.4 97l.1-.1c75.1 73.3 195.4 72.9 269.8-1.6 51-50.9 27.9-27.9 95.3-95.3 22.3-22.3 22.3-58.7 0-81zM140.4 363.8c-59.6-59.5-59.6-156 0-215.5 59.5-59.6 156-59.5 215.6 0 59.5 59.5 59.6 156 0 215.6-59.6 59.5-156 59.4-215.6-.1z',
			),
		),
		'label'             => __( 'Phabricator', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'phoenix-framework'                      => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M212.9 344.3c3.8-.1 22.8-1.4 25.6-2.2-2.4-2.6-43.6-1-68-49.6-4.3-8.6-7.5-17.6-6.4-27.6 2.9-25.5 32.9-30 52-18.5 36 21.6 63.3 91.3 113.7 97.5 37 4.5 84.6-17 108.2-45.4-.6-.1-.8-.2-1-.1-.4 .1-.8 .2-1.1 .3-33.3 12.1-94.3 9.7-134.7-14.8-37.6-22.8-53.1-58.7-51.8-74.6 1.8-21.3 22.9-23.2 35.9-19.6 14.4 3.9 24.4 17.6 38.9 27.4 15.6 10.4 32.9 13.7 51.3 10.3 14.9-2.7 34.4-12.3 36.5-14.5-1.1-.1-1.8-.1-2.5-.2-6.2-.6-12.4-.8-18.5-1.7C279.8 194.5 262.1 47.4 138.5 37.9 94.2 34.5 39.1 46 2.2 72.9c-.8 .6-1.5 1.2-2.2 1.8 .1 .2 .1 .3 .2 .5 .8 0 1.6-.1 2.4-.2 6.3-1 12.5-.8 18.7 .3 23.8 4.3 47.7 23.1 55.9 76.5 5.3 34.3-.7 50.8 8 86.1 19 77.1 91 107.6 127.7 106.4zM75.3 64.9c-.9-1-.9-1.2-1.3-2 12.1-2.6 24.2-4.1 36.6-4.8-1.1 14.7-22.2 21.3-35.3 6.8zm196.9 350.5c-42.8 1.2-92-26.7-123.5-61.4-4.6-5-16.8-20.2-18.6-23.4l.4-.4c6.6 4.1 25.7 18.6 54.8 27 24.2 7 48.1 6.3 71.6-3.3 22.7-9.3 41-.5 43.1 2.9-18.5 3.8-20.1 4.4-24 7.9-5.1 4.4-4.6 11.7 7 17.2 26.2 12.4 63-2.8 97.2 25.4 2.4 2 8.1 7.8 10.1 10.7-.1 .2-.3 .3-.4 .5-4.8-1.5-16.4-7.5-40.2-9.3-24.7-2-46.3 5.3-77.5 6.2zm174.8-252c16.4-5.2 41.3-13.4 66.5-3.3 16.1 6.5 26.2 18.7 32.1 34.6 3.5 9.4 5.1 19.7 5.1 28.7-.2 0-.4 0-.6 .1-.2-.4-.4-.9-.5-1.3-5-22-29.9-43.8-67.6-29.9-50.2 18.6-130.4 9.7-176.9-48-.7-.9-2.4-1.7-1.3-3.2 .1-.2 2.1 .6 3 1.3 18.1 13.4 38.3 21.9 60.3 26.2 30.5 6.1 54.6 2.9 79.9-5.2zm102.7 117.5c-32.4 .2-33.8 50.1-103.6 64.4-18.2 3.7-38.7 4.6-44.9 4.2v-.4c2.8-1.5 14.7-2.6 29.7-16.6 7.9-7.3 15.3-15.1 22.8-22.9 19.5-20.2 41.4-42.2 81.9-39 23.1 1.8 29.3 8.2 36.1 12.7 .3 .2 .4 .5 .7 .9-.5 0-.7 .1-.9 0-7-2.7-14.3-3.3-21.8-3.3zm-12.3-24.1c-.1 .2-.1 .4-.2 .6-28.9-4.4-48-7.9-68.5 4-17 9.9-31.4 20.5-62 24.4-27.1 3.4-45.1 2.4-66.1-8-.3-.2-.6-.4-1-.6 0-.2 .1-.3 .1-.5 24.9 3.8 36.4 5.1 55.5-5.8 22.3-12.9 40.1-26.6 71.3-31 29.6-4.1 51.3 2.5 70.9 16.9zM268.6 97.3c-.6-.6-1.1-1.2-2.1-2.3 7.6 0 29.7-1.2 53.4 8.4 19.7 8 32.2 21 50.2 32.9 11.1 7.3 23.4 9.3 36.4 8.1 4.3-.4 8.5-1.2 12.8-1.7 .4-.1 .9 0 1.5 .3-.6 .4-1.2 .9-1.8 1.2-8.1 4-16.7 6.3-25.6 7.1-26.1 2.6-50.3-3.7-73.4-15.4-19.3-9.9-36.4-22.9-51.4-38.6zM640 335.7c-3.5 3.1-22.7 11.6-42.7 5.3-12.3-3.9-19.5-14.9-31.6-24.1-10-7.6-20.9-7.9-28.1-8.4 .6-.8 .9-1.2 1.2-1.4 14.8-9.2 30.5-12.2 47.3-6.5 12.5 4.2 19.2 13.5 30.4 24.2 10.8 10.4 21 9.9 23.1 10.5 .1-.1 .2 0 .4 .4zm-212.5 137c2.2 1.2 1.6 1.5 1.5 2-18.5-1.4-33.9-7.6-46.8-22.2-21.8-24.7-41.7-27.9-48.6-29.7 .5-.2 .8-.4 1.1-.4 13.1 .1 26.1 .7 38.9 3.9 25.3 6.4 35 25.4 41.6 35.3 3.2 4.8 7.3 8.3 12.3 11.1z',
			),
		),
		'label'             => __( 'Phoenix Framework', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'phoenix-squadron'                       => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M96 63.38C142.5 27.25 201.6 7.31 260.5 8.81c29.58-.38 59.11 5.37 86.91 15.33-24.13-4.63-49-6.34-73.38-2.45C231.2 27 191 48.84 162.2 80.87c5.67-1 10.78-3.67 16-5.86 18.14-7.87 37.49-13.26 57.23-14.83 19.74-2.13 39.64-.43 59.28 1.92-14.42 2.79-29.12 4.57-43 9.59-34.43 11.07-65.27 33.16-86.3 62.63-13.8 19.71-23.63 42.86-24.67 67.13-.35 16.49 5.22 34.81 19.83 44a53.27 53.27 0 0 0 37.52 6.74c15.45-2.46 30.07-8.64 43.6-16.33 11.52-6.82 22.67-14.55 32-24.25 3.79-3.22 2.53-8.45 2.62-12.79-2.12-.34-4.38-1.11-6.3 .3a203 203 0 0 1 -35.82 15.37c-20 6.17-42.16 8.46-62.1 .78 12.79 1.73 26.06 .31 37.74-5.44 20.23-9.72 36.81-25.2 54.44-38.77a526.6 526.6 0 0 1 88.9-55.31c25.71-12 52.94-22.78 81.57-24.12-15.63 13.72-32.15 26.52-46.78 41.38-14.51 14-27.46 29.5-40.11 45.18-3.52 4.6-8.95 6.94-13.58 10.16a150.7 150.7 0 0 0 -51.89 60.1c-9.33 19.68-14.5 41.85-11.77 63.65 1.94 13.69 8.71 27.59 20.9 34.91 12.9 8 29.05 8.07 43.48 5.1 32.8-7.45 61.43-28.89 81-55.84 20.44-27.52 30.52-62.2 29.16-96.35-.52-7.5-1.57-15-1.66-22.49 8 19.48 14.82 39.71 16.65 60.83 2 14.28 .75 28.76-1.62 42.9-1.91 11-5.67 21.51-7.78 32.43a165 165 0 0 0 39.34-81.07 183.6 183.6 0 0 0 -14.21-104.6c20.78 32 32.34 69.58 35.71 107.5 .49 12.73 .49 25.51 0 38.23A243.2 243.2 0 0 1 482 371.3c-26.12 47.34-68 85.63-117.2 108-78.29 36.23-174.7 31.32-248-14.68A248.3 248.3 0 0 1 25.36 366 238.3 238.3 0 0 1 0 273.1v-31.34C3.93 172 40.87 105.8 96 63.38m222 80.33a79.13 79.13 0 0 0 16-4.48c5-1.77 9.24-5.94 10.32-11.22-8.96 4.99-17.98 9.92-26.32 15.7z',
			),
		),
		'label'             => __( 'Phoenix Squadron', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'phone'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M511.2 387l-23.25 100.8c-3.266 14.25-15.79 24.22-30.46 24.22C205.2 512 0 306.8 0 54.5c0-14.66 9.969-27.2 24.22-30.45l100.8-23.25C139.7-2.602 154.7 5.018 160.8 18.92l46.52 108.5c5.438 12.78 1.77 27.67-8.98 36.45L144.5 207.1c33.98 69.22 90.26 125.5 159.5 159.5l44.08-53.8c8.688-10.78 23.69-14.51 36.47-8.975l108.5 46.51C506.1 357.2 514.6 372.4 511.2 387z',
			),
		),
		'label'             => __( 'Phone', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'travel',
		),
	),
	'phone-flip'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M18.92 351.2l108.5-46.52c12.78-5.531 27.77-1.801 36.45 8.98l44.09 53.82c69.25-34 125.5-90.31 159.5-159.5l-53.81-44.04c-10.75-8.781-14.41-23.69-8.974-36.47l46.51-108.5c6.094-13.91 21.1-21.52 35.79-18.11l100.8 23.25c14.25 3.25 24.22 15.8 24.22 30.46c0 252.3-205.2 457.5-457.5 457.5c-14.67 0-27.18-9.968-30.45-24.22l-23.25-100.8C-2.571 372.4 5.018 357.2 18.92 351.2z',
			),
		),
		'label'             => __( 'Phone Flip', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'travel',
		),
	),
	'phone-slash'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M271.1 367.5L227.9 313.7c-8.688-10.78-23.69-14.51-36.47-8.974l-108.5 46.51c-13.91 6-21.49 21.19-18.11 35.79l23.25 100.8C91.32 502 103.8 512 118.5 512c107.4 0 206.1-37.46 284.2-99.65l-88.75-69.56C300.6 351.9 286.6 360.3 271.1 367.5zM630.8 469.1l-159.6-125.1c65.03-78.97 104.7-179.5 104.7-289.5c0-14.66-9.969-27.2-24.22-30.45L451 .8125c-14.69-3.406-29.73 4.213-35.82 18.12l-46.52 108.5c-5.438 12.78-1.771 27.67 8.979 36.45l53.82 44.08C419.2 232.1 403.9 256.2 386.2 277.4L38.81 5.111C34.41 1.673 29.19 0 24.03 0C16.91 0 9.84 3.158 5.121 9.189c-8.188 10.44-6.37 25.53 4.068 33.7l591.1 463.1c10.5 8.203 25.57 6.328 33.69-4.078C643.1 492.4 641.2 477.3 630.8 469.1z',
			),
		),
		'label'             => __( 'Phone Slash', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
		),
	),
	'phone-volume'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M284.6 181.9c-10.28-8.344-25.41-6.875-33.75 3.406C242.4 195.6 243.9 210.7 254.2 219.1c11.31 9.25 17.81 22.69 17.81 36.87c0 14.19-6.5 27.62-17.81 36.87c-10.28 8.406-11.78 23.53-3.375 33.78c4.719 5.812 11.62 8.812 18.56 8.812c5.344 0 10.75-1.781 15.19-5.406c22.53-18.44 35.44-45.4 35.44-74.05S307.1 200.4 284.6 181.9zM345.1 107.1c-10.22-8.344-25.34-6.907-33.78 3.343c-8.406 10.25-6.906 25.37 3.344 33.78c33.88 27.78 53.31 68.18 53.31 110.9s-19.44 83.09-53.31 110.9c-10.25 8.406-11.75 23.53-3.344 33.78c4.75 5.781 11.62 8.781 18.56 8.781c5.375 0 10.75-1.781 15.22-5.438C390.2 367.1 416 313.1 416 255.1S390.2 144.9 345.1 107.1zM406.4 33.15c-10.22-8.344-25.34-6.875-33.78 3.344c-8.406 10.25-6.906 25.37 3.344 33.78C431.9 116.1 464 183.8 464 255.1s-32.09 139.9-88.06 185.7c-10.25 8.406-11.75 23.53-3.344 33.78c4.75 5.781 11.62 8.781 18.56 8.781c5.375 0 10.75-1.781 15.22-5.438C473.5 423.8 512 342.6 512 255.1S473.5 88.15 406.4 33.15zM151.3 174.6C161.1 175.6 172.1 169.5 176 159.6l33.75-84.38C214 64.35 209.1 51.1 200.2 45.86l-67.47-42.17C123.2-2.289 110.9-.8945 102.9 7.08C-34.32 144.3-34.31 367.7 102.9 504.9c7.982 7.984 20.22 9.379 29.75 3.402l67.48-42.19c9.775-6.104 13.9-18.47 9.598-29.3L176 352.5c-3.945-9.963-14.14-16.11-24.73-14.97l-53.24 5.314C78.89 286.7 78.89 225.4 98.06 169.3L151.3 174.6z',
			),
		),
		'label'             => __( 'Phone Volume', 'astra' ),
		'custom_categories' => array(
			'business',
			'communication',
			'design',
			'science-and-technology',
			'travel',
		),
	),
	'photo-film'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M352 432c0 8.836-7.164 16-16 16H176c-8.838 0-16-7.164-16-16L160 128H48C21.49 128 .0003 149.5 .0003 176v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48L512 384h-160L352 432zM104 439c0 4.969-4.031 9-9 9h-30c-4.969 0-9-4.031-9-9v-30c0-4.969 4.031-9 9-9h30c4.969 0 9 4.031 9 9V439zM104 335c0 4.969-4.031 9-9 9h-30c-4.969 0-9-4.031-9-9v-30c0-4.969 4.031-9 9-9h30c4.969 0 9 4.031 9 9V335zM104 231c0 4.969-4.031 9-9 9h-30c-4.969 0-9-4.031-9-9v-30C56 196 60.03 192 65 192h30c4.969 0 9 4.031 9 9V231zM408 409c0-4.969 4.031-9 9-9h30c4.969 0 9 4.031 9 9v30c0 4.969-4.031 9-9 9h-30c-4.969 0-9-4.031-9-9V409zM591.1 0H239.1C213.5 0 191.1 21.49 191.1 48v256c0 26.51 21.49 48 48 48h352c26.51 0 48-21.49 48-48v-256C640 21.49 618.5 0 591.1 0zM303.1 64c17.68 0 32 14.33 32 32s-14.32 32-32 32C286.3 128 271.1 113.7 271.1 96S286.3 64 303.1 64zM574.1 279.6C571.3 284.8 565.9 288 560 288H271.1C265.1 288 260.5 284.6 257.7 279.3C255 273.9 255.5 267.4 259.1 262.6l70-96C332.1 162.4 336.9 160 341.1 160c5.11 0 9.914 2.441 12.93 6.574l22.35 30.66l62.74-94.11C442.1 98.67 447.1 96 453.3 96c5.348 0 10.34 2.672 13.31 7.125l106.7 160C576.6 268 576.9 274.3 574.1 279.6z',
			),
		),
		'label'             => __( 'Photo Film', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'social',
		),
	),
	'php'                                    => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320 104.5c171.4 0 303.2 72.2 303.2 151.5S491.3 407.5 320 407.5c-171.4 0-303.2-72.2-303.2-151.5S148.7 104.5 320 104.5m0-16.8C143.3 87.7 0 163 0 256s143.3 168.3 320 168.3S640 349 640 256 496.7 87.7 320 87.7zM218.2 242.5c-7.9 40.5-35.8 36.3-70.1 36.3l13.7-70.6c38 0 63.8-4.1 56.4 34.3zM97.4 350.3h36.7l8.7-44.8c41.1 0 66.6 3 90.2-19.1 26.1-24 32.9-66.7 14.3-88.1-9.7-11.2-25.3-16.7-46.5-16.7h-70.7L97.4 350.3zm185.7-213.6h36.5l-8.7 44.8c31.5 0 60.7-2.3 74.8 10.7 14.8 13.6 7.7 31-8.3 113.1h-37c15.4-79.4 18.3-86 12.7-92-5.4-5.8-17.7-4.6-47.4-4.6l-18.8 96.6h-36.5l32.7-168.6zM505 242.5c-8 41.1-36.7 36.3-70.1 36.3l13.7-70.6c38.2 0 63.8-4.1 56.4 34.3zM384.2 350.3H421l8.7-44.8c43.2 0 67.1 2.5 90.2-19.1 26.1-24 32.9-66.7 14.3-88.1-9.7-11.2-25.3-16.7-46.5-16.7H417l-32.8 168.7z',
			),
		),
		'label'             => __( 'PHP', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'pied-piper'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 480,
				'height' => 512,
				'path'   => 'M455.9 23.2C429.2 30 387.8 51.69 341.4 90.66A206 206 0 0 0 240 64C125.1 64 32 157.1 32 272s93.13 208 208 208 208-93.13 208-208a207.3 207.3 0 0 0 -58.75-144.8 155.4 155.4 0 0 0 -17 27.4A176.2 176.2 0 0 1 417.1 272c0 97.66-79.44 177.1-177.1 177.1a175.8 175.8 0 0 1 -87.63-23.4c82.94-107.3 150.8-37.77 184.3-226.6 5.79-32.62 28-94.26 126.2-160.2C471 33.45 465.4 20.8 455.9 23.2zM125 406.4A176.7 176.7 0 0 1 62.9 272C62.9 174.3 142.4 94.9 240 94.9a174 174 0 0 1 76.63 17.75C250.6 174.8 189.8 265.5 125 406.4z',
			),
		),
		'label'             => __( 'Pied Piper Logo', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'pied-piper-alt'                         => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M244 246c-3.2-2-6.3-2.9-10.1-2.9-6.6 0-12.6 3.2-19.3 3.7l1.7 4.9zm135.9 197.9c-19 0-64.1 9.5-79.9 19.8l6.9 45.1c35.7 6.1 70.1 3.6 106-9.8-4.8-10-23.5-55.1-33-55.1zM340.8 177c6.6 2.8 11.5 9.2 22.7 22.1 2-1.4 7.5-5.2 7.5-8.6 0-4.9-11.8-13.2-13.2-23 11.2-5.7 25.2-6 37.6-8.9 68.1-16.4 116.3-52.9 146.8-116.7C548.3 29.3 554 16.1 554.6 2l-2 2.6c-28.4 50-33 63.2-81.3 100-31.9 24.4-69.2 40.2-106.6 54.6l-6.3-.3v-21.8c-19.6 1.6-19.7-14.6-31.6-23-18.7 20.6-31.6 40.8-58.9 51.1-12.7 4.8-19.6 10-25.9 21.8 34.9-16.4 91.2-13.5 98.8-10zM555.5 0l-.6 1.1-.3 .9 .6-.6zm-59.2 382.1c-33.9-56.9-75.3-118.4-150-115.5l-.3-6c-1.1-13.5 32.8 3.2 35.1-31l-14.4 7.2c-19.8-45.7-8.6-54.3-65.5-54.3-14.7 0-26.7 1.7-41.4 4.6 2.9 18.6 2.2 36.7-10.9 50.3l19.5 5.5c-1.7 3.2-2.9 6.3-2.9 9.8 0 21 42.8 2.9 42.8 33.6 0 18.4-36.8 60.1-54.9 60.1-8 0-53.7-50-53.4-60.1l.3-4.6 52.3-11.5c13-2.6 12.3-22.7-2.9-22.7-3.7 0-43.1 9.2-49.4 10.6-2-5.2-7.5-14.1-13.8-14.1-3.2 0-6.3 3.2-9.5 4-9.2 2.6-31 2.9-21.5 20.1L15.9 298.5c-5.5 1.1-8.9 6.3-8.9 11.8 0 6 5.5 10.9 11.5 10.9 8 0 131.3-28.4 147.4-32.2 2.6 3.2 4.6 6.3 7.8 8.6 20.1 14.4 59.8 85.9 76.4 85.9 24.1 0 58-22.4 71.3-41.9 3.2-4.3 6.9-7.5 12.4-6.9 .6 13.8-31.6 34.2-33 43.7-1.4 10.2-1 35.2-.3 41.1 26.7 8.1 52-3.6 77.9-2.9 4.3-21 10.6-41.9 9.8-63.5l-.3-9.5c-1.4-34.2-10.9-38.5-34.8-58.6-1.1-1.1-2.6-2.6-3.7-4 2.2-1.4 1.1-1 4.6-1.7 88.5 0 56.3 183.6 111.5 229.9 33.1-15 72.5-27.9 103.5-47.2-29-25.6-52.6-45.7-72.7-79.9zm-196.2 46.1v27.2l11.8-3.4-2.9-23.8zm-68.7-150.4l24.1 61.2 21-13.8-31.3-50.9zm84.4 154.9l2 12.4c9-1.5 58.4-6.6 58.4-14.1 0-1.4-.6-3.2-.9-4.6-26.8 0-36.9 3.8-59.5 6.3z',
			),
		),
		'label'             => __( 'Alternate Pied Piper Logo (Old)', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'pied-piper-hat'                         => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M640 24.9c-80.8 53.6-89.4 92.5-96.4 104.4-6.7 12.2-11.7 60.3-23.3 83.6-11.7 23.6-54.2 42.2-66.1 50-11.7 7.8-28.3 38.1-41.9 64.2-108.1-4.4-167.4 38.8-259.2 93.6 29.4-9.7 43.3-16.7 43.3-16.7 94.2-36 139.3-68.3 281.1-49.2 1.1 0 1.9 .6 2.8 .8 3.9 2.2 5.3 6.9 3.1 10.8l-53.9 95.8c-2.5 4.7-7.8 7.2-13.1 6.1-126.8-23.8-226.9 17.3-318.9 18.6C24.1 488 0 453.4 0 451.8c0-1.1 .6-1.7 1.7-1.7 0 0 38.3 0 103.1-15.3C178.4 294.5 244 245.4 315.4 245.4c0 0 71.7 0 90.6 61.9 22.8-39.7 28.3-49.2 28.3-49.2 5.3-9.4 35-77.2 86.4-141.4 51.5-64 90.4-79.9 119.3-91.8z',
			),
		),
		'label'             => __( 'Pied Piper Hat (Old)', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'pied-piper-pp'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M205.3 174.6c0 21.1-14.2 38.1-31.7 38.1-7.1 0-12.8-1.2-17.2-3.7v-68c4.4-2.7 10.1-4.2 17.2-4.2 17.5 0 31.7 16.9 31.7 37.8zm52.6 67c-7.1 0-12.8 1.5-17.2 4.2v68c4.4 2.5 10.1 3.7 17.2 3.7 17.4 0 31.7-16.9 31.7-37.8 0-21.1-14.3-38.1-31.7-38.1zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zM185 255.1c41 0 74.2-35.6 74.2-79.6 0-44-33.2-79.6-74.2-79.6-12 0-24.1 3.2-34.6 8.8h-45.7V311l51.8-10.1v-50.6c8.6 3.1 18.1 4.8 28.5 4.8zm158.4 25.3c0-44-33.2-79.6-73.9-79.6-3.2 0-6.4 .2-9.6 .7-3.7 12.5-10.1 23.8-19.2 33.4-13.8 15-32.2 23.8-51.8 24.8V416l51.8-10.1v-50.6c8.6 3.2 18.2 4.7 28.7 4.7 40.8 0 74-35.6 74-79.6z',
			),
		),
		'label'             => __( 'Pied Piper PP Logo (Old)', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'pied-piper-square'                      => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M32 419L0 479.2l.8-328C.8 85.3 54 32 120 32h327.2c-93 28.9-189.9 94.2-253.9 168.6C122.7 282 82.6 338 32 419M448 32S305.2 98.8 261.6 199.1c-23.2 53.6-28.9 118.1-71 158.6-28.9 27.8-69.8 38.2-105.3 56.3-23.2 12-66.4 40.5-84.9 66h328.4c66 0 119.3-53.3 119.3-119.2-.1 0-.1-328.8-.1-328.8z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'piggy-bank'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M400 96L399.1 96.66C394.7 96.22 389.4 96 384 96H256C239.5 96 223.5 98.08 208.2 102C208.1 100 208 98.02 208 96C208 42.98 250.1 0 304 0C357 0 400 42.98 400 96zM384 128C387.5 128 390.1 128.1 394.4 128.3C398.7 128.6 402.9 129 407 129.6C424.6 109.1 450.8 96 480 96H512L493.2 171.1C509.1 185.9 521.9 203.9 530.7 224H544C561.7 224 576 238.3 576 256V352C576 369.7 561.7 384 544 384H512C502.9 396.1 492.1 406.9 480 416V480C480 497.7 465.7 512 448 512H416C398.3 512 384 497.7 384 480V448H256V480C256 497.7 241.7 512 224 512H192C174.3 512 160 497.7 160 480V416C125.1 389.8 101.3 349.8 96.79 304H68C30.44 304 0 273.6 0 236C0 198.4 30.44 168 68 168H72C85.25 168 96 178.7 96 192C96 205.3 85.25 216 72 216H68C56.95 216 48 224.1 48 236C48 247 56.95 256 68 256H99.2C111.3 196.2 156.9 148.5 215.5 133.2C228.4 129.8 241.1 128 256 128H384zM424 240C410.7 240 400 250.7 400 264C400 277.3 410.7 288 424 288C437.3 288 448 277.3 448 264C448 250.7 437.3 240 424 240z',
			),
		),
		'label'             => __( 'Piggy Bank', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'pills'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M112 32C50.12 32 0 82.12 0 143.1v223.1c0 61.88 50.12 111.1 112 111.1s112-50.12 112-111.1V143.1C224 82.12 173.9 32 112 32zM160 256H64V144c0-26.5 21.5-48 48-48s48 21.5 48 48V256zM299.8 226.2c-3.5-3.5-9.5-3-12.38 .875c-45.25 62.5-40.38 150.1 15.88 206.4c56.38 56.25 144 61.25 206.5 15.88c4-2.875 4.249-8.75 .75-12.25L299.8 226.2zM529.5 207.2c-56.25-56.25-143.9-61.13-206.4-15.87c-4 2.875-4.375 8.875-.875 12.38l210.9 210.7c3.5 3.5 9.375 3.125 12.25-.75C590.8 351.1 585.9 263.6 529.5 207.2z',
			),
		),
		'label'             => __( 'Pills', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'pinterest'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M496 256c0 137-111 248-248 248-25.6 0-50.2-3.9-73.4-11.1 10.1-16.5 25.2-43.5 30.8-65 3-11.6 15.4-59 15.4-59 8.1 15.4 31.7 28.5 56.8 28.5 74.8 0 128.7-68.8 128.7-154.3 0-81.9-66.9-143.2-152.9-143.2-107 0-163.9 71.8-163.9 150.1 0 36.4 19.4 81.7 50.3 96.1 4.7 2.2 7.2 1.2 8.3-3.3 .8-3.4 5-20.3 6.9-28.1 .6-2.5 .3-4.7-1.7-7.1-10.1-12.5-18.3-35.3-18.3-56.6 0-54.7 41.4-107.6 112-107.6 60.9 0 103.6 41.5 103.6 100.9 0 67.1-33.9 113.6-78 113.6-24.3 0-42.6-20.1-36.7-44.8 7-29.5 20.5-61.3 20.5-82.6 0-19-10.2-34.9-31.4-34.9-24.9 0-44.9 25.7-44.9 60.2 0 22 7.4 36.8 7.4 36.8s-24.5 103.8-29 123.2c-5 21.4-3 51.6-.9 71.2C65.4 450.9 0 361.1 0 256 0 119 111 8 248 8s248 111 248 248z',
			),
		),
		'label'             => __( 'Pinterest', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'pinterest-p'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M204 6.5C101.4 6.5 0 74.9 0 185.6 0 256 39.6 296 63.6 296c9.9 0 15.6-27.6 15.6-35.4 0-9.3-23.7-29.1-23.7-67.8 0-80.4 61.2-137.4 140.4-137.4 68.1 0 118.5 38.7 118.5 109.8 0 53.1-21.3 152.7-90.3 152.7-24.9 0-46.2-18-46.2-43.8 0-37.8 26.4-74.4 26.4-113.4 0-66.2-93.9-54.2-93.9 25.8 0 16.8 2.1 35.4 9.6 50.7-13.8 59.4-42 147.9-42 209.1 0 18.9 2.7 37.5 4.5 56.4 3.4 3.8 1.7 3.4 6.9 1.5 50.4-69 48.6-82.5 71.4-172.8 12.3 23.4 44.1 36 69.3 36 106.2 0 153.9-103.5 153.9-196.8C384 71.3 298.2 6.5 204 6.5z',
			),
		),
		'label'             => __( 'Pinterest P', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'pinterest-square'                       => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M448 80v352c0 26.5-21.5 48-48 48H154.4c9.8-16.4 22.4-40 27.4-59.3 3-11.5 15.3-58.4 15.3-58.4 8 15.3 31.4 28.2 56.3 28.2 74.1 0 127.4-68.1 127.4-152.7 0-81.1-66.2-141.8-151.4-141.8-106 0-162.2 71.1-162.2 148.6 0 36 19.2 80.8 49.8 95.1 4.7 2.2 7.1 1.2 8.2-3.3 .8-3.4 5-20.1 6.8-27.8 .6-2.5 .3-4.6-1.7-7-10.1-12.3-18.3-34.9-18.3-56 0-54.2 41-106.6 110.9-106.6 60.3 0 102.6 41.1 102.6 99.9 0 66.4-33.5 112.4-77.2 112.4-24.1 0-42.1-19.9-36.4-44.4 6.9-29.2 20.3-60.7 20.3-81.8 0-53-75.5-45.7-75.5 25 0 21.7 7.3 36.5 7.3 36.5-31.4 132.8-36.1 134.5-29.6 192.6l2.2 .8H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'pix'                                    => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M242.4 292.5C247.8 287.1 257.1 287.1 262.5 292.5L339.5 369.5C353.7 383.7 372.6 391.5 392.6 391.5H407.7L310.6 488.6C280.3 518.1 231.1 518.1 200.8 488.6L103.3 391.2H112.6C132.6 391.2 151.5 383.4 165.7 369.2L242.4 292.5zM262.5 218.9C256.1 224.4 247.9 224.5 242.4 218.9L165.7 142.2C151.5 127.1 132.6 120.2 112.6 120.2H103.3L200.7 22.76C231.1-7.586 280.3-7.586 310.6 22.76L407.8 119.9H392.6C372.6 119.9 353.7 127.7 339.5 141.9L262.5 218.9zM112.6 142.7C126.4 142.7 139.1 148.3 149.7 158.1L226.4 234.8C233.6 241.1 243 245.6 252.5 245.6C261.9 245.6 271.3 241.1 278.5 234.8L355.5 157.8C365.3 148.1 378.8 142.5 392.6 142.5H430.3L488.6 200.8C518.9 231.1 518.9 280.3 488.6 310.6L430.3 368.9H392.6C378.8 368.9 365.3 363.3 355.5 353.5L278.5 276.5C264.6 262.6 240.3 262.6 226.4 276.6L149.7 353.2C139.1 363 126.4 368.6 112.6 368.6H80.78L22.76 310.6C-7.586 280.3-7.586 231.1 22.76 200.8L80.78 142.7H112.6z',
			),
		),
		'label'             => __( 'Pix', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'pizza-slice'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M100.4 112.3L.5101 491.7c-1.375 5.625 .1622 11.6 4.287 15.6c4.127 4.125 10.13 5.744 15.63 4.119l379.1-105.1C395.3 231.4 276.5 114.1 100.4 112.3zM127.1 416c-17.62 0-32-14.38-32-31.1c0-17.62 14.39-32 32.01-32c17.63 0 32 14.38 32 31.1C160 401.6 145.6 416 127.1 416zM175.1 271.1c-17.63 0-32-14.38-32-32c0-17.62 14.38-31.1 32-31.1c17.62 0 32 14.38 32 31.1C208 257.6 193.6 271.1 175.1 271.1zM272 367.1c-17.62 0-32-14.38-32-31.1c0-17.62 14.38-32 32-32c17.63 0 32 14.38 32 32C304 353.6 289.6 367.1 272 367.1zM158.9 .1406c-16.13-1.5-31.25 8.501-35.38 24.12L108.7 80.52c187.6 5.5 314.5 130.6 322.5 316.1l56.88-15.75c15.75-4.375 25.5-19.62 23.63-35.87C490.9 165.1 340.8 17.39 158.9 .1406z',
			),
		),
		'label'             => __( 'Pizza Slice', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'place-of-worship'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M233.4 86.63L308.7 11.32C314.9 5.067 325.1 5.067 331.3 11.32L406.6 86.63C412.6 92.63 416 100.8 416 109.3V217.6L456.7 242C471.2 250.7 480 266.3 480 283.2V512H384V416C384 380.7 355.3 352 319.1 352C284.7 352 255.1 380.7 255.1 416V512H159.1V283.2C159.1 266.3 168.8 250.7 183.3 242L223.1 217.6V109.3C223.1 100.8 227.4 92.63 233.4 86.63H233.4zM24.87 330.3L128 273.6V512H48C21.49 512 0 490.5 0 464V372.4C0 354.9 9.53 338.8 24.87 330.3V330.3zM592 512H512V273.6L615.1 330.3C630.5 338.8 640 354.9 640 372.4V464C640 490.5 618.5 512 592 512V512z',
			),
		),
		'label'             => __( 'Place Of Worship', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'plane'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M482.3 192C516.5 192 576 221 576 256C576 292 516.5 320 482.3 320H365.7L265.2 495.9C259.5 505.8 248.9 512 237.4 512H181.2C170.6 512 162.9 501.8 165.8 491.6L214.9 320H112L68.8 377.6C65.78 381.6 61.04 384 56 384H14.03C6.284 384 0 377.7 0 369.1C0 368.7 .1818 367.4 .5398 366.1L32 256L.5398 145.9C.1818 144.6 0 143.3 0 142C0 134.3 6.284 128 14.03 128H56C61.04 128 65.78 130.4 68.8 134.4L112 192H214.9L165.8 20.4C162.9 10.17 170.6 0 181.2 0H237.4C248.9 0 259.5 6.153 265.2 16.12L365.7 192H482.3z',
			),
		),
		'label'             => __( 'Plane', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'plane-arrival'                          => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M.2528 166.9L.0426 67.99C.0208 57.74 9.508 50.11 19.51 52.34L55.07 60.24C65.63 62.58 74.29 70.11 78.09 80.24L95.1 127.1L223.3 165.6L181.8 20.4C178.9 10.18 186.6 .001 197.2 .001H237.3C248.8 .001 259.5 6.236 265.2 16.31L374.2 210.2L481.5 241.8C497.4 246.5 512.2 254.3 525.2 264.7L559.6 292.2C583.7 311.4 577.7 349.5 548.9 360.5C507.7 376.1 462.7 378.5 420.1 367.4L121.7 289.8C110.6 286.9 100.5 281.1 92.4 272.9L9.536 189.4C3.606 183.4 .2707 175.3 .2528 166.9V166.9zM608 448C625.7 448 640 462.3 640 480C640 497.7 625.7 512 608 512H32C14.33 512 0 497.7 0 480C0 462.3 14.33 448 32 448H608zM192 368C192 385.7 177.7 400 160 400C142.3 400 128 385.7 128 368C128 350.3 142.3 336 160 336C177.7 336 192 350.3 192 368zM224 384C224 366.3 238.3 352 256 352C273.7 352 288 366.3 288 384C288 401.7 273.7 416 256 416C238.3 416 224 401.7 224 384z',
			),
		),
		'label'             => __( 'Plane Arrival', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'plane-circle-check'                     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320 93.68V178.3L397.1 222.4C350.6 254 320 307.4 320 368C320 422.2 344.5 470.7 383.1 502.1C381 508.3 375.9 512 369.1 512C368.7 512 367.4 511.8 366.1 511.5L256 480L145.9 511.5C144.6 511.8 143.3 512 142 512C134.3 512 128 505.7 128 497.1V456C128 450.1 130.4 446.2 134.4 443.2L192 400V329.1L20.4 378.2C10.17 381.1 0 373.4 0 362.8V297.3C0 291.5 3.076 286.2 8.062 283.4L192 178.3V93.68C192 59.53 221 0 256 0C292 0 320 59.53 320 93.68H320zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM540.7 324.7L480 385.4L451.3 356.7C445.1 350.4 434.9 350.4 428.7 356.7C422.4 362.9 422.4 373.1 428.7 379.3L468.7 419.3C474.9 425.6 485.1 425.6 491.3 419.3L563.3 347.3C569.6 341.1 569.6 330.9 563.3 324.7C557.1 318.4 546.9 318.4 540.7 324.7H540.7z',
			),
		),
		'label'             => __( 'Plane Circle Check', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'plane-circle-exclamation'               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320 93.68V178.3L397.1 222.4C350.6 254 320 307.4 320 368C320 422.2 344.5 470.7 383.1 502.1C381 508.3 375.9 512 369.1 512C368.7 512 367.4 511.8 366.1 511.5L256 480L145.9 511.5C144.6 511.8 143.3 512 142 512C134.3 512 128 505.7 128 497.1V456C128 450.1 130.4 446.2 134.4 443.2L192 400V329.1L20.4 378.2C10.17 381.1 0 373.4 0 362.8V297.3C0 291.5 3.076 286.2 8.062 283.4L192 178.3V93.68C192 59.53 221 0 256 0C292 0 320 59.53 320 93.68H320zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 464C509.3 464 520 453.3 520 440C520 426.7 509.3 416 496 416C482.7 416 472 426.7 472 440C472 453.3 482.7 464 496 464zM479.1 288V368C479.1 376.8 487.2 384 495.1 384C504.8 384 511.1 376.8 511.1 368V288C511.1 279.2 504.8 272 495.1 272C487.2 272 479.1 279.2 479.1 288z',
			),
		),
		'label'             => __( 'Plane Circle Exclamation', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'plane-circle-xmark'                     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M320 93.68V178.3L397.1 222.4C350.6 254 320 307.4 320 368C320 422.2 344.5 470.7 383.1 502.1C381 508.3 375.9 512 369.1 512C368.7 512 367.4 511.8 366.1 511.5L256 480L145.9 511.5C144.6 511.8 143.3 512 142 512C134.3 512 128 505.7 128 497.1V456C128 450.1 130.4 446.2 134.4 443.2L192 400V329.1L20.4 378.2C10.17 381.1 0 373.4 0 362.8V297.3C0 291.5 3.076 286.2 8.062 283.4L192 178.3V93.68C192 59.53 221 0 256 0C292 0 320 59.53 320 93.68H320zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM555.3 331.3C561.6 325.1 561.6 314.9 555.3 308.7C549.1 302.4 538.9 302.4 532.7 308.7L496 345.4L459.3 308.7C453.1 302.4 442.9 302.4 436.7 308.7C430.4 314.9 430.4 325.1 436.7 331.3L473.4 368L436.7 404.7C430.4 410.9 430.4 421.1 436.7 427.3C442.9 433.6 453.1 433.6 459.3 427.3L496 390.6L532.7 427.3C538.9 433.6 549.1 433.6 555.3 427.3C561.6 421.1 561.6 410.9 555.3 404.7L518.6 368L555.3 331.3z',
			),
		),
		'label'             => __( 'Plane Circle Xmark', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'plane-departure'                        => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M484.6 62C502.6 52.8 522.6 48 542.8 48H600.2C627.2 48 645.9 74.95 636.4 100.2C618.2 148.9 582.1 188.9 535.6 212.2L262.8 348.6C258.3 350.8 253.4 352 248.4 352H110.7C101.4 352 92.5 347.9 86.42 340.8L13.34 255.6C6.562 247.7 9.019 235.5 18.33 230.8L50.49 214.8C59.05 210.5 69.06 210.2 77.8 214.1L135.1 239.1L234.6 189.7L87.64 95.2C77.21 88.49 78.05 72.98 89.14 67.43L135 44.48C150.1 36.52 169.5 35.55 186.1 41.8L381 114.9L484.6 62zM0 480C0 462.3 14.33 448 32 448H608C625.7 448 640 462.3 640 480C640 497.7 625.7 512 608 512H32C14.33 512 0 497.7 0 480z',
			),
		),
		'label'             => __( 'Plane Departure', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'plane-lock'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M192 93.68C192 59.53 221 0 256 0C292 0 320 59.53 320 93.68V178.3L421.8 236.4C418 247.6 416 259.6 416 272V296.6C398.1 306.9 385.7 325.7 384.2 347.5L320 329.1V400L377.6 443.2C381.6 446.2 384 450.1 384 456V497.1C384 505.7 377.7 512 369.1 512C368.7 512 367.4 511.8 366.1 511.5L256 480L145.9 511.5C144.6 511.8 143.3 512 142 512C134.3 512 128 505.7 128 497.1V456C128 450.1 130.4 446.2 134.4 443.2L192 400V329.1L20.4 378.2C10.17 381.1 0 373.4 0 362.8V297.3C0 291.5 3.076 286.2 8.062 283.4L192 178.3L192 93.68zM528 192C572.2 192 608 227.8 608 272V320C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320V272C448 227.8 483.8 192 528 192zM528 240C510.3 240 496 254.3 496 272V320H560V272C560 254.3 545.7 240 528 240z',
			),
		),
		'label'             => __( 'Plane Lock', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'plane-slash'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M238.1 161.3L197.8 20.4C194.9 10.17 202.6-.0001 213.2-.0001H269.4C280.9-.0001 291.5 6.153 297.2 16.12L397.7 192H514.3C548.5 192 608 221 608 256C608 292 548.5 320 514.3 320H440.6L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196C13.29-1.237 28.37-3.065 38.81 5.112L238.1 161.3zM41.54 128.7L362.5 381.6L297.2 495.9C291.5 505.8 280.9 512 269.4 512H213.2C202.6 512 194.9 501.8 197.8 491.6L246.9 319.1H144L100.8 377.6C97.78 381.6 93.04 384 88 384H46.03C38.28 384 32 377.7 32 369.1C32 368.7 32.18 367.4 32.54 366.1L64 255.1L32.54 145.9C32.18 144.6 32 143.3 32 142C32 135.9 35.1 130.6 41.54 128.7V128.7z',
			),
		),
		'label'             => __( 'Plane Slash', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'plane-up'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M192 93.68C192 59.53 221 0 256 0C292 0 320 59.53 320 93.68V160L497.8 278.5C506.7 284.4 512 294.4 512 305.1V361.8C512 372.7 501.3 380.4 490.9 376.1L320 319.1V400L377.6 443.2C381.6 446.2 384 450.1 384 456V497.1C384 505.7 377.7 512 369.1 512C368.7 512 367.4 511.8 366.1 511.5L256 480L145.9 511.5C144.6 511.8 143.3 512 142 512C134.3 512 128 505.7 128 497.1V456C128 450.1 130.4 446.2 134.4 443.2L192 400V319.1L21.06 376.1C10.7 380.4 0 372.7 0 361.8V305.1C0 294.4 5.347 284.4 14.25 278.5L192 160L192 93.68z',
			),
		),
		'label'             => __( 'Plane Up', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'plant-wilt'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M288 512H224V248C224 217.1 198.9 192 168 192C137.1 192 112 217.1 112 248V260.1C141.3 270.9 160 295.5 160 331.1C160 359.1 124.2 410.5 80 448C35.83 410.5 0 360.4 0 331.1C0 295.5 18.67 270.9 48 260.1V248C48 181.7 101.7 128 168 128C188.2 128 207.3 133 224 141.8V120C224 53.73 277.7 0 344 0C410.3 0 464 53.73 464 120V132.1C493.3 142.9 512 167.5 512 203.1C512 231.1 476.2 282.5 432 320C387.8 282.5 352 232.4 352 203.1C352 167.5 370.7 142.9 400 132.1V120C400 89.07 374.9 64 344 64C313.1 64 288 89.07 288 120V512z',
			),
		),
		'label'             => __( 'Plant Wilt', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'plate-wheat'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 112V128C256 136.8 248.8 144 240 144C195.8 144 160 108.2 160 64V48C160 39.16 167.2 32 176 32C220.2 32 256 67.82 256 112zM104 64C117.3 64 128 74.75 128 88C128 101.3 117.3 112 104 112H56C42.75 112 32 101.3 32 88C32 74.75 42.75 64 56 64H104zM136 136C149.3 136 160 146.7 160 160C160 173.3 149.3 184 136 184H24C10.75 184 0 173.3 0 160C0 146.7 10.75 136 24 136H136zM32 232C32 218.7 42.75 208 56 208H104C117.3 208 128 218.7 128 232C128 245.3 117.3 256 104 256H56C42.75 256 32 245.3 32 232zM272 48C272 39.16 279.2 32 288 32C332.2 32 368 67.82 368 112V128C368 136.8 360.8 144 352 144C307.8 144 272 108.2 272 64V48zM480 112V128C480 136.8 472.8 144 464 144C419.8 144 384 108.2 384 64V48C384 39.16 391.2 32 400 32C444.2 32 480 67.82 480 112zM480 208C480 252.2 444.2 288 400 288C391.2 288 384 280.8 384 272V256C384 211.8 419.8 176 464 176C472.8 176 480 183.2 480 192V208zM352 176C360.8 176 368 183.2 368 192V208C368 252.2 332.2 288 288 288C279.2 288 272 280.8 272 272V256C272 211.8 307.8 176 352 176zM256 208C256 252.2 220.2 288 176 288C167.2 288 160 280.8 160 272V256C160 211.8 195.8 176 240 176C248.8 176 256 183.2 256 192V208zM0 352C0 334.3 14.33 320 32 320H480C497.7 320 512 334.3 512 352C512 411.7 471.1 461.9 415.8 476C415.9 477.3 416 478.7 416 480C416 497.7 401.7 512 384 512H128C110.3 512 96 497.7 96 480C96 478.7 96.08 477.3 96.24 476C40.91 461.9 0 411.7 0 352V352z',
			),
		),
		'label'             => __( 'Plate Wheat', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'play'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M361 215C375.3 223.8 384 239.3 384 256C384 272.7 375.3 288.2 361 296.1L73.03 472.1C58.21 482 39.66 482.4 24.52 473.9C9.377 465.4 0 449.4 0 432V80C0 62.64 9.377 46.63 24.52 38.13C39.66 29.64 58.21 29.99 73.03 39.04L361 215z',
			),
		),
		'label'             => __( 'Play', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'science-and-technology',
		),
	),
	'playstation'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M570.9 372.3c-11.3 14.2-38.8 24.3-38.8 24.3L327 470.2v-54.3l150.9-53.8c17.1-6.1 19.8-14.8 5.8-19.4-13.9-4.6-39.1-3.3-56.2 2.9L327 381.1v-56.4c23.2-7.8 47.1-13.6 75.7-16.8 40.9-4.5 90.9 .6 130.2 15.5 44.2 14 49.2 34.7 38 48.9zm-224.4-92.5v-139c0-16.3-3-31.3-18.3-35.6-11.7-3.8-19 7.1-19 23.4v347.9l-93.8-29.8V32c39.9 7.4 98 24.9 129.2 35.4C424.1 94.7 451 128.7 451 205.2c0 74.5-46 102.8-104.5 74.6zM43.2 410.2c-45.4-12.8-53-39.5-32.3-54.8 19.1-14.2 51.7-24.9 51.7-24.9l134.5-47.8v54.5l-96.8 34.6c-17.1 6.1-19.7 14.8-5.8 19.4 13.9 4.6 39.1 3.3 56.2-2.9l46.4-16.9v48.8c-51.6 9.3-101.4 7.3-153.9-10z',
			),
		),
		'label'             => __( 'PlayStation', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'brands',
			'brands',
			'social',
		),
	),
	'plug'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M96 0C113.7 0 128 14.33 128 32V128H64V32C64 14.33 78.33 0 96 0zM288 0C305.7 0 320 14.33 320 32V128H256V32C256 14.33 270.3 0 288 0zM352 160C369.7 160 384 174.3 384 192C384 209.7 369.7 224 352 224V256C352 333.4 297 397.1 224 412.8V512H160V412.8C86.97 397.1 32 333.4 32 256V224C14.33 224 0 209.7 0 192C0 174.3 14.33 160 32 160H352z',
			),
		),
		'label'             => __( 'Plug', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'science-and-technology',
			'travel',
		),
	),
	'plug-circle-bolt'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M96 0C113.7 0 128 14.33 128 32V128H64V32C64 14.33 78.33 0 96 0zM288 0C305.7 0 320 14.33 320 32V128H256V32C256 14.33 270.3 0 288 0zM352 160C369.7 160 384 174.3 384 192C384 194.3 383.7 196.6 383.3 198.8C309.8 219.1 256 287.7 256 368C256 379.4 257.1 390.5 259.1 401.3C248.1 406.4 236.3 410.3 224 412.8V512H160V412.8C86.97 397.1 32 333.4 32 256V224C14.33 224 0 209.7 0 192C0 174.3 14.33 160 32 160H352zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM464.8 286.4L368.8 358.4C364.7 361.5 362.1 366.9 364.6 371.8C366.2 376.7 370.8 380 376 380H411.6L381.5 434.2C378.8 439.1 379.8 445.3 384.1 449C388.4 452.8 394.7 452.1 399.2 449.6L495.2 377.6C499.3 374.5 501 369.1 499.4 364.2C497.8 359.3 493.2 356 488 356H452.4L482.5 301.8C485.2 296.9 484.2 290.7 479.9 286.1C475.6 283.2 469.3 283 464.8 286.4V286.4z',
			),
		),
		'label'             => __( 'Plug Circle Bolt', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'plug-circle-check'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M96 0C113.7 0 128 14.33 128 32V128H64V32C64 14.33 78.33 0 96 0zM288 0C305.7 0 320 14.33 320 32V128H256V32C256 14.33 270.3 0 288 0zM352 160C369.7 160 384 174.3 384 192C384 194.3 383.7 196.6 383.3 198.8C309.8 219.1 256 287.7 256 368C256 379.4 257.1 390.5 259.1 401.3C248.1 406.4 236.3 410.3 224 412.8V512H160V412.8C86.97 397.1 32 333.4 32 256V224C14.33 224 0 209.7 0 192C0 174.3 14.33 160 32 160H352zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM476.7 324.7L416 385.4L387.3 356.7C381.1 350.4 370.9 350.4 364.7 356.7C358.4 362.9 358.4 373.1 364.7 379.3L404.7 419.3C410.9 425.6 421.1 425.6 427.3 419.3L499.3 347.3C505.6 341.1 505.6 330.9 499.3 324.7C493.1 318.4 482.9 318.4 476.7 324.7H476.7z',
			),
		),
		'label'             => __( 'Plug Circle Check', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'plug-circle-exclamation'                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M96 0C113.7 0 128 14.33 128 32V128H64V32C64 14.33 78.33 0 96 0zM288 0C305.7 0 320 14.33 320 32V128H256V32C256 14.33 270.3 0 288 0zM352 160C369.7 160 384 174.3 384 192C384 194.3 383.7 196.6 383.3 198.8C309.8 219.1 256 287.7 256 368C256 379.4 257.1 390.5 259.1 401.3C248.1 406.4 236.3 410.3 224 412.8V512H160V412.8C86.97 397.1 32 333.4 32 256V224C14.33 224 0 209.7 0 192C0 174.3 14.33 160 32 160H352zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM432 464C445.3 464 456 453.3 456 440C456 426.7 445.3 416 432 416C418.7 416 408 426.7 408 440C408 453.3 418.7 464 432 464zM415.1 288V368C415.1 376.8 423.2 384 431.1 384C440.8 384 447.1 376.8 447.1 368V288C447.1 279.2 440.8 272 431.1 272C423.2 272 415.1 279.2 415.1 288z',
			),
		),
		'label'             => __( 'Plug Circle Exclamation', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'plug-circle-minus'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M96 0C113.7 0 128 14.33 128 32V128H64V32C64 14.33 78.33 0 96 0zM288 0C305.7 0 320 14.33 320 32V128H256V32C256 14.33 270.3 0 288 0zM352 160C369.7 160 384 174.3 384 192C384 194.3 383.7 196.6 383.3 198.8C309.8 219.1 256 287.7 256 368C256 379.4 257.1 390.5 259.1 401.3C248.1 406.4 236.3 410.3 224 412.8V512H160V412.8C86.97 397.1 32 333.4 32 256V224C14.33 224 0 209.7 0 192C0 174.3 14.33 160 32 160H352zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM496 351.1H368C359.2 351.1 352 359.2 352 367.1C352 376.8 359.2 383.1 368 383.1H496C504.8 383.1 512 376.8 512 367.1C512 359.2 504.8 351.1 496 351.1z',
			),
		),
		'label'             => __( 'Plug Circle Minus', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'plug-circle-plus'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M96 0C113.7 0 128 14.33 128 32V128H64V32C64 14.33 78.33 0 96 0zM288 0C305.7 0 320 14.33 320 32V128H256V32C256 14.33 270.3 0 288 0zM352 160C369.7 160 384 174.3 384 192C384 194.3 383.7 196.6 383.3 198.8C309.8 219.1 256 287.7 256 368C256 379.4 257.1 390.5 259.1 401.3C248.1 406.4 236.3 410.3 224 412.8V512H160V412.8C86.97 397.1 32 333.4 32 256V224C14.33 224 0 209.7 0 192C0 174.3 14.33 160 32 160H352zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM448 303.1C448 295.2 440.8 287.1 432 287.1C423.2 287.1 416 295.2 416 303.1V351.1H368C359.2 351.1 352 359.2 352 367.1C352 376.8 359.2 383.1 368 383.1H416V431.1C416 440.8 423.2 447.1 432 447.1C440.8 447.1 448 440.8 448 431.1V383.1H496C504.8 383.1 512 376.8 512 367.1C512 359.2 504.8 351.1 496 351.1H448V303.1z',
			),
		),
		'label'             => __( 'Plug Circle Plus', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'plug-circle-xmark'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M96 0C113.7 0 128 14.33 128 32V128H64V32C64 14.33 78.33 0 96 0zM288 0C305.7 0 320 14.33 320 32V128H256V32C256 14.33 270.3 0 288 0zM352 160C369.7 160 384 174.3 384 192C384 194.3 383.7 196.6 383.3 198.8C309.8 219.1 256 287.7 256 368C256 379.4 257.1 390.5 259.1 401.3C248.1 406.4 236.3 410.3 224 412.8V512H160V412.8C86.97 397.1 32 333.4 32 256V224C14.33 224 0 209.7 0 192C0 174.3 14.33 160 32 160H352zM288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368zM491.3 331.3C497.6 325.1 497.6 314.9 491.3 308.7C485.1 302.4 474.9 302.4 468.7 308.7L432 345.4L395.3 308.7C389.1 302.4 378.9 302.4 372.7 308.7C366.4 314.9 366.4 325.1 372.7 331.3L409.4 368L372.7 404.7C366.4 410.9 366.4 421.1 372.7 427.3C378.9 433.6 389.1 433.6 395.3 427.3L432 390.6L468.7 427.3C474.9 433.6 485.1 433.6 491.3 427.3C497.6 421.1 497.6 410.9 491.3 404.7L454.6 368L491.3 331.3z',
			),
		),
		'label'             => __( 'Plug Circle Xmark', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'plus'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M432 256c0 17.69-14.33 32.01-32 32.01H256v144c0 17.69-14.33 31.99-32 31.99s-32-14.3-32-31.99v-144H48c-17.67 0-32-14.32-32-32.01s14.33-31.99 32-31.99H192v-144c0-17.69 14.33-32.01 32-32.01s32 14.32 32 32.01v144h144C417.7 224 432 238.3 432 256z',
			),
		),
		'label'             => __( 'Plus', 'astra' ),
		'custom_categories' => array(
			'design',
			'education',
			'science-and-technology',
			'travel',
		),
	),
	'plus-minus'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M352 448H32c-17.69 0-32 14.31-32 32s14.31 31.1 32 31.1h320c17.69 0 32-14.31 32-31.1S369.7 448 352 448zM48 208H160v111.1c0 17.69 14.31 31.1 32 31.1s32-14.31 32-31.1V208h112c17.69 0 32-14.32 32-32.01s-14.31-31.99-32-31.99H224v-112c0-17.69-14.31-32.01-32-32.01S160 14.33 160 32.01v112H48c-17.69 0-32 14.31-32 31.99S30.31 208 48 208z',
			),
		),
		'label'             => __( 'Plus Minus', 'astra' ),
		'custom_categories' => array(
			'communication',
			'education',
			'science-and-technology',
		),
	),
	'podcast'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M224 0C100.3 0 0 100.3 0 224c0 92.22 55.77 171.4 135.4 205.7c-3.48-20.75-6.17-41.59-6.998-58.15C80.08 340.1 48 285.8 48 224c0-97.05 78.95-176 176-176s176 78.95 176 176c0 61.79-32.08 116.1-80.39 147.6c-.834 16.5-3.541 37.37-7.035 58.17C392.2 395.4 448 316.2 448 224C448 100.3 347.7 0 224 0zM224 312c-32.88 0-64 8.625-64 43.75c0 33.13 12.88 104.3 20.62 132.8C185.8 507.6 205.1 512 224 512s38.25-4.375 43.38-23.38C275.1 459.9 288 388.8 288 355.8C288 320.6 256.9 312 224 312zM224 280c30.95 0 56-25.05 56-56S254.1 168 224 168S168 193 168 224S193 280 224 280zM368 224c0-79.53-64.47-144-144-144S80 144.5 80 224c0 44.83 20.92 84.38 53.04 110.8c4.857-12.65 14.13-25.88 32.05-35.04C165.1 299.7 165.4 299.7 165.6 299.7C142.9 282.1 128 254.9 128 224c0-53.02 42.98-96 96-96s96 42.98 96 96c0 30.92-14.87 58.13-37.57 75.68c.1309 .0254 .5078 .0488 .4746 .0742c17.93 9.16 27.19 22.38 32.05 35.04C347.1 308.4 368 268.8 368 224z',
			),
		),
		'label'             => __( 'Podcast', 'astra' ),
		'custom_categories' => array(
			'communication',
		),
	),
	'poo'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M451.4 369.1C468.8 356 480 335.4 480 312c0-39.75-32.25-72-72-72h-14.12C407.3 228.2 416 211.2 416 191.1c0-35.25-28.75-63.1-64-63.1h-5.875C349.8 117.9 352 107.2 352 95.1c0-53-43-96-96-96c-5.25 0-10.25 .75-15.12 1.5C250.3 14.62 256 30.62 256 47.1c0 44.25-35.75 80-80 80H160c-35.25 0-64 28.75-64 63.1c0 19.25 8.75 36.25 22.12 48H104C64.25 239.1 32 272.3 32 312c0 23.38 11.25 44 28.62 57.13C26.25 374.6 0 404.1 0 440C0 479.8 32.25 512 72 512h368c39.75 0 72-32.25 72-72C512 404.1 485.8 374.6 451.4 369.1zM192 256c17.75 0 32 14.25 32 32s-14.25 32-32 32S160 305.8 160 288S174.3 256 192 256zM351.5 395C340.1 422.9 292.1 448 256 448c-36.99 0-84.98-25.12-95.48-53C158.5 389.8 162.5 384 168.3 384h175.5C349.5 384 353.5 389.8 351.5 395zM320 320c-17.75 0-32-14.25-32-32s14.25-32 32-32s32 14.25 32 32S337.8 320 320 320z',
			),
		),
		'label'             => __( 'Poo', 'astra' ),
		'custom_categories' => array(
			'communication',
		),
	),
	'poo-storm'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M304 368H248.3l38.45-89.7c2.938-6.859 .7187-14.84-5.312-19.23c-6.096-4.422-14.35-4.031-19.94 .8906l-128 111.1c-5.033 4.391-6.783 11.44-4.439 17.67c2.346 6.25 8.314 10.38 14.97 10.38H199.7l-38.45 89.7c-2.938 6.859-.7187 14.84 5.312 19.23C169.4 510.1 172.7 512 175.1 512c3.781 0 7.531-1.328 10.53-3.953l128-111.1c5.033-4.391 6.783-11.44 4.439-17.67C316.6 372.1 310.7 368 304 368zM373.3 226.6C379.9 216.6 384 204.9 384 192c0-35.38-28.62-64-64-64h-5.875C317.8 118 320 107.3 320 96c0-53-43-96-96-96C218.9 0 213.9 .75 208.9 1.5C218.3 14.62 224 30.62 224 48C224 92.13 188.1 128 144 128H128C92.63 128 64 156.6 64 192c0 12.88 4.117 24.58 10.72 34.55C31.98 236.3 0 274.3 0 320c0 53.02 42.98 96 96 96h12.79c-4.033-4.414-7.543-9.318-9.711-15.1c-7.01-18.64-1.645-39.96 13.32-53.02l127.9-111.9C249.1 228.2 260.3 223.1 271.1 224c10.19 0 19.95 3.174 28.26 9.203c18.23 13.27 24.76 36.1 15.89 57.71l-19.33 45.1h7.195c19.89 0 37.95 12.51 44.92 31.11C355.3 384 351 402.8 339.1 416H352c53.02 0 96-42.98 96-96C448 274.3 416 236.3 373.3 226.6z',
			),
		),
		'label'             => __( 'Poo Storm', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'poop'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 440.1C512 479.9 479.7 512 439.1 512H71.92C32.17 512 0 479.8 0 440c0-35.88 26.19-65.35 60.56-70.85C43.31 356 32 335.4 32 312C32 272.2 64.25 240 104 240h13.99C104.5 228.2 96 211.2 96 192c0-35.38 28.56-64 63.94-64h16C220.1 128 256 92.12 256 48c0-17.38-5.784-33.35-15.16-46.47C245.8 .7754 250.9 0 256 0c53 0 96 43 96 96c0 11.25-2.288 22-5.913 32h5.879C387.3 128 416 156.6 416 192c0 19.25-8.59 36.25-22.09 48H408C447.8 240 480 272.2 480 312c0 23.38-11.38 44.01-28.63 57.14C485.7 374.6 512 404.3 512 440.1z',
			),
		),
		'label'             => __( 'Poop', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'power-off'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M288 256C288 273.7 273.7 288 256 288C238.3 288 224 273.7 224 256V32C224 14.33 238.3 0 256 0C273.7 0 288 14.33 288 32V256zM80 256C80 353.2 158.8 432 256 432C353.2 432 432 353.2 432 256C432 201.6 407.3 152.9 368.5 120.6C354.9 109.3 353 89.13 364.3 75.54C375.6 61.95 395.8 60.1 409.4 71.4C462.2 115.4 496 181.8 496 255.1C496 388.5 388.5 496 256 496C123.5 496 16 388.5 16 255.1C16 181.8 49.75 115.4 102.6 71.4C116.2 60.1 136.4 61.95 147.7 75.54C158.1 89.13 157.1 109.3 143.5 120.6C104.7 152.9 80 201.6 80 256z',
			),
		),
		'label'             => __( 'Power Off', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'prescription'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M440.1 448.4l-96.28-96.21l95.87-95.95c9.373-9.381 9.373-24.59 0-33.97l-22.62-22.64c-9.373-9.381-24.57-9.381-33.94 0L288.1 295.6L220.5 228c46.86-22.92 76.74-75.46 64.95-133.1C273.9 38.74 221.8 0 164.6 0H31.1C14.33 0 0 14.34 0 32.03v264.1c0 13.26 10.75 24.01 23.1 24.01l31.1 .085c13.25 0 23.1-10.75 23.1-24.02V240.2H119.4l112.1 112L135.4 448.4c-9.373 9.381-9.373 24.59 0 33.97l22.62 22.64c9.373 9.38 24.57 9.38 33.94 0l96.13-96.21l96.28 96.21c9.373 9.381 24.57 9.381 33.94 0l22.62-22.64C450.3 472.9 450.3 457.7 440.1 448.4zM79.1 80.06h87.1c22.06 0 39.1 17.95 39.1 40.03s-17.94 40.03-39.1 40.03H79.1V80.06z',
			),
		),
		'label'             => __( 'Prescription', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'prescription-bottle'                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M32 192h112C152.8 192 160 199.2 160 208C160 216.8 152.8 224 144 224H32v64h112C152.8 288 160 295.2 160 304C160 312.8 152.8 320 144 320H32v64h112C152.8 384 160 391.2 160 400C160 408.8 152.8 416 144 416H32v32c0 35.2 28.8 64 64 64h192c35.2 0 64-28.8 64-64V128H32V192zM360 0H24C10.75 0 0 10.75 0 24v48C0 85.25 10.75 96 24 96h336C373.3 96 384 85.25 384 72v-48C384 10.75 373.3 0 360 0z',
			),
		),
		'label'             => __( 'Prescription Bottle', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'prescription-bottle-medical'            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M32 448c0 35.2 28.8 64 64 64h192c35.2 0 64-28.8 64-64V128H32V448zM96 304C96 295.2 103.2 288 112 288H160V240C160 231.2 167.2 224 176 224h32C216.8 224 224 231.2 224 240V288h48C280.8 288 288 295.2 288 304v32c0 8.799-7.199 16-16 16H224v48c0 8.799-7.199 16-16 16h-32C167.2 416 160 408.8 160 400V352H112C103.2 352 96 344.8 96 336V304zM360 0H24C10.75 0 0 10.75 0 24v48C0 85.25 10.75 96 24 96h336C373.3 96 384 85.25 384 72v-48C384 10.75 373.3 0 360 0z',
			),
		),
		'label'             => __( 'Prescription Bottle Medical', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'print'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M448 192H64C28.65 192 0 220.7 0 256v96c0 17.67 14.33 32 32 32h32v96c0 17.67 14.33 32 32 32h320c17.67 0 32-14.33 32-32v-96h32c17.67 0 32-14.33 32-32V256C512 220.7 483.3 192 448 192zM384 448H128v-96h256V448zM432 296c-13.25 0-24-10.75-24-24c0-13.27 10.75-24 24-24s24 10.73 24 24C456 285.3 445.3 296 432 296zM128 64h229.5L384 90.51V160h64V77.25c0-8.484-3.375-16.62-9.375-22.62l-45.25-45.25C387.4 3.375 379.2 0 370.8 0H96C78.34 0 64 14.33 64 32v128h64V64z',
			),
		),
		'label'             => __( 'Print', 'astra' ),
		'custom_categories' => array(
			'business',
			'science-and-technology',
			'travel',
		),
	),
	'product-hunt'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M326.3 218.8c0 20.5-16.7 37.2-37.2 37.2h-70.3v-74.4h70.3c20.5 0 37.2 16.7 37.2 37.2zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-128.1-37.2c0-47.9-38.9-86.8-86.8-86.8H169.2v248h49.6v-74.4h70.3c47.9 0 86.8-38.9 86.8-86.8z',
			),
		),
		'label'             => __( 'Product Hunt', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'pump-medical'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M379.3 94.06l-43.32-43.32C323.1 38.74 307.7 32 290.8 32h-66.75c0-17.67-14.33-32-32-32H127.1c-17.67 0-32 14.33-32 32L96 128h128l-.0002-32h66.75l43.31 43.31c6.248 6.248 16.38 6.248 22.63 0l22.62-22.62C385.6 110.4 385.6 100.3 379.3 94.06zM235.6 160H84.37C51.27 160 23.63 185.2 20.63 218.2l-20.36 224C-3.139 479.7 26.37 512 64.01 512h191.1c37.63 0 67.14-32.31 63.74-69.79l-20.36-224C296.4 185.2 268.7 160 235.6 160zM239.1 333.3c0 7.363-5.971 13.33-13.33 13.33h-40v40c0 7.363-5.969 13.33-13.33 13.33h-26.67c-7.363 0-13.33-5.971-13.33-13.33v-40H93.33c-7.363 0-13.33-5.971-13.33-13.33V306.7c0-7.365 5.971-13.33 13.33-13.33h40v-40C133.3 245.1 139.3 240 146.7 240h26.67c7.363 0 13.33 5.969 13.33 13.33v40h40c7.363 0 13.33 5.969 13.33 13.33V333.3z',
			),
		),
		'label'             => __( 'Pump Medical', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'pump-soap'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M235.6 160H84.37C51.27 160 23.63 185.2 20.63 218.2l-20.36 224C-3.139 479.7 26.37 512 64.01 512h191.1c37.63 0 67.14-32.31 63.74-69.79l-20.36-224C296.4 185.2 268.7 160 235.6 160zM159.1 416C124.7 416 96 389.7 96 357.3c0-25 38.08-75.47 55.5-97.27c4.25-5.312 12.75-5.312 17 0C185.9 281.8 224 332.3 224 357.3C224 389.7 195.3 416 159.1 416zM379.3 94.06l-43.32-43.32C323.1 38.74 307.7 32 290.8 32h-66.75c0-17.67-14.33-32-32-32H127.1c-17.67 0-32 14.33-32 32L96 128h128l-.0002-32h66.75l43.31 43.31c6.248 6.248 16.38 6.248 22.63 0l22.62-22.62C385.6 110.4 385.6 100.3 379.3 94.06z',
			),
		),
		'label'             => __( 'Pump Soap', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'pushed'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 432,
				'height' => 512,
				'path'   => 'M407 111.9l-98.5-9 14-33.4c10.4-23.5-10.8-40.4-28.7-37L22.5 76.9c-15.1 2.7-26 18.3-21.4 36.6l105.1 348.3c6.5 21.3 36.7 24.2 47.7 7l35.3-80.8 235.2-231.3c16.4-16.8 4.3-42.9-17.4-44.8zM297.6 53.6c5.1-.7 7.5 2.5 5.2 7.4L286 100.9 108.6 84.6l189-31zM22.7 107.9c-3.1-5.1 1-10 6.1-9.1l248.7 22.7-96.9 230.7L22.7 107.9zM136 456.4c-2.6 4-7.9 3.1-9.4-1.2L43.5 179.7l127.7 197.6c-7 15-35.2 79.1-35.2 79.1zm272.8-314.5L210.1 337.3l89.7-213.7 106.4 9.7c4 1.1 5.7 5.3 2.6 8.6z',
			),
		),
		'label'             => __( 'Pushed', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'puzzle-piece'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M512 288c0 35.35-21.49 64-48 64c-32.43 0-31.72-32-55.64-32C394.9 320 384 330.9 384 344.4V480c0 17.67-14.33 32-32 32h-71.64C266.9 512 256 501.1 256 487.6C256 463.1 288 464.4 288 432c0-26.51-28.65-48-64-48s-64 21.49-64 48c0 32.43 32 31.72 32 55.64C192 501.1 181.1 512 167.6 512H32c-17.67 0-32-14.33-32-32v-135.6C0 330.9 10.91 320 24.36 320C48.05 320 47.6 352 80 352C106.5 352 128 323.3 128 288S106.5 223.1 80 223.1c-32.43 0-31.72 32-55.64 32C10.91 255.1 0 245.1 0 231.6v-71.64c0-17.67 14.33-31.1 32-31.1h135.6C181.1 127.1 192 117.1 192 103.6c0-23.69-32-23.24-32-55.64c0-26.51 28.65-47.1 64-47.1s64 21.49 64 47.1c0 32.43-32 31.72-32 55.64c0 13.45 10.91 24.36 24.36 24.36H352c17.67 0 32 14.33 32 31.1v71.64c0 13.45 10.91 24.36 24.36 24.36c23.69 0 23.24-32 55.64-32C490.5 223.1 512 252.7 512 288z',
			),
		),
		'label'             => __( 'Puzzle Piece', 'astra' ),
		'custom_categories' => array(
			'education',
			'lifestyle-and-hobbies',
		),
	),
	'python'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M439.8 200.5c-7.7-30.9-22.3-54.2-53.4-54.2h-40.1v47.4c0 36.8-31.2 67.8-66.8 67.8H172.7c-29.2 0-53.4 25-53.4 54.3v101.8c0 29 25.2 46 53.4 54.3 33.8 9.9 66.3 11.7 106.8 0 26.9-7.8 53.4-23.5 53.4-54.3v-40.7H226.2v-13.6h160.2c31.1 0 42.6-21.7 53.4-54.2 11.2-33.5 10.7-65.7 0-108.6zM286.2 404c11.1 0 20.1 9.1 20.1 20.3 0 11.3-9 20.4-20.1 20.4-11 0-20.1-9.2-20.1-20.4 .1-11.3 9.1-20.3 20.1-20.3zM167.8 248.1h106.8c29.7 0 53.4-24.5 53.4-54.3V91.9c0-29-24.4-50.7-53.4-55.6-35.8-5.9-74.7-5.6-106.8 .1-45.2 8-53.4 24.7-53.4 55.6v40.7h106.9v13.6h-147c-31.1 0-58.3 18.7-66.8 54.2-9.8 40.7-10.2 66.1 0 108.6 7.6 31.6 25.7 54.2 56.8 54.2H101v-48.8c0-35.3 30.5-66.4 66.8-66.4zm-6.7-142.6c-11.1 0-20.1-9.1-20.1-20.3 .1-11.3 9-20.4 20.1-20.4 11 0 20.1 9.2 20.1 20.4s-9 20.3-20.1 20.3z',
			),
		),
		'label'             => __( 'Python', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'q'                                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M393.1 402.5c34.12-39.32 54.93-90.48 54.93-146.5c0-123.5-100.5-224-223.1-224S.0001 132.5 .0001 256s100.5 224 223.1 224c44.45 0 85.81-13.16 120.7-35.58l46.73 56.08c6.328 7.594 15.42 11.52 24.59 11.52c21.35 0 31.98-18.26 31.98-32.01c0-7.223-2.433-14.49-7.419-20.47L393.1 402.5zM224 416c-88.22 0-160-71.78-160-160s71.78-159.1 160-159.1s160 71.78 160 159.1c0 36.21-12.55 69.28-32.92 96.12L280.6 267.5c-6.338-7.597-15.44-11.53-24.61-11.53c-21.27 0-31.96 18.22-31.96 32.02c0 7.223 2.433 14.49 7.419 20.47l71.53 85.83C279.6 407.7 252.8 416 224 416z',
			),
		),
		'label'             => __( 'Q', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'qq'                                     => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M433.8 420.4c-11.53 1.393-44.86-52.74-44.86-52.74 0 31.34-16.14 72.25-51.05 101.8 16.84 5.192 54.84 19.17 45.8 34.42-7.316 12.34-125.5 7.881-159.6 4.037-34.12 3.844-152.3 8.306-159.6-4.037-9.045-15.25 28.92-29.21 45.78-34.42-34.92-29.54-51.06-70.44-51.06-101.8 0 0-33.33 54.13-44.86 52.74-5.37-.65-12.42-29.64 9.347-99.7 10.26-33.02 21.1-60.48 40.14-105.8C60.68 98.06 108.1 .006 224 0c113.7 .006 163.2 96.13 160.3 214.1 18.12 45.22 29.91 72.85 40.14 105.8 21.77 70.06 14.72 99.05 9.346 99.7z',
			),
		),
		'label'             => __( 'QQ', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'qrcode'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M144 32C170.5 32 192 53.49 192 80V176C192 202.5 170.5 224 144 224H48C21.49 224 0 202.5 0 176V80C0 53.49 21.49 32 48 32H144zM128 96H64V160H128V96zM144 288C170.5 288 192 309.5 192 336V432C192 458.5 170.5 480 144 480H48C21.49 480 0 458.5 0 432V336C0 309.5 21.49 288 48 288H144zM128 352H64V416H128V352zM256 80C256 53.49 277.5 32 304 32H400C426.5 32 448 53.49 448 80V176C448 202.5 426.5 224 400 224H304C277.5 224 256 202.5 256 176V80zM320 160H384V96H320V160zM352 448H384V480H352V448zM448 480H416V448H448V480zM416 288H448V416H352V384H320V480H256V288H352V320H416V288z',
			),
		),
		'label'             => __( 'Qrcode', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'question'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M204.3 32.01H96c-52.94 0-96 43.06-96 96c0 17.67 14.31 31.1 32 31.1s32-14.32 32-31.1c0-17.64 14.34-32 32-32h108.3C232.8 96.01 256 119.2 256 147.8c0 19.72-10.97 37.47-30.5 47.33L127.8 252.4C117.1 258.2 112 268.7 112 280v40c0 17.67 14.31 31.99 32 31.99s32-14.32 32-31.99V298.3L256 251.3c39.47-19.75 64-59.42 64-103.5C320 83.95 268.1 32.01 204.3 32.01zM144 400c-22.09 0-40 17.91-40 40s17.91 39.1 40 39.1s40-17.9 40-39.1S166.1 400 144 400z',
			),
		),
		'label'             => __( 'Question', 'astra' ),
		'custom_categories' => array(
			'design',
		),
	),
	'quinscape'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M313.6 474.6h-1a158.1 158.1 0 0 1 0-316.2c94.9 0 168.2 83.1 157 176.6 4 5.1 8.2 9.6 11.2 15.3 13.4-30.3 20.3-62.4 20.3-97.7C501.1 117.5 391.6 8 256.5 8S12 117.5 12 252.6s109.5 244.6 244.5 244.6a237.4 237.4 0 0 0 70.4-10.1c-5.2-3.5-8.9-8.1-13.3-12.5zm-.1-.1l.4 .1zm78.4-168.9a99.2 99.2 0 1 0 99.2 99.2 99.18 99.18 0 0 0 -99.2-99.2z',
			),
		),
		'label'             => __( 'QuinScape', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'quora'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M440.5 386.7h-29.3c-1.5 13.5-10.5 30.8-33 30.8-20.5 0-35.3-14.2-49.5-35.8 44.2-34.2 74.7-87.5 74.7-153C403.5 111.2 306.8 32 205 32 105.3 32 7.3 111.7 7.3 228.7c0 134.1 131.3 221.6 249 189C276 451.3 302 480 351.5 480c81.8 0 90.8-75.3 89-93.3zM297 329.2C277.5 300 253.3 277 205.5 277c-30.5 0-54.3 10-69 22.8l12.2 24.3c6.2-3 13-4 19.8-4 35.5 0 53.7 30.8 69.2 61.3-10 3-20.7 4.2-32.7 4.2-75 0-107.5-53-107.5-156.7C97.5 124.5 130 71 205 71c76.2 0 108.7 53.5 108.7 157.7 .1 41.8-5.4 75.6-16.7 100.5z',
			),
		),
		'label'             => __( 'Quora', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'quote-left'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M96 224C84.72 224 74.05 226.3 64 229.9V224c0-35.3 28.7-64 64-64c17.67 0 32-14.33 32-32S145.7 96 128 96C57.42 96 0 153.4 0 224v96c0 53.02 42.98 96 96 96s96-42.98 96-96S149 224 96 224zM352 224c-11.28 0-21.95 2.305-32 5.879V224c0-35.3 28.7-64 64-64c17.67 0 32-14.33 32-32s-14.33-32-32-32c-70.58 0-128 57.42-128 128v96c0 53.02 42.98 96 96 96s96-42.98 96-96S405 224 352 224z',
			),
		),
		'label'             => __( 'Quote Left', 'astra' ),
		'custom_categories' => array(
			'communication',
		),
	),
	'quote-right'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M96 96C42.98 96 0 138.1 0 192s42.98 96 96 96c11.28 0 21.95-2.305 32-5.879V288c0 35.3-28.7 64-64 64c-17.67 0-32 14.33-32 32s14.33 32 32 32c70.58 0 128-57.42 128-128V192C192 138.1 149 96 96 96zM448 192c0-53.02-42.98-96-96-96s-96 42.98-96 96s42.98 96 96 96c11.28 0 21.95-2.305 32-5.879V288c0 35.3-28.7 64-64 64c-17.67 0-32 14.33-32 32s14.33 32 32 32c70.58 0 128-57.42 128-128V192z',
			),
		),
		'label'             => __( 'Quote Right', 'astra' ),
		'custom_categories' => array(
			'communication',
		),
	),
	'r'                                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 320,
				'height' => 512,
				'path'   => 'M228.7 309.7C282 288.6 320 236.8 320 176c0-79.41-64.59-144-144-144H32c-17.67 0-32 14.33-32 32v384c0 17.67 14.33 32 32 32s32-14.33 32-32v-128h93.43l104.5 146.6c6.25 8.75 16.09 13.42 26.09 13.42c6.422 0 12.91-1.922 18.55-5.938c14.39-10.27 17.73-30.25 7.484-44.64L228.7 309.7zM64 96.01h112c44.11 0 80 35.89 80 80s-35.89 79.1-80 79.1H64V96.01z',
			),
		),
		'label'             => __( 'R', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'r-project'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 581,
				'height' => 512,
				'path'   => 'M581 226.6C581 119.1 450.9 32 290.5 32S0 119.1 0 226.6C0 322.4 103.3 402 239.4 418.1V480h99.1v-61.5c24.3-2.7 47.6-7.4 69.4-13.9L448 480h112l-67.4-113.7c54.5-35.4 88.4-84.9 88.4-139.7zm-466.8 14.5c0-73.5 98.9-133 220.8-133s211.9 40.7 211.9 133c0 50.1-26.5 85-70.3 106.4-2.4-1.6-4.7-2.9-6.4-3.7-10.2-5.2-27.8-10.5-27.8-10.5s86.6-6.4 86.6-92.7-90.6-87.9-90.6-87.9h-199V361c-74.1-21.5-125.2-67.1-125.2-119.9zm225.1 38.3v-55.6c57.8 0 87.8-6.8 87.8 27.3 0 36.5-38.2 28.3-87.8 28.3zm-.9 72.5H365c10.8 0 18.9 11.7 24 19.2-16.1 1.9-33 2.8-50.6 2.9v-22.1z',
			),
		),
		'label'             => __( 'R Project', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'radiation'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 303.1c26.5 0 48-21.5 48-48S282.5 207.1 256 207.1S208 229.5 208 255.1S229.5 303.1 256 303.1zM213.6 188L142.7 74.71C132.5 58.41 109.9 54.31 95.25 66.75c-44.94 38.1-76.19 91.82-85.17 152.8C7.266 238.7 22.67 255.8 42.01 255.8h133.8C175.8 227.2 191 202.3 213.6 188zM416.8 66.75c-14.67-12.44-37.21-8.338-47.41 7.965L298.4 188c22.6 14.3 37.8 39.2 37.8 67.8h133.8c19.34 0 34.74-17.13 31.93-36.26C492.9 158.6 461.7 104.8 416.8 66.75zM298.4 323.5C286.1 331.2 271.6 335.9 256 335.9s-30.1-4.701-42.4-12.4L142.7 436.9c-10.14 16.21-4.16 38.2 13.32 45.95C186.6 496.4 220.4 504 256 504s69.42-7.611 100-21.18c17.48-7.752 23.46-29.74 13.32-45.95L298.4 323.5z',
			),
		),
		'label'             => __( 'Radiation', 'astra' ),
		'custom_categories' => array(
			'environment',
			'science-and-technology',
		),
	),
	'radio'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M447.1 128L218.5 128l276.2-80.97c12.72-3.734 19.1-17.06 16.28-29.78c-3.719-12.7-16.1-19.1-29.78-16.28L51.75 126.9c-29.07 8.512-49.55 34.8-51.39 64.78L.0007 192v255.1c0 35.31 28.69 63.1 63.1 63.1h383.1c35.31 0 63.1-28.69 63.1-63.1V192C511.1 156.7 483.3 128 447.1 128zM80 248c0-4.406 3.594-7.1 7.1-7.1h111.1c4.406 0 7.1 3.594 7.1 7.1V263.1c0 4.406-3.594 7.1-7.1 7.1h-111.1c-4.406 0-7.1-3.594-7.1-7.1V248zM208 391.1c0 4.406-3.594 7.1-7.1 7.1h-111.1c-4.406 0-7.1-3.594-7.1-7.1v-15.1c0-4.406 3.594-7.1 7.1-7.1h111.1c4.406 0 7.1 3.594 7.1 7.1V391.1zM224 327.1c0 4.406-3.594 7.1-7.1 7.1H72c-4.406 0-7.1-3.594-7.1-7.1V311.1c0-4.406 3.594-7.1 7.1-7.1h143.1c4.406 0 7.1 3.594 7.1 7.1V327.1zM367.1 399.1c-44.16 0-80-35.84-80-79.1s35.84-80 80-80s79.1 35.85 79.1 80S412.2 399.1 367.1 399.1z',
			),
		),
		'label'             => __( 'Radio', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'rainbow'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M312.3 32.09C137.6 36.22 0 183.3 0 358V464C0 472.8 7.164 480 16 480h32C56.84 480 64 472.8 64 464v-106.9c0-143.2 117.2-263.5 260.4-261.1C463.5 98.4 576 212.3 576 352v112c0 8.836 7.164 16 16 16h32c8.838 0 16-7.164 16-16V352C640 172.1 492.3 27.84 312.3 32.09zM313.5 224.2C244.8 227.6 192 286.9 192 355.7V464C192 472.8 199.2 480 208 480h32C248.8 480 256 472.8 256 464v-109.7c0-34.06 25.65-63.85 59.64-66.11C352.9 285.7 384 315.3 384 352v112c0 8.836 7.164 16 16 16h32c8.838 0 16-7.164 16-16V352C448 279.3 387 220.5 313.5 224.2zM313.2 128.1C191.4 131.7 96 234.9 96 356.8V464C96 472.8 103.2 480 112 480h32C152.8 480 160 472.8 160 464v-108.1c0-86.64 67.24-160.5 153.8-163.8C404.8 188.7 480 261.7 480 352v112c0 8.836 7.164 16 16 16h32c8.838 0 16-7.164 16-16V352C544 226.2 439.8 124.3 313.2 128.1z',
			),
		),
		'label'             => __( 'Rainbow', 'astra' ),
		'custom_categories' => array(
			'environment',
		),
	),
	'ranking-star'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M406.1 61.65C415.4 63.09 419.4 74.59 412.6 81.41L374.6 118.1L383.6 170.1C384.1 179.5 375.3 186.7 366.7 182.4L320.2 157.9L273.3 182.7C264.7 187 255 179.8 256.4 170.5L265.4 118.4L227.4 81.41C220.6 74.59 224.6 63.09 233.9 61.65L286.2 54.11L309.8 6.332C314.1-2.289 326.3-1.93 330.2 6.332L353.8 54.11L406.1 61.65zM384 256C401.7 256 416 270.3 416 288V480C416 497.7 401.7 512 384 512H256C238.3 512 224 497.7 224 480V288C224 270.3 238.3 256 256 256H384zM160 320C177.7 320 192 334.3 192 352V480C192 497.7 177.7 512 160 512H32C14.33 512 0 497.7 0 480V352C0 334.3 14.33 320 32 320H160zM448 416C448 398.3 462.3 384 480 384H608C625.7 384 640 398.3 640 416V480C640 497.7 625.7 512 608 512H480C462.3 512 448 497.7 448 480V416z',
			),
		),
		'label'             => __( 'Ranking Star', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
		),
	),
	'raspberry-pi'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 407,
				'height' => 512,
				'path'   => 'M372 232.5l-3.7-6.5c.1-46.4-21.4-65.3-46.5-79.7 7.6-2 15.4-3.6 17.6-13.2 13.1-3.3 15.8-9.4 17.1-15.8 3.4-2.3 14.8-8.7 13.6-19.7 6.4-4.4 10-10.1 8.1-18.1 6.9-7.5 8.7-13.7 5.8-19.4 8.3-10.3 4.6-15.6 1.1-20.9 6.2-11.2 .7-23.2-16.6-21.2-6.9-10.1-21.9-7.8-24.2-7.8-2.6-3.2-6-6-16.5-4.7-6.8-6.1-14.4-5-22.3-2.1-9.3-7.3-15.5-1.4-22.6 .8C271.6 .6 269 5.5 263.5 7.6c-12.3-2.6-16.1 3-22 8.9l-6.9-.1c-18.6 10.8-27.8 32.8-31.1 44.1-3.3-11.3-12.5-33.3-31.1-44.1l-6.9 .1c-5.9-5.9-9.7-11.5-22-8.9-5.6-2-8.1-7-19.4-3.4-4.6-1.4-8.9-4.4-13.9-4.3-2.6 .1-5.5 1-8.7 3.5-7.9-3-15.5-4-22.3 2.1-10.5-1.3-14 1.4-16.5 4.7-2.3 0-17.3-2.3-24.2 7.8C21.2 16 15.8 28 22 39.2c-3.5 5.4-7.2 10.7 1.1 20.9-2.9 5.7-1.1 11.9 5.8 19.4-1.8 8 1.8 13.7 8.1 18.1-1.2 11 10.2 17.4 13.6 19.7 1.3 6.4 4 12.4 17.1 15.8 2.2 9.5 10 11.2 17.6 13.2-25.1 14.4-46.6 33.3-46.5 79.7l-3.7 6.5c-28.8 17.2-54.7 72.7-14.2 117.7 2.6 14.1 7.1 24.2 11 35.4 5.9 45.2 44.5 66.3 54.6 68.8 14.9 11.2 30.8 21.8 52.2 29.2C159 504.2 181 512 203 512h1c22.1 0 44-7.8 64.2-28.4 21.5-7.4 37.3-18 52.2-29.2 10.2-2.5 48.7-23.6 54.6-68.8 3.9-11.2 8.4-21.3 11-35.4 40.6-45.1 14.7-100.5-14-117.7zm-22.2-8c-1.5 18.7-98.9-65.1-82.1-67.9 45.7-7.5 83.6 19.2 82.1 67.9zm-43 93.1c-24.5 15.8-59.8 5.6-78.8-22.8s-14.6-64.2 9.9-80c24.5-15.8 59.8-5.6 78.8 22.8s14.6 64.2-9.9 80zM238.9 29.3c.8 4.2 1.8 6.8 2.9 7.6 5.4-5.8 9.8-11.7 16.8-17.3 0 3.3-1.7 6.8 2.5 9.4 3.7-5 8.8-9.5 15.5-13.3-3.2 5.6-.6 7.3 1.2 9.6 5.1-4.4 10-8.8 19.4-12.3-2.6 3.1-6.2 6.2-2.4 9.8 5.3-3.3 10.6-6.6 23.1-8.9-2.8 3.1-8.7 6.3-5.1 9.4 6.6-2.5 14-4.4 22.1-5.4-3.9 3.2-7.1 6.3-3.9 8.8 7.1-2.2 16.9-5.1 26.4-2.6l-6 6.1c-.7 .8 14.1 .6 23.9 .8-3.6 5-7.2 9.7-9.3 18.2 1 1 5.8 .4 10.4 0-4.7 9.9-12.8 12.3-14.7 16.6 2.9 2.2 6.8 1.6 11.2 .1-3.4 6.9-10.4 11.7-16 17.3 1.4 1 3.9 1.6 9.7 .9-5.2 5.5-11.4 10.5-18.8 15 1.3 1.5 5.8 1.5 10 1.6-6.7 6.5-15.3 9.9-23.4 14.2 4 2.7 6.9 2.1 10 2.1-5.7 4.7-15.4 7.1-24.4 10 1.7 2.7 3.4 3.4 7.1 4.1-9.5 5.3-23.2 2.9-27 5.6 .9 2.7 3.6 4.4 6.7 5.8-15.4 .9-57.3-.6-65.4-32.3 15.7-17.3 44.4-37.5 93.7-62.6-38.4 12.8-73 30-102 53.5-34.3-15.9-10.8-55.9 5.8-71.8zm-34.4 114.6c24.2-.3 54.1 17.8 54 34.7-.1 15-21 27.1-53.8 26.9-32.1-.4-53.7-15.2-53.6-29.8 0-11.9 26.2-32.5 53.4-31.8zm-123-12.8c3.7-.7 5.4-1.5 7.1-4.1-9-2.8-18.7-5.3-24.4-10 3.1 0 6 .7 10-2.1-8.1-4.3-16.7-7.7-23.4-14.2 4.2-.1 8.7 0 10-1.6-7.4-4.5-13.6-9.5-18.8-15 5.8 .7 8.3 .1 9.7-.9-5.6-5.6-12.7-10.4-16-17.3 4.3 1.5 8.3 2 11.2-.1-1.9-4.2-10-6.7-14.7-16.6 4.6 .4 9.4 1 10.4 0-2.1-8.5-5.8-13.3-9.3-18.2 9.8-.1 24.6 0 23.9-.8l-6-6.1c9.5-2.5 19.3 .4 26.4 2.6 3.2-2.5-.1-5.6-3.9-8.8 8.1 1.1 15.4 2.9 22.1 5.4 3.5-3.1-2.3-6.3-5.1-9.4 12.5 2.3 17.8 5.6 23.1 8.9 3.8-3.6 .2-6.7-2.4-9.8 9.4 3.4 14.3 7.9 19.4 12.3 1.7-2.3 4.4-4 1.2-9.6 6.7 3.8 11.8 8.3 15.5 13.3 4.1-2.6 2.5-6.2 2.5-9.4 7 5.6 11.4 11.5 16.8 17.3 1.1-.8 2-3.4 2.9-7.6 16.6 15.9 40.1 55.9 6 71.8-29-23.5-63.6-40.7-102-53.5 49.3 25 78 45.3 93.7 62.6-8 31.8-50 33.2-65.4 32.3 3.1-1.4 5.8-3.2 6.7-5.8-4-2.8-17.6-.4-27.2-5.6zm60.1 24.1c16.8 2.8-80.6 86.5-82.1 67.9-1.5-48.7 36.5-75.5 82.1-67.9zM38.2 342c-23.7-18.8-31.3-73.7 12.6-98.3 26.5-7 9 107.8-12.6 98.3zm91 98.2c-13.3 7.9-45.8 4.7-68.8-27.9-15.5-27.4-13.5-55.2-2.6-63.4 16.3-9.8 41.5 3.4 60.9 25.6 16.9 20 24.6 55.3 10.5 65.7zm-26.4-119.7c-24.5-15.8-28.9-51.6-9.9-80s54.3-38.6 78.8-22.8 28.9 51.6 9.9 80c-19.1 28.4-54.4 38.6-78.8 22.8zM205 496c-29.4 1.2-58.2-23.7-57.8-32.3-.4-12.7 35.8-22.6 59.3-22 23.7-1 55.6 7.5 55.7 18.9 .5 11-28.8 35.9-57.2 35.4zm58.9-124.9c.2 29.7-26.2 53.8-58.8 54-32.6 .2-59.2-23.8-59.4-53.4v-.6c-.2-29.7 26.2-53.8 58.8-54 32.6-.2 59.2 23.8 59.4 53.4v.6zm82.2 42.7c-25.3 34.6-59.6 35.9-72.3 26.3-13.3-12.4-3.2-50.9 15.1-72 20.9-23.3 43.3-38.5 58.9-26.6 10.5 10.3 16.7 49.1-1.7 72.3zm22.9-73.2c-21.5 9.4-39-105.3-12.6-98.3 43.9 24.7 36.3 79.6 12.6 98.3z',
			),
		),
		'label'             => __( 'Raspberry Pi', 'astra' ),
		'custom_categories' => array(),
	),
	'ravelry'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M498.3 234.2c-1.208-10.34-1.7-20.83-3.746-31a310.3 310.3 0 0 0 -9.622-36.6 184.1 184.1 0 0 0 -30.87-57.5 251.2 251.2 0 0 0 -18.82-21.69 237.4 237.4 0 0 0 -47.11-36.12A240.8 240.8 0 0 0 331.4 26.65c-11.02-3.1-22.27-5.431-33.51-7.615-6.78-1.314-13.75-1.667-20.63-2.482-.316-.036-.6-.358-.9-.553q-16.14 .009-32.29 .006c-2.41 .389-4.808 .925-7.236 1.15a179.3 179.3 0 0 0 -34.26 7.1 221.5 221.5 0 0 0 -39.77 16.35 281.4 281.4 0 0 0 -38.08 24.16c-6.167 4.61-12.27 9.36-17.97 14.52C96.54 88.49 86.34 97.72 76.79 107.6a243.9 243.9 0 0 0 -33.65 43.95 206.5 206.5 0 0 0 -20.49 44.6 198.2 198.2 0 0 0 -7.691 34.76A201.1 201.1 0 0 0 13.4 266.4a299.7 299.7 0 0 0 4.425 40.24 226.9 226.9 0 0 0 16.73 53.3 210.5 210.5 0 0 0 24 39.53 213.6 213.6 0 0 0 26.36 28.42A251.3 251.3 0 0 0 126.7 458.5a287.8 287.8 0 0 0 55.9 25.28 269.5 269.5 0 0 0 40.64 9.835c6.071 1.01 12.27 1.253 18.41 1.873a4.149 4.149 0 0 1 1.19 .56h32.29c2.507-.389 5-.937 7.527-1.143 16.34-1.332 32.11-5.335 47.49-10.72A219.1 219.1 0 0 0 379.1 460.3c9.749-6.447 19.4-13.08 28.74-20.1 5.785-4.348 10.99-9.5 16.3-14.46 3.964-3.7 7.764-7.578 11.51-11.5a232.2 232.2 0 0 0 31.43-41.64c9.542-16.05 17.35-32.9 22.3-50.93 2.859-10.41 4.947-21.05 7.017-31.65 1.032-5.279 1.251-10.72 1.87-16.09 .036-.317 .358-.6 .552-.9V236A9.757 9.757 0 0 1 498.3 234.2zm-161.1-1.15s-16.57-2.98-28.47-2.98c-27.2 0-33.57 14.9-33.57 37.04V360.8H201.6V170.1H275.1v31.93c8.924-26.82 26.77-36.19 62.04-36.19z',
			),
		),
		'label'             => __( 'Ravelry', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'react'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M418.2 177.2c-5.4-1.8-10.8-3.5-16.2-5.1 .9-3.7 1.7-7.4 2.5-11.1 12.3-59.6 4.2-107.5-23.1-123.3-26.3-15.1-69.2 .6-112.6 38.4-4.3 3.7-8.5 7.6-12.5 11.5-2.7-2.6-5.5-5.2-8.3-7.7-45.5-40.4-91.1-57.4-118.4-41.5-26.2 15.2-34 60.3-23 116.7 1.1 5.6 2.3 11.1 3.7 16.7-6.4 1.8-12.7 3.8-18.6 5.9C38.3 196.2 0 225.4 0 255.6c0 31.2 40.8 62.5 96.3 81.5 4.5 1.5 9 3 13.6 4.3-1.5 6-2.8 11.9-4 18-10.5 55.5-2.3 99.5 23.9 114.6 27 15.6 72.4-.4 116.6-39.1 3.5-3.1 7-6.3 10.5-9.7 4.4 4.3 9 8.4 13.6 12.4 42.8 36.8 85.1 51.7 111.2 36.6 27-15.6 35.8-62.9 24.4-120.5-.9-4.4-1.9-8.9-3-13.5 3.2-.9 6.3-1.9 9.4-2.9 57.7-19.1 99.5-50 99.5-81.7 0-30.3-39.4-59.7-93.8-78.4zM282.9 92.3c37.2-32.4 71.9-45.1 87.7-36 16.9 9.7 23.4 48.9 12.8 100.4-.7 3.4-1.4 6.7-2.3 10-22.2-5-44.7-8.6-67.3-10.6-13-18.6-27.2-36.4-42.6-53.1 3.9-3.7 7.7-7.2 11.7-10.7zM167.2 307.5c5.1 8.7 10.3 17.4 15.8 25.9-15.6-1.7-31.1-4.2-46.4-7.5 4.4-14.4 9.9-29.3 16.3-44.5 4.6 8.8 9.3 17.5 14.3 26.1zm-30.3-120.3c14.4-3.2 29.7-5.8 45.6-7.8-5.3 8.3-10.5 16.8-15.4 25.4-4.9 8.5-9.7 17.2-14.2 26-6.3-14.9-11.6-29.5-16-43.6zm27.4 68.9c6.6-13.8 13.8-27.3 21.4-40.6s15.8-26.2 24.4-38.9c15-1.1 30.3-1.7 45.9-1.7s31 .6 45.9 1.7c8.5 12.6 16.6 25.5 24.3 38.7s14.9 26.7 21.7 40.4c-6.7 13.8-13.9 27.4-21.6 40.8-7.6 13.3-15.7 26.2-24.2 39-14.9 1.1-30.4 1.6-46.1 1.6s-30.9-.5-45.6-1.4c-8.7-12.7-16.9-25.7-24.6-39s-14.8-26.8-21.5-40.6zm180.6 51.2c5.1-8.8 9.9-17.7 14.6-26.7 6.4 14.5 12 29.2 16.9 44.3-15.5 3.5-31.2 6.2-47 8 5.4-8.4 10.5-17 15.5-25.6zm14.4-76.5c-4.7-8.8-9.5-17.6-14.5-26.2-4.9-8.5-10-16.9-15.3-25.2 16.1 2 31.5 4.7 45.9 8-4.6 14.8-10 29.2-16.1 43.4zM256.2 118.3c10.5 11.4 20.4 23.4 29.6 35.8-19.8-.9-39.7-.9-59.5 0 9.8-12.9 19.9-24.9 29.9-35.8zM140.2 57c16.8-9.8 54.1 4.2 93.4 39 2.5 2.2 5 4.6 7.6 7-15.5 16.7-29.8 34.5-42.9 53.1-22.6 2-45 5.5-67.2 10.4-1.3-5.1-2.4-10.3-3.5-15.5-9.4-48.4-3.2-84.9 12.6-94zm-24.5 263.6c-4.2-1.2-8.3-2.5-12.4-3.9-21.3-6.7-45.5-17.3-63-31.2-10.1-7-16.9-17.8-18.8-29.9 0-18.3 31.6-41.7 77.2-57.6 5.7-2 11.5-3.8 17.3-5.5 6.8 21.7 15 43 24.5 63.6-9.6 20.9-17.9 42.5-24.8 64.5zm116.6 98c-16.5 15.1-35.6 27.1-56.4 35.3-11.1 5.3-23.9 5.8-35.3 1.3-15.9-9.2-22.5-44.5-13.5-92 1.1-5.6 2.3-11.2 3.7-16.7 22.4 4.8 45 8.1 67.9 9.8 13.2 18.7 27.7 36.6 43.2 53.4-3.2 3.1-6.4 6.1-9.6 8.9zm24.5-24.3c-10.2-11-20.4-23.2-30.3-36.3 9.6 .4 19.5 .6 29.5 .6 10.3 0 20.4-.2 30.4-.7-9.2 12.7-19.1 24.8-29.6 36.4zm130.7 30c-.9 12.2-6.9 23.6-16.5 31.3-15.9 9.2-49.8-2.8-86.4-34.2-4.2-3.6-8.4-7.5-12.7-11.5 15.3-16.9 29.4-34.8 42.2-53.6 22.9-1.9 45.7-5.4 68.2-10.5 1 4.1 1.9 8.2 2.7 12.2 4.9 21.6 5.7 44.1 2.5 66.3zm18.2-107.5c-2.8 .9-5.6 1.8-8.5 2.6-7-21.8-15.6-43.1-25.5-63.8 9.6-20.4 17.7-41.4 24.5-62.9 5.2 1.5 10.2 3.1 15 4.7 46.6 16 79.3 39.8 79.3 58 0 19.6-34.9 44.9-84.8 61.4zm-149.7-15c25.3 0 45.8-20.5 45.8-45.8s-20.5-45.8-45.8-45.8c-25.3 0-45.8 20.5-45.8 45.8s20.5 45.8 45.8 45.8z',
			),
		),
		'label'             => __( 'React', 'astra' ),
		'custom_categories' => array(),
	),
	'reacteurope'                            => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M250.6 211.7l5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1-2.3-6.8-2.3 6.8-7.2 .1 5.7 4.3zm63.7 0l5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.2-.1-2.3-6.8-2.3 6.8-7.2 .1 5.7 4.3zm-91.3 50.5h-3.4c-4.8 0-3.8 4-3.8 12.1 0 4.7-2.3 6.1-5.8 6.1s-5.8-1.4-5.8-6.1v-36.6c0-4.7 2.3-6.1 5.8-6.1s5.8 1.4 5.8 6.1c0 7.2-.7 10.5 3.8 10.5h3.4c4.7-.1 3.8-3.9 3.8-12.3 0-9.9-6.7-14.1-16.8-14.1h-.2c-10.1 0-16.8 4.2-16.8 14.1V276c0 10.4 6.7 14.1 16.8 14.1h.2c10.1 0 16.8-3.8 16.8-14.1 0-9.86 1.1-13.76-3.8-13.76zm-80.7 17.4h-14.7v-19.3H139c2.5 0 3.8-1.3 3.8-3.8v-2.1c0-2.5-1.3-3.8-3.8-3.8h-11.4v-18.3H142c2.5 0 3.8-1.3 3.8-3.8v-2.1c0-2.5-1.3-3.8-3.8-3.8h-21.7c-2.4-.1-3.7 1.3-3.7 3.8v59.1c0 2.5 1.3 3.8 3.8 3.8h21.9c2.5 0 3.8-1.3 3.8-3.8v-2.1c0-2.5-1.3-3.8-3.8-3.8zm-42-18.5c4.6-2 7.3-6 7.3-12.4v-11.9c0-10.1-6.7-14.1-16.8-14.1H77.4c-2.5 0-3.8 1.3-3.8 3.8v59.1c0 2.5 1.3 3.8 3.8 3.8h3.4c2.5 0 3.8-1.3 3.8-3.8v-22.9h5.6l7.4 23.5a4.1 4.1 0 0 0 4.3 3.2h3.3c2.8 0 4-1.8 3.2-4.4zm-3.8-14c0 4.8-2.5 6.1-6.1 6.1h-5.8v-20.9h5.8c3.6 0 6.1 1.3 6.1 6.1zM176 226a3.82 3.82 0 0 0 -4.2-3.4h-6.9a3.68 3.68 0 0 0 -4 3.4l-11 59.2c-.5 2.7 .9 4.1 3.4 4.1h3a3.74 3.74 0 0 0 4.1-3.5l1.8-11.3h12.2l1.8 11.3a3.74 3.74 0 0 0 4.1 3.5h3.5c2.6 0 3.9-1.4 3.4-4.1zm-12.3 39.3l4.7-29.7 4.7 29.7zm89.3 20.2v-53.2h7.5c2.5 0 3.8-1.3 3.8-3.8v-2.1c0-2.5-1.3-3.8-3.8-3.8h-25.8c-2.5 0-3.8 1.3-3.8 3.8v2.1c0 2.5 1.3 3.8 3.8 3.8h7.3v53.2c0 2.5 1.3 3.8 3.8 3.8h3.4c2.5 .04 3.8-1.3 3.8-3.76zm248-.8h-19.4V258h16.1a1.89 1.89 0 0 0 2-2v-.8a1.89 1.89 0 0 0 -2-2h-16.1v-25.8h19.1a1.89 1.89 0 0 0 2-2v-.8a1.77 1.77 0 0 0 -2-1.9h-22.2a1.62 1.62 0 0 0 -2 1.8v63a1.81 1.81 0 0 0 2 1.9H501a1.81 1.81 0 0 0 2-1.9v-.8a1.84 1.84 0 0 0 -2-1.96zm-93.1-62.9h-.8c-10.1 0-15.3 4.7-15.3 14.1V276c0 9.3 5.2 14.1 15.3 14.1h.8c10.1 0 15.3-4.8 15.3-14.1v-40.1c0-9.36-5.2-14.06-15.3-14.06zm10.2 52.4c-.1 8-3 11.1-10.5 11.1s-10.5-3.1-10.5-11.1v-36.6c0-7.9 3-11.1 10.5-11.1s10.5 3.2 10.5 11.1zm-46.5-14.5c6.1-1.6 9.2-6.1 9.2-13.3v-9.7c0-9.4-5.2-14.1-15.3-14.1h-13.7a1.81 1.81 0 0 0 -2 1.9v63a1.81 1.81 0 0 0 2 1.9h1.2a1.74 1.74 0 0 0 1.9-1.9v-26.9h11.6l10.4 27.2a2.32 2.32 0 0 0 2.3 1.5h1.5c1.4 0 2-1 1.5-2.3zm-6.4-3.9H355v-28.5h10.2c7.5 0 10.5 3.1 10.5 11.1v6.4c0 7.84-3 11.04-10.5 11.04zm85.9-33.1h-13.7a1.62 1.62 0 0 0 -2 1.8v63a1.81 1.81 0 0 0 2 1.9h1.2a1.74 1.74 0 0 0 1.9-1.9v-26.1h10.6c10.1 0 15.3-4.8 15.3-14.1v-10.5c0-9.4-5.2-14.1-15.3-14.1zm10.2 22.8c0 7.9-3 11.1-10.5 11.1h-10.2v-29.2h10.2c7.5-.1 10.5 3.1 10.5 11zM259.5 308l-2.3-6.8-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3zm227.6-136.1a364.4 364.4 0 0 0 -35.6-11.3c19.6-78 11.6-134.7-22.3-153.9C394.7-12.66 343.3 11 291 61.94q5.1 4.95 10.2 10.2c82.5-80 119.6-53.5 120.9-52.8 22.4 12.7 36 55.8 15.5 137.8a587.8 587.8 0 0 0 -84.6-13C281.1 43.64 212.4 2 170.8 2 140 2 127 23 123.2 29.74c-18.1 32-13.3 84.2 .1 133.8-70.5 20.3-120.7 54.1-120.3 95 .5 59.6 103.2 87.8 122.1 92.8-20.5 81.9-10.1 135.6 22.3 153.9 28 15.8 75.1 6 138.2-55.2q-5.1-4.95-10.2-10.2c-82.5 80-119.7 53.5-120.9 52.8-22.3-12.6-36-55.6-15.5-137.9 12.4 2.9 41.8 9.5 84.6 13 71.9 100.4 140.6 142 182.1 142 30.8 0 43.8-21 47.6-27.7 18-31.9 13.3-84.1-.1-133.8 152.3-43.8 156.2-130.2 33.9-176.3zM135.9 36.84c2.9-5.1 11.9-20.3 34.9-20.3 36.8 0 98.8 39.6 163.3 126.2a714 714 0 0 0 -93.9 .9 547.8 547.8 0 0 1 42.2-52.4Q277.3 86 272.2 81a598.3 598.3 0 0 0 -50.7 64.2 569.7 569.7 0 0 0 -84.4 14.6c-.2-1.4-24.3-82.2-1.2-123zm304.8 438.3c-2.9 5.1-11.8 20.3-34.9 20.3-36.7 0-98.7-39.4-163.3-126.2a695.4 695.4 0 0 0 93.9-.9 547.8 547.8 0 0 1 -42.2 52.4q5.1 5.25 10.2 10.2a588.5 588.5 0 0 0 50.7-64.2c47.3-4.7 80.3-13.5 84.4-14.6 22.7 84.4 4.5 117 1.2 123zm9.1-138.6c-3.6-11.9-7.7-24.1-12.4-36.4a12.67 12.67 0 0 1 -10.7-5.7l-.1 .1a19.61 19.61 0 0 1 -5.4 3.6c5.7 14.3 10.6 28.4 14.7 42.2a535.3 535.3 0 0 1 -72 13c3.5-5.3 17.2-26.2 32.2-54.2a24.6 24.6 0 0 1 -6-3.2c-1.1 1.2-3.6 4.2-10.9 4.2-6.2 11.2-17.4 30.9-33.9 55.2a711.9 711.9 0 0 1 -112.4 1c-7.9-11.2-21.5-31.1-36.8-57.8a21 21 0 0 1 -3-1.5c-1.9 1.6-3.9 3.2-12.6 3.2 6.3 11.2 17.5 30.7 33.8 54.6a548.8 548.8 0 0 1 -72.2-11.7q5.85-21 14.1-42.9c-3.2 0-5.4 .2-8.4-1a17.58 17.58 0 0 1 -6.9 1c-4.9 13.4-9.1 26.5-12.7 39.4C-31.7 297-12.1 216 126.7 175.6c3.6 11.9 7.7 24.1 12.4 36.4 10.4 0 12.9 3.4 14.4 5.3a12 12 0 0 1 2.3-2.2c-5.8-14.7-10.9-29.2-15.2-43.3 7-1.8 32.4-8.4 72-13-15.9 24.3-26.7 43.9-32.8 55.3a14.22 14.22 0 0 1 6.4 8 23.42 23.42 0 0 1 10.2-8.4c6.5-11.7 17.9-31.9 34.8-56.9a711.7 711.7 0 0 1 112.4-1c31.5 44.6 28.9 48.1 42.5 64.5a21.42 21.42 0 0 1 10.4-7.4c-6.4-11.4-17.6-31-34.3-55.5 40.4 4.1 65 10 72.2 11.7-4 14.4-8.9 29.2-14.6 44.2a20.74 20.74 0 0 1 6.8 4.3l.1 .1a12.72 12.72 0 0 1 8.9-5.6c4.9-13.4 9.2-26.6 12.8-39.5a359.7 359.7 0 0 1 34.5 11c106.1 39.9 74 87.9 72.6 90.4-19.8 35.1-80.1 55.2-105.7 62.5zm-114.4-114h-1.2a1.74 1.74 0 0 0 -1.9 1.9v49.8c0 7.9-2.6 11.1-10.1 11.1s-10.1-3.1-10.1-11.1v-49.8a1.69 1.69 0 0 0 -1.9-1.9H309a1.81 1.81 0 0 0 -2 1.9v51.5c0 9.6 5 14.1 15.1 14.1h.4c10.1 0 15.1-4.6 15.1-14.1v-51.5a2 2 0 0 0 -2.2-1.9zM321.7 308l-2.3-6.8-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3zm-31.1 7.4l-2.3-6.8-2.3 6.8-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3zm5.1-30.8h-19.4v-26.7h16.1a1.89 1.89 0 0 0 2-2v-.8a1.89 1.89 0 0 0 -2-2h-16.1v-25.8h19.1a1.89 1.89 0 0 0 2-2v-.8a1.77 1.77 0 0 0 -2-1.9h-22.2a1.81 1.81 0 0 0 -2 1.9v63a1.81 1.81 0 0 0 2 1.9h22.5a1.77 1.77 0 0 0 2-1.9v-.8a1.83 1.83 0 0 0 -2-2.06zm-7.4-99.4L286 192l-7.1 .1 5.7 4.3-2.1 6.8 5.8-4.1 5.8 4.1-2.1-6.8 5.7-4.3-7.1-.1z',
			),
		),
		'label'             => __( 'ReactEurope', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'readme'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M528.3 46.5H388.5c-48.1 0-89.9 33.3-100.4 80.3-10.6-47-52.3-80.3-100.4-80.3H48c-26.5 0-48 21.5-48 48v245.8c0 26.5 21.5 48 48 48h89.7c102.2 0 132.7 24.4 147.3 75 .7 2.8 5.2 2.8 6 0 14.7-50.6 45.2-75 147.3-75H528c26.5 0 48-21.5 48-48V94.6c0-26.4-21.3-47.9-47.7-48.1zM242 311.9c0 1.9-1.5 3.5-3.5 3.5H78.2c-1.9 0-3.5-1.5-3.5-3.5V289c0-1.9 1.5-3.5 3.5-3.5h160.4c1.9 0 3.5 1.5 3.5 3.5v22.9zm0-60.9c0 1.9-1.5 3.5-3.5 3.5H78.2c-1.9 0-3.5-1.5-3.5-3.5v-22.9c0-1.9 1.5-3.5 3.5-3.5h160.4c1.9 0 3.5 1.5 3.5 3.5V251zm0-60.9c0 1.9-1.5 3.5-3.5 3.5H78.2c-1.9 0-3.5-1.5-3.5-3.5v-22.9c0-1.9 1.5-3.5 3.5-3.5h160.4c1.9 0 3.5 1.5 3.5 3.5v22.9zm259.3 121.7c0 1.9-1.5 3.5-3.5 3.5H337.5c-1.9 0-3.5-1.5-3.5-3.5v-22.9c0-1.9 1.5-3.5 3.5-3.5h160.4c1.9 0 3.5 1.5 3.5 3.5v22.9zm0-60.9c0 1.9-1.5 3.5-3.5 3.5H337.5c-1.9 0-3.5-1.5-3.5-3.5V228c0-1.9 1.5-3.5 3.5-3.5h160.4c1.9 0 3.5 1.5 3.5 3.5v22.9zm0-60.9c0 1.9-1.5 3.5-3.5 3.5H337.5c-1.9 0-3.5-1.5-3.5-3.5v-22.8c0-1.9 1.5-3.5 3.5-3.5h160.4c1.9 0 3.5 1.5 3.5 3.5V190z',
			),
		),
		'label'             => __( 'ReadMe', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'rebel'                                  => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256.5 504C117.2 504 9 387.8 13.2 249.9 16 170.7 56.4 97.7 129.7 49.5c.3 0 1.9-.6 1.1 .8-5.8 5.5-111.3 129.8-14.1 226.4 49.8 49.5 90 2.5 90 2.5 38.5-50.1-.6-125.9-.6-125.9-10-24.9-45.7-40.1-45.7-40.1l28.8-31.8c24.4 10.5 43.2 38.7 43.2 38.7 .8-29.6-21.9-61.4-21.9-61.4L255.1 8l44.3 50.1c-20.5 28.8-21.9 62.6-21.9 62.6 13.8-23 43.5-39.3 43.5-39.3l28.5 31.8c-27.4 8.9-45.4 39.9-45.4 39.9-15.8 28.5-27.1 89.4 .6 127.3 32.4 44.6 87.7-2.8 87.7-2.8 102.7-91.9-10.5-225-10.5-225-6.1-5.5 .8-2.8 .8-2.8 50.1 36.5 114.6 84.4 116.2 204.8C500.9 400.2 399 504 256.5 504z',
			),
		),
		'label'             => __( 'Rebel Alliance', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'receipt'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M13.97 2.196C22.49-1.72 32.5-.3214 39.62 5.778L80 40.39L120.4 5.778C129.4-1.926 142.6-1.926 151.6 5.778L192 40.39L232.4 5.778C241.4-1.926 254.6-1.926 263.6 5.778L304 40.39L344.4 5.778C351.5-.3214 361.5-1.72 370 2.196C378.5 6.113 384 14.63 384 24V488C384 497.4 378.5 505.9 370 509.8C361.5 513.7 351.5 512.3 344.4 506.2L304 471.6L263.6 506.2C254.6 513.9 241.4 513.9 232.4 506.2L192 471.6L151.6 506.2C142.6 513.9 129.4 513.9 120.4 506.2L80 471.6L39.62 506.2C32.5 512.3 22.49 513.7 13.97 509.8C5.456 505.9 0 497.4 0 488V24C0 14.63 5.456 6.112 13.97 2.196V2.196zM96 144C87.16 144 80 151.2 80 160C80 168.8 87.16 176 96 176H288C296.8 176 304 168.8 304 160C304 151.2 296.8 144 288 144H96zM96 368H288C296.8 368 304 360.8 304 352C304 343.2 296.8 336 288 336H96C87.16 336 80 343.2 80 352C80 360.8 87.16 368 96 368zM96 240C87.16 240 80 247.2 80 256C80 264.8 87.16 272 96 272H288C296.8 272 304 264.8 304 256C304 247.2 296.8 240 288 240H96z',
			),
		),
		'label'             => __( 'Receipt', 'astra' ),
		'custom_categories' => array(
			'business',
			'lifestyle-and-hobbies',
			'science-and-technology',
		),
	),
	'record-vinyl'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 160C202.9 160 160 202.9 160 256s42.92 96 96 96c53.08 0 96-42.92 96-96S309.1 160 256 160zM256 288C238.3 288 224 273.7 224 256s14.33-32 32-32c17.67 0 32 14.33 32 32S273.7 288 256 288zM256 0c-141.4 0-256 114.6-256 256s114.6 256 256 256c141.4 0 256-114.6 256-256S397.4 0 256 0zM256 384c-70.75 0-128-57.25-128-128s57.25-128 128-128s128 57.25 128 128S326.8 384 256 384z',
			),
		),
		'label'             => __( 'Record Vinyl', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'rectangle-ad'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M208 237.7L229.2 280H186.8L208 237.7zM416 280C416 293.3 405.3 304 392 304C378.7 304 368 293.3 368 280C368 266.7 378.7 256 392 256C405.3 256 416 266.7 416 280zM512 32C547.3 32 576 60.65 576 96V416C576 451.3 547.3 480 512 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H512zM229.5 173.3C225.4 165.1 217.1 160 208 160C198.9 160 190.6 165.1 186.5 173.3L114.5 317.3C108.6 329.1 113.4 343.5 125.3 349.5C137.1 355.4 151.5 350.6 157.5 338.7L162.8 328H253.2L258.5 338.7C264.5 350.6 278.9 355.4 290.7 349.5C302.6 343.5 307.4 329.1 301.5 317.3L229.5 173.3zM416 212.1C408.5 209.4 400.4 208 392 208C352.2 208 320 240.2 320 280C320 319.8 352.2 352 392 352C403.1 352 413.6 349.5 423 344.1C427.4 349.3 433.4 352 440 352C453.3 352 464 341.3 464 328V184C464 170.7 453.3 160 440 160C426.7 160 416 170.7 416 184V212.1z',
			),
		),
		'label'             => __( 'Rectangle Ad', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'rectangle-list'                         => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M0 96C0 60.65 28.65 32 64 32H512C547.3 32 576 60.65 576 96V416C576 451.3 547.3 480 512 480H64C28.65 480 0 451.3 0 416V96zM160 256C160 238.3 145.7 224 128 224C110.3 224 96 238.3 96 256C96 273.7 110.3 288 128 288C145.7 288 160 273.7 160 256zM160 160C160 142.3 145.7 128 128 128C110.3 128 96 142.3 96 160C96 177.7 110.3 192 128 192C145.7 192 160 177.7 160 160zM160 352C160 334.3 145.7 320 128 320C110.3 320 96 334.3 96 352C96 369.7 110.3 384 128 384C145.7 384 160 369.7 160 352zM224 136C210.7 136 200 146.7 200 160C200 173.3 210.7 184 224 184H448C461.3 184 472 173.3 472 160C472 146.7 461.3 136 448 136H224zM224 232C210.7 232 200 242.7 200 256C200 269.3 210.7 280 224 280H448C461.3 280 472 269.3 472 256C472 242.7 461.3 232 448 232H224zM224 328C210.7 328 200 338.7 200 352C200 365.3 210.7 376 224 376H448C461.3 376 472 365.3 472 352C472 338.7 461.3 328 448 328H224z',
			),
			'regular' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M128 192C110.3 192 96 177.7 96 160C96 142.3 110.3 128 128 128C145.7 128 160 142.3 160 160C160 177.7 145.7 192 128 192zM200 160C200 146.7 210.7 136 224 136H448C461.3 136 472 146.7 472 160C472 173.3 461.3 184 448 184H224C210.7 184 200 173.3 200 160zM200 256C200 242.7 210.7 232 224 232H448C461.3 232 472 242.7 472 256C472 269.3 461.3 280 448 280H224C210.7 280 200 269.3 200 256zM200 352C200 338.7 210.7 328 224 328H448C461.3 328 472 338.7 472 352C472 365.3 461.3 376 448 376H224C210.7 376 200 365.3 200 352zM128 224C145.7 224 160 238.3 160 256C160 273.7 145.7 288 128 288C110.3 288 96 273.7 96 256C96 238.3 110.3 224 128 224zM128 384C110.3 384 96 369.7 96 352C96 334.3 110.3 320 128 320C145.7 320 160 334.3 160 352C160 369.7 145.7 384 128 384zM0 96C0 60.65 28.65 32 64 32H512C547.3 32 576 60.65 576 96V416C576 451.3 547.3 480 512 480H64C28.65 480 0 451.3 0 416V96zM48 96V416C48 424.8 55.16 432 64 432H512C520.8 432 528 424.8 528 416V96C528 87.16 520.8 80 512 80H64C55.16 80 48 87.16 48 96z',
			),
		),
		'label'             => __( 'Rectangle List', 'astra' ),
		'custom_categories' => array(),
	),
	'rectangle-xmark'                        => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M448 32C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96C0 60.65 28.65 32 64 32H448zM175 208.1L222.1 255.1L175 303C165.7 312.4 165.7 327.6 175 336.1C184.4 346.3 199.6 346.3 208.1 336.1L255.1 289.9L303 336.1C312.4 346.3 327.6 346.3 336.1 336.1C346.3 327.6 346.3 312.4 336.1 303L289.9 255.1L336.1 208.1C346.3 199.6 346.3 184.4 336.1 175C327.6 165.7 312.4 165.7 303 175L255.1 222.1L208.1 175C199.6 165.7 184.4 165.7 175 175C165.7 184.4 165.7 199.6 175 208.1V208.1z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M175 175C184.4 165.7 199.6 165.7 208.1 175L255.1 222.1L303 175C312.4 165.7 327.6 165.7 336.1 175C346.3 184.4 346.3 199.6 336.1 208.1L289.9 255.1L336.1 303C346.3 312.4 346.3 327.6 336.1 336.1C327.6 346.3 312.4 346.3 303 336.1L255.1 289.9L208.1 336.1C199.6 346.3 184.4 346.3 175 336.1C165.7 327.6 165.7 312.4 175 303L222.1 255.1L175 208.1C165.7 199.6 165.7 184.4 175 175V175zM0 96C0 60.65 28.65 32 64 32H448C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96zM48 96V416C48 424.8 55.16 432 64 432H448C456.8 432 464 424.8 464 416V96C464 87.16 456.8 80 448 80H64C55.16 80 48 87.16 48 96z',
			),
		),
		'label'             => __( 'Rectangle Xmark', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
		),
	),
	'recycle'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M180.2 243.1C185 263.9 162.2 280.2 144.1 268.8L119.8 253.6l-50.9 81.43c-13.33 21.32 2.004 48.98 27.15 48.98h32.02c17.64 0 31.98 14.32 31.98 31.96c0 17.64-14.34 32.05-31.98 32.05H96.15c-75.36 0-121.3-82.84-81.47-146.8L65.51 219.8L41.15 204.5C23.04 193.1 27.66 165.5 48.48 160.7l91.43-21.15C148.5 137.7 157.2 142.9 159.2 151.6L180.2 243.1zM283.1 78.96l41.25 66.14l-24.25 15.08c-18.16 11.31-13.57 38.94 7.278 43.77l91.4 21.15c8.622 1.995 17.23-3.387 19.21-12.01l21.04-91.43c4.789-20.81-17.95-37.05-36.07-25.76l-24.36 15.2L337.4 45.14c-37.58-60.14-125.2-60.18-162.8-.0617L167.2 56.9C157.9 71.75 162.5 91.58 177.3 100.9c14.92 9.359 34.77 4.886 44.11-10.04l7.442-11.89C241.6 58.58 270.9 59.33 283.1 78.96zM497.3 301.3l-16.99-27.26c-9.336-14.98-29.06-19.56-44.04-10.21c-14.94 9.318-19.52 29.15-10.18 44.08l16.99 27.15c13.35 21.32-1.984 49-27.14 49h-95.99l.0234-28.74c0-21.38-25.85-32.09-40.97-16.97l-66.41 66.43c-6.222 6.223-6.222 16.41 .0044 22.63l66.42 66.34c15.12 15.1 40.95 4.386 40.95-16.98l-.0234-28.68h95.86C491.2 448.1 537.2 365.2 497.3 301.3z',
			),
		),
		'label'             => __( 'Recycle', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'red-river'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M353.2 32H94.8C42.4 32 0 74.4 0 126.8v258.4C0 437.6 42.4 480 94.8 480h258.4c52.4 0 94.8-42.4 94.8-94.8V126.8c0-52.4-42.4-94.8-94.8-94.8zM144.9 200.9v56.3c0 27-21.9 48.9-48.9 48.9V151.9c0-13.2 10.7-23.9 23.9-23.9h154.2c0 27-21.9 48.9-48.9 48.9h-56.3c-12.3-.6-24.6 11.6-24 24zm176.3 72h-56.3c-12.3-.6-24.6 11.6-24 24v56.3c0 27-21.9 48.9-48.9 48.9V247.9c0-13.2 10.7-23.9 23.9-23.9h154.2c0 27-21.9 48.9-48.9 48.9z',
			),
		),
		'label'             => __( 'red river', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'reddit'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M201.5 305.5c-13.8 0-24.9-11.1-24.9-24.6 0-13.8 11.1-24.9 24.9-24.9 13.6 0 24.6 11.1 24.6 24.9 0 13.6-11.1 24.6-24.6 24.6zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-132.3-41.2c-9.4 0-17.7 3.9-23.8 10-22.4-15.5-52.6-25.5-86.1-26.6l17.4-78.3 55.4 12.5c0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.3 24.9-24.9s-11.1-24.9-24.9-24.9c-9.7 0-18 5.8-22.1 13.8l-61.2-13.6c-3-.8-6.1 1.4-6.9 4.4l-19.1 86.4c-33.2 1.4-63.1 11.3-85.5 26.8-6.1-6.4-14.7-10.2-24.1-10.2-34.9 0-46.3 46.9-14.4 62.8-1.1 5-1.7 10.2-1.7 15.5 0 52.6 59.2 95.2 132 95.2 73.1 0 132.3-42.6 132.3-95.2 0-5.3-.6-10.8-1.9-15.8 31.3-16 19.8-62.5-14.9-62.5zM302.8 331c-18.2 18.2-76.1 17.9-93.6 0-2.2-2.2-6.1-2.2-8.3 0-2.5 2.5-2.5 6.4 0 8.6 22.8 22.8 87.3 22.8 110.2 0 2.5-2.2 2.5-6.1 0-8.6-2.2-2.2-6.1-2.2-8.3 0zm7.7-75c-13.6 0-24.6 11.1-24.6 24.9 0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.1 24.9-24.6 0-13.8-11-24.9-24.9-24.9z',
			),
		),
		'label'             => __( 'reddit Logo', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'reddit-alien'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M440.3 203.5c-15 0-28.2 6.2-37.9 15.9-35.7-24.7-83.8-40.6-137.1-42.3L293 52.3l88.2 19.8c0 21.6 17.6 39.2 39.2 39.2 22 0 39.7-18.1 39.7-39.7s-17.6-39.7-39.7-39.7c-15.4 0-28.7 9.3-35.3 22l-97.4-21.6c-4.9-1.3-9.7 2.2-11 7.1L246.3 177c-52.9 2.2-100.5 18.1-136.3 42.8-9.7-10.1-23.4-16.3-38.4-16.3-55.6 0-73.8 74.6-22.9 100.1-1.8 7.9-2.6 16.3-2.6 24.7 0 83.8 94.4 151.7 210.3 151.7 116.4 0 210.8-67.9 210.8-151.7 0-8.4-.9-17.2-3.1-25.1 49.9-25.6 31.5-99.7-23.8-99.7zM129.4 308.9c0-22 17.6-39.7 39.7-39.7 21.6 0 39.2 17.6 39.2 39.7 0 21.6-17.6 39.2-39.2 39.2-22 .1-39.7-17.6-39.7-39.2zm214.3 93.5c-36.4 36.4-139.1 36.4-175.5 0-4-3.5-4-9.7 0-13.7 3.5-3.5 9.7-3.5 13.2 0 27.8 28.5 120 29 149 0 3.5-3.5 9.7-3.5 13.2 0 4.1 4 4.1 10.2 .1 13.7zm-.8-54.2c-21.6 0-39.2-17.6-39.2-39.2 0-22 17.6-39.7 39.2-39.7 22 0 39.7 17.6 39.7 39.7-.1 21.5-17.7 39.2-39.7 39.2z',
			),
		),
		'label'             => __( 'reddit Alien', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'brands',
			'social',
			'social',
		),
	),
	'reddit-square'                          => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M283.2 345.5c2.7 2.7 2.7 6.8 0 9.2-24.5 24.5-93.8 24.6-118.4 0-2.7-2.4-2.7-6.5 0-9.2 2.4-2.4 6.5-2.4 8.9 0 18.7 19.2 81 19.6 100.5 0 2.4-2.3 6.6-2.3 9 0zm-91.3-53.8c0-14.9-11.9-26.8-26.5-26.8-14.9 0-26.8 11.9-26.8 26.8 0 14.6 11.9 26.5 26.8 26.5 14.6 0 26.5-11.9 26.5-26.5zm90.7-26.8c-14.6 0-26.5 11.9-26.5 26.8 0 14.6 11.9 26.5 26.5 26.5 14.9 0 26.8-11.9 26.8-26.5 0-14.9-11.9-26.8-26.8-26.8zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-99.7 140.6c-10.1 0-19 4.2-25.6 10.7-24.1-16.7-56.5-27.4-92.5-28.6l18.7-84.2 59.5 13.4c0 14.6 11.9 26.5 26.5 26.5 14.9 0 26.8-12.2 26.8-26.8 0-14.6-11.9-26.8-26.8-26.8-10.4 0-19.3 6.2-23.8 14.9l-65.7-14.6c-3.3-.9-6.5 1.5-7.4 4.8l-20.5 92.8c-35.7 1.5-67.8 12.2-91.9 28.9-6.5-6.8-15.8-11-25.9-11-37.5 0-49.8 50.4-15.5 67.5-1.2 5.4-1.8 11-1.8 16.7 0 56.5 63.7 102.3 141.9 102.3 78.5 0 142.2-45.8 142.2-102.3 0-5.7-.6-11.6-2.1-17 33.6-17.2 21.2-67.2-16.1-67.2z',
			),
		),
		'label'             => __( 'Dribbble', 'astra' ),
		'custom_categories' => array(),
	),
	'redhat'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M341.5 285.6c33.65 0 82.34-6.94 82.34-47 .22-6.74 .86-1.82-20.88-96.24-4.62-19.15-8.68-27.84-42.31-44.65-26.09-13.34-82.92-35.37-99.73-35.37-15.66 0-20.2 20.17-38.87 20.17-18 0-31.31-15.06-48.12-15.06-16.14 0-26.66 11-34.78 33.62-27.5 77.55-26.28 74.27-26.12 78.27 0 24.8 97.64 106.1 228.5 106.1M429 254.8c4.65 22 4.65 24.35 4.65 27.25 0 37.66-42.33 58.56-98 58.56-125.7 .08-235.9-73.65-235.9-122.3a49.55 49.55 0 0 1 4.06-19.72C58.56 200.9 0 208.9 0 260.6c0 84.67 200.6 189 359.5 189 121.8 0 152.5-55.08 152.5-98.58 0-34.21-29.59-73.05-82.93-96.24',
			),
		),
		'label'             => __( 'Redhat', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'registered'                             => array(
		'svg'               => array(
			'solid'   => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM349.8 349.8c5.594 12.03 .4375 26.31-11.56 31.94c-3.312 1.531-6.75 2.25-10.19 2.25c-9 0-17.66-5.125-21.75-13.81l-38.46-82.19H208v72c0 13.25-10.75 24-24 24s-24-10.75-24-24V152c0-13.25 10.75-24 24-24l88 .0044c44.13 0 80 35.88 80 80c0 28.32-14.87 53.09-37.12 67.31L349.8 349.8zM272 176h-64v64h64c17.66 0 32-14.34 32-32S289.7 176 272 176z',
			),
			'regular' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM352 208c0-44.13-35.88-80-80-80L184 128c-13.25 0-24 10.75-24 24v208c0 13.25 10.75 24 24 24s24-10.75 24-24v-72h59.79l38.46 82.19C310.3 378.9 319 384 328 384c3.438 0 6.875-.7187 10.19-2.25c12-5.625 17.16-19.91 11.56-31.94l-34.87-74.5C337.1 261.1 352 236.3 352 208zM272 240h-64v-64h64c17.66 0 32 14.34 32 32S289.7 240 272 240z',
			),
		),
		'label'             => __( 'Registered', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'renren'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M214 169.1c0 110.4-61 205.4-147.6 247.4C30 373.2 8 317.7 8 256.6 8 133.9 97.1 32.2 214 12.5v156.6zM255 504c-42.9 0-83.3-11-118.5-30.4C193.7 437.5 239.9 382.9 255 319c15.5 63.9 61.7 118.5 118.8 154.7C338.7 493 298.3 504 255 504zm190.6-87.5C359 374.5 298 279.6 298 169.1V12.5c116.9 19.7 206 121.4 206 244.1 0 61.1-22 116.6-58.4 159.9z',
			),
		),
		'label'             => __( 'Renren', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'repeat'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 256c-17.67 0-32 14.31-32 32c0 52.94-43.06 96-96 96H192L192 344c0-9.469-5.578-18.06-14.23-21.94C169.1 318.3 159 319.8 151.9 326.2l-80 72C66.89 402.7 64 409.2 64 416s2.891 13.28 7.938 17.84l80 72C156.4 509.9 162.2 512 168 512c3.312 0 6.615-.6875 9.756-2.062C186.4 506.1 192 497.5 192 488L192 448h160c88.22 0 160-71.78 160-160C512 270.3 497.7 256 480 256zM160 128h159.1L320 168c0 9.469 5.578 18.06 14.23 21.94C337.4 191.3 340.7 192 343.1 192c5.812 0 11.57-2.125 16.07-6.156l80-72C445.1 109.3 448 102.8 448 95.1s-2.891-13.28-7.938-17.84l-80-72c-7.047-6.312-17.19-7.875-25.83-4.094C325.6 5.938 319.1 14.53 319.1 24L320 64H160C71.78 64 0 135.8 0 224c0 17.69 14.33 32 32 32s32-14.31 32-32C64 171.1 107.1 128 160 128z',
			),
		),
		'label'             => __( 'Repeat', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'reply'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M8.31 189.9l176-151.1c15.41-13.3 39.69-2.509 39.69 18.16v80.05C384.6 137.9 512 170.1 512 322.3c0 61.44-39.59 122.3-83.34 154.1c-13.66 9.938-33.09-2.531-28.06-18.62c45.34-145-21.5-183.5-176.6-185.8v87.92c0 20.7-24.31 31.45-39.69 18.16l-176-151.1C-2.753 216.6-2.784 199.4 8.31 189.9z',
			),
		),
		'label'             => __( 'Reply', 'astra' ),
		'custom_categories' => array(),
	),
	'reply-all'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M136.3 226.2l176 151.1c15.38 13.3 39.69 2.545 39.69-18.16V275.1c108.5 12.58 151.1 58.79 112.6 181.9c-5.031 16.09 14.41 28.56 28.06 18.62c43.75-31.81 83.34-92.69 83.34-154.1c0-131.3-94.86-173.2-224-183.5V56.02c0-20.67-24.28-31.46-39.69-18.16L136.3 189.9C125.2 199.4 125.2 216.6 136.3 226.2zM8.31 226.2l176 151.1c15.38 13.3 39.69 2.545 39.69-18.16v-15.83L66.33 208l157.7-136.2V56.02c0-20.67-24.28-31.46-39.69-18.16l-176 151.1C-2.77 199.4-2.77 216.6 8.31 226.2z',
			),
		),
		'label'             => __( 'Reply All', 'astra' ),
		'custom_categories' => array(),
	),
	'replyd'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M320 480H128C57.6 480 0 422.4 0 352V160C0 89.6 57.6 32 128 32h192c70.4 0 128 57.6 128 128v192c0 70.4-57.6 128-128 128zM193.4 273.2c-6.1-2-11.6-3.1-16.4-3.1-7.2 0-13.5 1.9-18.9 5.6-5.4 3.7-9.6 9-12.8 15.8h-1.1l-4.2-18.3h-28v138.9h36.1v-89.7c1.5-5.4 4.4-9.8 8.7-13.2 4.3-3.4 9.8-5.1 16.2-5.1 4.6 0 9.8 1 15.6 3.1l4.8-34zm115.2 103.4c-3.2 2.4-7.7 4.8-13.7 7.1-6 2.3-12.8 3.5-20.4 3.5-12.2 0-21.1-3-26.5-8.9-5.5-5.9-8.5-14.7-9-26.4h83.3c.9-4.8 1.6-9.4 2.1-13.9 .5-4.4 .7-8.6 .7-12.5 0-10.7-1.6-19.7-4.7-26.9-3.2-7.2-7.3-13-12.5-17.2-5.2-4.3-11.1-7.3-17.8-9.2-6.7-1.8-13.5-2.8-20.6-2.8-21.1 0-37.5 6.1-49.2 18.3s-17.5 30.5-17.5 55c0 22.8 5.2 40.7 15.6 53.7 10.4 13.1 26.8 19.6 49.2 19.6 10.7 0 20.9-1.5 30.4-4.6 9.5-3.1 17.1-6.8 22.6-11.2l-12-23.6zm-21.8-70.3c3.8 5.4 5.3 13.1 4.6 23.1h-51.7c.9-9.4 3.7-17 8.2-22.6 4.5-5.6 11.5-8.5 21-8.5 8.2-.1 14.1 2.6 17.9 8zm79.9 2.5c4.1 3.9 9.4 5.8 16.1 5.8 7 0 12.6-1.9 16.7-5.8s6.1-9.1 6.1-15.6-2-11.6-6.1-15.4c-4.1-3.8-9.6-5.7-16.7-5.7-6.7 0-12 1.9-16.1 5.7-4.1 3.8-6.1 8.9-6.1 15.4s2 11.7 6.1 15.6zm0 100.5c4.1 3.9 9.4 5.8 16.1 5.8 7 0 12.6-1.9 16.7-5.8s6.1-9.1 6.1-15.6-2-11.6-6.1-15.4c-4.1-3.8-9.6-5.7-16.7-5.7-6.7 0-12 1.9-16.1 5.7-4.1 3.8-6.1 8.9-6.1 15.4 0 6.6 2 11.7 6.1 15.6z',
			),
		),
		'label'             => __( 'replyd', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'republican'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M544 191.1c0-88.37-71.62-159.1-159.1-159.1L159.1 32C71.62 32 0 103.6 0 191.1l.025 63.98h543.1V191.1zM176.3 170.4l-19.75 19.37l4.75 27.25c.7498 4.875-4.375 8.625-8.75 6.25l-24.5-12.87L103.5 223.2C99.27 225.6 94.02 221.9 94.77 216.1l4.75-27.25l-19.75-19.37C76.15 166.9 78.15 160.9 83.02 160.2L110.4 156.2l12.25-24.87c2.125-4.5 8.625-4.375 10.62 0L145.5 156.2L172.9 160.2C177.9 160.9 179.8 166.9 176.3 170.4zM320.3 170.4l-19.75 19.37l4.75 27.25c.7498 4.875-4.375 8.625-8.75 6.25L272 210.4l-24.5 12.87C243.3 225.6 238 221.9 238.8 216.1L243.5 189.7l-19.75-19.37c-3.625-3.5-1.625-9.498 3.25-10.12L254.4 156.2l12.25-24.87c2.125-4.5 8.625-4.375 10.62 0L289.5 156.2l27.37 4C321.9 160.9 323.8 166.9 320.3 170.4zM464.3 170.4l-19.75 19.37l4.75 27.25c.7498 4.875-4.375 8.625-8.75 6.25l-24.5-12.87l-24.5 12.87c-4.25 2.375-9.5-1.375-8.75-6.25l4.75-27.25l-19.75-19.37c-3.625-3.5-1.625-9.498 3.25-10.12l27.37-4l12.25-24.87c2.125-4.5 8.625-4.375 10.62 0l12.25 24.87l27.37 4C465.9 160.9 467.8 166.9 464.3 170.4zM624 319.1L592 319.1c-8.799 0-15.1 7.199-15.1 15.1v63.99c0 8.748-7.25 15.1-15.1 15.1c-8.75 0-15.1-7.25-15.1-15.1l-.0313-111.1L.025 287.1v159.1c0 17.6 14.4 31.1 31.1 31.1L95.98 479.1c17.6 0 32.04-14.4 32.04-32v-63.98l191.1-.0169v63.99c0 17.6 14.36 32 31.96 32l64.04 .013c17.6 0 31.1-14.4 31.1-31.1l-.0417-96.01l32.04 .0006v43.25c0 41.79 29.91 80.03 71.48 84.35C599.3 484.5 640 446.9 640 399.1v-63.98C640 327.2 632.8 319.1 624 319.1z',
			),
		),
		'label'             => __( 'Republican', 'astra' ),
		'custom_categories' => array(),
	),
	'researchgate'                           => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M0 32v448h448V32H0zm262.2 334.4c-6.6 3-33.2 6-50-14.2-9.2-10.6-25.3-33.3-42.2-63.6-8.9 0-14.7 0-21.4-.6v46.4c0 23.5 6 21.2 25.8 23.9v8.1c-6.9-.3-23.1-.8-35.6-.8-13.1 0-26.1 .6-33.6 .8v-8.1c15.5-2.9 22-1.3 22-23.9V225c0-22.6-6.4-21-22-23.9V193c25.8 1 53.1-.6 70.9-.6 31.7 0 55.9 14.4 55.9 45.6 0 21.1-16.7 42.2-39.2 47.5 13.6 24.2 30 45.6 42.2 58.9 7.2 7.8 17.2 14.7 27.2 14.7v7.3zm22.9-135c-23.3 0-32.2-15.7-32.2-32.2V167c0-12.2 8.8-30.4 34-30.4s30.4 17.9 30.4 17.9l-10.7 7.2s-5.5-12.5-19.7-12.5c-7.9 0-19.7 7.3-19.7 19.7v26.8c0 13.4 6.6 23.3 17.9 23.3 14.1 0 21.5-10.9 21.5-26.8h-17.9v-10.7h30.4c0 20.5 4.7 49.9-34 49.9zm-116.5 44.7c-9.4 0-13.6-.3-20-.8v-69.7c6.4-.6 15-.6 22.5-.6 23.3 0 37.2 12.2 37.2 34.5 0 21.9-15 36.6-39.7 36.6z',
			),
		),
		'label'             => __( 'Researchgate', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'resolving'                              => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M281.2 278.2c46-13.3 49.6-23.5 44-43.4L314 195.5c-6.1-20.9-18.4-28.1-71.1-12.8L54.7 236.8l28.6 98.6 197.9-57.2zM248.5 8C131.4 8 33.2 88.7 7.2 197.5l221.9-63.9c34.8-10.2 54.2-11.7 79.3-8.2 36.3 6.1 52.7 25 61.4 55.2l10.7 37.8c8.2 28.1 1 50.6-23.5 73.6-19.4 17.4-31.2 24.5-61.4 33.2L203 351.8l220.4 27.1 9.7 34.2-48.1 13.3-286.8-37.3 23 80.2c36.8 22 80.3 34.7 126.3 34.7 137 0 248.5-111.4 248.5-248.3C497 119.4 385.5 8 248.5 8zM38.3 388.6L0 256.8c0 48.5 14.3 93.4 38.3 131.8z',
			),
		),
		'label'             => __( 'Resolving', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'restroom'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M319.1 0C306.8 0 296 10.8 296 24v464c0 13.2 10.8 24 23.1 24s24-10.8 24-24V24C344 10.8 333.2 0 319.1 0zM213.7 171.8C204.9 145.6 180.5 128 152.9 128H103.1C75.47 128 51.06 145.6 42.37 171.8L1.653 293.9c-5.594 16.77 3.469 34.89 20.22 40.48c12.68 4.211 25.93 .1426 34.13-9.18V480c0 17.67 14.33 32 32 32s31.1-14.33 31.1-32l-.0003-144h16l.0003 144c0 17.67 14.33 32 32 32s31.1-14.33 31.1-32l-.0003-155.2c6.041 6.971 14.7 11.25 24 11.25c3.344 0 6.75-.5313 10.13-1.656c16.75-5.594 25.81-23.72 20.22-40.48L213.7 171.8zM128 96c26.5 0 47.1-21.5 47.1-48S154.5 0 128 0S80 21.5 80 48S101.5 96 128 96zM511.1 96c26.5 0 48-21.5 48-48S538.5 0 511.1 0s-47.1 21.5-47.1 48S485.5 96 511.1 96zM638.3 293.9l-40.69-122.1C588.9 145.6 564.5 128 536.9 128h-49.88c-27.59 0-52 17.59-60.69 43.75l-40.72 122.1c-5.594 16.77 3.469 34.89 20.22 40.48c3.422 1.137 6.856 1.273 10.25 1.264L399.1 384h40v96c0 17.67 14.32 32 31.1 32s32-14.33 32-32v-96h16v96c0 17.67 14.32 32 31.1 32s32-14.33 32-32v-96h39.1l-15.99-47.98c3.342 0 6.747-.5313 10.12-1.656C634.9 328.8 643.9 310.6 638.3 293.9z',
			),
		),
		'label'             => __( 'Restroom', 'astra' ),
		'custom_categories' => array(
			'travel',
		),
	),
	'retweet'                                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M614.2 334.8C610.5 325.8 601.7 319.1 592 319.1H544V176C544 131.9 508.1 96 464 96h-128c-17.67 0-32 14.31-32 32s14.33 32 32 32h128C472.8 160 480 167.2 480 176v143.1h-48c-9.703 0-18.45 5.844-22.17 14.82s-1.656 19.29 5.203 26.16l80 80.02C499.7 445.7 505.9 448 512 448s12.28-2.344 16.97-7.031l80-80.02C615.8 354.1 617.9 343.8 614.2 334.8zM304 352h-128C167.2 352 160 344.8 160 336V192h48c9.703 0 18.45-5.844 22.17-14.82s1.656-19.29-5.203-26.16l-80-80.02C140.3 66.34 134.1 64 128 64S115.7 66.34 111 71.03l-80 80.02C24.17 157.9 22.11 168.2 25.83 177.2S38.3 192 48 192H96V336C96 380.1 131.9 416 176 416h128c17.67 0 32-14.31 32-32S321.7 352 304 352z',
			),
		),
		'label'             => __( 'Retweet', 'astra' ),
		'custom_categories' => array(
			'social',
		),
	),
	'rev'                                    => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M289.7 274.9a65.57 65.57 0 1 1 -65.56-65.56 65.64 65.64 0 0 1 65.56 65.56zm139.6-5.05h-.13a204.7 204.7 0 0 0 -74.32-153l-45.38 26.2a157.1 157.1 0 0 1 71.81 131.8C381.2 361.5 310.7 432 224.1 432S67 361.5 67 274.9c0-81.88 63-149.3 143-156.4v39.12l108.8-62.79L210 32v38.32c-106.7 7.25-191 96-191 204.6 0 111.6 89.12 202.3 200.1 205v.11h210.2V269.8z',
			),
		),
		'label'             => __( 'Rev.io', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'ribbon'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M6.05 444.3c-9.626 10.87-7.501 27.62 4.5 35.75l68.76 27.87c9.876 6.75 23.38 4.1 31.38-3.75l91.76-101.9L123.2 314.3L6.05 444.3zM441.8 444.3c0 0-292-324.5-295.4-329.1c15.38-8.5 40.25-17.1 77.51-17.1s62.13 9.5 77.51 17.1c-3.25 5.5-56.01 64.5-56.01 64.5l79.13 87.75l34.13-37.1c28.75-31.87 33.38-78.62 11.5-115.5L326.5 39.52c-4.25-7.25-9.876-13.25-16.75-17.1c-40.75-27.62-127.5-29.75-171.5 0C131.3 26.27 125.7 32.27 121.4 39.52L77.81 112.8C76.31 115.3 40.68 174.9 89.31 228.8l248.1 275.2c8.001 8.875 21.38 10.5 31.25 3.75l68.88-27.87C449.5 471.9 451.6 455.1 441.8 444.3z',
			),
		),
		'label'             => __( 'Ribbon', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'right-from-bracket'                     => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M96 480h64C177.7 480 192 465.7 192 448S177.7 416 160 416H96c-17.67 0-32-14.33-32-32V128c0-17.67 14.33-32 32-32h64C177.7 96 192 81.67 192 64S177.7 32 160 32H96C42.98 32 0 74.98 0 128v256C0 437 42.98 480 96 480zM504.8 238.5l-144.1-136c-6.975-6.578-17.2-8.375-26-4.594c-8.803 3.797-14.51 12.47-14.51 22.05l-.0918 72l-128-.001c-17.69 0-32.02 14.33-32.02 32v64c0 17.67 14.34 32 32.02 32l128 .001l.0918 71.1c0 9.578 5.707 18.25 14.51 22.05c8.803 3.781 19.03 1.984 26-4.594l144.1-136C514.4 264.4 514.4 247.6 504.8 238.5z',
			),
		),
		'label'             => __( 'Right From Bracket', 'astra' ),
		'custom_categories' => array(),
	),
	'right-left'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M32 160h319.9l.0791 72c0 9.547 5.652 18.19 14.41 22c8.754 3.812 18.93 2.078 25.93-4.406l112-104c10.24-9.5 10.24-25.69 0-35.19l-112-104c-6.992-6.484-17.17-8.217-25.93-4.408c-8.758 3.816-14.41 12.46-14.41 22L351.9 96H32C14.31 96 0 110.3 0 127.1S14.31 160 32 160zM480 352H160.1L160 279.1c0-9.547-5.652-18.19-14.41-22C136.9 254.2 126.7 255.9 119.7 262.4l-112 104c-10.24 9.5-10.24 25.69 0 35.19l112 104c6.992 6.484 17.17 8.219 25.93 4.406C154.4 506.2 160 497.5 160 488L160.1 416H480c17.69 0 32-14.31 32-32S497.7 352 480 352z',
			),
		),
		'label'             => __( 'Right Left', 'astra' ),
		'custom_categories' => array(),
	),
	'right-long'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M504.3 273.6l-112.1 104c-6.992 6.484-17.18 8.218-25.94 4.406c-8.758-3.812-14.42-12.45-14.42-21.1L351.9 288H32C14.33 288 .0002 273.7 .0002 255.1S14.33 224 32 224h319.9l0-72c0-9.547 5.66-18.19 14.42-22c8.754-3.809 18.95-2.075 25.94 4.41l112.1 104C514.6 247.9 514.6 264.1 504.3 273.6z',
			),
		),
		'label'             => __( 'Right Long', 'astra' ),
		'custom_categories' => array(),
	),
	'right-to-bracket'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M344.7 238.5l-144.1-136C193.7 95.97 183.4 94.17 174.6 97.95C165.8 101.8 160.1 110.4 160.1 120V192H32.02C14.33 192 0 206.3 0 224v64c0 17.68 14.33 32 32.02 32h128.1v72c0 9.578 5.707 18.25 14.51 22.05c8.803 3.781 19.03 1.984 26-4.594l144.1-136C354.3 264.4 354.3 247.6 344.7 238.5zM416 32h-64c-17.67 0-32 14.33-32 32s14.33 32 32 32h64c17.67 0 32 14.33 32 32v256c0 17.67-14.33 32-32 32h-64c-17.67 0-32 14.33-32 32s14.33 32 32 32h64c53.02 0 96-42.98 96-96V128C512 74.98 469 32 416 32z',
			),
		),
		'label'             => __( 'Right To Bracket', 'astra' ),
		'custom_categories' => array(),
	),
	'ring'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M256 64C109.1 64 0 125.9 0 208v98.13C0 384.5 114.6 448 256 448s256-63.5 256-141.9V208C512 125.9 401.1 64 256 64zM256 288C203.1 288 155.1 279.1 120.4 264.6C155 249.9 201.6 240 256 240s101 9.875 135.6 24.62C356.9 279.1 308.9 288 256 288zM437.1 234.4C392.1 208.3 328.3 192 256 192S119.9 208.3 74.88 234.4C68 226.1 64 217.3 64 208C64 163.9 149.1 128 256 128c105.1 0 192 35.88 192 80C448 217.3 444 226.1 437.1 234.4z',
			),
		),
		'label'             => __( 'Ring', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'road'                                   => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M256 96C256 113.7 270.3 128 288 128C305.7 128 320 113.7 320 96V32H394.8C421.9 32 446 49.08 455.1 74.63L572.9 407.2C574.9 413 576 419.2 576 425.4C576 455.5 551.5 480 521.4 480H320V416C320 398.3 305.7 384 288 384C270.3 384 256 398.3 256 416V480H54.61C24.45 480 0 455.5 0 425.4C0 419.2 1.06 413 3.133 407.2L120.9 74.63C129.1 49.08 154.1 32 181.2 32H255.1L256 96zM320 224C320 206.3 305.7 192 288 192C270.3 192 256 206.3 256 224V288C256 305.7 270.3 320 288 320C305.7 320 320 305.7 320 288V224z',
			),
		),
		'label'             => __( 'Road', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'road-barrier'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M32 32C49.67 32 64 46.33 64 64V96H149.2L64 266.3V448C64 465.7 49.67 480 32 480C14.33 480 0 465.7 0 448V64C0 46.33 14.33 32 32 32V32zM309.2 288H234.8L330.8 96H405.2L309.2 288zM458.8 96H533.2L437.2 288H362.8L458.8 96zM202.8 96H277.2L181.2 288H106.8L202.8 96zM576 117.7V64C576 46.33 590.3 32 608 32C625.7 32 640 46.33 640 64V448C640 465.7 625.7 480 608 480C590.3 480 576 465.7 576 448V288H490.8L576 117.7z',
			),
		),
		'label'             => __( 'Road Barrier', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'road-bridge'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M352 0H608C625.7 0 640 14.33 640 32V480C640 497.7 625.7 512 608 512H352C334.3 512 320 497.7 320 480V32C320 14.33 334.3 0 352 0zM456 224V288C456 301.3 466.7 312 480 312C493.3 312 504 301.3 504 288V224C504 210.7 493.3 200 480 200C466.7 200 456 210.7 456 224zM504 384C504 370.7 493.3 360 480 360C466.7 360 456 370.7 456 384V448C456 461.3 466.7 472 480 472C493.3 472 504 461.3 504 448V384zM456 64V128C456 141.3 466.7 152 480 152C493.3 152 504 141.3 504 128V64C504 50.75 493.3 40 480 40C466.7 40 456 50.75 456 64zM32 96H288V160H248V224H288V320C234.1 320 192 362.1 192 416V480C192 497.7 177.7 512 160 512H128C110.3 512 96 497.7 96 480V416C96 362.1 53.02 320 0 320V224H72V160H32C14.33 160 0 145.7 0 128C0 110.3 14.33 96 32 96zM200 160H120V224H200V160z',
			),
		),
		'label'             => __( 'Road Bridge', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'road-circle-check'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M213.2 32H288V96C288 113.7 302.3 128 320 128C337.7 128 352 113.7 352 96V32H426.8C453.9 32 478 49.08 487.1 74.63L529.8 195.2C518.9 193.1 507.6 192 496 192C436.5 192 383.9 221.6 352 266.8V224C352 206.3 337.7 192 320 192C302.3 192 288 206.3 288 224V288C288 305.7 302.3 320 320 320C322.3 320 324.6 319.7 326.8 319.3C322.4 334.7 320 351.1 320 368C320 373.4 320.2 378.7 320.7 384L320 384C302.3 384 288 398.3 288 416V480H86.61C56.45 480 32 455.5 32 425.4C32 419.2 33.06 413 35.13 407.2L152.9 74.63C161.1 49.08 186.1 32 213.2 32H213.2zM640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368zM540.7 324.7L480 385.4L451.3 356.7C445.1 350.4 434.9 350.4 428.7 356.7C422.4 362.9 422.4 373.1 428.7 379.3L468.7 419.3C474.9 425.6 485.1 425.6 491.3 419.3L563.3 347.3C569.6 341.1 569.6 330.9 563.3 324.7C557.1 318.4 546.9 318.4 540.7 324.7H540.7z',
			),
		),
		'label'             => __( 'Road Circle Check', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'road-circle-exclamation'                => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M213.2 32H288V96C288 113.7 302.3 128 320 128C337.7 128 352 113.7 352 96V32H426.8C453.9 32 478 49.08 487.1 74.63L529.8 195.2C518.9 193.1 507.6 192 496 192C436.5 192 383.9 221.6 352 266.8V224C352 206.3 337.7 192 320 192C302.3 192 288 206.3 288 224V288C288 305.7 302.3 320 320 320C322.3 320 324.6 319.7 326.8 319.3C322.4 334.7 320 351.1 320 368C320 373.4 320.2 378.7 320.7 384L320 384C302.3 384 288 398.3 288 416V480H86.61C56.45 480 32 455.5 32 425.4C32 419.2 33.06 413 35.13 407.2L152.9 74.63C161.1 49.08 186.1 32 213.2 32H213.2zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM496 464C509.3 464 520 453.3 520 440C520 426.7 509.3 416 496 416C482.7 416 472 426.7 472 440C472 453.3 482.7 464 496 464zM479.1 288V368C479.1 376.8 487.2 384 495.1 384C504.8 384 511.1 376.8 511.1 368V288C511.1 279.2 504.8 272 495.1 272C487.2 272 479.1 279.2 479.1 288z',
			),
		),
		'label'             => __( 'Road Circle Exclamation', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'road-circle-xmark'                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M213.2 32H288V96C288 113.7 302.3 128 320 128C337.7 128 352 113.7 352 96V32H426.8C453.9 32 478 49.08 487.1 74.63L529.8 195.2C518.9 193.1 507.6 192 496 192C436.5 192 383.9 221.6 352 266.8V224C352 206.3 337.7 192 320 192C302.3 192 288 206.3 288 224V288C288 305.7 302.3 320 320 320C322.3 320 324.6 319.7 326.8 319.3C322.4 334.7 320 351.1 320 368C320 373.4 320.2 378.7 320.7 384L320 384C302.3 384 288 398.3 288 416V480H86.61C56.45 480 32 455.5 32 425.4C32 419.2 33.06 413 35.13 407.2L152.9 74.63C161.1 49.08 186.1 32 213.2 32H213.2zM352 368C352 288.5 416.5 224 496 224C575.5 224 640 288.5 640 368C640 447.5 575.5 512 496 512C416.5 512 352 447.5 352 368zM518.6 368L555.3 331.3C561.6 325.1 561.6 314.9 555.3 308.7C549.1 302.4 538.9 302.4 532.7 308.7L496 345.4L459.3 308.7C453.1 302.4 442.9 302.4 436.7 308.7C430.4 314.9 430.4 325.1 436.7 331.3L473.4 368L436.7 404.7C430.4 410.9 430.4 421.1 436.7 427.3C442.9 433.6 453.1 433.6 459.3 427.3L496 390.6L532.7 427.3C538.9 433.6 549.1 433.6 555.3 427.3C561.6 421.1 561.6 410.9 555.3 404.7L518.6 368z',
			),
		),
		'label'             => __( 'Road Circle Xmark', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'road-lock'                              => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M288 96C288 113.7 302.3 128 320 128C337.7 128 352 113.7 352 96V32H426.8C453.9 32 478 49.08 487.1 74.63L517.5 160.5C460.6 165.8 416 213.7 416 272V296.6C396.9 307.6 384 328.3 384 352V480H352V416C352 398.3 337.7 384 320 384C302.3 384 288 398.3 288 416V480H86.61C56.45 480 32 455.5 32 425.4C32 419.2 33.06 413 35.13 407.2L152.9 74.63C161.1 49.08 186.1 32 213.2 32H287.1L288 96zM352 224C352 206.3 337.7 192 320 192C302.3 192 288 206.3 288 224V288C288 305.7 302.3 320 320 320C337.7 320 352 305.7 352 288V224zM528 192C572.2 192 608 227.8 608 272V320C625.7 320 640 334.3 640 352V480C640 497.7 625.7 512 608 512H448C430.3 512 416 497.7 416 480V352C416 334.3 430.3 320 448 320V272C448 227.8 483.8 192 528 192zM528 240C510.3 240 496 254.3 496 272V320H560V272C560 254.3 545.7 240 528 240z',
			),
		),
		'label'             => __( 'Road Lock', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'road-spikes'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M64 116.8C64 101 84.53 94.79 93.31 107.1L192 255.1V116.8C192 101 212.5 94.79 221.3 107.1L320 255.1V116.8C320 101 340.5 94.79 349.3 107.1L448 255.1V116.8C448 101 468.5 94.79 477.3 107.1L606.8 302.2C621 323.5 605.8 351.1 580.2 351.1H64L64 116.8zM608 383.1C625.7 383.1 640 398.3 640 415.1C640 433.7 625.7 447.1 608 447.1H32C14.33 447.1 0 433.7 0 415.1C0 398.3 14.33 383.1 32 383.1H608z',
			),
		),
		'label'             => __( 'Road Spikes', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
			'travel',
		),
	),
	'robot'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M9.375 233.4C3.375 239.4 0 247.5 0 256v128c0 8.5 3.375 16.62 9.375 22.62S23.5 416 32 416h32V224H32C23.5 224 15.38 227.4 9.375 233.4zM464 96H352V32c0-17.62-14.38-32-32-32S288 14.38 288 32v64H176C131.8 96 96 131.8 96 176V448c0 35.38 28.62 64 64 64h320c35.38 0 64-28.62 64-64V176C544 131.8 508.3 96 464 96zM256 416H192v-32h64V416zM224 296C201.9 296 184 278.1 184 256S201.9 216 224 216S264 233.9 264 256S246.1 296 224 296zM352 416H288v-32h64V416zM448 416h-64v-32h64V416zM416 296c-22.12 0-40-17.88-40-40S393.9 216 416 216S456 233.9 456 256S438.1 296 416 296zM630.6 233.4C624.6 227.4 616.5 224 608 224h-32v192h32c8.5 0 16.62-3.375 22.62-9.375S640 392.5 640 384V256C640 247.5 636.6 239.4 630.6 233.4z',
			),
		),
		'label'             => __( 'Robot', 'astra' ),
		'custom_categories' => array(
			'education',
			'science-and-technology',
		),
	),
	'rocket'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M156.6 384.9L125.7 353.1C117.2 345.5 114.2 333.1 117.1 321.8C120.1 312.9 124.1 301.3 129.8 288H24C15.38 288 7.414 283.4 3.146 275.9C-1.123 268.4-1.042 259.2 3.357 251.8L55.83 163.3C68.79 141.4 92.33 127.1 117.8 127.1H200C202.4 124 204.8 120.3 207.2 116.7C289.1-4.07 411.1-8.142 483.9 5.275C495.6 7.414 504.6 16.43 506.7 28.06C520.1 100.9 516.1 222.9 395.3 304.8C391.8 307.2 387.1 309.6 384 311.1V394.2C384 419.7 370.6 443.2 348.7 456.2L260.2 508.6C252.8 513 243.6 513.1 236.1 508.9C228.6 504.6 224 496.6 224 488V380.8C209.9 385.6 197.6 389.7 188.3 392.7C177.1 396.3 164.9 393.2 156.6 384.9V384.9zM384 167.1C406.1 167.1 424 150.1 424 127.1C424 105.9 406.1 87.1 384 87.1C361.9 87.1 344 105.9 344 127.1C344 150.1 361.9 167.1 384 167.1z',
			),
		),
		'label'             => __( 'Rocket', 'astra' ),
		'custom_categories' => array(
			'science-and-technology',
			'travel',
		),
	),
	'rocketchat'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M284 224.8a34.11 34.11 0 1 0 34.32 34.11A34.22 34.22 0 0 0 284 224.8zm-110.4 0a34.11 34.11 0 1 0 34.32 34.11A34.22 34.22 0 0 0 173.6 224.8zm220.9 0a34.11 34.11 0 1 0 34.32 34.11A34.22 34.22 0 0 0 394.5 224.8zm153.8-55.32c-15.53-24.17-37.31-45.57-64.68-63.62-52.89-34.82-122.4-54-195.7-54a405.1 405.1 0 0 0 -72.03 6.357 238.5 238.5 0 0 0 -49.51-36.59C99.68-11.7 40.86 .711 11.14 11.42A14.29 14.29 0 0 0 5.58 34.78C26.54 56.46 61.22 99.3 52.7 138.3c-33.14 33.9-51.11 74.78-51.11 117.3 0 43.37 17.97 84.25 51.11 118.1 8.526 38.96-26.15 81.82-47.12 103.5a14.28 14.28 0 0 0 5.555 23.34c29.72 10.71 88.55 23.15 155.3-10.2a238.7 238.7 0 0 0 49.51-36.59A405.1 405.1 0 0 0 288 460.1c73.31 0 142.8-19.16 195.7-53.97 27.37-18.05 49.15-39.43 64.68-63.62 17.31-26.92 26.07-55.92 26.07-86.13C574.4 225.4 565.6 196.4 548.3 169.5zM284.1 409.9a345.6 345.6 0 0 1 -89.45-11.5l-20.13 19.39a184.4 184.4 0 0 1 -37.14 27.58 145.8 145.8 0 0 1 -52.52 14.87c.983-1.771 1.881-3.563 2.842-5.356q30.26-55.68 16.33-100.1c-32.99-25.96-52.78-59.2-52.78-95.4 0-83.1 104.3-150.5 232.8-150.5s232.9 67.37 232.9 150.5C517.9 342.5 413.6 409.9 284.1 409.9z',
			),
		),
		'label'             => __( 'Rocket.Chat', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'rockrms'                                => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 496,
				'height' => 512,
				'path'   => 'M248 8C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm157.4 419.5h-90l-112-131.3c-17.9-20.4-3.9-56.1 26.6-56.1h75.3l-84.6-99.3-84.3 98.9h-90L193.5 67.2c14.4-18.4 41.3-17.3 54.5 0l157.7 185.1c19 22.8 2 57.2-27.6 56.1-.6 0-74.2 .2-74.2 .2l101.5 118.9z',
			),
		),
		'label'             => __( 'Rockrms', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'rotate'                                 => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M449.9 39.96l-48.5 48.53C362.5 53.19 311.4 32 256 32C161.5 32 78.59 92.34 49.58 182.2c-5.438 16.81 3.797 34.88 20.61 40.28c16.97 5.5 34.86-3.812 40.3-20.59C130.9 138.5 189.4 96 256 96c37.96 0 73 14.18 100.2 37.8L311.1 178C295.1 194.8 306.8 223.4 330.4 224h146.9C487.7 223.7 496 215.3 496 204.9V59.04C496 34.99 466.9 22.95 449.9 39.96zM441.8 289.6c-16.94-5.438-34.88 3.812-40.3 20.59C381.1 373.5 322.6 416 256 416c-37.96 0-73-14.18-100.2-37.8L200 334C216.9 317.2 205.2 288.6 181.6 288H34.66C24.32 288.3 16 296.7 16 307.1v145.9c0 24.04 29.07 36.08 46.07 19.07l48.5-48.53C149.5 458.8 200.6 480 255.1 480c94.45 0 177.4-60.34 206.4-150.2C467.9 313 458.6 294.1 441.8 289.6z',
			),
		),
		'label'             => __( 'Rotate', 'astra' ),
		'custom_categories' => array(
			'communication',
			'design',
			'science-and-technology',
		),
	),
	'rotate-left'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M480 256c0 123.4-100.5 223.9-223.9 223.9c-48.84 0-95.17-15.58-134.2-44.86c-14.12-10.59-16.97-30.66-6.375-44.81c10.59-14.12 30.62-16.94 44.81-6.375c27.84 20.91 61 31.94 95.88 31.94C344.3 415.8 416 344.1 416 256s-71.69-159.8-159.8-159.8c-37.46 0-73.09 13.49-101.3 36.64l45.12 45.14c17.01 17.02 4.955 46.1-19.1 46.1H35.17C24.58 224.1 16 215.5 16 204.9V59.04c0-24.04 29.07-36.08 46.07-19.07l47.6 47.63C149.9 52.71 201.5 32.11 256.1 32.11C379.5 32.11 480 132.6 480 256z',
			),
		),
		'label'             => __( 'Rotate Left', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'rotate-right'                           => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M468.9 32.11c13.87 0 27.18 10.77 27.18 27.04v145.9c0 10.59-8.584 19.17-19.17 19.17h-145.7c-16.28 0-27.06-13.32-27.06-27.2c0-6.634 2.461-13.4 7.96-18.9l45.12-45.14c-28.22-23.14-63.85-36.64-101.3-36.64c-88.09 0-159.8 71.69-159.8 159.8S167.8 415.9 255.9 415.9c73.14 0 89.44-38.31 115.1-38.31c18.48 0 31.97 15.04 31.97 31.96c0 35.04-81.59 70.41-147 70.41c-123.4 0-223.9-100.5-223.9-223.9S132.6 32.44 256 32.44c54.6 0 106.2 20.39 146.4 55.26l47.6-47.63C455.5 34.57 462.3 32.11 468.9 32.11z',
			),
		),
		'label'             => __( 'Rotate Right', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
		),
	),
	'route'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M320 256C302.3 256 288 270.3 288 288C288 305.7 302.3 320 320 320H416C469 320 512 362.1 512 416C512 469 469 512 416 512H139.6C148.3 502.1 158.9 489.4 169.6 475.2C175.9 466.8 182.4 457.6 188.6 448H416C433.7 448 448 433.7 448 416C448 398.3 433.7 384 416 384H320C266.1 384 223.1 341 223.1 288C223.1 234.1 266.1 192 320 192H362.1C340.2 161.5 320 125.4 320 96C320 42.98 362.1 0 416 0C469 0 512 42.98 512 96C512 160 416 256 416 256H320zM416 128C433.7 128 448 113.7 448 96C448 78.33 433.7 64 416 64C398.3 64 384 78.33 384 96C384 113.7 398.3 128 416 128zM118.3 487.8C118.1 488 117.9 488.2 117.7 488.4C113.4 493.4 109.5 497.7 106.3 501.2C105.9 501.6 105.5 502 105.2 502.4C99.5 508.5 96 512 96 512C96 512 0 416 0 352C0 298.1 42.98 255.1 96 255.1C149 255.1 192 298.1 192 352C192 381.4 171.8 417.5 149.9 448C138.1 463.2 127.7 476.9 118.3 487.8L118.3 487.8zM95.1 384C113.7 384 127.1 369.7 127.1 352C127.1 334.3 113.7 320 95.1 320C78.33 320 63.1 334.3 63.1 352C63.1 369.7 78.33 384 95.1 384z',
			),
		),
		'label'             => __( 'Route', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
			'travel',
		),
	),
	'rss'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M25.57 176.1C12.41 175.4 .9117 185.2 .0523 198.4s9.173 24.65 22.39 25.5c120.1 7.875 225.7 112.7 233.6 233.6C256.9 470.3 267.4 480 279.1 480c.5313 0 1.062-.0313 1.594-.0625c13.22-.8438 23.25-12.28 22.39-25.5C294.6 310.3 169.7 185.4 25.57 176.1zM32 32C14.33 32 0 46.31 0 64s14.33 32 32 32c194.1 0 352 157.9 352 352c0 17.69 14.33 32 32 32s32-14.31 32-32C448 218.6 261.4 32 32 32zM63.1 351.9C28.63 351.9 0 380.6 0 416s28.63 64 63.1 64s64.08-28.62 64.08-64S99.37 351.9 63.1 351.9z',
			),
		),
		'label'             => __( 'Rss', 'astra' ),
		'custom_categories' => array(
			'communication',
			'science-and-technology',
			'travel',
		),
	),
	'ruble-sign'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M240 32C319.5 32 384 96.47 384 176C384 255.5 319.5 320 240 320H128V352H288C305.7 352 320 366.3 320 384C320 401.7 305.7 416 288 416H128V448C128 465.7 113.7 480 96 480C78.33 480 64 465.7 64 448V416H32C14.33 416 0 401.7 0 384C0 366.3 14.33 352 32 352H64V320H32C14.33 320 0 305.7 0 288C0 270.3 14.33 256 32 256H64V64C64 46.33 78.33 32 96 32H240zM320 176C320 131.8 284.2 96 240 96H128V256H240C284.2 256 320 220.2 320 176z',
			),
		),
		'label'             => __( 'Ruble Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'rug'                                    => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M80 64V448H24C10.75 448 0 437.3 0 424C0 410.7 10.75 400 24 400H32V360H24C10.75 360 0 349.3 0 336C0 322.7 10.75 312 24 312H32V280H24C10.75 280 0 269.3 0 256C0 242.7 10.75 232 24 232H32V200H24C10.75 200 0 189.3 0 176C0 162.7 10.75 152 24 152H32V112H24C10.75 112 0 101.3 0 88C0 74.75 10.75 64 24 64H80zM112 64H528V448H112V64zM616 112H608V152H616C629.3 152 640 162.7 640 176C640 189.3 629.3 200 616 200H608V232H616C629.3 232 640 242.7 640 256C640 269.3 629.3 280 616 280H608V312H616C629.3 312 640 322.7 640 336C640 349.3 629.3 360 616 360H608V400H616C629.3 400 640 410.7 640 424C640 437.3 629.3 448 616 448H560V64H616C629.3 64 640 74.75 640 88C640 101.3 629.3 112 616 112z',
			),
		),
		'label'             => __( 'Rug', 'astra' ),
		'custom_categories' => array(
			'lifestyle-and-hobbies',
		),
	),
	'ruler'                                  => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M177.9 494.1C159.2 512.8 128.8 512.8 110.1 494.1L17.94 401.9C-.8054 383.2-.8054 352.8 17.94 334.1L68.69 283.3L116.7 331.3C122.9 337.6 133.1 337.6 139.3 331.3C145.6 325.1 145.6 314.9 139.3 308.7L91.31 260.7L132.7 219.3L180.7 267.3C186.9 273.6 197.1 273.6 203.3 267.3C209.6 261.1 209.6 250.9 203.3 244.7L155.3 196.7L196.7 155.3L244.7 203.3C250.9 209.6 261.1 209.6 267.3 203.3C273.6 197.1 273.6 186.9 267.3 180.7L219.3 132.7L260.7 91.31L308.7 139.3C314.9 145.6 325.1 145.6 331.3 139.3C337.6 133.1 337.6 122.9 331.3 116.7L283.3 68.69L334.1 17.94C352.8-.8055 383.2-.8055 401.9 17.94L494.1 110.1C512.8 128.8 512.8 159.2 494.1 177.9L177.9 494.1z',
			),
		),
		'label'             => __( 'Ruler', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'ruler-combined'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M0 464V48C0 21.49 21.49 0 48 0H144C170.5 0 192 21.49 192 48V96H112C103.2 96 96 103.2 96 112C96 120.8 103.2 128 112 128H192V192H112C103.2 192 96 199.2 96 208C96 216.8 103.2 224 112 224H192V288H112C103.2 288 96 295.2 96 304C96 312.8 103.2 320 112 320H192V400C192 408.8 199.2 416 208 416C216.8 416 224 408.8 224 400V320H288V400C288 408.8 295.2 416 304 416C312.8 416 320 408.8 320 400V320H384V400C384 408.8 391.2 416 400 416C408.8 416 416 408.8 416 400V320H464C490.5 320 512 341.5 512 368V464C512 490.5 490.5 512 464 512H48C23.15 512 2.706 493.1 .2477 468.9C.0838 467.3 0 465.7 0 464z',
			),
		),
		'label'             => __( 'Ruler Combined', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'ruler-horizontal'                       => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M0 176C0 149.5 21.49 128 48 128H112V208C112 216.8 119.2 224 128 224C136.8 224 144 216.8 144 208V128H208V208C208 216.8 215.2 224 224 224C232.8 224 240 216.8 240 208V128H304V208C304 216.8 311.2 224 320 224C328.8 224 336 216.8 336 208V128H400V208C400 216.8 407.2 224 416 224C424.8 224 432 216.8 432 208V128H496V208C496 216.8 503.2 224 512 224C520.8 224 528 216.8 528 208V128H592C618.5 128 640 149.5 640 176V336C640 362.5 618.5 384 592 384H48C21.49 384 0 362.5 0 336V176z',
			),
		),
		'label'             => __( 'Ruler Horizontal', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'ruler-vertical'                         => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 256,
				'height' => 512,
				'path'   => 'M0 48C0 21.49 21.49 0 48 0H208C234.5 0 256 21.49 256 48V96H176C167.2 96 160 103.2 160 112C160 120.8 167.2 128 176 128H256V192H176C167.2 192 160 199.2 160 208C160 216.8 167.2 224 176 224H256V288H176C167.2 288 160 295.2 160 304C160 312.8 167.2 320 176 320H256V384H176C167.2 384 160 391.2 160 400C160 408.8 167.2 416 176 416H256V464C256 490.5 234.5 512 208 512H48C21.49 512 0 490.5 0 464V48z',
			),
		),
		'label'             => __( 'Ruler Vertical', 'astra' ),
		'custom_categories' => array(
			'business',
			'design',
		),
	),
	'rupee-sign'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 448,
				'height' => 512,
				'path'   => 'M.0003 64C.0003 46.33 14.33 32 32 32H112C191.5 32 256 96.47 256 176C256 234.8 220.8 285.3 170.3 307.7L221.7 436.1C228.3 452.5 220.3 471.1 203.9 477.7C187.5 484.3 168.9 476.3 162.3 459.9L106.3 320H64V448C64 465.7 49.67 480 32 480C14.33 480 0 465.7 0 448L.0003 64zM64 256H112C156.2 256 192 220.2 192 176C192 131.8 156.2 96 112 96H64V256zM320.8 282.2C321.3 283.3 322.2 284.8 325 287.1C332.2 292.8 343.7 297.1 362.9 303.8L364.2 304.3C380.3 309.1 402.9 317.9 419.1 332.4C429.5 340.5 437.9 351 443 364.7C448.1 378.4 449.1 393.2 446.8 408.7C442.7 436.8 426.4 457.1 403.1 469.6C381 480.7 354.9 482.1 329.9 477.6L329.7 477.5C320.4 475.8 309.2 471.8 300.5 468.6C294.4 466.3 287.9 463.7 282.7 461.6C280.2 460.6 278.1 459.8 276.4 459.1C259.9 452.7 251.8 434.2 258.2 417.7C264.6 401.2 283.1 393.1 299.6 399.5C302.2 400.5 304.8 401.5 307.5 402.6C312.3 404.5 317.4 406.5 322.9 408.6C331.7 411.9 338.2 413.1 341.6 414.6C357.2 417.5 368.3 415.5 374.5 412.4C379.4 409.9 382.5 406.3 383.5 399.3C384.5 392.4 383.7 388.8 383.1 387.1C382.4 385.4 381.3 383.5 378.6 381.2C371.7 375.4 360.4 370.8 341.6 364.2L338.6 363.1C323.1 357.7 301.6 350.2 285.3 337.2C275.8 329.7 266.1 319.7 261.5 306.3C256.1 292.8 254.9 278.2 257.2 263.1C265.6 205.1 324.2 185.1 374.1 194.2C380.1 195.5 401.4 200 409.5 202.6C426.4 207.8 435.8 225.7 430.6 242.6C425.3 259.5 407.4 268.9 390.5 263.7C385.8 262.2 368.2 258.2 362.6 257.2C347.1 254.5 336.8 256.8 329.1 260.4C323.7 263.7 321.1 267.1 320.5 272.4C319.6 278.4 320.4 281.2 320.8 282.2H320.8z',
			),
		),
		'label'             => __( 'Rupee Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'rupiah-sign'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M.0003 64C.0003 46.33 14.33 32 32 32H112C191.5 32 256 96.47 256 176C256 234.8 220.8 285.3 170.3 307.7L221.7 436.1C228.3 452.5 220.3 471.1 203.9 477.7C187.5 484.3 168.9 476.3 162.3 459.9L106.3 320H64V448C64 465.7 49.67 480 32 480C14.33 480 0 465.7 0 448L.0003 64zM64 256H112C156.2 256 192 220.2 192 176C192 131.8 156.2 96 112 96H64V256zM400 160C461.9 160 512 210.1 512 272C512 333.9 461.9 384 400 384H352V480C352 497.7 337.7 512 320 512C302.3 512 288 497.7 288 480V192C288 174.3 302.3 160 320 160H400zM448 272C448 245.5 426.5 224 400 224H352V320H400C426.5 320 448 298.5 448 272z',
			),
		),
		'label'             => __( 'Rupiah Sign', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'rust'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M508.5 249.8 486.7 236.2c-.17-2-.34-3.93-.55-5.88l18.72-17.5a7.35 7.35 0 0 0 -2.44-12.25l-24-9c-.54-1.88-1.08-3.78-1.67-5.64l15-20.83a7.35 7.35 0 0 0 -4.79-11.54l-25.42-4.15c-.9-1.73-1.79-3.45-2.73-5.15l10.68-23.42a7.35 7.35 0 0 0 -6.95-10.39l-25.82 .91q-1.79-2.22-3.61-4.4L439 81.84A7.36 7.36 0 0 0 430.2 73L405 78.93q-2.17-1.83-4.4-3.61l.91-25.82a7.35 7.35 0 0 0 -10.39-7L367.7 53.23c-1.7-.94-3.43-1.84-5.15-2.73L358.4 25.08a7.35 7.35 0 0 0 -11.54-4.79L326 35.26c-1.86-.59-3.75-1.13-5.64-1.67l-9-24a7.35 7.35 0 0 0 -12.25-2.44l-17.5 18.72c-1.95-.21-3.91-.38-5.88-.55L262.3 3.48a7.35 7.35 0 0 0 -12.5 0L236.2 25.3c-2 .17-3.93 .34-5.88 .55L212.9 7.13a7.35 7.35 0 0 0 -12.25 2.44l-9 24c-1.89 .55-3.79 1.08-5.66 1.68l-20.82-15a7.35 7.35 0 0 0 -11.54 4.79l-4.15 25.41c-1.73 .9-3.45 1.79-5.16 2.73L120.9 42.55a7.35 7.35 0 0 0 -10.39 7l.92 25.81c-1.49 1.19-3 2.39-4.42 3.61L81.84 73A7.36 7.36 0 0 0 73 81.84L78.93 107c-1.23 1.45-2.43 2.93-3.62 4.41l-25.81-.91a7.42 7.42 0 0 0 -6.37 3.26 7.35 7.35 0 0 0 -.57 7.13l10.66 23.41c-.94 1.7-1.83 3.43-2.73 5.16L25.08 153.6a7.35 7.35 0 0 0 -4.79 11.54l15 20.82c-.59 1.87-1.13 3.77-1.68 5.66l-24 9a7.35 7.35 0 0 0 -2.44 12.25l18.72 17.5c-.21 1.95-.38 3.91-.55 5.88L3.48 249.8a7.35 7.35 0 0 0 0 12.5L25.3 275.8c.17 2 .34 3.92 .55 5.87L7.13 299.1a7.35 7.35 0 0 0 2.44 12.25l24 9c.55 1.89 1.08 3.78 1.68 5.65l-15 20.83a7.35 7.35 0 0 0 4.79 11.54l25.42 4.15c.9 1.72 1.79 3.45 2.73 5.14L42.56 391.1a7.35 7.35 0 0 0 .57 7.13 7.13 7.13 0 0 0 6.37 3.26l25.83-.91q1.77 2.22 3.6 4.4L73 430.2A7.36 7.36 0 0 0 81.84 439L107 433.1q2.18 1.83 4.41 3.61l-.92 25.82a7.35 7.35 0 0 0 10.39 6.95l23.43-10.68c1.69 .94 3.42 1.83 5.14 2.73l4.15 25.42a7.34 7.34 0 0 0 11.54 4.78l20.83-15c1.86 .6 3.76 1.13 5.65 1.68l9 24a7.36 7.36 0 0 0 12.25 2.44l17.5-18.72c1.95 .21 3.92 .38 5.88 .55l13.51 21.82a7.35 7.35 0 0 0 12.5 0l13.51-21.82c2-.17 3.93-.34 5.88-.56l17.5 18.73a7.36 7.36 0 0 0 12.25-2.44l9-24c1.89-.55 3.78-1.08 5.65-1.68l20.82 15a7.34 7.34 0 0 0 11.54-4.78l4.15-25.42c1.72-.9 3.45-1.79 5.15-2.73l23.42 10.68a7.35 7.35 0 0 0 10.39-6.95l-.91-25.82q2.22-1.79 4.4-3.61L430.2 439a7.36 7.36 0 0 0 8.84-8.84L433.1 405q1.83-2.17 3.61-4.4l25.82 .91a7.23 7.23 0 0 0 6.37-3.26 7.35 7.35 0 0 0 .58-7.13L458.8 367.7c.94-1.7 1.83-3.43 2.73-5.15l25.42-4.15a7.35 7.35 0 0 0 4.79-11.54l-15-20.83c.59-1.87 1.13-3.76 1.67-5.65l24-9a7.35 7.35 0 0 0 2.44-12.25l-18.72-17.5c.21-1.95 .38-3.91 .55-5.87l21.82-13.51a7.35 7.35 0 0 0 0-12.5zm-151 129.1A13.91 13.91 0 0 0 341 389.5l-7.64 35.67A187.5 187.5 0 0 1 177 424.4l-7.64-35.66a13.87 13.87 0 0 0 -16.46-10.68l-31.51 6.76a187.4 187.4 0 0 1 -16.26-19.21H258.3c1.72 0 2.89-.29 2.89-1.91V309.5c0-1.57-1.17-1.91-2.89-1.91H213.5l.05-34.35H262c4.41 0 23.66 1.28 29.79 25.87 1.91 7.55 6.17 32.14 9.06 40 2.89 8.82 14.6 26.46 27.1 26.46H407a187.3 187.3 0 0 1 -17.34 20.09zm25.77 34.49A15.24 15.24 0 1 1 368 398.1h.44A15.23 15.23 0 0 1 383.2 413.3zm-225.6-.68a15.24 15.24 0 1 1 -15.25-15.25h.45A15.25 15.25 0 0 1 157.6 412.6zM69.57 234.1l32.83-14.6a13.88 13.88 0 0 0 7.06-18.33L102.7 186h26.56V305.7H75.65A187.6 187.6 0 0 1 69.57 234.1zM58.31 198.1a15.24 15.24 0 0 1 15.23-15.25H74a15.24 15.24 0 1 1 -15.67 15.24zm155.2 24.49 .05-35.32h63.26c3.28 0 23.07 3.77 23.07 18.62 0 12.29-15.19 16.7-27.68 16.7zM399 306.7c-9.8 1.13-20.63-4.12-22-10.09-5.78-32.49-15.39-39.4-30.57-51.4 18.86-11.95 38.46-29.64 38.46-53.26 0-25.52-17.49-41.59-29.4-49.48-16.76-11-35.28-13.23-40.27-13.23H116.3A187.5 187.5 0 0 1 221.2 70.06l23.47 24.6a13.82 13.82 0 0 0 19.6 .44l26.26-25a187.5 187.5 0 0 1 128.4 91.43l-18 40.57A14 14 0 0 0 408 220.4l34.59 15.33a187.1 187.1 0 0 1 .4 32.54H423.7c-1.91 0-2.69 1.27-2.69 3.13v8.82C421 301 409.3 305.6 399 306.7zM240 60.21A15.24 15.24 0 0 1 255.2 45h.45A15.24 15.24 0 1 1 240 60.21zM436.8 214a15.24 15.24 0 1 1 0-30.48h.44a15.24 15.24 0 0 1 -.44 30.48z',
			),
		),
		'label'             => __( 'Rust', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	's'                                      => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 384,
				'height' => 512,
				'path'   => 'M349.9 379.1c-6.281 36.63-25.89 65.02-56.69 82.11c-24.91 13.83-54.08 18.98-83.73 18.98c-61.86 0-125.8-22.42-157.5-35.38c-16.38-6.672-24.22-25.34-17.55-41.7c6.641-16.36 25.27-24.28 41.7-17.55c77.56 31.64 150.6 39.39 186.1 19.69c13.83-7.672 21.67-19.42 24.69-36.98c7.25-42.31-18.2-56.75-103.7-81.38C112.6 266.6 15.98 238.7 34.11 133.2c5.484-32 23.64-59.36 51.14-77.02c45.59-29.33 115-31.87 206.4-7.688c17.09 4.531 27.27 22.05 22.75 39.13s-22.06 27.23-39.13 22.75C184 86.17 140.4 96.81 119.8 110c-12.55 8.062-20.17 19.5-22.66 34c-7.266 42.31 18.19 56.75 103.7 81.38C271.4 245.7 368 273.5 349.9 379.1z',
			),
		),
		'label'             => __( 'S', 'astra' ),
		'custom_categories' => array(
			'education',
		),
	),
	'sack-dollar'                            => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M320 96H192L144.6 24.88C137.5 14.24 145.1 0 157.9 0H354.1C366.9 0 374.5 14.24 367.4 24.88L320 96zM192 128H320C323.8 130.5 328.1 133.3 332.1 136.4C389.7 172.7 512 250.9 512 416C512 469 469 512 416 512H96C42.98 512 0 469 0 416C0 250.9 122.3 172.7 179 136.4C183.9 133.3 188.2 130.5 192 128V128zM276.1 224C276.1 212.9 267.1 203.9 255.1 203.9C244.9 203.9 235.9 212.9 235.9 224V230C230.3 231.2 224.1 232.9 220 235.1C205.1 241.9 192.1 254.5 188.9 272.8C187.1 283 188.1 292.9 192.3 301.8C196.5 310.6 203 316.8 209.6 321.3C221.2 329.2 236.5 333.8 248.2 337.3L250.4 337.9C264.4 342.2 273.8 345.3 279.7 349.6C282.2 351.4 283.1 352.8 283.4 353.7C283.8 354.5 284.4 356.3 283.7 360.3C283.1 363.8 281.2 366.8 275.7 369.1C269.6 371.7 259.7 373 246.9 371C240.9 370 230.2 366.4 220.7 363.2C218.5 362.4 216.3 361.7 214.3 361C203.8 357.5 192.5 363.2 189 373.7C185.5 384.2 191.2 395.5 201.7 398.1C202.9 399.4 204.4 399.9 206.1 400.5C213.1 403.2 226.4 407.4 235.9 409.6V416C235.9 427.1 244.9 436.1 255.1 436.1C267.1 436.1 276.1 427.1 276.1 416V410.5C281.4 409.5 286.6 407.1 291.4 405.9C307.2 399.2 319.8 386.2 323.1 367.2C324.9 356.8 324.1 346.8 320.1 337.7C316.2 328.7 309.9 322.1 303.2 317.3C291.1 308.4 274.9 303.6 262.8 299.9L261.1 299.7C247.8 295.4 238.2 292.4 232.1 288.2C229.5 286.4 228.7 285.2 228.5 284.7C228.3 284.3 227.7 283.1 228.3 279.7C228.7 277.7 230.2 274.4 236.5 271.6C242.1 268.7 252.9 267.1 265.1 268.1C269.5 269.7 283 272.3 286.9 273.3C297.5 276.2 308.5 269.8 311.3 259.1C314.2 248.5 307.8 237.5 297.1 234.7C292.7 233.5 282.7 231.5 276.1 230.3L276.1 224z',
			),
		),
		'label'             => __( 'Sack Dollar', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'sack-xmark'                             => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M144.6 24.88C137.5 14.24 145.1 0 157.9 0H354.1C366.9 0 374.5 14.24 367.4 24.88L320 96H192L144.6 24.88zM332.1 136.4C389.7 172.7 512 250.9 512 416C512 469 469 512 416 512H96C42.98 512 0 469 0 416C0 250.9 122.3 172.7 179 136.4C183.9 133.3 188.2 130.5 192 128H320C323.8 130.5 328.1 133.3 332.1 136.4V136.4zM336.1 288.1C346.3 279.6 346.3 264.4 336.1 255C327.6 245.7 312.4 245.7 303 255L256 302.1L208.1 255C199.6 245.7 184.4 245.7 175 255C165.7 264.4 165.7 279.6 175 288.1L222.1 336L175 383C165.7 392.4 165.7 407.6 175 416.1C184.4 426.3 199.6 426.3 208.1 416.1L256 369.9L303 416.1C312.4 426.3 327.6 426.3 336.1 416.1C346.3 407.6 346.3 392.4 336.1 383L289.9 336L336.1 288.1z',
			),
		),
		'label'             => __( 'Sack Xmark', 'astra' ),
		'custom_categories' => array(
			'business',
		),
	),
	'safari'                                 => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 512,
				'height' => 512,
				'path'   => 'M274.7 274.7l-37.38-37.38L166 346zM256 8C119 8 8 119 8 256S119 504 256 504 504 393 504 256 393 8 256 8zM411.9 182.8l14.78-6.13A8 8 0 0 1 437.1 181h0a8 8 0 0 1 -4.33 10.46L418 197.6a8 8 0 0 1 -10.45-4.33h0A8 8 0 0 1 411.9 182.8zM314.4 94l6.12-14.78A8 8 0 0 1 331 74.92h0a8 8 0 0 1 4.33 10.45l-6.13 14.78a8 8 0 0 1 -10.45 4.33h0A8 8 0 0 1 314.4 94zM256 60h0a8 8 0 0 1 8 8V84a8 8 0 0 1 -8 8h0a8 8 0 0 1 -8-8V68A8 8 0 0 1 256 60zM181 74.92a8 8 0 0 1 10.46 4.33L197.6 94a8 8 0 1 1 -14.78 6.12l-6.13-14.78A8 8 0 0 1 181 74.92zm-63.58 42.49h0a8 8 0 0 1 11.31 0L140 128.7A8 8 0 0 1 140 140h0a8 8 0 0 1 -11.31 0l-11.31-11.31A8 8 0 0 1 117.4 117.4zM60 256h0a8 8 0 0 1 8-8H84a8 8 0 0 1 8 8h0a8 8 0 0 1 -8 8H68A8 8 0 0 1 60 256zm40.15 73.21-14.78 6.13A8 8 0 0 1 74.92 331h0a8 8 0 0 1 4.33-10.46L94 314.4a8 8 0 0 1 10.45 4.33h0A8 8 0 0 1 100.2 329.2zm4.33-136h0A8 8 0 0 1 94 197.6l-14.78-6.12A8 8 0 0 1 74.92 181h0a8 8 0 0 1 10.45-4.33l14.78 6.13A8 8 0 0 1 104.5 193.2zM197.6 418l-6.12 14.78a8 8 0 0 1 -14.79-6.12l6.13-14.78A8 8 0 1 1 197.6 418zM264 444a8 8 0 0 1 -8 8h0a8 8 0 0 1 -8-8V428a8 8 0 0 1 8-8h0a8 8 0 0 1 8 8zm67-6.92h0a8 8 0 0 1 -10.46-4.33L314.4 418a8 8 0 0 1 4.33-10.45h0a8 8 0 0 1 10.45 4.33l6.13 14.78A8 8 0 0 1 331 437.1zm63.58-42.49h0a8 8 0 0 1 -11.31 0L372 383.3A8 8 0 0 1 372 372h0a8 8 0 0 1 11.31 0l11.31 11.31A8 8 0 0 1 394.6 394.6zM286.3 286.3 110.3 401.7 225.8 225.8 401.7 110.3zM437.1 331h0a8 8 0 0 1 -10.45 4.33l-14.78-6.13a8 8 0 0 1 -4.33-10.45h0A8 8 0 0 1 418 314.4l14.78 6.12A8 8 0 0 1 437.1 331zM444 264H428a8 8 0 0 1 -8-8h0a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8h0A8 8 0 0 1 444 264z',
			),
		),
		'label'             => __( 'Safari', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'sailboat'                               => array(
		'svg'               => array(
			'solid' => array(
				'width'  => 576,
				'height' => 512,
				'path'   => 'M256 16C256 9.018 260.5 2.841 267.2 .7414C273.9-1.358 281.1 1.105 285.1 6.826L509.1 326.8C512.5 331.7 512.9 338.1 510.2 343.4C507.4 348.7 501.1 352 496 352H272C263.2 352 256 344.8 256 336V16zM212.1 96.54C219.1 98.4 224 104.7 224 112V336C224 344.8 216.8 352 208 352H80C74.3 352 69.02 348.1 66.16 344C63.3 339.1 63.28 333 66.11 328.1L194.1 104.1C197.7 97.76 205.1 94.68 212.1 96.54V96.54zM5.718 404.3C2.848 394.1 10.52 384 21.12 384H554.9C565.5 384 573.2 394.1 570.3 404.3L566.3 418.7C550.7 473.9 500.4 512 443 512H132.1C75.62 512 25.27 473.9 9.747 418.7L5.718 404.3z',
			),
		),
		'label'             => __( 'Sailboat', 'astra' ),
		'custom_categories' => array(
			'business',
			'travel',
		),
	),
	'salesforce'                             => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M248.9 245.6h-26.35c.69-5.16 3.32-14.12 13.64-14.12 6.75 0 11.97 3.82 12.71 14.12zm136.7-13.88c-.47 0-14.11-1.77-14.11 20s13.63 20 14.11 20c13 0 14.11-13.54 14.11-20 0-21.76-13.66-20-14.11-20zm-243.2 23.76a8.63 8.63 0 0 0 -3.29 7.29c0 4.78 2.08 6.05 3.29 7.05 4.7 3.7 15.07 2.12 20.93 .95v-16.94c-5.32-1.07-16.73-1.96-20.93 1.65zM640 232c0 87.58-80 154.4-165.4 136.4-18.37 33-70.73 70.75-132.2 41.63-41.16 96.05-177.9 92.18-213.8-5.17C8.91 428.8-50.19 266.5 53.36 205.6 18.61 126.2 76 32 167.7 32a124.2 124.2 0 0 1 98.56 48.7c20.7-21.4 49.4-34.81 81.15-34.81 42.34 0 79 23.52 98.8 58.57C539 63.78 640 132.7 640 232zm-519.5 31.8c0-11.76-11.69-15.17-17.87-17.17-5.27-2.11-13.41-3.51-13.41-8.94 0-9.46 17-6.66 25.17-2.12 0 0 1.17 .71 1.64-.47 .24-.7 2.36-6.58 2.59-7.29a1.13 1.13 0 0 0 -.7-1.41c-12.33-7.63-40.7-8.51-40.7 12.7 0 12.46 11.49 15.44 17.88 17.17 4.72 1.58 13.17 3 13.17 8.7 0 4-3.53 7.06-9.17 7.06a31.76 31.76 0 0 1 -19-6.35c-.47-.23-1.42-.71-1.65 .71l-2.4 7.47c-.47 .94 .23 1.18 .23 1.41 1.75 1.4 10.3 6.59 22.82 6.59 13.17 0 21.4-7.06 21.4-18.11zm32-42.58c-10.13 0-18.66 3.17-21.4 5.18a1 1 0 0 0 -.24 1.41l2.59 7.06a1 1 0 0 0 1.18 .7c.65 0 6.8-4 16.93-4 4 0 7.06 .71 9.18 2.36 3.6 2.8 3.06 8.29 3.06 10.58-4.79-.3-19.11-3.44-29.41 3.76a16.92 16.92 0 0 0 -7.34 14.54c0 5.9 1.51 10.4 6.59 14.35 12.24 8.16 36.28 2 38.1 1.41 1.58-.32 3.53-.66 3.53-1.88v-33.88c.04-4.61 .32-21.64-22.78-21.64zM199 200.2a1.11 1.11 0 0 0 -1.18-1.18H188a1.11 1.11 0 0 0 -1.17 1.18v79a1.11 1.11 0 0 0 1.17 1.18h9.88a1.11 1.11 0 0 0 1.18-1.18zm55.75 28.93c-2.1-2.31-6.79-7.53-17.65-7.53-3.51 0-14.16 .23-20.7 8.94-6.35 7.63-6.58 18.11-6.58 21.41 0 3.12 .15 14.26 7.06 21.17 2.64 2.91 9.06 8.23 22.81 8.23 10.82 0 16.47-2.35 18.58-3.76 .47-.24 .71-.71 .24-1.88l-2.35-6.83a1.26 1.26 0 0 0 -1.41-.7c-2.59 .94-6.35 2.82-15.29 2.82-17.42 0-16.85-14.74-16.94-16.7h37.17a1.23 1.23 0 0 0 1.17-.94c-.29 0 2.07-14.7-6.09-24.23zm36.69 52.69c13.17 0 21.41-7.06 21.41-18.11 0-11.76-11.7-15.17-17.88-17.17-4.14-1.66-13.41-3.38-13.41-8.94 0-3.76 3.29-6.35 8.47-6.35a38.11 38.11 0 0 1 16.7 4.23s1.18 .71 1.65-.47c.23-.7 2.35-6.58 2.58-7.29a1.13 1.13 0 0 0 -.7-1.41c-7.91-4.9-16.74-4.94-20.23-4.94-12 0-20.46 7.29-20.46 17.64 0 12.46 11.48 15.44 17.87 17.17 6.11 2 13.17 3.26 13.17 8.7 0 4-3.52 7.06-9.17 7.06a31.8 31.8 0 0 1 -19-6.35 1 1 0 0 0 -1.65 .71l-2.35 7.52c-.47 .94 .23 1.18 .23 1.41 1.72 1.4 10.33 6.59 22.79 6.59zM357.1 224c0-.71-.24-1.18-1.18-1.18h-11.76c0-.14 .94-8.94 4.47-12.47 4.16-4.15 11.76-1.64 12-1.64 1.17 .47 1.41 0 1.64-.47l2.83-7.77c.7-.94 0-1.17-.24-1.41-5.09-2-17.35-2.87-24.46 4.24-5.48 5.48-7 13.92-8 19.52h-8.47a1.28 1.28 0 0 0 -1.17 1.18l-1.42 7.76c0 .7 .24 1.17 1.18 1.17h8.23c-8.51 47.9-8.75 50.21-10.35 55.52-1.08 3.62-3.29 6.9-5.88 7.76-.09 0-3.88 1.68-9.64-.24 0 0-.94-.47-1.41 .71-.24 .71-2.59 6.82-2.83 7.53s0 1.41 .47 1.41c5.11 2 13 1.77 17.88 0 6.28-2.28 9.72-7.89 11.53-12.94 2.75-7.71 2.81-9.79 11.76-59.74h12.23a1.29 1.29 0 0 0 1.18-1.18zm53.39 16c-.56-1.68-5.1-18.11-25.17-18.11-15.25 0-23 10-25.16 18.11-1 3-3.18 14 0 23.52 .09 .3 4.41 18.12 25.16 18.12 14.95 0 22.9-9.61 25.17-18.12 3.21-9.61 1.01-20.52 0-23.52zm45.4-16.7c-5-1.65-16.62-1.9-22.11 5.41v-4.47a1.11 1.11 0 0 0 -1.18-1.17h-9.4a1.11 1.11 0 0 0 -1.18 1.17v55.28a1.12 1.12 0 0 0 1.18 1.18h9.64a1.12 1.12 0 0 0 1.18-1.18v-27.77c0-2.91 .05-11.37 4.46-15.05 4.9-4.9 12-3.36 13.41-3.06a1.57 1.57 0 0 0 1.41-.94 74 74 0 0 0 3.06-8 1.16 1.16 0 0 0 -.47-1.41zm46.81 54.1l-2.12-7.29c-.47-1.18-1.41-.71-1.41-.71-4.23 1.82-10.15 1.89-11.29 1.89-4.64 0-17.17-1.13-17.17-19.76 0-6.23 1.85-19.76 16.47-19.76a34.85 34.85 0 0 1 11.52 1.65s.94 .47 1.18-.71c.94-2.59 1.64-4.47 2.59-7.53 .23-.94-.47-1.17-.71-1.17-11.59-3.87-22.34-2.53-27.76 0-1.59 .74-16.23 6.49-16.23 27.52 0 2.9-.58 30.11 28.94 30.11a44.45 44.45 0 0 0 15.52-2.83 1.3 1.3 0 0 0 .47-1.42zm53.87-39.52c-.8-3-5.37-16.23-22.35-16.23-16 0-23.52 10.11-25.64 18.59a38.58 38.58 0 0 0 -1.65 11.76c0 25.87 18.84 29.4 29.88 29.4 10.82 0 16.46-2.35 18.58-3.76 .47-.24 .71-.71 .24-1.88l-2.36-6.83a1.26 1.26 0 0 0 -1.41-.7c-2.59 .94-6.35 2.82-15.29 2.82-17.42 0-16.85-14.74-16.93-16.7h37.16a1.25 1.25 0 0 0 1.18-.94c-.24-.01 .94-7.07-1.41-15.54zm-23.29-6.35c-10.33 0-13 9-13.64 14.12H546c-.88-11.92-7.62-14.13-12.73-14.13z',
			),
		),
		'label'             => __( 'Salesforce', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
	'sass'                                   => array(
		'svg'               => array(
			'brands' => array(
				'width'  => 640,
				'height' => 512,
				'path'   => 'M301.8 378.9c-.3 .6-.6 1.08 0 0zm249.1-87a131.2 131.2 0 0 0 -58 13.5c-5.9-11.9-12-22.3-13-30.1-1.2-9.1-2.5-14.5-1.1-25.3s7.7-26.1 7.6-27.2-1.4-6.6-14.3-6.7-24 2.5-25.29 5.9a122.8 122.8 0 0 0 -5.3 19.1c-2.3 11.7-25.79 53.5-39.09 75.3-4.4-8.5-8.1-16-8.9-22-1.2-9.1-2.5-14.5-1.1-25.3s7.7-26.1 7.6-27.2-1.4-6.6-14.29-6.7-24 2.5-25.3 5.9-2.7 11.4-5.3 19.1-33.89 77.3-42.08 95.4c-4.2 9.2-7.8 16.6-10.4 21.6-.4 .8-.7 1.3-.9 1.7 .3-.5 .5-1 .5-.8-2.2 4.3-3.5 6.7-3.5 6.7v.1c-1.7 3.2-3.6 6.1-4.5 6.1-.6 0-1.9-8.4 .3-19.9 4.7-24.2 15.8-61.8 15.7-63.1-.1-.7 2.1-7.2-7.3-10.7-9.1-3.3-12.4 2.2-13.2 2.2s-1.4 2-1.4 2 10.1-42.4-19.39-42.4c-18.4 0-44 20.2-56.58 38.5-7.9 4.3-25 13.6-43 23.5-6.9 3.8-14 7.7-20.7 11.4-.5-.5-.9-1-1.4-1.5-35.79-38.2-101.9-65.2-99.07-116.5 1-18.7 7.5-67.8 127.1-127.4 98-48.8 176.4-35.4 189.8-5.6 19.4 42.5-41.89 121.6-143.7 133-38.79 4.3-59.18-10.7-64.28-16.3-5.3-5.9-6.1-6.2-8.1-5.1-3.3 1.8-1.2 7 0 10.1 3 7.9 15.5 21.9 36.79 28.9 18.7 6.1 64.18 9.5 119.2-11.8 61.78-23.8 109.9-90.1 95.77-145.6C386.5 18.32 293-.18 204.6 31.22c-52.69 18.7-109.7 48.1-150.7 86.4-48.69 45.6-56.48 85.3-53.28 101.9 11.39 58.9 92.57 97.3 125.1 125.7-1.6 .9-3.1 1.7-4.5 2.5-16.29 8.1-78.18 40.5-93.67 74.7-17.5 38.8 2.9 66.6 16.29 70.4 41.79 11.6 84.58-9.3 107.6-43.6s20.2-79.1 9.6-99.5c-.1-.3-.3-.5-.4-.8 4.2-2.5 8.5-5 12.8-7.5 8.29-4.9 16.39-9.4 23.49-13.3-4 10.8-6.9 23.8-8.4 42.6-1.8 22 7.3 50.5 19.1 61.7 5.2 4.9 11.49 5 15.39 5 13.8 0 20-11.4 26.89-25 8.5-16.6 16-35.9 16-35.9s-9.4 52.2 16.3 52.2c9.39 0 18.79-12.1 23-18.3v.1s.2-.4 .7-1.2c1-1.5 1.5-2.4 1.5-2.4v-.3c3.8-6.5 12.1-21.4 24.59-46 16.2-31.8 31.69-71.5 31.69-71.5a201.2 201.2 0 0 0 6.2 25.8c2.8 9.5 8.7 19.9 13.4 30-3.8 5.2-6.1 8.2-6.1 8.2a.31 .31 0 0 0 .1 .2c-3 4-6.4 8.3-9.9 12.5-12.79 15.2-28 32.6-30 37.6-2.4 5.9-1.8 10.3 2.8 13.7 3.4 2.6 9.4 3 15.69 2.5 11.5-.8 19.6-3.6 23.5-5.4a82.2 82.2 0 0 0 20.19-10.6c12.5-9.2 20.1-22.4 19.4-39.8-.4-9.6-3.5-19.2-7.3-28.2 1.1-1.6 2.3-3.3 3.4-5C434.8 301.7 450.1 270 450.1 270a201.2 201.2 0 0 0 6.2 25.8c2.4 8.1 7.09 17 11.39 25.7-18.59 15.1-30.09 32.6-34.09 44.1-7.4 21.3-1.6 30.9 9.3 33.1 4.9 1 11.9-1.3 17.1-3.5a79.46 79.46 0 0 0 21.59-11.1c12.5-9.2 24.59-22.1 23.79-39.6-.3-7.9-2.5-15.8-5.4-23.4 15.7-6.6 36.09-10.2 62.09-7.2 55.68 6.5 66.58 41.3 64.48 55.8s-13.8 22.6-17.7 25-5.1 3.3-4.8 5.1c.5 2.6 2.3 2.5 5.6 1.9 4.6-.8 29.19-11.8 30.29-38.7 1.6-34-31.09-71.4-89-71.1zm-429.2 144.7c-18.39 20.1-44.19 27.7-55.28 21.3C54.61 451 59.31 421.4 82 400c13.8-13 31.59-25 43.39-32.4 2.7-1.6 6.6-4 11.4-6.9 .8-.5 1.2-.7 1.2-.7 .9-.6 1.9-1.1 2.9-1.7 8.29 30.4 .3 57.2-19.1 78.3zm134.4-91.4c-6.4 15.7-19.89 55.7-28.09 53.6-7-1.8-11.3-32.3-1.4-62.3 5-15.1 15.6-33.1 21.9-40.1 10.09-11.3 21.19-14.9 23.79-10.4 3.5 5.9-12.2 49.4-16.2 59.2zm111 53c-2.7 1.4-5.2 2.3-6.4 1.6-.9-.5 1.1-2.4 1.1-2.4s13.9-14.9 19.4-21.7c3.2-4 6.9-8.7 10.89-13.9 0 .5 .1 1 .1 1.6-.13 17.9-17.32 30-25.12 34.8zm85.58-19.5c-2-1.4-1.7-6.1 5-20.7 2.6-5.7 8.59-15.3 19-24.5a36.18 36.18 0 0 1 1.9 10.8c-.1 22.5-16.2 30.9-25.89 34.4z',
			),
		),
		'label'             => __( 'Sass', 'astra' ),
		'custom_categories' => array(
			'brands',
			'brands',
			'social',
		),
	),
);
